/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.time.Instant;
import java.util.Date;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BInteger;

public class DateTimeBValueProviders {
    private DateTimeBValueProviders() {
    }

    public static class InstantBValueProvider
    implements SerializationBValueProvider<Instant> {
        @Override
        public Class<?> getType() {
            return Instant.class;
        }

        @Override
        public BPacket toBValue(Instant object, BValueSerializer serializer) {
            long l = object.toEpochMilli();
            return BPacket.from(this.typeName(), new BInteger(l));
        }

        @Override
        public Instant toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            BInteger epochMilli = (BInteger)packet.getValue();
            return Instant.ofEpochMilli(epochMilli.intValue());
        }
    }

    public static class DateBValueProvider
    implements SerializationBValueProvider<Date> {
        @Override
        public Class<?> getType() {
            return Date.class;
        }

        @Override
        public BPacket toBValue(Date date, BValueSerializer serializer) {
            long time = date.getTime();
            return BPacket.from(this.typeName(), new BInteger(time));
        }

        @Override
        public Date toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
            BInteger time = (BInteger)packet.getValue();
            return new Date(time.intValue());
        }
    }
}

