/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public final class BByte
extends BValueType
implements BRefType<Long> {
    private long value;
    private BType type = BTypes.typeByte;

    public BByte(long value) {
        this.value = value;
    }

    public BByte(byte value) {
        this.value = Byte.toUnsignedLong(value);
    }

    @Override
    public long byteValue() {
        return this.value;
    }

    @Override
    public long intValue() {
        return this.value;
    }

    @Override
    public double floatValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value, MathContext.DECIMAL128).setScale(1, 6);
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0L;
    }

    @Override
    public String stringValue() {
        return Long.toString(this.value);
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BByte that = (BByte)obj;
        return this.value == that.value;
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

