/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.CompileFileContextOperation;
import org.ballerinalang.langserver.compiler.LSCompilerOperationContext;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSContextManager;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.workspace.ExtendedWorkspaceDocumentManagerImpl;
import org.ballerinalang.langserver.compiler.workspace.repository.LangServerFSProgramDirectory;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;

public class ExtendedLSCompiler
extends LSModuleCompiler {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedLSCompiler.class);
    private static final ExtendedWorkspaceDocumentManagerImpl docManager = ExtendedWorkspaceDocumentManagerImpl.getInstance();

    public static BallerinaFile compileContent(String content, CompilerPhase phase) throws CompilationFailedException {
        Path filePath = LSCompilerUtil.createTempFile("untitled.bal");
        Optional<Lock> exModeLock = docManager.enableExplicitMode(filePath);
        Optional<Lock> fileLock = docManager.lockFile(filePath);
        try {
            docManager.updateFile(filePath, content);
            BallerinaFile bFile = ExtendedLSCompiler.compileFile(filePath, phase);
            docManager.closeFile(filePath);
            BallerinaFile ballerinaFile = bFile;
            return ballerinaFile;
        }
        catch (WorkspaceDocumentException e) {
            throw new CompilationFailedException("Error occurred while compiling file:" + filePath.toString(), e);
        }
        finally {
            docManager.disableExplicitMode(exModeLock.orElse(null));
            fileLock.ifPresent(Lock::unlock);
        }
    }

    public static BallerinaFile compileFile(Path filePath, CompilerPhase compilerPhase) throws CompilationFailedException {
        BallerinaFile bfile;
        LSContextManager contextManager = LSContextManager.getInstance();
        Path path = filePath.getFileName();
        Path parent = filePath.getParent();
        if (parent == null) {
            return null;
        }
        String packageName = path.toString();
        CompilerContext context = contextManager.createNewCompilerContext(parent.toString(), docManager);
        LangServerFSProgramDirectory programDirectory = LangServerFSProgramDirectory.getInstance(parent, docManager);
        context.put(SourceDirectory.class, (Object)programDirectory);
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.TRUE.toString());
        options.put(CompilerOptionName.TEST_ENABLED, String.valueOf(true));
        options.put(CompilerOptionName.SKIP_TESTS, String.valueOf(false));
        BLangDiagnosticLogHelper.getInstance((CompilerContext)context).resetErrorCount();
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        LSContext lsContext = new LSCompilerOperationContext.CompilerOperationContextBuilder(CompileFileContextOperation.COMPILE_FILE).withCompileFileParams(context, packageName).build();
        try {
            compiler.setOutStream((PrintStream)new LSCompilerUtil.EmptyPrintStream());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to create the empty stream.");
        }
        BLangPackage bLangPackage = ExtendedLSCompiler.compileSafe(compiler, parent.toString(), packageName, lsContext);
        if (context.get(DiagnosticListener.class) instanceof CollectDiagnosticListener) {
            List<Diagnostic> diagnostics = ((CollectDiagnosticListener)context.get(DiagnosticListener.class)).getDiagnostics();
            bfile = new BallerinaFile(bLangPackage, diagnostics, false, context);
        } else {
            bfile = new BallerinaFile(bLangPackage, new ArrayList<Diagnostic>(), false, context);
        }
        return bfile;
    }
}

