/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;

public class LSClientLogger {
    private static LanguageClient languageClient = null;
    private static boolean isInitializedOnce = false;
    private static final LSClientConfigHolder configHolder = LSClientConfigHolder.getInstance();

    public static void initialize(LanguageClient languageClient) {
        LSClientLogger.languageClient = languageClient;
        isInitializedOnce = true;
    }

    public static void notifyUser(String operation, Throwable error) {
        if (!isInitializedOnce) {
            return;
        }
        if (languageClient != null) {
            languageClient.showMessage(new MessageParams(MessageType.Error, operation + " failed, " + error.getMessage()));
        }
    }

    public static void logError(String message, Throwable error, TextDocumentIdentifier identifier, Position ... position) {
        if (!isInitializedOnce) {
            return;
        }
        String details = LSClientLogger.getErrorDetails(identifier, error, position);
        if (configHolder.getConfig().isDebugLogEnabled() && languageClient != null) {
            Charset charset = StandardCharsets.UTF_8;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                PrintStream ps = new PrintStream((OutputStream)baos, true, charset.name());
                error.printStackTrace(ps);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            languageClient.logMessage(new MessageParams(MessageType.Error, message + " " + details + "\n" + baos));
        }
    }

    public static void logTrace(String message) {
        if (!isInitializedOnce) {
            return;
        }
        if (configHolder.getConfig().isTraceLogEnabled() && languageClient != null) {
            languageClient.logMessage(new MessageParams(MessageType.Info, message));
        }
    }

    private static String getErrorDetails(TextDocumentIdentifier identifier, Throwable error, Position ... position) {
        String msg = error.getMessage();
        StringBuilder result = new StringBuilder("{");
        if (identifier != null) {
            result.append("uri: '").append(identifier.getUri().replaceFirst("file://", "")).append("'");
        }
        if (position != null && position[0] != null) {
            if (position.length == 2) {
                result.append(", line: ").append(position[0].getLine() + 1).append(", col: ").append(position[0].getCharacter() + 1);
                result.append("- line: ").append(position[1].getLine() + 1).append(", col: ").append(position[1].getCharacter() + 1);
            } else {
                result.append(", line: ").append(position[0].getLine() + 1).append(", col: ").append(position[0].getCharacter() + 1);
            }
        }
        if (msg != null && !msg.isEmpty()) {
            result.append(", error: '").append(msg);
        } else {
            result.append(", error: '").append(error.toString());
            for (StackTraceElement elm : error.getStackTrace()) {
                if (!elm.getClassName().startsWith("org.wso2.")) continue;
                result.append(", ").append(elm.toString());
                break;
            }
        }
        result.append("'}");
        return result.toString();
    }
}

