/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.EitherPair;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class LSCompilerCache {
    private static final long MAX_CACHE_COUNT = 10L;
    private static Map<Key, CacheEntry> packageMap;

    private LSCompilerCache() {
    }

    public static CacheEntry getPackage(Key key, LSContext context) {
        return LSCompilerCache.get(key, context, true);
    }

    public static CacheEntry getPackages(Key key, LSContext context) {
        return LSCompilerCache.get(key, context, false);
    }

    private static CacheEntry get(Key key, LSContext context, boolean isSinglePkg) {
        CacheEntry cacheEntry = packageMap.get(key);
        if (cacheEntry == null || cacheEntry.get() == null || (isSinglePkg ? !cacheEntry.get().isLeft() : !cacheEntry.get().isRight())) {
            return null;
        }
        List diagnostics = cacheEntry.diagnostics;
        DiagnosticListener diagnosticListener = (DiagnosticListener)cacheEntry.compilerContext.get(DiagnosticListener.class);
        if (diagnostics != null && diagnosticListener instanceof CollectDiagnosticListener) {
            CollectDiagnosticListener listener = (CollectDiagnosticListener)diagnosticListener;
            listener.clearAll();
            diagnostics.forEach(listener::received);
        }
        context.put(DocumentServiceKeys.COMPILER_CONTEXT_KEY, (Object)cacheEntry.compilerContext);
        return cacheEntry;
    }

    public static void putPackage(Key key, BLangPackage bLangPackage, LSContext context) {
        LSCompilerCache.put(key, EitherPair.forLeft(bLangPackage), context);
    }

    public static void putPackages(Key key, List<BLangPackage> bLangPackages, LSContext context) {
        LSCompilerCache.put(key, EitherPair.forRight(bLangPackages), context);
    }

    private static void put(Key key, EitherPair<BLangPackage, List<BLangPackage>> bLangPackages, LSContext context) {
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        String sourceRoot = key.sourceRoot;
        packageMap.put(key, new CacheEntry(bLangPackages, compilerContext));
        LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + sourceRoot + "'} added cache entry with {key: " + key + "}");
    }

    public static synchronized void clear(LSContext context, String sourceRoot) {
        AtomicInteger count = new AtomicInteger(0);
        packageMap.keySet().stream().filter(p -> ((Key)p).sourceRoot.equals(sourceRoot)).forEach(k -> {
            packageMap.remove(k);
            count.getAndIncrement();
        });
        LSClientLogger.logTrace("Operation '" + context.getOperation().getName() + "' {projectRoot: '" + sourceRoot + "'} cleared " + count + " cached entries for the project");
    }

    public static void clearAll() {
        packageMap.clear();
    }

    public static void markOutDated(Key key) {
        CacheEntry cacheEntry = packageMap.get(key);
        if (cacheEntry != null) {
            cacheEntry.isOutdated = true;
            packageMap.put(key, cacheEntry);
        }
    }

    static {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(10L).build();
        packageMap = cache.asMap();
    }

    public static class CacheEntry {
        private EitherPair<BLangPackage, List<BLangPackage>> bLangPackages;
        private CompilerContext compilerContext;
        private final List<Diagnostic> diagnostics;
        private boolean isOutdated = false;

        CacheEntry(EitherPair<BLangPackage, List<BLangPackage>> bLangPackages, CompilerContext compilerContext) {
            this.bLangPackages = bLangPackages;
            this.compilerContext = compilerContext;
            DiagnosticListener diagnosticListener = (DiagnosticListener)compilerContext.get(DiagnosticListener.class);
            ArrayList<Diagnostic> diagnostics = null;
            if (diagnosticListener instanceof CollectDiagnosticListener) {
                CollectDiagnosticListener listener = (CollectDiagnosticListener)diagnosticListener;
                diagnostics = new ArrayList<Diagnostic>(listener.getDiagnostics());
            }
            this.diagnostics = diagnostics;
        }

        public EitherPair<BLangPackage, List<BLangPackage>> get() {
            return this.bLangPackages;
        }

        public boolean isOutdated() {
            return this.isOutdated;
        }
    }

    public static class Key {
        private final String sourceRoot;
        private final String errorStrategy;
        private final String compilerPhase;
        private final String preserveWhitespace;
        private final String testEnabled;
        private final String skipTests;
        private final String sourceDirectory;

        public Key(String sourceRoot, LSContext context) {
            this.sourceRoot = sourceRoot;
            CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
            CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
            this.compilerPhase = options.get(CompilerOptionName.COMPILER_PHASE);
            this.preserveWhitespace = options.get(CompilerOptionName.PRESERVE_WHITESPACE);
            this.testEnabled = options.get(CompilerOptionName.TEST_ENABLED);
            this.skipTests = options.get(CompilerOptionName.SKIP_TESTS);
            DefaultErrorStrategy defaultErrorStrategy = (DefaultErrorStrategy)compilerContext.get(DefaultErrorStrategy.class);
            this.errorStrategy = defaultErrorStrategy != null ? defaultErrorStrategy.getClass().getName() : null;
            SourceDirectory sourceDirectory = (SourceDirectory)compilerContext.get(SourceDirectory.class);
            this.sourceDirectory = sourceDirectory != null ? sourceDirectory.getClass().getName() : null;
        }

        public boolean equals(Object o) {
            if (this == o || !(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return key.sourceRoot.equals(this.sourceRoot) && this.errorStrategy != null && this.errorStrategy.equals(key.errorStrategy) && this.compilerPhase != null && this.compilerPhase.equals(key.compilerPhase) && this.preserveWhitespace != null && this.preserveWhitespace.equals(key.preserveWhitespace) && this.testEnabled != null && this.testEnabled.equals(key.testEnabled) && this.skipTests != null && this.skipTests.equals(key.skipTests) && this.sourceDirectory != null && this.sourceDirectory.equals(key.sourceDirectory);
        }

        public int hashCode() {
            return Arrays.hashCode(new String[]{this.sourceRoot, this.errorStrategy, this.compilerPhase, this.preserveWhitespace, this.testEnabled, this.skipTests, this.sourceDirectory});
        }

        public String toString() {
            return String.format("sourceRoot %s, errorStrategy: %s, compilerPhase: %s, preserveWS: %s, testEnabled: %s, skipTests: %s, sourceDirectory: %s", this.sourceRoot, this.errorStrategy != null ? this.errorStrategy.substring(this.errorStrategy.lastIndexOf(".") + 1) : "", this.compilerPhase != null ? this.compilerPhase : "", this.preserveWhitespace != null ? this.preserveWhitespace : "", this.testEnabled != null ? this.testEnabled : "", this.skipTests != null ? this.skipTests : "", this.sourceDirectory != null ? this.sourceDirectory.substring(this.sourceDirectory.lastIndexOf(".") + 1) : "");
        }
    }
}

