/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSContextManager;
import org.ballerinalang.langserver.compiler.common.CustomErrorStrategyFactory;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.langserver.compiler.workspace.repository.LangServerFSProgramDirectory;
import org.ballerinalang.langserver.compiler.workspace.repository.LangServerFSProjectDirectory;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.PackageRepository;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;

public class LSCompilerUtil {
    private static final Logger logger = LoggerFactory.getLogger(LSCompilerUtil.class);
    public static final String UNTITLED_BAL = "untitled.bal";
    private static Path untitledProjectPath;
    private static final Pattern untitledFilePattern;
    private static EmptyPrintStream emptyPrintStream;

    public static CompilerContext prepareCompilerContext(PackageID packageID, PackageRepository packageRepository, String sourceRoot, WorkspaceDocumentManager documentManager, CompilerPhase compilerPhase, boolean stopOnSemanticErrors) {
        LSContextManager lsContextManager = LSContextManager.getInstance();
        CompilerContext context = lsContextManager.getCompilerContext(packageID, sourceRoot, documentManager);
        context.put(PackageRepository.class, (Object)packageRepository);
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        boolean isExperimentalEnabled = LSClientConfigHolder.getInstance().getConfig().isAllowExperimental();
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(isExperimentalEnabled));
        if (null == compilerPhase) {
            throw new AssertionError((Object)"Compiler Phase can not be null.");
        }
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.TRUE.toString());
        options.put(CompilerOptionName.TEST_ENABLED, String.valueOf(true));
        options.put(CompilerOptionName.SKIP_TESTS, String.valueOf(false));
        options.put(CompilerOptionName.TOOLING_COMPILATION, String.valueOf(stopOnSemanticErrors));
        context.put(DefaultErrorStrategy.class, null);
        if (context.get(DiagnosticListener.class) instanceof CollectDiagnosticListener) {
            ((CollectDiagnosticListener)context.get(DiagnosticListener.class)).clearAll();
        }
        LangServerFSProjectDirectory projectDirectory = LangServerFSProjectDirectory.getInstance(Paths.get(sourceRoot, new String[0]), documentManager);
        context.put(SourceDirectory.class, (Object)projectDirectory);
        return context;
    }

    public static CompilerContext prepareCompilerContext(PackageRepository packageRepository, String sourceRoot, WorkspaceDocumentManager documentManager, boolean stopOnSemanticErrors) {
        return LSCompilerUtil.prepareCompilerContext(null, packageRepository, sourceRoot, documentManager, CompilerPhase.TAINT_ANALYZE, stopOnSemanticErrors);
    }

    public static CompilerContext prepareCompilerContext(PackageID pkgID, PackageRepository pkgRepo, LSDocumentIdentifier lsDocument, WorkspaceDocumentManager docManager, CompilerPhase compilerPhase, boolean stopOnSemanticErrors) {
        CompilerContext context = LSCompilerUtil.prepareCompilerContext(pkgID, pkgRepo, lsDocument.getProjectRoot(), docManager, compilerPhase, stopOnSemanticErrors);
        Path sourceRootPath = lsDocument.getProjectRootPath();
        if (lsDocument.isWithinProject()) {
            LangServerFSProjectDirectory projectDirectory = LangServerFSProjectDirectory.getInstance(sourceRootPath, docManager);
            context.put(SourceDirectory.class, (Object)projectDirectory);
        } else {
            LangServerFSProgramDirectory programDirectory = LangServerFSProgramDirectory.getInstance(sourceRootPath, docManager);
            context.put(SourceDirectory.class, (Object)programDirectory);
        }
        return context;
    }

    public static CompilerContext prepareCompilerContext(PackageID packageID, PackageRepository packageRepository, LSDocumentIdentifier sourceRoot, WorkspaceDocumentManager documentManager, boolean stopOnSemanticErrors) {
        return LSCompilerUtil.prepareCompilerContext(packageID, packageRepository, sourceRoot, documentManager, CompilerPhase.COMPILER_PLUGIN, stopOnSemanticErrors);
    }

    static Compiler getCompiler(LSContext context, CompilerContext compilerContext, Class customErrorStrategy) {
        context.put(DocumentServiceKeys.COMPILER_CONTEXT_KEY, (Object)compilerContext);
        if (customErrorStrategy != null) {
            compilerContext.put(DefaultErrorStrategy.class, (Object)CustomErrorStrategyFactory.getCustomErrorStrategy(customErrorStrategy, context));
        }
        BLangDiagnosticLogHelper.getInstance((CompilerContext)compilerContext).resetErrorCount();
        Compiler compiler = Compiler.getInstance((CompilerContext)compilerContext);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler;
    }

    public static String getProjectRoot(Path filePath) {
        if (filePath == null || filePath.getParent() == null) {
            return null;
        }
        Path parentPath = filePath.getParent();
        Path projectRoot = ProjectDirs.findProjectRoot((Path)Paths.get(parentPath.toString(), new String[0]));
        return projectRoot != null ? projectRoot.toString() : parentPath.toString();
    }

    public static String getProjectDir(Path filePath) {
        if (filePath == null || filePath.getParent() == null) {
            return null;
        }
        Path parentPath = filePath.getParent();
        Path projectRoot = ProjectDirs.findProjectRoot((Path)Paths.get(parentPath.toString(), new String[0]));
        return projectRoot == null ? null : projectRoot.toString();
    }

    public static Path getCurrentModulePath(Path filePath) {
        Path projectRoot;
        Path currentModulePath = projectRoot = Paths.get(LSCompilerUtil.getProjectRoot(filePath), new String[0]);
        Path prevSourceRoot = filePath.getParent();
        try {
            if (prevSourceRoot == null || Files.isSameFile(prevSourceRoot, projectRoot)) {
                return currentModulePath;
            }
            while (true) {
                Path newSourceRoot = prevSourceRoot.getParent();
                currentModulePath = prevSourceRoot;
                if (!(newSourceRoot == null || newSourceRoot.toString().isEmpty() || "/".equals(newSourceRoot.toString()) || Files.isSameFile(newSourceRoot, projectRoot))) {
                    prevSourceRoot = newSourceRoot;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return currentModulePath;
    }

    public static Path createTempFile(String tempFileId) {
        if (UNTITLED_BAL.equals(tempFileId)) {
            return Paths.get(untitledProjectPath.toString(), tempFileId);
        }
        File tempInnerFolder = new File(Paths.get(untitledProjectPath.toString(), tempFileId).toString());
        File untitledBal = new File(Paths.get(tempInnerFolder.toString(), UNTITLED_BAL).toString());
        if (!untitledBal.exists()) {
            try {
                boolean newFile;
                boolean mkdir = tempInnerFolder.mkdir();
                if (mkdir && logger.isDebugEnabled()) {
                    logger.debug("Temp directory created: " + tempInnerFolder.toURI());
                }
                if ((newFile = untitledBal.createNewFile()) && logger.isDebugEnabled()) {
                    logger.debug("Temp file created: " + untitledBal.toURI());
                }
            }
            catch (IOException e) {
                logger.error("Unable to create untitled project directory, unsaved files might not work properly.");
            }
        }
        return Paths.get(tempInnerFolder.toString(), UNTITLED_BAL);
    }

    public static Optional<String> getUntitledFileId(String filePath) {
        Matcher pkgMatcher = untitledFilePattern.matcher(filePath);
        return pkgMatcher.find() ? Optional.of(pkgMatcher.group(1)) : Optional.empty();
    }

    public static Optional<Path> getUntitledFilePath(String filePath) {
        return LSCompilerUtil.getUntitledFileId(filePath).map(LSCompilerUtil::createTempFile);
    }

    static Manifest getManifest(Path projectDirPath) {
        Path tomlFilePath = projectDirPath.resolve("Ballerina.toml");
        try {
            return ManifestProcessor.parseTomlContentFromFile((Path)tomlFilePath);
        }
        catch (IOException | TomlException e) {
            return new Manifest();
        }
    }

    static {
        untitledFilePattern = Pattern.compile(".*[/\\\\]temp[/\\\\](.*)[/\\\\]untitled.bal");
        try {
            emptyPrintStream = new EmptyPrintStream();
        }
        catch (IOException e) {
            logger.error("Unable to create the empty stream.");
        }
        try {
            untitledProjectPath = Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Unable to create the temp directory.");
        }
        File untitledBal = new File(Paths.get(untitledProjectPath.toString(), UNTITLED_BAL).toString());
        try {
            boolean created = untitledBal.createNewFile();
            if (created && logger.isDebugEnabled()) {
                logger.debug("A temp file created: " + untitledBal.toURI());
            }
        }
        catch (IOException e) {
            logger.error("Unable to create untitled project directory, unsaved files might not work properly.");
        }
    }

    public static class EmptyPrintStream
    extends PrintStream {
        public EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

