/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LSPackageCache {
    private static final CompilerContext.Key<LSPackageCache> LS_PACKAGE_CACHE_KEY = new CompilerContext.Key();
    private static final Object LOCK = new Object();
    private final ExtendedPackageCache packageCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LSPackageCache getInstance(CompilerContext context) {
        LSPackageCache lsPackageCache = (LSPackageCache)context.get(LS_PACKAGE_CACHE_KEY);
        if (lsPackageCache == null) {
            Object object = LOCK;
            synchronized (object) {
                lsPackageCache = (LSPackageCache)context.get(LS_PACKAGE_CACHE_KEY);
                if (lsPackageCache == null) {
                    lsPackageCache = new LSPackageCache(context);
                }
            }
        }
        return lsPackageCache;
    }

    private LSPackageCache(CompilerContext context) {
        this.packageCache = new ExtendedPackageCache(context);
        context.put(LS_PACKAGE_CACHE_KEY, (Object)this);
    }

    public BLangPackage get(PackageID pkgId) {
        return this.packageCache.get(pkgId);
    }

    public void invalidate(PackageID packageID) {
        this.packageCache.remove(packageID);
    }

    public void invalidateProjectModules(List<String> modules) {
        this.packageCache.remove(modules);
    }

    public void clearCache() {
        this.packageCache.clearCache();
    }

    public void put(PackageID packageID, BLangPackage bLangPackage) {
        if (bLangPackage != null) {
            bLangPackage.packageID = packageID;
            this.packageCache.put(packageID, bLangPackage);
        }
    }

    public ExtendedPackageCache getPackageCache() {
        return this.packageCache;
    }

    public Map<String, BLangPackage> getPackageMap() {
        return this.packageCache.getMap();
    }

    static class ExtendedPackageCache
    extends PackageCache {
        private static final long MAX_CACHE_COUNT = 100L;
        protected Map<String, BPackageSymbol> pkgSymbolMap;

        private ExtendedPackageCache(CompilerContext context) {
            super(context);
            Cache cache = CacheBuilder.newBuilder().maximumSize(100L).build();
            this.packageMap = cache.asMap();
            this.pkgSymbolMap = new ConcurrentHashMap<String, BPackageSymbol>();
        }

        public Map<String, BLangPackage> getMap() {
            return this.packageMap;
        }

        public void remove(PackageID packageID) {
            if (packageID != null) {
                this.packageMap.forEach((key, value) -> {
                    boolean isLangLib;
                    String[] split = key.split("/");
                    String alias = split.length > 1 ? split[1] : key;
                    String orgName = split.length > 1 ? split[0] : "";
                    String name = packageID.getName().value;
                    boolean bl = isLangLib = Names.BALLERINA_ORG.value.equals(orgName) && alias.startsWith(Names.LANG.value + ".");
                    if (!isLangLib && (alias.contains(name + ":") || alias.contains(name))) {
                        this.packageMap.remove(key);
                    }
                });
                this.pkgSymbolMap.forEach((key, value) -> {
                    boolean isLangLib;
                    String[] split = key.split("/");
                    String alias = split.length > 1 ? split[1] : key;
                    String orgName = split.length > 1 ? split[0] : "";
                    String name = packageID.getName().value;
                    boolean bl = isLangLib = Names.BALLERINA_ORG.value.equals(orgName) && alias.startsWith(Names.LANG.value + ".");
                    if (!isLangLib && (alias.contains(name + ":") || alias.contains(name))) {
                        this.pkgSymbolMap.remove(key);
                    }
                });
            }
        }

        public void remove(List<String> modules) {
            if (modules.isEmpty()) {
                return;
            }
            this.packageMap.forEach((key, value) -> {
                String moduleName = value.packageID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining("."));
                if (modules.contains(moduleName)) {
                    this.packageMap.remove(key);
                }
            });
            this.pkgSymbolMap.forEach((key, value) -> {
                String moduleName = value.pkgID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining("."));
                if (modules.contains(moduleName)) {
                    this.pkgSymbolMap.remove(key);
                }
            });
        }

        public void clearCache() {
            this.packageMap.clear();
            this.pkgSymbolMap.clear();
        }
    }
}

