/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.common.modal;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFile {
    private BLangPackage bLangPackage;
    private final List<Diagnostic> diagnostics;
    private final boolean isBallerinaProject;
    private CompilerContext compilerContext;

    public BallerinaFile(BLangPackage bLangPackage, List<Diagnostic> diagnostics, boolean isBallerinaProject, CompilerContext compilerContext) {
        this.bLangPackage = bLangPackage;
        this.diagnostics = diagnostics;
        this.isBallerinaProject = isBallerinaProject;
        this.compilerContext = compilerContext;
    }

    public Optional<List<Diagnostic>> getDiagnostics() {
        Optional<List<Diagnostic>> diagnostics = Optional.ofNullable(this.diagnostics);
        diagnostics.ifPresent(diag -> diag.sort(Comparator.comparingInt(a -> a.getPosition().getStartLine())));
        return diagnostics;
    }

    public Optional<BLangPackage> getBLangPackage() {
        return Optional.ofNullable(this.bLangPackage);
    }

    public boolean isBallerinaProject() {
        return this.isBallerinaProject;
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    public void setBLangPackage(BLangPackage bLangPackage) {
        this.bLangPackage = bLangPackage;
    }
}

