/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.common.modal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public final class SymbolMetaInfo {
    private String name;
    private String pkgOrgName;
    private String pkgName;
    private String pkgAlias;
    private boolean caller;
    private String kind;
    private BSymbol bSymbol;
    private String typeName;
    private boolean isLocal;
    private DiagnosticPos position;

    private SymbolMetaInfo(String name, String pkgOrgName, String pkgName, String pkgAlias, boolean caller, String kind, BSymbol bSymbol, String typeName, boolean isLocal, DiagnosticPos position) {
        this.name = name;
        this.pkgOrgName = pkgOrgName;
        this.pkgName = pkgName;
        this.pkgAlias = pkgAlias;
        this.caller = caller;
        this.kind = kind;
        this.bSymbol = bSymbol;
        this.typeName = typeName;
        this.isLocal = isLocal;
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public String getPkgOrgName() {
        return this.pkgOrgName;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getPkgAlias() {
        return this.pkgAlias;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public String getKind() {
        return this.kind;
    }

    public BSymbol getbSymbol() {
        return this.bSymbol;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public JsonElement getJson() {
        Gson gson = new Gson();
        JsonElement element = gson.toJsonTree((Object)this);
        if (this.position != null) {
            JsonObject positionJson = new JsonObject();
            positionJson.addProperty("startColumn", (Number)this.position.getStartColumn());
            positionJson.addProperty("startLine", (Number)this.position.getStartLine());
            positionJson.addProperty("endColumn", (Number)this.position.getEndColumn());
            positionJson.addProperty("endLine", (Number)this.position.getEndLine());
            element.getAsJsonObject().add("position", (JsonElement)positionJson);
        }
        return element;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public DiagnosticPos getPosition() {
        return this.position;
    }

    public static class SymbolMetaInfoBuilder {
        private String name;
        private String pkgOrgName;
        private String pkgName;
        private String pkgAlias;
        private boolean caller = false;
        private String kind = "";
        private BSymbol bSymbol;
        private String typeName;
        private boolean isLocal;
        private DiagnosticPos pos;

        public SymbolMetaInfoBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SymbolMetaInfoBuilder setCaller(boolean caller) {
            this.caller = caller;
            return this;
        }

        public SymbolMetaInfoBuilder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public SymbolMetaInfoBuilder setPkgOrgName(String pkgOrgName) {
            this.pkgOrgName = pkgOrgName;
            return this;
        }

        public SymbolMetaInfoBuilder setPkgName(String pkgName) {
            this.pkgName = pkgName;
            return this;
        }

        public SymbolMetaInfoBuilder setPkgAlias(String pkgAlias) {
            this.pkgAlias = pkgAlias;
            return this;
        }

        public SymbolMetaInfoBuilder setbSymbol(BSymbol bSymbol) {
            this.bSymbol = bSymbol;
            return this;
        }

        public SymbolMetaInfoBuilder setTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public SymbolMetaInfoBuilder setLocal(boolean local) {
            this.isLocal = local;
            return this;
        }

        public SymbolMetaInfoBuilder setPos(DiagnosticPos pos) {
            this.pos = pos;
            return this;
        }

        public SymbolMetaInfo build() {
            return new SymbolMetaInfo(this.name, this.pkgOrgName, this.pkgName, this.pkgAlias, this.caller, this.kind, this.bSymbol, this.typeName, this.isLocal, this.pos);
        }
    }
}

