/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.langserver.compiler.config.ConfigChangeListener;
import org.ballerinalang.langserver.compiler.config.LSClientConfig;

public class LSClientConfigHolder {
    private static final LSClientConfigHolder INSTANCE = new LSClientConfigHolder();
    private List<ConfigChangeListener> listeners = new ArrayList<ConfigChangeListener>();
    private LSClientConfig clientConfig = LSClientConfig.getDefault();

    private LSClientConfigHolder() {
    }

    public static LSClientConfigHolder getInstance() {
        return INSTANCE;
    }

    public LSClientConfig getConfig() {
        return this.clientConfig;
    }

    public void register(ConfigChangeListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ConfigChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void updateConfig(LSClientConfig newConfig) {
        LSClientConfig oldConfig = this.clientConfig;
        this.clientConfig = newConfig;
        ((Stream)this.listeners.stream().parallel()).forEach(listener -> listener.didChange(oldConfig, newConfig));
    }
}

