/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.format;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.compiler.format.FormattingConstants;
import org.ballerinalang.langserver.compiler.sourcegen.FormattingSourceGen;

public class FormattingNodeTree {
    public void formatAbortNode(JsonObject node) {
        this.modifyBranchingStatement(node);
    }

    public void formatAnnotationNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isPublic = node.has("public") && node.get("public").getAsBoolean();
            boolean isConst = node.has("constant") && node.get("constant").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String whiteSpace;
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals("public")) {
                    whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                    currentWS.addProperty("ws", whiteSpace);
                    continue;
                }
                if (text.equals("const")) {
                    if (!isPublic) {
                        whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                        currentWS.addProperty("ws", whiteSpace);
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("annotation")) {
                    if (!isPublic && !isConst) {
                        whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                        currentWS.addProperty("ws", whiteSpace);
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(";") || text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("typeNode")) {
                JsonObject typeNode = node.getAsJsonObject("typeNode");
                JsonObject typeNodeFormattingConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false);
                typeNode.add("formattingConfig", (JsonElement)typeNodeFormattingConfig);
            }
            this.modifyAnnotationAttachments(node, formatConfig, indentation);
        }
    }

    public void formatAnnotationAttachmentNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(node.getAsJsonArray("ws"), useParentIndentation ? indentWithParentIndentation : indentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("@")) {
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentWithParentIndentation);
                        continue;
                    }
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression") && node.getAsJsonObject("expression").has("ws")) {
                JsonObject expression = node.getAsJsonObject("expression");
                JsonObject expressionFormatConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
        }
    }

    public void formatAnnotAccessExpressionNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatArrayLiteralExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject openingBracketWS = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(openingBracketWS.get("ws").getAsString())) {
                openingBracketWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
            }
            for (JsonElement item : ws) {
                JsonObject wsItem = item.getAsJsonObject();
                String text = wsItem.get("text").getAsString();
                if (!text.equals(",") || !this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                wsItem.addProperty("ws", "");
            }
            JsonObject closingBracketWS = ws.get(ws.size() - 1).getAsJsonObject();
            if (this.noHeightAvailable(closingBracketWS.get("ws").getAsString())) {
                closingBracketWS.addProperty("ws", "");
            }
            this.modifyExpressions(node, indentWithParentIndentation);
        }
    }

    public void formatArrayTypeNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            String indentation = this.getIndentation(formatConfig, false);
            if (node.has("elementType")) {
                if (node.has("grouped") && node.get("grouped").getAsBoolean()) {
                    JsonObject elementTypeFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                    node.getAsJsonObject("elementType").add("formattingConfig", (JsonElement)elementTypeFormatConfig);
                } else {
                    node.getAsJsonObject("elementType").add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                this.preserveHeight(ws, useParentIndentation ? indentWithParentIndentation : indentation, useParentIndentation);
                for (int i = 0; i < ws.size(); ++i) {
                    JsonObject wsItem = ws.get(i).getAsJsonObject();
                    if (!this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                    String text = wsItem.get("text").getAsString();
                    if (text.equals("(") && i == 0) {
                        if (!node.has("grouped") || !node.get("grouped").getAsBoolean()) continue;
                        wsItem.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                        continue;
                    }
                    wsItem.addProperty("ws", "");
                }
            }
        }
    }

    public void formatAssignmentNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean hasVar = node.has("declaredWithVar") && node.get("declaredWithVar").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("var") && hasVar) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(";")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals("start")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("variable")) {
                JsonObject variable = node.getAsJsonObject("variable");
                JsonObject variableFormatConfig = hasVar ? this.getFormattingConfig(0, 1, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), false) : this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), 0, formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(indentation), false);
                variable.add("formattingConfig", (JsonElement)variableFormatConfig);
            }
            if (node.has("expression") && node.getAsJsonObject("expression").has("ws")) {
                JsonObject expression = node.getAsJsonObject("expression");
                JsonObject expressionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
        }
    }

    public void formatArrowExprNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean paranOnNewLine = false;
            boolean equalGTOnNewLine = false;
            boolean isParamOnNewLine = false;
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
                for (JsonElement wsItem : ws) {
                    JsonObject arrowExprWS = wsItem.getAsJsonObject();
                    String text = arrowExprWS.get("text").getAsString();
                    if (this.noHeightAvailable(arrowExprWS.get("ws").getAsString())) {
                        if (text.equals("(")) {
                            arrowExprWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        if (text.equals(",")) {
                            arrowExprWS.addProperty("ws", "");
                            continue;
                        }
                        if (text.equals(")")) {
                            arrowExprWS.addProperty("ws", "");
                            continue;
                        }
                        if (!text.equals("=>")) continue;
                        arrowExprWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals("(") || text.equals(")")) {
                        paranOnNewLine = true;
                        continue;
                    }
                    if (text.equals("=>")) {
                        equalGTOnNewLine = true;
                        continue;
                    }
                    if (!text.equals(",") || !paranOnNewLine) continue;
                    arrowExprWS.addProperty("ws", arrowExprWS.get("ws").getAsString() + "    ");
                }
            }
            if (node.has("parameters")) {
                JsonArray parameters = node.getAsJsonArray("parameters");
                isParamOnNewLine = this.isMemberOnNewLine(parameters);
                boolean hasParentheses = node.has("hasParantheses") && node.get("hasParantheses").getAsBoolean();
                for (int i = 0; i < parameters.size(); ++i) {
                    JsonObject param = parameters.get(i).getAsJsonObject();
                    JsonObject paramFormatConfig = i == 0 ? (hasParentheses ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(paranOnNewLine ? indentWithParentIndentation + "    " : indentWithParentIndentation), true) : this.getFormattingConfig(0, formatConfig.get("spacesCount").getAsInt(), 0, false, this.getWhiteSpaceCount(paranOnNewLine ? indentWithParentIndentation + "    " : indentWithParentIndentation), true)) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(paranOnNewLine ? indentWithParentIndentation + "    " : indentWithParentIndentation), true);
                    param.add("formattingConfig", (JsonElement)paramFormatConfig);
                }
            }
            if (node.has("body")) {
                JsonObject body = node.getAsJsonObject("body");
                JsonObject bodyFormatConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentWithParentIndentation), false, this.getWhiteSpaceCount(equalGTOnNewLine || paranOnNewLine || isParamOnNewLine ? indentWithParentIndentation + "    " : indentWithParentIndentation), true);
                body.add("formattingConfig", (JsonElement)bodyFormatConfig);
            }
        }
    }

    public void formatBinaryExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject operatorSymbolWS = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(operatorSymbolWS.get("ws").getAsString())) {
                operatorSymbolWS.addProperty("ws", " ");
            }
            if (node.has("leftExpression")) {
                node.getAsJsonObject("leftExpression").add("formattingConfig", (JsonElement)formatConfig);
                node.getAsJsonObject("leftExpression").addProperty("isExpression", Boolean.valueOf(true));
            }
            if (node.has("rightExpression")) {
                JsonObject rightExpression = node.getAsJsonObject("rightExpression");
                JsonObject rightExprFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true);
                rightExpression.add("formattingConfig", (JsonElement)rightExprFormatConfig);
                rightExpression.addProperty("isExpression", Boolean.valueOf(true));
            }
        }
    }

    public void formatBlockNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            for (JsonElement child : node.getAsJsonArray("statements")) {
                child.getAsJsonObject().add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("ws") && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("else")) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt());
                this.preserveHeight(ws, indentation, false);
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    String text = currentWS.get("text").getAsString();
                    if (text.equals("else")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals("{")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals("}")) continue;
                    if (node.getAsJsonArray("statements").size() <= 0) {
                        currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation + FormattingConstants.NEW_LINE + indentation);
                        continue;
                    }
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                }
            }
        }
    }

    public void formatBlockFunctionBodyNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                if (node.has("statements") && node.getAsJsonArray("statements").size() > 0) {
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentationOfParent);
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("statements")) {
                JsonObject stmtsFormatConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation) == 0 ? this.getWhiteSpaceCount(indentationOfParent) : this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentationOfParent), false);
                JsonArray stmts = node.getAsJsonArray("statements");
                for (JsonElement stmtItem : stmts) {
                    JsonObject stmt = stmtItem.getAsJsonObject();
                    stmt.add("formattingConfig", (JsonElement)stmtsFormatConfig);
                }
            }
        }
    }

    public void formatBracedTupleExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("(")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (!text.equals(")") && !text.equals(",")) continue;
                currentWS.addProperty("ws", "");
            }
            this.modifyExpressions(node, formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation);
        }
    }

    public void formatBreakNode(JsonObject node) {
        this.modifyBranchingStatement(node);
    }

    public void formatBuiltInRefTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            JsonObject refTypeWhitespace = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(refTypeWhitespace.get("ws").getAsString())) {
                refTypeWhitespace.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
        }
    }

    public void formatCheckExprNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            String indentationWithParent = this.getParentIndentation(formatConfig);
            this.preserveHeight(ws, useParentIndentation ? indentationWithParent : indentation, useParentIndentation);
            int indentationSpaceCount = formatConfig.get("spacesCount").getAsInt();
            int indentationNewLineCount = formatConfig.get("newLineCount").getAsInt();
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("check")) {
                    if (indentationSpaceCount > 0) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (indentationNewLineCount <= 0) continue;
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationSpaceCount > 0 ? indentationWithParent : indentation), true));
            }
        }
    }

    public void formatCheckPanicExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            boolean isExpression = node.has("isExpression") && node.get("isExpression").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("checkpanic")) {
                    if (isExpression) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatCompilationUnitNode(JsonObject node) {
        JsonArray topLevelNodes = node.get("topLevelNodes").getAsJsonArray();
        for (int i = 0; i < topLevelNodes.size() - 1; ++i) {
            boolean swapped = false;
            for (int j = 0; j < topLevelNodes.size() - i - 1; ++j) {
                String compImportName;
                String refImportName;
                int comparisonResult;
                if (!topLevelNodes.get(j).getAsJsonObject().get("kind").getAsString().equals("Import") || !topLevelNodes.get(j).getAsJsonObject().has("ws") || !topLevelNodes.get(j + 1).getAsJsonObject().get("kind").getAsString().equals("Import") || !topLevelNodes.get(j + 1).getAsJsonObject().has("ws") || (comparisonResult = (refImportName = topLevelNodes.get(j).getAsJsonObject().get("orgName").getAsJsonObject().get("value").getAsString() + "/" + topLevelNodes.get(j).getAsJsonObject().get("packageName").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString()).compareTo(compImportName = topLevelNodes.get(j + 1).getAsJsonObject().get("orgName").getAsJsonObject().get("value").getAsString() + "/" + topLevelNodes.get(j + 1).getAsJsonObject().get("packageName").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString())) <= 0) continue;
                String refWS = topLevelNodes.get(j).getAsJsonObject().get("ws").getAsJsonArray().get(0).getAsJsonObject().get("ws").getAsString();
                String compWS = topLevelNodes.get(j + 1).getAsJsonObject().get("ws").getAsJsonArray().get(0).getAsJsonObject().get("ws").getAsString();
                JsonElement tempLowNode = topLevelNodes.get(j);
                JsonElement tempTopNode = topLevelNodes.get(j + 1);
                FormattingSourceGen.swapWSIndexes(tempTopNode.getAsJsonObject(), tempLowNode.getAsJsonObject());
                tempLowNode.getAsJsonObject().get("ws").getAsJsonArray().get(0).getAsJsonObject().addProperty("ws", compWS);
                tempTopNode.getAsJsonObject().get("ws").getAsJsonArray().get(0).getAsJsonObject().addProperty("ws", refWS);
                topLevelNodes.set(j, tempTopNode);
                topLevelNodes.set(j + 1, tempLowNode);
                swapped = true;
            }
            if (!swapped) break;
        }
        int movedFirstIndex = 0;
        for (int index = 0; index < topLevelNodes.size(); ++index) {
            JsonObject formatConfig;
            JsonObject child = topLevelNodes.get(index).getAsJsonObject();
            int n = movedFirstIndex = child.has("ws") && !child.has("skip") ? movedFirstIndex : ++movedFirstIndex;
            if (index == movedFirstIndex) {
                formatConfig = this.getFormattingConfig(0, 0, this.getWhiteSpaceCount(""), false, this.getWhiteSpaceCount(""), false);
                movedFirstIndex = 0;
            } else {
                formatConfig = child.has("kind") && child.get("kind").getAsString().equals("Import") ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(""), false, this.getWhiteSpaceCount(""), false) : this.getFormattingConfig(2, 0, this.getWhiteSpaceCount(""), false, this.getWhiteSpaceCount(""), false);
            }
            child.add("formattingConfig", (JsonElement)formatConfig);
        }
        if (node.has("ws") && topLevelNodes.size() > 0) {
            JsonArray ws = node.get("ws").getAsJsonArray();
            this.preserveHeight(ws, null, false);
            JsonObject eofWS = ws.get(ws.size() - 1).getAsJsonObject();
            if (this.noHeightAvailable(eofWS.get("ws").getAsString())) {
                eofWS.addProperty("ws", FormattingConstants.NEW_LINE);
            } else if (this.noNewLine(eofWS.get("ws").getAsString().charAt(eofWS.get("ws").getAsString().length() - 1) + "")) {
                eofWS.addProperty("ws", eofWS.get("ws").getAsString() + FormattingConstants.NEW_LINE);
            }
        }
    }

    public void formatCompoundAssignmentNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String compoundOperator = node.get("compoundOperator").getAsString();
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals(compoundOperator)) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals(";")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("variable")) {
                node.getAsJsonObject("variable").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false));
            }
        }
    }

    public void formatConstantNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isPublic = node.has("public") && node.get("public").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("public")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("const")) {
                    if (isPublic) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(";")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            this.modifyAnnotationAttachments(node, formatConfig, indentation);
            if (node.has("typeNode")) {
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false));
            }
            if (node.has("initialExpression")) {
                node.getAsJsonObject("initialExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false));
            }
        }
    }

    public void formatConstrainedTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            if (node.has("type")) {
                JsonObject typeFormatConfig = formatConfig;
                if (isGrouped) {
                    typeFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), formatConfig.get("useParentIndentation").getAsBoolean());
                }
                node.getAsJsonObject("type").add("formattingConfig", (JsonElement)typeFormatConfig);
            }
            if (node.has("constraint")) {
                JsonObject constraintFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true);
                node.getAsJsonObject("constraint").add("formattingConfig", (JsonElement)constraintFormatConfig);
            }
            for (JsonElement item : ws) {
                JsonObject wsItem = item.getAsJsonObject();
                if (!this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                String text = wsItem.get("text").getAsString();
                if (text.equals("(") && isGrouped) {
                    if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        wsItem.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        wsItem.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    wsItem.addProperty("ws", "");
                    continue;
                }
                if (text.equals("<") || text.equals(">") || text.equals("}") || text.equals("object")) {
                    wsItem.addProperty("ws", "");
                    continue;
                }
                if (text.equals("typedesc")) {
                    wsItem.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (!text.equals(")") || !isGrouped) continue;
                wsItem.addProperty("ws", "");
            }
        }
    }

    public void formatNextNode(JsonObject node) {
        this.modifyBranchingStatement(node);
    }

    public void formatDoNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            boolean isOnNewLine = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals("do")) {
                    if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                if (node.has("body") && node.getAsJsonObject("body").getAsJsonArray("statements").size() > 0) {
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + "    " + (this.getWhiteSpaceCount(indentation) == 0 ? indentationOfParent : indentation));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("body")) {
                this.modifyConstructBody(node.getAsJsonObject("body"), indentation, indentationOfParent + "    ", false);
            }
        }
    }

    public void formatDocumentationParameterNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                String[] splitText = text.split(" ");
                if (!text.equals("#") && (splitText.length != 2 || !splitText[0].equals("#") || !splitText[1].equals("+")) && (splitText.length != 4 || !splitText[0].equals("#") || !splitText[1].equals("+") || !splitText[2].equals("return") || !splitText[3].equals("-"))) continue;
                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
        }
    }

    public void formatDoActionNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("fromClauseNodes")) {
                JsonArray fromClauseNodes = node.getAsJsonArray("fromClauseNodes");
                for (JsonElement fromClauseItem : fromClauseNodes) {
                    JsonObject fromClause = fromClauseItem.getAsJsonObject();
                    fromClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("doClauseNode")) {
                JsonObject selectClauseNode = node.getAsJsonObject("doClauseNode");
                selectClauseNode.add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("whereClauseNode")) {
                JsonArray whereClauseNodes = node.getAsJsonArray("whereClauseNode");
                for (JsonElement whereClauseItem : whereClauseNodes) {
                    JsonObject whereClause = whereClauseItem.getAsJsonObject();
                    whereClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("letClauseNode")) {
                JsonArray letClauseNodes = node.getAsJsonArray("letClauseNode");
                for (JsonElement letClauseItem : letClauseNodes) {
                    JsonObject letClause = letClauseItem.getAsJsonObject();
                    letClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
        }
    }

    public void formatMarkdownDocumentationNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (int i = 0; i < ws.size(); ++i) {
                String text;
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("#")) continue;
                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
            if (node.has("parameters") && node.getAsJsonArray("parameters").size() > 0) {
                JsonArray parameters = node.getAsJsonArray("parameters");
                for (JsonElement parameter : parameters) {
                    parameter.getAsJsonObject().add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("returnParameter")) {
                JsonObject returnParameter = node.getAsJsonObject("returnParameter");
                returnParameter.getAsJsonObject().add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatElvisExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentationOfParent, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("?:")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("leftExpression")) {
                node.getAsJsonObject("leftExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), formatConfig.get("indentedStartColumn").getAsInt(), true));
            }
            if (node.has("rightExpression")) {
                node.getAsJsonObject("rightExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatErrorConstructorNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentationOfParent, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("error")) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (!text.equals("(") && !text.equals(",") && !text.equals(")")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("reasonExpression")) {
                node.getAsJsonObject("reasonExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("detailsExpression")) {
                node.getAsJsonObject("detailsExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatErrorDestructureNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals(";")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("varRef")) {
                node.getAsJsonObject("varRef").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true));
            }
        }
    }

    public void formatErrorTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("error")) {
                        if (formatConfig.get("newLineCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals("<") && !text.equals(",") && !text.equals(">") && !text.equals("?")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals(",")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("reasonTypeNode")) {
                node.getAsJsonObject("reasonTypeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true));
            }
            if (node.has("detailsTypeNode")) {
                node.getAsJsonObject("detailsTypeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatErrorVariableNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
            boolean reasonWSUpdated = false;
            boolean isEllipsisAvailable = false;
            boolean isUnderscoreAvailable = false;
            boolean isVarAvailable = node.has("isVarExists") && node.get("isVarExists").getAsBoolean();
            boolean isOpenParanOrErrorOnNewLine = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.equals("_")) {
                    isUnderscoreAvailable = true;
                }
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("var")) {
                        if (!isEllipsisAvailable) {
                            if (formatConfig.get("newLineCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            } else if (formatConfig.get("spacesCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            } else {
                                currentWS.addProperty("ws", "");
                            }
                        } else {
                            currentWS.addProperty("ws", "");
                        }
                        isVarAvailable = true;
                        continue;
                    }
                    if (text.equals("error")) {
                        currentWS.addProperty("ws", " ");
                        isEllipsisAvailable = false;
                        continue;
                    }
                    if (text.equals("(") || text.equals("=")) {
                        currentWS.addProperty("ws", " ");
                        isEllipsisAvailable = false;
                        continue;
                    }
                    if (text.equals("...")) {
                        isEllipsisAvailable = true;
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals(",") || text.equals(")") || text.equals(";")) {
                        isEllipsisAvailable = false;
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (reasonWSUpdated) {
                        if (isEllipsisAvailable && isVarAvailable) {
                            currentWS.addProperty("ws", " ");
                        } else if (isEllipsisAvailable) {
                            currentWS.addProperty("ws", "");
                        } else {
                            currentWS.addProperty("ws", " ");
                        }
                    } else if (isEllipsisAvailable && isVarAvailable) {
                        currentWS.addProperty("ws", " ");
                    } else if (isEllipsisAvailable) {
                        currentWS.addProperty("ws", "");
                    } else {
                        currentWS.addProperty("ws", "");
                        reasonWSUpdated = true;
                    }
                    isEllipsisAvailable = false;
                    continue;
                }
                if (text.equals("var")) {
                    isVarAvailable = true;
                    continue;
                }
                if (text.equals("error") && (node.has("typeNode") || isVarAvailable)) {
                    isOpenParanOrErrorOnNewLine = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals("(") && (node.has("typeNode") || isVarAvailable)) {
                    isOpenParanOrErrorOnNewLine = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals("...")) {
                    isEllipsisAvailable = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals(",")) {
                    if (isOpenParanOrErrorOnNewLine) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    " + "    ");
                        continue;
                    }
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if ((text.equals("=") || text.equals(";") || text.equals(")")) && isOpenParanOrErrorOnNewLine) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals(";") || text.equals(",") || text.equals(")") || text.equals("(") || text.equals("=") || text.equals("error") || text.equals("var") || text.equals("...")) continue;
                isEllipsisAvailable = false;
                reasonWSUpdated = true;
                if (isOpenParanOrErrorOnNewLine) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    " + "    ");
                    continue;
                }
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("typeNode")) {
                if (isVarAvailable) {
                    node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true));
                } else {
                    node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("reason")) {
                JsonObject reason = node.getAsJsonObject("reason");
                JsonObject reasonFormatConfig = isOpenParanOrErrorOnNewLine ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + "    "), true) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true);
                reason.add("formattingConfig", (JsonElement)reasonFormatConfig);
            }
            if (node.has("detail")) {
                boolean noReason = !node.has("reason") || node.has("reason") && !this.isReasonAvailable(node.getAsJsonObject("reason"));
                JsonArray details = node.getAsJsonArray("detail");
                for (int i = 0; i < details.size(); ++i) {
                    JsonObject detail = details.get(i).getAsJsonObject();
                    if (i == 0 && noReason && !isUnderscoreAvailable) {
                        detail.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + (isOpenParanOrErrorOnNewLine ? "    " : "")), true));
                        continue;
                    }
                    detail.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + (isOpenParanOrErrorOnNewLine ? "    " : "")), true));
                }
            }
            if (node.has("restDetail")) {
                JsonObject restDetail = node.getAsJsonObject("restDetail");
                JsonObject restFormatConfig = isOpenParanOrErrorOnNewLine ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + "    "), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true);
                restDetail.add("formattingConfig", (JsonElement)restFormatConfig);
            }
            if (node.has("initialExpression")) {
                JsonObject initialExpression = node.getAsJsonObject("initialExpression");
                JsonObject exprFormatConfig = isOpenParanOrErrorOnNewLine ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + "    "), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation), true);
                initialExpression.add("formattingConfig", (JsonElement)exprFormatConfig);
            }
        }
    }

    public void formatErrorVariableRefNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("error")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("(") || text.equals("...")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals(",") && !text.equals(")")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals(",") && !text.equals("...")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("typeNode")) {
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("reason")) {
                node.getAsJsonObject("reason").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true));
            }
            if (node.has("detail")) {
                boolean noReason = !node.has("reason") || node.has("reason") && !this.isReasonAvailable(node.getAsJsonObject("reason"));
                JsonArray details = node.getAsJsonArray("detail");
                for (int i = 0; i < details.size(); ++i) {
                    JsonObject detail = details.get(i).getAsJsonObject();
                    if (i == 0 && noReason) {
                        detail.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true));
                        continue;
                    }
                    detail.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true));
                }
            }
            if (node.has("restVar")) {
                node.getAsJsonObject("restVar").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true));
            }
        }
    }

    public void formatExprFunctionBodyNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            this.preserveHeight(ws, indentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString()) && text.equals("=>")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("=>")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("expr")) {
                JsonObject expr = node.getAsJsonObject("expr");
                expr.add("formattingConfig", (JsonElement)this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), 0, formatConfig.get("doIndent").getAsBoolean(), formatConfig.get("indentedStartColumn").getAsInt(), formatConfig.get("useParentIndentation").getAsBoolean()));
            }
        }
    }

    public void formatExpressionStatementNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject semicolonWhitespace;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)formatConfig);
            }
            if (this.noHeightAvailable((semicolonWhitespace = ws.get(0).getAsJsonObject()).get("ws").getAsString())) {
                semicolonWhitespace.addProperty("ws", "");
            }
        }
    }

    public void formatExternFunctionBodyNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("=") && !text.equals("external")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("annotationAttachments")) {
                JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                for (int i = 0; i < annotationAttachments.size(); ++i) {
                    JsonObject annotationAttachment = annotationAttachments.get(i).getAsJsonObject();
                    JsonObject annotationFormattingConfig = i == 0 ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true) : this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), true);
                    annotationAttachment.add("formattingConfig", (JsonElement)annotationFormattingConfig);
                }
            }
        }
    }

    public void formatFieldBasedAccessExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                if (node.has("isExpression") && node.get("isExpression").getAsBoolean()) {
                    expression.addProperty("isExpression", Boolean.valueOf(true));
                }
                JsonObject expressionFormatConfig = this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(indentation.isEmpty() ? indentWithParentIndentation : indentation), formatConfig.get("useParentIndentation").getAsBoolean());
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
            for (JsonElement jsonElement : ws) {
                if (!this.noHeightAvailable(jsonElement.getAsJsonObject().get("ws").getAsString())) continue;
                jsonElement.getAsJsonObject().addProperty("ws", "");
            }
        }
    }

    public void formatFiniteTypeNodeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.get("ws").getAsJsonArray();
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean leadWithWhiteSpace = node.has("leadWithWhiteSpace") && node.get("leadWithWhiteSpace").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("|")) continue;
                currentWS.addProperty("ws", "");
            }
            int spaceCount = 0;
            spaceCount = leadWithWhiteSpace ? 1 : (!node.has("leadWithWhiteSpace") ? 1 : 0);
            if (node.has("valueSet")) {
                JsonArray valueSet = node.getAsJsonArray("valueSet");
                for (int i = 0; i < valueSet.size(); ++i) {
                    JsonObject value = valueSet.get(i).getAsJsonObject();
                    JsonObject valueFormatConfig = i == 0 ? this.getFormattingConfig(0, spaceCount, 0, false, this.getWhiteSpaceCount(indentation), false) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), false);
                    value.add("formattingConfig", (JsonElement)valueFormatConfig);
                }
            }
        }
    }

    public void formatForeachNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = formatConfig.get("doIndent").getAsBoolean() ? this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt()) + "    " : this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt());
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentWithParentIndentation));
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            for (JsonElement item : ws) {
                JsonObject wsItem = item.getAsJsonObject();
                if (!this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                String text = wsItem.get("text").getAsString();
                if (text.equals("foreach")) {
                    wsItem.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentWithParentIndentation);
                    continue;
                }
                if (text.equals("(")) {
                    wsItem.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(",")) {
                    wsItem.addProperty("ws", "");
                    continue;
                }
                if (text.equals("in")) {
                    wsItem.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(")")) {
                    wsItem.addProperty("ws", "");
                    continue;
                }
                if (text.equals("{")) {
                    wsItem.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("}")) {
                    if (node.has("body") && node.getAsJsonObject("body").has("statements") && node.getAsJsonObject("body").getAsJsonArray("statements").size() <= 0) {
                        wsItem.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation + FormattingConstants.NEW_LINE + indentWithParentIndentation);
                        continue;
                    }
                    wsItem.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation);
                    continue;
                }
                wsItem.addProperty("ws", " ");
            }
            if (node.has("variables")) {
                JsonArray variables = node.getAsJsonArray("variables");
                for (int i = 0; i < variables.size(); ++i) {
                    JsonObject variable = variables.get(i).getAsJsonObject();
                    JsonObject variableFormatConfig = i == 0 && node.has("withParantheses") && node.get("withParantheses").getAsBoolean() ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), false) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                    variable.add("formattingConfig", (JsonElement)variableFormatConfig);
                }
            }
            if (node.has("collection")) {
                JsonObject collection = node.getAsJsonObject("collection");
                JsonObject collectionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true);
                collection.add("formattingConfig", (JsonElement)collectionFormatConfig);
            }
            if (node.has("variableDefinitionNode")) {
                node.getAsJsonObject("variableDefinitionNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true));
            }
            if (node.has("body")) {
                this.modifyConstructBody(node.getAsJsonObject("body"), indentation, indentWithParentIndentation, false);
            }
        }
    }

    public void formatForkJoinNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("fork")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                if (node.has("workers") && node.getAsJsonArray("workers").size() <= 0) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
            }
            if (node.has("workers")) {
                JsonArray workers = node.getAsJsonArray("workers");
                for (JsonElement workerItem : workers) {
                    workerItem.getAsJsonObject().add("formattingConfig", (JsonElement)this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentation), false));
                }
            }
        }
    }

    public void formatFromNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("from")) {
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        if (formatConfig.get("newLineCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals("in") && !text.equals("var")) continue;
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("var")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("variableDefinitionNode")) {
                JsonObject variableDefinitionNode = node.getAsJsonObject("variableDefinitionNode");
                variableDefinitionNode.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + "    "), true));
            }
            if (node.has("collection")) {
                JsonObject collection = node.getAsJsonObject("collection");
                collection.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + "    "), true));
            }
        }
    }

    public void formatFunctionNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            boolean hasReturnTypeAnnotations;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean isLambda = node.has("lambda") && node.get("lambda").getAsBoolean();
            boolean isWorker = node.has("worker") && node.get("worker").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            String functionName = "";
            boolean bl = hasReturnTypeAnnotations = node.has("returnTypeAnnotationAttachments") && node.getAsJsonArray("returnTypeAnnotationAttachments").size() > 0;
            if (node.has("name")) {
                functionName = node.getAsJsonObject("name").get("value").getAsString();
            }
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentWithParentIndentation));
            this.preserveHeight(ws, useParentIndentation ? indentWithParentIndentation : indentation, useParentIndentation);
            boolean differentFirstKeyword = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!text.equals("public") && !text.equals("private") && !text.equals("remote") && !text.equals("worker") && !text.equals("resource")) continue;
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (differentFirstKeyword) {
                        currentWS.addProperty("ws", " ");
                    } else {
                        String whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 || node.has("markdownDocumentationAttachment") || node.has("deprecatedAttachments") && node.getAsJsonArray("deprecatedAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                        currentWS.addProperty("ws", whiteSpace);
                    }
                }
                differentFirstKeyword = true;
            }
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject functionWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(functionWS.get("ws").getAsString())) continue;
                String wsText = functionWS.get("text").getAsString();
                if (wsText.equals("function")) {
                    if (isLambda && !isWorker) {
                        functionWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (differentFirstKeyword) {
                        functionWS.addProperty("ws", " ");
                        continue;
                    }
                    String whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 || node.has("markdownDocumentationAttachment") || node.has("deprecatedAttachments") && node.getAsJsonArray("deprecatedAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                    functionWS.addProperty("ws", whiteSpace);
                    continue;
                }
                if (wsText.equals(functionName)) {
                    functionWS.addProperty("ws", " ");
                    continue;
                }
                if (wsText.equals("(")) {
                    if (isLambda) continue;
                    functionWS.addProperty("ws", "");
                    continue;
                }
                if (wsText.equals(",")) {
                    functionWS.addProperty("ws", "");
                    continue;
                }
                if (wsText.equals("=>")) {
                    functionWS.addProperty("ws", " ");
                    continue;
                }
                if (wsText.equals(")")) {
                    functionWS.addProperty("ws", "");
                    continue;
                }
                if (wsText.equals("returns")) {
                    functionWS.addProperty("ws", " ");
                    continue;
                }
                if (wsText.equals("{")) {
                    functionWS.addProperty("ws", " ");
                    continue;
                }
                if (wsText.equals("}")) {
                    if (node.has("body") && node.getAsJsonObject("body").getAsJsonArray("statements").size() <= 0 && node.getAsJsonArray("endpointNodes").size() <= 0 && node.getAsJsonArray("workers").size() <= 0) {
                        if (!this.noHeightAvailable(functionWS.get("ws").getAsString())) continue;
                        functionWS.addProperty("ws", "");
                        continue;
                    }
                    if (!this.noHeightAvailable(functionWS.get("ws").getAsString())) continue;
                    functionWS.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation);
                    continue;
                }
                if (wsText.equals(";")) {
                    functionWS.addProperty("ws", "");
                    continue;
                }
                if (differentFirstKeyword && (wsText.equals("public") || wsText.equals("private") || wsText.equals("remote") || wsText.equals("worker") || wsText.equals("resource"))) continue;
                functionWS.addProperty("ws", " ");
            }
            if (node.has("parameters")) {
                JsonArray allParameters = node.getAsJsonArray("parameters");
                this.iterateAndFormatMembers(indentation.isEmpty() ? indentWithParentIndentation : indentation, allParameters);
            }
            this.modifyEndpoints(node, indentation);
            this.modifyWorkers(node, indentation);
            this.modifyAnnotationAttachments(node, formatConfig, indentation);
            this.modifyMarkdownDocumentation(node, formatConfig, indentation);
            if (node.has("restParameters")) {
                JsonObject restParam = node.getAsJsonObject("restParameters");
                JsonObject restParamFormatConfig = node.has("parameters") && node.getAsJsonArray("parameters").size() > 0 ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation.isEmpty() ? indentWithParentIndentation : indentation), true) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation.isEmpty() ? indentWithParentIndentation : indentation), true);
                restParam.add("formattingConfig", (JsonElement)restParamFormatConfig);
            }
            String additionalIndentation = "";
            boolean isLineBroken = false;
            if (hasReturnTypeAnnotations) {
                JsonArray returnTypeAnnotations = node.getAsJsonArray("returnTypeAnnotationAttachments");
                isLineBroken = this.isMemberOnNewLine(returnTypeAnnotations);
                String string = additionalIndentation = isLineBroken ? "    " : "";
            }
            if (node.has("returnTypeNode") && node.has("hasReturns") && node.get("hasReturns").getAsBoolean()) {
                JsonObject returnTypeNode = node.getAsJsonObject("returnTypeNode");
                JsonObject returnTypeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation.isEmpty() ? indentWithParentIndentation : indentation), true);
                returnTypeNode.add("formattingConfig", (JsonElement)returnTypeFormatConfig);
                if (isLineBroken) {
                    returnTypeNode.addProperty("isLineBroken", Boolean.valueOf(isLineBroken));
                }
            }
            this.modifyReturnTypeAnnotations(node, indentation + additionalIndentation);
            if (node.has("externalAnnotationAttachments")) {
                JsonArray externalAnnotationAttachments = node.getAsJsonArray("externalAnnotationAttachments");
                for (int i = 0; i < externalAnnotationAttachments.size(); ++i) {
                    JsonObject externalAnnotationAttachment = externalAnnotationAttachments.get(i).getAsJsonObject();
                    JsonObject annotationFormattingConfig = i == 0 ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true) : this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), true);
                    externalAnnotationAttachment.add("formattingConfig", (JsonElement)annotationFormattingConfig);
                }
            }
            if (node.has("body")) {
                JsonObject funcBodyFormattingConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentWithParentIndentation), true);
                node.getAsJsonObject("body").add("formattingConfig", (JsonElement)funcBodyFormattingConfig);
            }
        }
    }

    public void formatFunctionClauseNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatFunctionTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
            boolean returnKeywordExists = node.has("returnKeywordExists") && node.get("returnKeywordExists").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentWithParentIndentation : indentation, useParentIndentation);
            boolean groupOpenParanthesesFound = false;
            boolean closeParanFound = false;
            boolean groupedParanOnNewLine = false;
            boolean paramShouldAddTab = false;
            boolean returnParanShouldAddTab = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("function")) {
                        if (isGrouped && groupOpenParanthesesFound) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("(")) {
                        if (isGrouped && groupOpenParanthesesFound) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (isGrouped) {
                            groupOpenParanthesesFound = true;
                            if (formatConfig.get("spacesCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                                continue;
                            }
                            currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals(")")) {
                        if (!closeParanFound && isGrouped) {
                            closeParanFound = true;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(",")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals("returns")) continue;
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("(") && !groupOpenParanthesesFound && isGrouped) {
                    groupOpenParanthesesFound = true;
                    groupedParanOnNewLine = true;
                    continue;
                }
                if (text.equals(")") && groupOpenParanthesesFound && !closeParanFound) {
                    paramShouldAddTab = true;
                    closeParanFound = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals(")") && closeParanFound) {
                    groupedParanOnNewLine = true;
                    continue;
                }
                if ((text.equals("function") || text.equals("(") && groupOpenParanthesesFound) && isGrouped) {
                    paramShouldAddTab = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals("function") || text.equals("(") || text.equals(")") && !closeParanFound) {
                    paramShouldAddTab = true;
                    continue;
                }
                if (text.equals("returns") && isGrouped) {
                    returnParanShouldAddTab = true;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (text.equals("returns")) {
                    returnParanShouldAddTab = true;
                    continue;
                }
                if (!text.equals(",") || !isGrouped) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("params")) {
                JsonArray parameters = node.getAsJsonArray("params");
                this.iterateAndFormatMembers((paramShouldAddTab ? indentation + "    " : indentation) + (isGrouped && groupedParanOnNewLine ? "    " : ""), parameters);
            }
            if (node.has("restParam")) {
                JsonObject restParam = node.getAsJsonObject("restParam");
                JsonObject restParamFormatConfig = node.has("params") && node.getAsJsonArray("params").size() > 0 ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((paramShouldAddTab ? indentWithParentIndentation + "    " : indentation) + (isGrouped && groupedParanOnNewLine ? "    " : "")), true) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount((paramShouldAddTab ? indentWithParentIndentation + "    " : indentation) + (isGrouped && groupedParanOnNewLine ? "    " : "")), true);
                restParam.add("formattingConfig", (JsonElement)restParamFormatConfig);
            }
            if (returnKeywordExists) {
                JsonObject returnType = node.getAsJsonObject("returnTypeNode");
                JsonObject returnTypeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((returnParanShouldAddTab ? indentation + "    " : indentation) + (isGrouped && groupedParanOnNewLine ? "    " : "")), true);
                returnType.add("formattingConfig", (JsonElement)returnTypeFormatConfig);
                this.modifyReturnTypeAnnotations(node, indentation);
            }
        }
    }

    public void formatGroupExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isLineBroken = false;
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("(")) {
                        if (formatConfig.get("newLineCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (!text.equals(")")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!useParentIndentation || !text.equals(")") && !text.equals("(")) continue;
                isLineBroken = true;
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.addProperty("grouped", Boolean.valueOf(true));
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, this.getWhiteSpaceCount(indentation), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(indentationOfParent), formatConfig.get("useParentIndentation").getAsBoolean()));
                expression.addProperty("isLineBroken", Boolean.valueOf(isLineBroken));
            }
        }
    }

    public void formatIdentifierNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
        }
    }

    public void formatIfNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentWithParentIndentation));
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject firstKeywordWS = ws.get(0).getAsJsonObject();
            if (node.has("isElseIfBlock") && node.get("isElseIfBlock").getAsBoolean()) {
                JsonObject ifKeywordWS;
                if (this.noHeightAvailable(firstKeywordWS.get("ws").getAsString())) {
                    firstKeywordWS.addProperty("ws", " ");
                }
                if (this.noHeightAvailable((ifKeywordWS = ws.get(1).getAsJsonObject()).get("ws").getAsString())) {
                    ifKeywordWS.addProperty("ws", " ");
                }
            } else if (this.noHeightAvailable(firstKeywordWS.get("ws").getAsString())) {
                firstKeywordWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentWithParentIndentation);
            }
            JsonObject openingBraceWS = ws.get(ws.size() - 2).getAsJsonObject();
            if (this.noHeightAvailable(openingBraceWS.get("ws").getAsString())) {
                openingBraceWS.addProperty("ws", " ");
            }
            JsonObject closingBraceWS = ws.get(ws.size() - 1).getAsJsonObject();
            this.modifyBlockClosingBrace(node, indentWithParentIndentation, closingBraceWS, "body", false);
            if (node.has("elseStatement") && !node.getAsJsonObject("elseStatement").get("kind").getAsString().equals("Block")) {
                JsonObject elseStatement = node.getAsJsonObject("elseStatement");
                JsonObject elseStatementFormatConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                elseStatement.add("formattingConfig", (JsonElement)elseStatementFormatConfig);
            } else if (node.has("elseStatement") && node.getAsJsonObject("elseStatement").has("isElseBlock") && node.getAsJsonObject("elseStatement").get("isElseBlock").getAsBoolean()) {
                this.modifyConstructBody(node.getAsJsonObject("elseStatement"), indentation, indentWithParentIndentation, false);
            }
            if (node.has("condition")) {
                JsonObject conditionWs = node.getAsJsonObject("condition");
                JsonObject conditionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true);
                conditionWs.add("formattingConfig", (JsonElement)conditionFormatConfig);
            }
            if (node.has("body")) {
                this.modifyConstructBody(node.getAsJsonObject("body"), indentation, indentWithParentIndentation, false);
            }
        }
    }

    public void formatImportNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.get("ws").getAsJsonArray();
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            String orgName = "";
            String packageVersion = "";
            ArrayList<String> packageNames = new ArrayList<String>();
            if (node.has("orgName")) {
                orgName = node.getAsJsonObject("orgName").get("value").getAsString();
            }
            if (node.has("packageVersion")) {
                packageVersion = node.getAsJsonObject("packageVersion").get("value").getAsString();
            }
            if (node.has("packageName")) {
                for (JsonElement packageNameItem : node.getAsJsonArray("packageName")) {
                    JsonObject packageName = packageNameItem.getAsJsonObject();
                    packageNames.add(packageName.get("value").getAsString());
                }
            }
            this.preserveHeight(ws, indentation, useParentIndentation);
            boolean forwardSlashAvailable = false;
            boolean dotAvailable = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("import")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("/")) {
                    currentWS.addProperty("ws", "");
                    forwardSlashAvailable = true;
                    continue;
                }
                if (packageNames.contains(text)) {
                    if (forwardSlashAvailable || dotAvailable) {
                        currentWS.addProperty("ws", "");
                        forwardSlashAvailable = false;
                        dotAvailable = false;
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(orgName) || text.equals("as") || text.equals("version") || text.equals(packageVersion)) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(";") || text.equals(".")) {
                    dotAvailable = true;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (dotAvailable) {
                    currentWS.addProperty("ws", "");
                    dotAvailable = false;
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
        }
    }

    public void formatIndexBasedAccessExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("[") && !text.equals("]")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("index")) {
                node.getAsJsonObject("index").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount((formatConfig.get("useParentIndentation").getAsBoolean() ? indentationOfParent : indentation) + (useParentIndentation ? "    " : "")), true));
            }
        }
    }

    public void formatIntRangeExprNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatInvocationNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            int argumentID;
            JsonObject matchedArgument;
            JsonObject expression;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isExpressionAvailable = node.has("expression");
            boolean isExpression = node.has("isExpression") && node.get("isExpression").getAsBoolean();
            boolean isAsync = false;
            boolean isCheck = false;
            boolean isActionOrFieldInvocation = false;
            boolean isOpenParenOnNewLine = false;
            boolean annotationAvailable = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0;
            JsonObject identifierWhitespace = null;
            int expressionId = 0;
            String name = node.has("name") ? node.get("name").getAsJsonObject().get("value").getAsString() : "";
            boolean isLineBroken = false;
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            if (isExpressionAvailable && (expression = node.getAsJsonObject("expression")).has("id")) {
                expressionId = expression.get("id").getAsInt();
            }
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject invocationWS = ws.get(i).getAsJsonObject();
                String text = invocationWS.get("text").getAsString();
                if (this.noHeightAvailable(invocationWS.get("ws").getAsString())) {
                    if (text.equals("check") || text.equals("checkpanic")) {
                        invocationWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                        isCheck = true;
                        continue;
                    }
                    if (text.equals("start") && !isActionOrFieldInvocation) {
                        if (isCheck || annotationAvailable) {
                            invocationWS.addProperty("ws", " ");
                        } else {
                            invocationWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                        }
                        isAsync = true;
                        continue;
                    }
                    if (text.equals(".") || text.equals("->")) {
                        invocationWS.addProperty("ws", "");
                        isActionOrFieldInvocation = true;
                        continue;
                    }
                    if (text.equals("(")) {
                        invocationWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(",")) {
                        invocationWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(")")) {
                        invocationWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(":")) {
                        invocationWS.addProperty("ws", "");
                        JsonObject packageAliasWhitespace = ws.get(i - 1).getAsJsonObject();
                        if (this.noHeightAvailable(packageAliasWhitespace.get("ws").getAsString())) {
                            if (isAsync || isCheck) {
                                packageAliasWhitespace.addProperty("ws", " ");
                            } else {
                                packageAliasWhitespace.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                            }
                        }
                        if (!this.noHeightAvailable((identifierWhitespace = ws.get(i + 1).getAsJsonObject()).get("ws").getAsString())) continue;
                        identifierWhitespace.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals("error")) {
                        if (formatConfig.get("newLineCount").getAsInt() > 0) {
                            invocationWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            invocationWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        invocationWS.addProperty("ws", "");
                        continue;
                    }
                    if (identifierWhitespace != null || ws.get(i + 1).getAsJsonObject().get("text").getAsString().equals(":")) continue;
                    if (isAsync || isCheck) {
                        invocationWS.addProperty("ws", " ");
                        continue;
                    }
                    if (isActionOrFieldInvocation) {
                        invocationWS.addProperty("ws", "");
                        continue;
                    }
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        invocationWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        invocationWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    invocationWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals(name) && node.has("isExpression") && node.get("isExpression").getAsBoolean()) {
                    isLineBroken = true;
                    continue;
                }
                if (text.equals("(")) {
                    isOpenParenOnNewLine = true;
                    if (!isLineBroken) continue;
                    this.preserveHeightForWS(invocationWS, indentWithParentIndentation + "    ");
                    continue;
                }
                if (text.equals(")")) {
                    if (!isOpenParenOnNewLine && !isLineBroken) {
                        this.preserveHeightForWS(invocationWS, indentWithParentIndentation);
                        continue;
                    }
                    if (!isLineBroken) continue;
                    this.preserveHeightForWS(invocationWS, indentWithParentIndentation + "    ");
                    continue;
                }
                if (!text.equals(",")) continue;
                invocationWS.addProperty("ws", invocationWS.get("ws").getAsString() + "    ");
            }
            if (node.has("argumentExpressions")) {
                JsonArray argumentExpressions = node.getAsJsonArray("argumentExpressions");
                if (expressionId != 0) {
                    boolean foundMatch = false;
                    matchedArgument = null;
                    for (JsonElement argument : argumentExpressions) {
                        argumentID = argument.getAsJsonObject().get("id").getAsInt();
                        if (argumentID != expressionId) continue;
                        matchedArgument = argument.getAsJsonObject();
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch && matchedArgument != null) {
                        argumentExpressions.remove(matchedArgument);
                    }
                }
                this.iterateAndFormatMembers((indentation.isEmpty() ? indentWithParentIndentation : indentation) + ((isOpenParenOnNewLine || isLineBroken) && isExpression ? "    " : ""), argumentExpressions);
            }
            if (node.has("requiredArgs")) {
                JsonArray argumentExpressions = node.getAsJsonArray("requiredArgs");
                if (expressionId != 0) {
                    boolean foundMatch = false;
                    matchedArgument = null;
                    for (JsonElement argument : argumentExpressions) {
                        argumentID = argument.getAsJsonObject().get("id").getAsInt();
                        if (argumentID != expressionId) continue;
                        matchedArgument = argument.getAsJsonObject();
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch && matchedArgument != null) {
                        argumentExpressions.remove(matchedArgument);
                    }
                }
                this.iterateAndFormatMembers((indentation.isEmpty() ? indentWithParentIndentation : indentation) + ((isOpenParenOnNewLine || isLineBroken) && isExpression ? "    " : ""), argumentExpressions);
            }
            if (node.has("annotationAttachments")) {
                JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                for (JsonElement annotationAttachment : annotationAttachments) {
                    annotationAttachment.getAsJsonObject().add("formattingConfig", (JsonElement)this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(useParentIndentation ? indentWithParentIndentation + "    " : indentWithParentIndentation), useParentIndentation));
                }
            }
            if (node.has("expression")) {
                expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatLambdaNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("functionNode")) {
            JsonObject functionNode = node.getAsJsonObject("functionNode");
            functionNode.add("formattingConfig", (JsonElement)node.getAsJsonObject("formattingConfig"));
        }
    }

    public void formatLetClauseNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals("let")) {
                    if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals(",")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("letVarDeclarations")) {
                JsonArray letVarDecs = node.getAsJsonArray("letVarDeclarations");
                for (JsonElement letVarItem : letVarDecs) {
                    JsonObject letVar = letVarItem.getAsJsonObject();
                    letVar.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + "    "), true));
                }
            }
        }
    }

    public void formatLetExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals("let")) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals("in")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("variableDeclarations")) {
                JsonArray variableDeclarations = node.getAsJsonArray("variableDeclarations");
                for (JsonElement variableDeclarationItem : variableDeclarations) {
                    JsonObject variableDeclaration = variableDeclarationItem.getAsJsonObject();
                    variableDeclaration.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatListConstructorExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
            boolean isLineBroken = false;
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            boolean lineSeparationAvailable = false;
            if (node.has("expressions")) {
                lineSeparationAvailable = this.isMemberOnNewLine(node.getAsJsonArray("expressions"));
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("(")) {
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        if (formatConfig.get("newLineCount").getAsInt() <= 0) continue;
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("[")) {
                        if (isGrouped) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        if (formatConfig.get("newLineCount").getAsInt() <= 0) continue;
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals(")") || text.equals("]")) {
                        if (lineSeparationAvailable) {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentationOfParent);
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals(",")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals(",") && lineSeparationAvailable) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (!useParentIndentation || !text.equals("[") && !text.equals("(") && !text.equals(",") && !text.equals("]") && !text.equals(")")) continue;
                isLineBroken = true;
            }
            if (node.has("expressions")) {
                JsonArray expressions = node.getAsJsonArray("expressions");
                for (int i = 0; i < expressions.size(); ++i) {
                    JsonObject expression = expressions.get(i).getAsJsonObject();
                    JsonObject expressionFormatting = lineSeparationAvailable ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentationOfParent + (isLineBroken ? "    " : "")), true, this.getWhiteSpaceCount(indentationOfParent + (isLineBroken ? "    " : "")), false) : (i == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent + (isLineBroken ? "    " : "")), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + (isLineBroken ? "    " : "")), true));
                    expression.getAsJsonObject().add("formattingConfig", (JsonElement)expressionFormatting);
                }
            }
        }
    }

    public void formatLiteralNode(JsonObject node) {
        this.modifyLiteralNode(node);
    }

    public void formatLockNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("lock")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                this.modifyBlockClosingBrace(node, indentation, currentWS, "body", true);
            }
            if (node.has("body")) {
                node.getAsJsonObject("body").add("formattingConfig", (JsonElement)this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentation), false));
            }
        }
    }

    public void formatMatchNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement item : ws) {
                JsonObject wsItem = item.getAsJsonObject();
                if (!this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                String text = wsItem.get("text").getAsString();
                if (text.equals("match")) {
                    wsItem.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                }
                if (text.equals("{")) {
                    wsItem.addProperty("ws", " ");
                }
                if (!text.equals("}")) continue;
                wsItem.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                JsonObject expressionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false);
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
            this.modifyPatternClauses(node, indentation);
        }
    }

    public void formatMatchStructuredPatternClauseNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean withCurlies = node.has("withCurlies") && node.get("withCurlies").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, indentation, useParentIndentation);
            if (node.has("variableNode")) {
                if (ws.get(0).getAsJsonObject().get("text").getAsString().equals("var")) {
                    node.getAsJsonObject("variableNode").addProperty("isVarExists", Boolean.valueOf(true));
                    node.getAsJsonObject("variableNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true));
                } else {
                    node.getAsJsonObject("variableNode").add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("var")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("=>")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                if (node.has("statement") && node.getAsJsonObject("statement").has("statements") && node.getAsJsonObject("statement").getAsJsonArray("statements").size() <= 0) {
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation + FormattingConstants.NEW_LINE + indentation);
                    continue;
                }
                currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
            }
            if (node.has("statement")) {
                this.modifyConstructBody(node.getAsJsonObject("statement"), indentation, indentation, false);
            }
        }
    }

    public void formatMatchStaticPatternClauseNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean withCurlies = node.has("withCurlies") && node.get("withCurlies").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, indentation, useParentIndentation);
            if (node.has("literal")) {
                node.getAsJsonObject("literal").add("formattingConfig", (JsonElement)formatConfig);
            }
            for (JsonElement item : ws) {
                JsonObject wsItem = item.getAsJsonObject();
                if (!this.noHeightAvailable(wsItem.get("ws").getAsString())) continue;
                String text = wsItem.get("text").getAsString();
                if (text.equals("=>")) {
                    wsItem.addProperty("ws", " ");
                }
                if (text.equals("{")) {
                    wsItem.addProperty("ws", " ");
                }
                if (!text.equals("}")) continue;
                if (node.has("statement") && node.getAsJsonObject("statement").has("statements") && node.getAsJsonObject("statement").getAsJsonArray("statements").size() <= 0) {
                    wsItem.addProperty("ws", FormattingConstants.NEW_LINE + indentation + FormattingConstants.NEW_LINE + indentation);
                    continue;
                }
                wsItem.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
            }
            if (node.has("statement")) {
                this.modifyConstructBody(node.getAsJsonObject("statement"), indentation, indentation, false);
            }
        }
    }

    public void formatNamedArgsExprNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), formatConfig.get("useParentIndentation").getAsBoolean()));
            }
        }
    }

    public void formatNumericLiteralNode(JsonObject node) {
        this.modifyLiteralNode(node);
    }

    public void formatObjectTypeNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonObject functionFormatConfig;
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            JsonArray fields = node.getAsJsonArray("fields");
            JsonArray functions = node.getAsJsonArray("functions");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isAnonType = node.has("isAnonType") && node.get("isAnonType").getAsBoolean();
            boolean isLineBroken = node.has("isLineBroken") && node.get("isLineBroken").getAsBoolean();
            boolean isObjectKeywordLineBroken = false;
            boolean lineSeparationAvailable = false;
            if (isAnonType) {
                lineSeparationAvailable = this.isMemberOnNewLine(fields);
                if (functions.size() > 0 || node.has("initFunction")) {
                    lineSeparationAvailable = true;
                }
            }
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
            String firstWSToken = ws.size() > 0 ? ws.get(0).getAsJsonObject().get("text").getAsString() : "";
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("abstract") || text.equals("client") || text.equals("object")) {
                        if (firstWSToken.equals(text)) {
                            if (formatConfig.get("newLineCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent));
                                continue;
                            }
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals("{")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals("}")) continue;
                    if (isAnonType) {
                        if (lineSeparationAvailable) {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent) + (isObjectKeywordLineBroken ? "    " : ""));
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (node.getAsJsonArray("fields").size() <= 0 && node.getAsJsonArray("functions").size() <= 0 && !node.has("initFunction")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                    continue;
                }
                if (!useParentIndentation) continue;
                if (text.equals("abstract") || text.equals("client") || text.equals("object")) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    isObjectKeywordLineBroken = true;
                    continue;
                }
                if (!isObjectKeywordLineBroken && !isLineBroken) continue;
                if (text.equals("{")) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    continue;
                }
                if (!text.equals("}")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("fields")) {
                for (int i = 0; i < fields.size(); ++i) {
                    JsonObject fieldFormatConfig = isAnonType ? (lineSeparationAvailable ? this.getFormattingConfig(1, 0, (this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent)) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), true, (this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent)) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), false) : (i == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), false) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), false))) : this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), true, formatConfig.get("startColumn").getAsInt(), false);
                    fields.get(i).getAsJsonObject().add("formattingConfig", (JsonElement)fieldFormatConfig);
                }
            }
            if (node.has("initFunction")) {
                JsonObject initFunction = node.getAsJsonObject("initFunction");
                functionFormatConfig = this.getFormattingConfig(2, 0, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), true, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), false);
                initFunction.add("formattingConfig", (JsonElement)functionFormatConfig);
            }
            if (node.has("functions")) {
                for (int i = 0; i < functions.size(); ++i) {
                    functionFormatConfig = this.getFormattingConfig(2, 0, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), true, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isObjectKeywordLineBroken || isLineBroken ? this.getWhiteSpaceCount("    ") : 0), false);
                    functions.get(i).getAsJsonObject().add("formattingConfig", (JsonElement)functionFormatConfig);
                }
            }
        }
    }

    public void formatOrderByVariableNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            if (node.has("variableReference")) {
                node.getAsJsonObject("variableReference").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals(node.get("typeString").getAsString())) continue;
                    currentWS.addProperty("ws", " ");
                }
            }
        }
    }

    public void formatPanicNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("panic")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (!text.equals(";")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expressions")) {
                node.getAsJsonObject("expressions").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentationOfParent), formatConfig.get("useParentIndentation").getAsBoolean()));
            }
        }
    }

    public void formatPatternClauseNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatPatternStreamingEdgeInputNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatPatternStreamingInputNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatQueryExprNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("fromClauseNodes")) {
                JsonArray fromClauseNodes = node.getAsJsonArray("fromClauseNodes");
                for (JsonElement fromClauseItem : fromClauseNodes) {
                    JsonObject fromClause = fromClauseItem.getAsJsonObject();
                    fromClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("selectClauseNode")) {
                JsonObject selectClauseNode = node.getAsJsonObject("selectClauseNode");
                selectClauseNode.add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("whereClauseNode")) {
                JsonArray whereClauseNodes = node.getAsJsonArray("whereClauseNode");
                for (JsonElement whereClauseItem : whereClauseNodes) {
                    JsonObject whereClause = whereClauseItem.getAsJsonObject();
                    whereClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
            if (node.has("letClauseList")) {
                JsonArray letClauseList = node.getAsJsonArray("letClauseList");
                for (JsonElement letClauseItem : letClauseList) {
                    JsonObject letClause = letClauseItem.getAsJsonObject();
                    letClause.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
        }
    }

    public void formatRecordDestructureNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals(";")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("variableRefs")) {
                node.getAsJsonObject("variableRefs").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatRecordLiteralExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            this.preserveHeight(ws, indentWithParentIndentation, false);
            boolean lineSeparationAvailable = false;
            if (node.has("fields")) {
                lineSeparationAvailable = this.isMemberOnNewLine(node.getAsJsonArray("fields"));
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.equals("{") && this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentWithParentIndentation);
                    } else if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    } else {
                        currentWS.addProperty("ws", "");
                    }
                }
                if (text.equals("}") && this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (lineSeparationAvailable) {
                        if (node.has("keyValuePairs") && node.getAsJsonArray("keyValuePairs").size() <= 0) {
                            currentWS.addProperty("ws", "");
                        } else {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation);
                        }
                    } else {
                        currentWS.addProperty("ws", "");
                    }
                }
                if (!text.equals(",") && !currentWS.get("text").getAsString().equals(";")) continue;
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                this.preserveHeightForWS(currentWS, indentWithParentIndentation + "    ");
                lineSeparationAvailable = true;
            }
            if (node.has("fields")) {
                JsonArray keyValuePairs = node.getAsJsonArray("fields");
                for (int i = 0; i < keyValuePairs.size(); ++i) {
                    JsonObject keyValue = keyValuePairs.get(i).getAsJsonObject();
                    JsonObject keyValueFormatting = lineSeparationAvailable ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentWithParentIndentation), true, this.getWhiteSpaceCount(indentWithParentIndentation), false) : (i == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true));
                    keyValue.getAsJsonObject().add("formattingConfig", (JsonElement)keyValueFormatting);
                }
            }
        }
    }

    public void formatRecordLiteralKeyValueNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                this.preserveHeight(ws, indentation, useParentIndentation);
                boolean colonVisited = false;
                boolean calculatedKey = false;
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (text.equals(":")) {
                        colonVisited = true;
                    } else if (text.equals("[") && !colonVisited) {
                        calculatedKey = true;
                    }
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    if (text.equals(":") || text.equals("]")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals("[")) continue;
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                }
                if (node.has("key")) {
                    JsonObject keyNode = node.getAsJsonObject("key");
                    if (calculatedKey) {
                        keyNode.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, formatConfig.get("indentedStartColumn").getAsInt(), formatConfig.get("useParentIndentation").getAsBoolean()));
                    } else {
                        keyNode.add("formattingConfig", (JsonElement)formatConfig);
                    }
                }
            }
            if (node.has("value")) {
                JsonObject valueNode = node.getAsJsonObject("value");
                JsonObject valueNodeFormatConfig = formatConfig;
                if (node.has("ws")) {
                    valueNodeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                }
                valueNode.add("formattingConfig", (JsonElement)valueNodeFormatConfig);
            }
        }
    }

    public void formatRecordLiteralSpreadOpNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("...")) continue;
                if (formatConfig.get("spacesCount").getAsInt() > 0) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (formatConfig.get("newLineCount").getAsInt() > 0) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatRecordTypeNode(JsonObject node) {
        block24: {
            JsonObject childFormatConfig;
            boolean isLineBrokenForPreFix;
            if (!node.has("formattingConfig")) break block24;
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray fields = node.getAsJsonArray("fields");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean isAnonType = node.has("isAnonType") && node.get("isAnonType").getAsBoolean() || node.has("isAnonymous") && node.get("isAnonymous").getAsBoolean() && node.has("isLocal") && node.get("isLocal").getAsBoolean();
            boolean lineSeparationAvailable = false;
            boolean isRecordKeywordLineBroken = false;
            boolean bl = isLineBrokenForPreFix = node.has("isLineBroken") && node.get("isLineBroken").getAsBoolean();
            if (isAnonType) {
                lineSeparationAvailable = this.isMemberOnNewLine(fields);
            }
            if (node.has("ws")) {
                String text;
                Object currentWS;
                JsonArray ws = node.getAsJsonArray("ws");
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
                if (isAnonType) {
                    for (JsonElement wsItem : ws) {
                        currentWS = wsItem.getAsJsonObject();
                        text = currentWS.get("text").getAsString();
                        if (!text.equals("...") || this.noNewLine(currentWS.get("ws").getAsString())) continue;
                        currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent) + "    ");
                        lineSeparationAvailable = true;
                        break;
                    }
                    if (node.has("restFieldType") && node.get("restFieldType").getAsJsonObject().has("ws") && !lineSeparationAvailable) {
                        Iterator restParam = node.getAsJsonObject("restFieldType");
                        List<JsonObject> sortedWSForRestParam = FormattingSourceGen.extractWS((JsonObject)restParam);
                        for (JsonObject wsForRestParam : sortedWSForRestParam) {
                            String currentWS2 = wsForRestParam.get("ws").getAsString();
                            if (this.noNewLine(currentWS2)) continue;
                            lineSeparationAvailable = true;
                            break;
                        }
                    }
                }
                for (JsonElement wsItem : ws) {
                    currentWS = wsItem.getAsJsonObject();
                    text = currentWS.get("text").getAsString();
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        if (text.equals("record")) {
                            if (formatConfig.get("newLineCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent));
                                continue;
                            }
                            if (formatConfig.get("spacesCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                                continue;
                            }
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (text.equals("{") || text.equals("{|")) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (text.equals("...")) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (text.equals("}") || text.equals("|}")) {
                            if (isAnonType) {
                                if (lineSeparationAvailable) {
                                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent) + (isRecordKeywordLineBroken ? "    " : ""));
                                    continue;
                                }
                                currentWS.addProperty("ws", "");
                                continue;
                            }
                            if (fields.size() <= 0 && !node.has("restFieldType")) {
                                currentWS.addProperty("ws", "");
                                continue;
                            }
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent));
                            continue;
                        }
                        if (!text.equals(";")) continue;
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!useParentIndentation) continue;
                    if (text.equals("record")) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        isRecordKeywordLineBroken = true;
                        continue;
                    }
                    if (!isRecordKeywordLineBroken && !isLineBrokenForPreFix) continue;
                    if (text.equals("{") || text.equals("{|")) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        continue;
                    }
                    if (!text.equals("}") && !text.equals("|}")) continue;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                }
                if (node.has("restFieldType") && node.get("restFieldType").getAsJsonObject().has("ws")) {
                    JsonObject restFieldType = node.getAsJsonObject("restFieldType");
                    JsonObject restFieldTypeFormatConfig = isAnonType ? (lineSeparationAvailable ? this.getFormattingConfig(1, 0, (this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent)) + (isRecordKeywordLineBroken || isLineBrokenForPreFix ? this.getWhiteSpaceCount("    ") : 0), true, (this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent)) + (isRecordKeywordLineBroken || isLineBrokenForPreFix ? this.getWhiteSpaceCount("    ") : 0), false) : this.getFormattingConfig(0, fields.size() <= 0 ? 0 : 1, 0, false, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), true)) : this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), true, formatConfig.get("startColumn").getAsInt(), false);
                    restFieldType.add("formattingConfig", (JsonElement)restFieldTypeFormatConfig);
                }
            }
            if (isAnonType) {
                for (int i = 0; i < fields.size(); ++i) {
                    JsonObject child = fields.get(i).getAsJsonObject();
                    childFormatConfig = lineSeparationAvailable ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isRecordKeywordLineBroken || isLineBrokenForPreFix ? this.getWhiteSpaceCount("    ") : 0), true, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent) + (isRecordKeywordLineBroken || isLineBrokenForPreFix ? this.getWhiteSpaceCount("    ") : 0), false) : (i == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), true));
                    child.add("formattingConfig", (JsonElement)childFormatConfig);
                }
            } else {
                for (int i = 0; i < fields.size(); ++i) {
                    JsonObject child = fields.get(i).getAsJsonObject();
                    childFormatConfig = this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), true, formatConfig.get("startColumn").getAsInt(), false);
                    child.add("formattingConfig", (JsonElement)childFormatConfig);
                }
            }
        }
    }

    public void formatRecordVariableNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            String text;
            JsonObject currentWS;
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            boolean lineSeparationAvailable = false;
            if (node.has("variables")) {
                lineSeparationAvailable = this.isMemberOnNewLine(node.getAsJsonArray("variables"));
            }
            boolean frontedWithKeyword = false;
            for (JsonElement wsItem : ws) {
                currentWS = wsItem.getAsJsonObject();
                text = currentWS.get("text").getAsString();
                if (!text.equals("final") && !text.equals("public") && !text.equals("var") && !text.equals("client") && !text.equals("listener") && !text.equals("abstract") && !text.equals("channel") && !text.equals("const")) continue;
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (formatConfig.get("spacesCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    } else if (formatConfig.get("newLineCount").getAsInt() > 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    } else {
                        currentWS.addProperty("ws", "");
                    }
                }
                frontedWithKeyword = true;
            }
            for (JsonElement wsItem : ws) {
                currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                text = currentWS.get("text").getAsString();
                if (text.equals("{")) {
                    if (frontedWithKeyword || node.has("typeNode")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("}")) {
                    if (lineSeparationAvailable) {
                        if (node.has("variables") && node.getAsJsonArray("variables").size() <= 0) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentationOfParent);
                        continue;
                    }
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("=")) {
                    if (currentWS.get("ws").getAsString().equals(" ")) continue;
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals(";") || currentWS.get("ws").getAsString().equals("")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("typeNode") && !frontedWithKeyword) {
                JsonObject typeNode = node.getAsJsonObject("typeNode");
                if (!node.has("annotationAttachments") || node.getAsJsonArray("annotationAttachments").size() <= 0) {
                    JsonObject typeFormatConfig = this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(indentation), false);
                    typeNode.add("formattingConfig", (JsonElement)typeFormatConfig);
                }
            }
            if (node.has("variables")) {
                JsonArray variables = node.getAsJsonArray("variables");
                int i = 0;
                for (JsonElement variableItem : variables) {
                    JsonObject variableFormatConfig;
                    JsonObject variable = variableItem.getAsJsonObject();
                    if (!variable.has("ws")) continue;
                    if (lineSeparationAvailable) {
                        variableFormatConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentationOfParent), true, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), false);
                    } else if (i == 0) {
                        variableFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true);
                        ++i;
                    } else {
                        variableFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true);
                    }
                    variable.add("formattingConfig", (JsonElement)variableFormatConfig);
                }
            }
            if (node.has("initialExpression")) {
                node.getAsJsonObject("initialExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatRecordVariableRefNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            String text;
            Object currentWS;
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            boolean lineSeparationAvailable = false;
            for (JsonElement wsItem : ws) {
                currentWS = wsItem.getAsJsonObject();
                text = currentWS.get("text").getAsString();
                if (!text.equals("...") || this.noNewLine(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent) + "    ");
                lineSeparationAvailable = true;
                break;
            }
            if (node.has("restParam")) {
                JsonObject restParam = node.getAsJsonObject("restParam");
                List<JsonObject> sortedWSForRestParam = FormattingSourceGen.extractWS(restParam);
                for (JsonObject wsForRestParam : sortedWSForRestParam) {
                    String currentWS2 = wsForRestParam.get("ws").getAsString();
                    if (this.noNewLine(currentWS2)) continue;
                    lineSeparationAvailable = true;
                    break;
                }
            }
            if (node.has("recordRefFields") && !lineSeparationAvailable) {
                lineSeparationAvailable = this.isMemberOnNewLine(node.getAsJsonArray("recordRefFields"));
            }
            for (JsonElement wsItem : ws) {
                currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                text = currentWS.get("text").getAsString();
                if (text.equals("{")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("...")) {
                    if (lineSeparationAvailable) {
                        currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent) + "    ");
                        continue;
                    }
                    if (node.has("recordRefFields") && node.has("restParam") && node.getAsJsonArray("recordRefFields").size() <= 0) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                if (lineSeparationAvailable) {
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + (this.getWhiteSpaceCount(indentation) > 0 ? indentation : indentationOfParent));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("recordRefFields")) {
                JsonArray recordRefFields = node.getAsJsonArray("recordRefFields");
                int i = 0;
                for (JsonElement recordRefFieldItem : recordRefFields) {
                    JsonObject recordRefFieldFormatConfig;
                    JsonObject recordRefField = recordRefFieldItem.getAsJsonObject();
                    if (!recordRefField.has("ws")) continue;
                    if (lineSeparationAvailable) {
                        recordRefFieldFormatConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation) > 0 ? this.getWhiteSpaceCount(indentation) : this.getWhiteSpaceCount(indentationOfParent), true, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), false);
                    } else if (i == 0) {
                        recordRefFieldFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), false);
                        ++i;
                    } else {
                        recordRefFieldFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), false);
                    }
                    recordRefField.add("formattingConfig", (JsonElement)recordRefFieldFormatConfig);
                }
            }
            if (node.has("restParam")) {
                node.getAsJsonObject("restParam").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatResourceNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject openingBracketWhitespace;
            JsonObject closingParenthesesWhitespace;
            JsonObject openingParenthesesWhitespace;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentWithParentIndentation));
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject resourceNameWhitespace = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(resourceNameWhitespace.get("ws").getAsString())) {
                String whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 || node.has("documentationAttachments") && node.getAsJsonArray("documentationAttachments").size() > 0 || node.has("deprecatedAttachments") && node.getAsJsonArray("deprecatedAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                resourceNameWhitespace.addProperty("ws", whiteSpace);
            }
            if (this.noHeightAvailable((openingParenthesesWhitespace = ws.get(1).getAsJsonObject()).get("ws").getAsString())) {
                openingParenthesesWhitespace.addProperty("ws", "");
            }
            if (this.noHeightAvailable((closingParenthesesWhitespace = ws.get(ws.size() - 3).getAsJsonObject()).get("ws").getAsString())) {
                closingParenthesesWhitespace.addProperty("ws", "");
            }
            if (this.noHeightAvailable((openingBracketWhitespace = ws.get(ws.size() - 2).getAsJsonObject()).get("ws").getAsString())) {
                openingBracketWhitespace.addProperty("ws", " ");
            }
            JsonObject closingBracketWhitespace = ws.get(ws.size() - 1).getAsJsonObject();
            if (node.has("body") && node.getAsJsonObject("body").getAsJsonArray("statements").size() <= 0 && node.getAsJsonArray("workers").size() <= 0 && node.getAsJsonArray("endpointNodes").size() <= 0) {
                if (this.noHeightAvailable(closingBracketWhitespace.get("ws").getAsString())) {
                    closingBracketWhitespace.addProperty("ws", FormattingConstants.NEW_LINE + indentation + FormattingConstants.NEW_LINE + indentation);
                }
            } else if (this.noHeightAvailable(closingBracketWhitespace.get("ws").getAsString())) {
                closingBracketWhitespace.addProperty("ws", FormattingConstants.NEW_LINE + this.getWhiteSpaces(node.getAsJsonObject("position").get("startColumn").getAsInt()));
            }
            if (node.has("parameters")) {
                JsonArray parameters = node.getAsJsonArray("parameters");
                this.iterateAndFormatMembers(indentation, parameters);
            }
            if (node.has("endpointNodes")) {
                JsonArray endpointNodes = node.getAsJsonArray("endpointNodes");
                for (int i = 0; i < endpointNodes.size(); ++i) {
                    JsonObject endpointNode = endpointNodes.get(i).getAsJsonObject();
                    JsonObject endpointFormatConfig = i == 0 ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentWithParentIndentation), false) : this.getFormattingConfig(2, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                    endpointNode.add("formattingConfig", (JsonElement)endpointFormatConfig);
                }
            }
            this.modifyAnnotationAttachments(node, formatConfig, indentation);
            this.modifyWorkers(node, indentation);
        }
    }

    public void formatRestArgsExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("...")) continue;
                currentWS.addProperty("ws", indentation);
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatRetryNode(JsonObject node) {
        this.modifyBranchingStatement(node);
    }

    public void formatReturnNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject semicolonWhitespace;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject returnKeywordWhitespace = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(returnKeywordWhitespace.get("ws").getAsString())) {
                if (formatConfig.get("newLineCount").getAsInt() > 0) {
                    returnKeywordWhitespace.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                } else if (formatConfig.get("spacesCount").getAsInt() > 0) {
                    returnKeywordWhitespace.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                }
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                JsonObject expressionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
            if (this.noHeightAvailable((semicolonWhitespace = ws.get(1).getAsJsonObject()).get("ws").getAsString())) {
                semicolonWhitespace.addProperty("ws", "");
            }
        }
    }

    public void formatSelectExpressionNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    currentWS.addProperty("ws", " ");
                }
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatSelectNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("select")) continue;
                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + "    "), true));
            }
        }
    }

    public void formatServiceNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isServiceLineBroken = node.has("isServiceLineBroken") && node.get("isServiceLineBroken").getAsBoolean() && useParentIndentation;
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            if (node.has("anonymousService") && node.get("anonymousService").getAsBoolean()) {
                if (node.has("annotationAttachments") && !isServiceLineBroken) {
                    JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                    isServiceLineBroken = this.isMemberOnNewLine(annotationAttachments);
                }
                String lineBreakIndentation = isServiceLineBroken ? "    " : "";
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    if (text.equals("service")) {
                        String whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 ? " " : this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt());
                        currentWS.addProperty("ws", whiteSpace);
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                }
                if (node.has("annotationAttachments")) {
                    JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                    for (int i = 0; i < annotationAttachments.size(); ++i) {
                        JsonObject annotationAttachment = annotationAttachments.get(i).getAsJsonObject();
                        JsonObject annotationAttachmentFormattingConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + lineBreakIndentation), true);
                        annotationAttachment.getAsJsonObject().add("formattingConfig", (JsonElement)annotationAttachmentFormattingConfig);
                    }
                }
                if (node.has("typeDefinition") && node.getAsJsonObject("typeDefinition").has("typeNode")) {
                    JsonObject typeNode = node.getAsJsonObject("typeDefinition").getAsJsonObject("typeNode");
                    JsonObject typeDefFormatConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentationOfParent + lineBreakIndentation), false, this.getWhiteSpaceCount(indentationOfParent + lineBreakIndentation), false);
                    typeNode.add("formattingConfig", (JsonElement)typeDefFormatConfig);
                }
                if (node.has("resources")) {
                    JsonArray resources = node.getAsJsonArray("resources");
                    this.iterateAndFormatBlockStatements(indentationOfParent + lineBreakIndentation, indentationOfParent + lineBreakIndentation, resources);
                }
            } else {
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    if (text.equals("service")) {
                        String whiteSpace = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0 || node.has("documentationAttachments") && node.getAsJsonArray("documentationAttachments").size() > 0 || node.has("deprecatedAttachments") && node.getAsJsonArray("deprecatedAttachments").size() > 0 ? FormattingConstants.NEW_LINE + indentation : this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation;
                        currentWS.addProperty("ws", whiteSpace);
                        continue;
                    }
                    if (text.equals(",")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                }
                if (node.has("typeDefinition") && node.getAsJsonObject("typeDefinition").has("typeNode")) {
                    JsonObject typeNode = node.getAsJsonObject("typeDefinition").getAsJsonObject("typeNode");
                    String typeNodeIndentation = this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + (formatConfig.get("doIndent").getAsBoolean() ? this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt()) + "    " : this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt()));
                    JsonObject typeDefFormatConfig = this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(typeNodeIndentation), false, this.getWhiteSpaceCount(typeNodeIndentation), false);
                    typeNode.add("formattingConfig", (JsonElement)typeDefFormatConfig);
                }
                if (node.has("resources")) {
                    JsonArray resources = node.getAsJsonArray("resources");
                    this.iterateAndFormatBlockStatements(this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt()), indentation, resources);
                }
                this.modifyMarkdownDocumentation(node, formatConfig, indentation);
                this.modifyAnnotationAttachments(node, formatConfig, indentation);
                if (node.has("attachedExprs")) {
                    JsonArray attachedExprs = node.getAsJsonArray("attachedExprs");
                    for (JsonElement attachedExpr : attachedExprs) {
                        JsonObject memberFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                        attachedExpr.getAsJsonObject().add("formattingConfig", (JsonElement)memberFormatConfig);
                    }
                }
            }
        }
    }

    public void formatServiceConstructorNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isServiceLineBroken = false;
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (!text.equals("service")) continue;
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (!useParentIndentation || !text.equals("service")) continue;
                isServiceLineBroken = true;
            }
            if (node.has("serviceNode")) {
                node.getAsJsonObject("serviceNode").add("formattingConfig", (JsonElement)formatConfig);
                node.getAsJsonObject("serviceNode").addProperty("isServiceLineBroken", Boolean.valueOf(isServiceLineBroken));
            }
        }
    }

    public void formatSimpleVariableRefNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            String packageAlias = "";
            if (node.has("packageAlias")) {
                packageAlias = node.getAsJsonObject("packageAlias").get("value").getAsString();
            }
            int colonIndex = 0;
            boolean packageAliasAvailableBeforeColon = false;
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (i == 0 && !text.equals(":")) {
                        if (text.equals(packageAlias)) {
                            packageAliasAvailableBeforeColon = true;
                        }
                        if (formatConfig.get("newLineCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        if (formatConfig.get("spacesCount").getAsInt() > 0) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(":")) {
                        currentWS.addProperty("ws", "");
                        ++colonIndex;
                        continue;
                    }
                    if (colonIndex == 1) {
                        if (packageAliasAvailableBeforeColon) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (colonIndex > 1) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (ws.size() > 1) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (i != 0 || text.equals(":") || !text.equals(packageAlias)) continue;
                packageAliasAvailableBeforeColon = true;
            }
        }
    }

    public void formatStreamActionNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("=>")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("(")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(")")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("}")) continue;
                currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
            if (node.has("invokableBody")) {
                node.getAsJsonObject("invokableBody").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatStreamingInputNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("streamReference")) {
                node.getAsJsonObject("streamReference").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("beforeStreamingCondition")) {
                node.getAsJsonObject("beforeStreamingCondition").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("preFunctionInvocations")) {
                node.getAsJsonObject("preFunctionInvocations").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("windowClause")) {
                node.getAsJsonObject("windowClause").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("postFunctionInvocations")) {
                node.getAsJsonObject("postFunctionInvocations").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("afterStreamingCondition")) {
                node.getAsJsonObject("afterStreamingCondition").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("alias")) {
                if (node.has("ws")) {
                    JsonArray ws = node.getAsJsonArray("ws");
                    String indentation = this.getIndentation(formatConfig, false);
                    String indentationOfParent = this.getParentIndentation(formatConfig);
                    boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                    this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                    for (JsonElement wsItem : ws) {
                        String text;
                        JsonObject currentWS = wsItem.getAsJsonObject();
                        if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("as")) continue;
                        currentWS.addProperty("ws", " ");
                    }
                }
                node.getAsJsonObject("alias").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatStreamTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("<") && !text.equals(">")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("type")) {
                JsonObject type = node.getAsJsonObject("type");
                type.add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("constraint")) {
                JsonObject constraint = node.getAsJsonObject("constraint");
                constraint.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatStringTemplateLiteralNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.contains("string") && text.contains("`")) {
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    }
                    currentWS.addProperty("text", "string `");
                    continue;
                }
                if (!text.equals("`") || !this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expressions")) {
                JsonArray expressions = node.getAsJsonArray("expressions");
                for (JsonElement expressionItem : expressions) {
                    JsonObject expression = expressionItem.getAsJsonObject();
                    expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
        }
    }

    public void formatTableColumnNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            if (ws.size() > 1) {
                JsonObject identifierWS;
                JsonObject primaryKeyWS = ws.get(0).getAsJsonObject();
                if (this.noHeightAvailable(primaryKeyWS.get("ws").getAsString())) {
                    primaryKeyWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                }
                if (this.noHeightAvailable((identifierWS = ws.get(1).getAsJsonObject()).get("ws").getAsString())) {
                    identifierWS.addProperty("ws", " ");
                }
            } else {
                JsonObject identifierWS = ws.get(0).getAsJsonObject();
                if (this.noHeightAvailable(identifierWS.get("ws").getAsString())) {
                    identifierWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                }
            }
        }
    }

    public void formatTableNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            String indentation = indentWithParentIndentation + "    ";
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentWithParentIndentation));
            this.preserveHeight(ws, indentWithParentIndentation, false);
            int openBracesCount = 0;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (currentWS.get("text").getAsString().equals("table") && this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    currentWS.addProperty("ws", " ");
                }
                if (currentWS.get("text").getAsString().equals(",")) {
                    if (openBracesCount == 1) {
                        if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                            currentWS.addProperty("ws", "");
                        } else {
                            this.preserveHeightForWS(currentWS, indentation);
                        }
                    } else if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        currentWS.addProperty("ws", "");
                    } else {
                        this.preserveHeightForWS(currentWS, indentation + "    ");
                    }
                }
                if (currentWS.get("text").getAsString().equals("{") || currentWS.get("text").getAsString().equals("[")) {
                    if (openBracesCount > 0) {
                        if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                        } else {
                            this.preserveHeightForWS(currentWS, indentation);
                        }
                    } else if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        currentWS.addProperty("ws", " ");
                    }
                }
                if (currentWS.get("text").getAsString().equals("}")) {
                    if (openBracesCount == 1) {
                        if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                            if (node.has("dataRows") && node.has("tableColumns") && node.getAsJsonArray("dataRows").size() <= 0 && node.getAsJsonArray("tableColumns").size() <= 0) {
                                currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation + FormattingConstants.NEW_LINE + indentWithParentIndentation);
                            } else {
                                currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentWithParentIndentation);
                            }
                        }
                    } else if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        currentWS.addProperty("ws", "");
                    } else {
                        this.preserveHeightForWS(currentWS, indentation);
                    }
                }
                if (currentWS.get("text").getAsString().equals("]")) {
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        if (node.has("dataRows") && node.getAsJsonArray("dataRows").size() <= 0) {
                            currentWS.addProperty("ws", "");
                        } else {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                        }
                    } else {
                        this.preserveHeightForWS(currentWS, indentation);
                    }
                }
                if (currentWS.get("text").getAsString().equals("{") || currentWS.get("text").getAsString().equals("[")) {
                    openBracesCount = openBracesCount > 0 ? ++openBracesCount : 1;
                }
                if (!currentWS.get("text").getAsString().equals("}") && !currentWS.get("text").getAsString().equals("]") || openBracesCount <= 1) continue;
                --openBracesCount;
            }
            if (node.has("dataRows")) {
                JsonArray dataRows = node.getAsJsonArray("dataRows");
                for (JsonElement dataRowItem : dataRows) {
                    JsonObject dataRow = dataRowItem.getAsJsonObject();
                    JsonObject rowFormatConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentation), false);
                    dataRow.add("formattingConfig", (JsonElement)rowFormatConfig);
                }
            }
            if (node.has("tableColumns")) {
                JsonArray tableColumns = node.getAsJsonArray("tableColumns");
                this.iterateAndFormatMembers(indentation + "    ", tableColumns);
            }
        }
    }

    public void formatTableQueryExpressionNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("tableQuery")) {
                if (node.has("isExpression")) {
                    node.getAsJsonObject("tableQuery").addProperty("isExpression", Boolean.valueOf(node.get("isExpression").getAsBoolean()));
                }
                node.getAsJsonObject("tableQuery").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatTernaryExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean conditionBrokenToNewLine = node.has("isLineBroken") && node.get("isLineBroken").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            if (node.has("condition")) {
                JsonObject condition = node.getAsJsonObject("condition");
                List<JsonObject> sortedWSForRestParam = FormattingSourceGen.extractWS(condition);
                for (JsonObject wsForRestParam : sortedWSForRestParam) {
                    String currentWS = wsForRestParam.get("ws").getAsString();
                    if (this.noNewLine(currentWS)) continue;
                    conditionBrokenToNewLine = true;
                    break;
                }
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (!text.equals("?") && !text.equals(":")) continue;
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!useParentIndentation || !text.equals("?") && !text.equals(":") || !conditionBrokenToNewLine) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("condition")) {
                node.getAsJsonObject("condition").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("thenExpression")) {
                node.getAsJsonObject("thenExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + (conditionBrokenToNewLine ? "    " : "")), true));
            }
            if (node.has("elseExpression")) {
                node.getAsJsonObject("elseExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + (conditionBrokenToNewLine ? "    " : "")), true));
            }
        }
    }

    public void formatTransactionNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, indentation, useParentIndentation);
            boolean isRetryBody = false;
            boolean isCommittedBody = false;
            boolean isAbortedBody = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("transaction")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("onretry")) {
                    currentWS.addProperty("ws", " ");
                    isRetryBody = true;
                    isAbortedBody = false;
                    isCommittedBody = false;
                    continue;
                }
                if (text.equals("aborted")) {
                    currentWS.addProperty("ws", " ");
                    isRetryBody = false;
                    isAbortedBody = true;
                    isCommittedBody = false;
                    continue;
                }
                if (text.equals("committed")) {
                    currentWS.addProperty("ws", " ");
                    isRetryBody = false;
                    isAbortedBody = false;
                    isCommittedBody = true;
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("}")) {
                    if (isRetryBody) {
                        this.modifyBlockClosingBrace(node, indentation, currentWS, "onRetryBody", false);
                        continue;
                    }
                    if (isAbortedBody) {
                        this.modifyBlockClosingBrace(node, indentation, currentWS, "abortedBody", false);
                        continue;
                    }
                    if (isCommittedBody) {
                        this.modifyBlockClosingBrace(node, indentation, currentWS, "committedBody", false);
                        continue;
                    }
                    this.modifyBlockClosingBrace(node, indentation, currentWS, "transactionBody", false);
                    continue;
                }
                if (text.equals("with")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("retries")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("=")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("onabort")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("oncommit")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("transactionBody")) {
                this.modifyConstructBody(node.getAsJsonObject("transactionBody"), indentation, indentation, false);
            }
            if (node.has("onRetryBody")) {
                this.modifyConstructBody(node.getAsJsonObject("onRetryBody"), indentation, indentation, false);
            }
            if (node.has("committedBody")) {
                this.modifyConstructBody(node.getAsJsonObject("committedBody"), indentation, indentation, false);
            }
            if (node.has("abortedBody")) {
                this.modifyConstructBody(node.getAsJsonObject("abortedBody"), indentation, indentation, false);
            }
            if (node.has("retryCount")) {
                this.skipFormatting(node.getAsJsonObject("retryCount"), true);
            }
            if (node.has("onAbortFunction")) {
                this.skipFormatting(node.getAsJsonObject("onAbortFunction"), true);
            }
            if (node.has("onCommitFunction")) {
                this.skipFormatting(node.getAsJsonObject("onCommitFunction"), true);
            }
        }
    }

    public void formatTrapExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            String text;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentationOfParent, useParentIndentation);
            JsonObject trapKeywordWS = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(trapKeywordWS.get("ws").getAsString()) && (text = trapKeywordWS.get("text").getAsString()).equals("trap")) {
                trapKeywordWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), formatConfig.get("useParentIndentation").getAsBoolean()));
            }
        }
    }

    public void formatTupleDestructureNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean declaredWithVar = node.has("declaredWithVar") && node.get("declaredWithVar").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("var")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("(") || text.equals("[")) {
                        if (declaredWithVar) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("...")) {
                        if (node.has("variableRefs") && node.getAsJsonArray("variableRefs").size() > 0) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals(")") || text.equals(";") || text.equals("]") || text.equals(",")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals("=")) continue;
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (!text.equals("...") && !text.equals(",")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("variableRefs")) {
                JsonArray varRefs = node.getAsJsonArray("variableRefs");
                this.modifyVariableReferences(formatConfig, indentation, varRefs);
            }
            if (node.has("restParam")) {
                JsonObject restParamFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true);
                node.getAsJsonObject("restParam").add("formattingConfig", (JsonElement)restParamFormatConfig);
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                JsonObject expressionFormatConfig = this.getFormattingConfig(0, 1, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), true);
                expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
            }
        }
    }

    public void formatTupleTypeNodeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("(")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("[")) {
                        if (isGrouped) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (!text.equals("]") && !text.equals(",") && !text.equals(")") && !text.equals("...")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals("...") && !text.equals(",")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            JsonArray memberTypeNodes = null;
            if (node.has("memberTypeNodes")) {
                memberTypeNodes = node.getAsJsonArray("memberTypeNodes");
                JsonObject memberFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true);
                this.modifyVariableReferences(memberFormatConfig, indentation, memberTypeNodes);
            }
            if (node.has("restParamType")) {
                JsonObject restParamType = node.getAsJsonObject("restParamType");
                JsonObject restParamFormatConfig = memberTypeNodes != null && memberTypeNodes.size() > 0 ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true);
                restParamType.add("formattingConfig", (JsonElement)restParamFormatConfig);
            }
        }
    }

    public void formatTupleVariableNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, true);
                String indentWithParentIndentation = this.getParentIndentation(formatConfig);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
                this.preserveHeight(ws, useParentIndentation ? indentWithParentIndentation : indentation, useParentIndentation);
                JsonObject firstKeywordWS = ws.get(0).getAsJsonObject();
                boolean isFirstKeywordExist = false;
                if (node.has("typeNode")) {
                    JsonObject typeNode = node.getAsJsonObject("typeNode");
                    if (node.has("final") && node.get("final").getAsBoolean() || node.has("public") && node.get("public").getAsBoolean() && firstKeywordWS.get("text").getAsString().equals("public") || firstKeywordWS.get("text").getAsString().equals("const") || firstKeywordWS.get("text").getAsString().equals("var")) {
                        isFirstKeywordExist = true;
                        if (this.noHeightAvailable(firstKeywordWS.get("ws").getAsString())) {
                            firstKeywordWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        }
                    }
                    JsonObject typeFormatConfig = this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(indentation), false);
                    typeNode.add("formattingConfig", (JsonElement)typeFormatConfig);
                } else if (node.has("final") && node.get("final").getAsBoolean() || node.has("public") && node.get("public").getAsBoolean() && firstKeywordWS.get("text").getAsString().equals("public") || firstKeywordWS.get("text").getAsString().equals("const") || firstKeywordWS.get("text").getAsString().equals("var")) {
                    isFirstKeywordExist = true;
                    if (this.noHeightAvailable(firstKeywordWS.get("ws").getAsString())) {
                        firstKeywordWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    }
                }
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        if (text.equals("[")) {
                            if (isFirstKeywordExist || node.has("isVarExists") && node.get("isVarExists").getAsBoolean()) {
                                currentWS.addProperty("ws", " ");
                                continue;
                            }
                            if (formatConfig.get("spacesCount").getAsInt() > 0) {
                                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                                continue;
                            }
                            if (!node.has("typeNode")) continue;
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (!text.equals("]") && !text.equals(",")) continue;
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!text.equals(",")) continue;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                }
                JsonArray variables = null;
                if (node.has("variables")) {
                    variables = node.getAsJsonArray("variables");
                    this.iterateAndFormatMembers(indentation, variables);
                }
                if (node.has("annotationAttachments")) {
                    JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                    for (JsonElement annotationAttachment : annotationAttachments) {
                        JsonObject annotationAttachmentFormattingConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentation), false);
                        annotationAttachment.getAsJsonObject().add("formattingConfig", (JsonElement)annotationAttachmentFormattingConfig);
                    }
                }
                if (node.has("restVariable")) {
                    JsonObject restVariable = node.getAsJsonObject("restVariable");
                    JsonObject restParamFormatConfig = variables != null && variables.size() > 0 ? this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(useParentIndentation ? indentWithParentIndentation : indentation), true) : this.getFormattingConfig(0, 0, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(useParentIndentation ? indentWithParentIndentation : indentation), true);
                    restVariable.add("formattingConfig", (JsonElement)restParamFormatConfig);
                }
                if (node.has("initialExpression")) {
                    JsonObject initialExpression = node.getAsJsonObject("initialExpression");
                    initialExpression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true));
                }
            } else if (node.has("typeNode")) {
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatTupleVariableRefNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatTypeConversionExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            boolean isAnnotationAvailable = false;
            boolean isOperatorsBrokenToNewLine = false;
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("<")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (!text.equals(">")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals("<") && !text.equals(">")) continue;
                isOperatorsBrokenToNewLine = true;
            }
            if (node.has("annotationAttachments")) {
                JsonArray annotations = node.getAsJsonArray("annotationAttachments");
                if (annotations.size() > 0) {
                    isAnnotationAvailable = true;
                }
                for (int i = 0; i < annotations.size(); ++i) {
                    JsonObject annotationAttachment = annotations.get(i).getAsJsonObject();
                    boolean isOnNewLine = this.isOnNewLine(annotationAttachment);
                    String annotationParentIndentation = isOperatorsBrokenToNewLine ? indentationOfParent + "    " + "    " : (isOnNewLine ? indentationOfParent + "    " : indentationOfParent);
                    JsonObject annotationAttachmentFormattingConfig = i == 0 ? this.getFormattingConfig(0, 0, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(annotationParentIndentation), true) : this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(annotationParentIndentation), true);
                    annotationAttachment.add("formattingConfig", (JsonElement)annotationAttachmentFormattingConfig);
                }
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("typeNode")) {
                if (isAnnotationAvailable) {
                    node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(isOperatorsBrokenToNewLine ? indentationOfParent + "    " : indentationOfParent), true));
                } else {
                    node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(isOperatorsBrokenToNewLine ? indentationOfParent + "    " : indentationOfParent), true));
                }
            }
        }
    }

    public void formatTypeDefinitionNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            boolean isEnum = true;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("public")) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("type")) {
                    if (node.has("public") && node.get("public").getAsBoolean()) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                if (text.equals("object") || text.equals("record")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals("{")) {
                    currentWS.addProperty("ws", " ");
                    isEnum = false;
                    continue;
                }
                if (text.equals("}")) {
                    if (node.has("typeNode") && node.getAsJsonObject("typeNode").getAsJsonArray("fields").size() <= 0) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                    continue;
                }
                if (text.equals(";")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("typeNode")) {
                JsonObject typeNodeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false);
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)typeNodeFormatConfig);
            }
            this.modifyAnnotationAttachments(node, formatConfig, indentation);
            this.modifyMarkdownDocumentation(node, formatConfig, indentation);
        }
    }

    public void formatTypedescExpressionNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("typeNode")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("ws") && node.has("isObject") && node.get("isObject").getAsBoolean()) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, false);
                String indentationOfParent = this.getParentIndentation(formatConfig);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, false);
                boolean lineSeparationAvailable = false;
                if (node.getAsJsonObject("typeNode").get("isAnonType").getAsBoolean()) {
                    JsonObject anonType = node.getAsJsonObject("typeNode").getAsJsonObject("anonType");
                    JsonArray fields = anonType.getAsJsonArray("fields");
                    JsonArray functions = anonType.getAsJsonArray("functions");
                    lineSeparationAvailable = this.isMemberOnNewLine(fields);
                    if (functions.size() > 0 || anonType.has("initFunction")) {
                        lineSeparationAvailable = true;
                    }
                }
                boolean isObjectKeywordLineBroken = false;
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        if (text.equals("object")) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        if (text.equals("{")) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (!text.equals("}")) continue;
                        if (lineSeparationAvailable) {
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentationOfParent + (isObjectKeywordLineBroken ? "    " : ""));
                            continue;
                        }
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!useParentIndentation) continue;
                    if (text.equals("object")) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        isObjectKeywordLineBroken = true;
                        continue;
                    }
                    if (!isObjectKeywordLineBroken) continue;
                    if (text.equals("{")) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        continue;
                    }
                    if (!text.equals("}")) continue;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                }
                node.getAsJsonObject("typeNode").addProperty("isLineBroken", Boolean.valueOf(isObjectKeywordLineBroken));
            }
            node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)formatConfig);
        }
    }

    public void formatTypeInitExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            boolean isLineBroken = false;
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("new")) {
                        currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (text.equals("(")) {
                        if (node.has("type")) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals(",") && !text.equals(")")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!useParentIndentation || !text.equals("new") && !text.equals("(") && !text.equals(",") && !text.equals(")")) continue;
                isLineBroken = true;
            }
            if (node.has("expressions")) {
                JsonArray expressions = node.getAsJsonArray("expressions");
                this.iterateAndFormatMembers((indentation.isEmpty() ? indentationOfParent : indentation) + (isLineBroken ? "    " : ""), expressions);
            }
            if (node.has("type")) {
                node.getAsJsonObject("type").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatTypeTestExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("is")) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("typeNode")) {
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatUnaryExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("typeof") && !text.equals("~") && !text.equals("+") && !text.equals("-") && !text.equals("untaint") && !text.equals("!")) continue;
                if (formatConfig.get("newLineCount").getAsInt() > 0) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                String operatorKind = node.get("operatorKind").getAsString();
                JsonObject expressionFormatConfig = null;
                if (operatorKind.equals("+") || operatorKind.equals("-") || operatorKind.equals("!") || operatorKind.equals("~")) {
                    expressionFormatConfig = this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true);
                } else if (operatorKind.equals("untaint") || operatorKind.equals("typeof")) {
                    expressionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true);
                }
                if (expressionFormatConfig != null) {
                    expression.add("formattingConfig", (JsonElement)expressionFormatConfig);
                }
            }
        }
    }

    public void formatUnionTypeNodeNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    String text = currentWS.get("text").getAsString();
                    if (text.equals("(")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("|")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (text.equals("?")) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (!currentWS.get("text").getAsString().equals(")")) continue;
                    currentWS.addProperty("ws", "");
                }
            }
            if (node.has("memberTypeNodes")) {
                JsonArray memberTypeNodes = node.getAsJsonArray("memberTypeNodes");
                boolean leadWithWhiteSpace = false;
                String firstMember = "";
                if (node.getAsJsonObject("parent").get("kind").getAsString().equals("TypeDefinition")) {
                    int previousTokenIndex = 0;
                    for (JsonElement memberType : memberTypeNodes) {
                        JsonObject memberTypeNode = memberType.getAsJsonObject();
                        if (memberTypeNode.has("isAnonType") && memberTypeNode.get("isAnonType").getAsBoolean()) {
                            List<JsonObject> extractedWS;
                            JsonObject firstWS;
                            JsonObject anonType = memberTypeNode.getAsJsonObject("anonType");
                            if (anonType.get("kind").getAsString().equals("FiniteTypeNode") && !(firstWS = (extractedWS = FormattingSourceGen.extractWS(anonType)).get(0)).get("text").getAsString().equals("|")) {
                                leadWithWhiteSpace = true;
                            }
                            anonType.addProperty("leadWithWhiteSpace", Boolean.valueOf(leadWithWhiteSpace));
                            continue;
                        }
                        List<JsonObject> extractedWS = FormattingSourceGen.extractWS(memberTypeNode);
                        JsonObject firstWS = extractedWS.get(0);
                        int index = firstWS.get("i").getAsInt();
                        if (index < previousTokenIndex && previousTokenIndex != 0) {
                            previousTokenIndex = index;
                            firstMember = firstWS.get("text").getAsString();
                            continue;
                        }
                        if (previousTokenIndex != 0) continue;
                        previousTokenIndex = index;
                        firstMember = firstWS.get("text").getAsString();
                    }
                }
                for (int i = 0; i < memberTypeNodes.size(); ++i) {
                    JsonObject memberType = memberTypeNodes.get(i).getAsJsonObject();
                    List<JsonObject> extractedWS = FormattingSourceGen.extractWS(memberType);
                    JsonObject firstWS = extractedWS.get(0);
                    JsonObject memberTypeFormatConfig = i == 0 && !node.getAsJsonObject("parent").get("kind").getAsString().equals("TypeDefinition") ? (isGrouped ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true) : this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), formatConfig.get("spacesCount").getAsInt(), formatConfig.get("startColumn").getAsInt(), formatConfig.get("doIndent").getAsBoolean(), this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), false)) : (!leadWithWhiteSpace ? (firstWS.get("text").getAsString().equals(firstMember) ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true)) : this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
                    memberType.add("formattingConfig", (JsonElement)memberTypeFormatConfig);
                }
            }
        }
    }

    public void formatUserDefinedTypeNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("ws") && !node.has("isAnonType")) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, false);
                String indentationOfParent = this.getParentIndentation(formatConfig);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt())));
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                boolean isPackageAliasExist = false;
                boolean isGrouped = node.has("grouped") && node.get("grouped").getAsBoolean();
                for (int i = 0; i < ws.size(); ++i) {
                    JsonObject currentWS = ws.get(i).getAsJsonObject();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    String text = currentWS.get("text").getAsString();
                    if (i == 0) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                        continue;
                    }
                    if (text.equals(":")) {
                        currentWS.addProperty("ws", "");
                        isPackageAliasExist = true;
                        continue;
                    }
                    if (text.equals("?") || text.equals(")") && isGrouped) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    if (isPackageAliasExist) {
                        currentWS.addProperty("ws", "");
                        isPackageAliasExist = false;
                        continue;
                    }
                    if (isGrouped) {
                        currentWS.addProperty("ws", "");
                        continue;
                    }
                    currentWS.addProperty("ws", " ");
                }
            } else if (node.has("isAnonType") && node.get("isAnonType").getAsBoolean()) {
                JsonObject anonType = node.getAsJsonObject("anonType");
                anonType.add("formattingConfig", (JsonElement)formatConfig);
                if (node.has("isLineBroken")) {
                    anonType.addProperty("isLineBroken", Boolean.valueOf(node.get("isLineBroken").getAsBoolean()));
                }
            }
        }
    }

    public void formatValueTypeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (i == 0) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
        }
    }

    public void formatVariableDefNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean isVarExists = false;
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, false);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                this.preserveHeight(ws, indentation, useParentIndentation);
                JsonObject firstKeyword = ws.get(0).getAsJsonObject();
                if (firstKeyword.get("text").getAsString().equals("var")) {
                    isVarExists = true;
                }
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    if (text.equals("var")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    }
                    if (text.equals("=")) {
                        currentWS.addProperty("ws", " ");
                    }
                    if (!text.equals(";")) continue;
                    currentWS.addProperty("ws", "");
                }
            }
            if (node.has("variable")) {
                JsonObject variable = node.getAsJsonObject("variable");
                if (node.has("param")) {
                    variable.add("param", node.get("param"));
                }
                variable.add("formattingConfig", (JsonElement)formatConfig);
                if (isVarExists) {
                    variable.addProperty("isVarExists", Boolean.valueOf(true));
                }
            }
        }
    }

    public void formatVariableNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            boolean isLineBroken;
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            boolean bl = isLineBroken = node.has("isLineBroken") && node.get("isLineBroken").getAsBoolean();
            if (node.has("ws")) {
                boolean hasAnnotation;
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, true);
                String indentWithParentIndentation = this.getParentIndentation(formatConfig);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                String additionalIndentation = "";
                String varName = node.has("name") ? node.get("name").getAsJsonObject().get("value").getAsString() : "";
                boolean isParam = node.has("param") && node.get("param").getAsBoolean();
                boolean isObject = false;
                boolean bl2 = hasAnnotation = node.has("annotationAttachments") && node.getAsJsonArray("annotationAttachments").size() > 0;
                if (hasAnnotation && useParentIndentation && isParam) {
                    JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                    isLineBroken = this.isMemberOnNewLine(annotationAttachments);
                    additionalIndentation = isLineBroken ? "    " : "";
                }
                node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
                boolean lineSeparationAvailable = false;
                if (node.has("symbolType") && node.get("symbolType").getAsString().equals("object") && node.has("isAnonType") && node.get("isAnonType").getAsBoolean()) {
                    this.preserveHeight(ws, indentWithParentIndentation, false);
                    isObject = true;
                    JsonObject anonType = node.getAsJsonObject("typeNode").getAsJsonObject("anonType");
                    JsonArray fields = anonType.getAsJsonArray("fields");
                    JsonArray functions = anonType.getAsJsonArray("functions");
                    lineSeparationAvailable = this.isMemberOnNewLine(fields);
                    if (functions.size() > 0 || anonType.has("initFunction")) {
                        lineSeparationAvailable = true;
                    }
                } else {
                    this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
                }
                boolean hasFirstKeyword = false;
                JsonObject firstKeywordWS = ws.get(0).getAsJsonObject();
                String firstKeyword = firstKeywordWS.get("text").getAsString();
                if (firstKeyword.equals("final") || firstKeyword.equals("public") || firstKeyword.equals("private") || firstKeyword.equals("const") || firstKeyword.equals("var") || firstKeyword.equals("client") || firstKeyword.equals("listener") || firstKeyword.equals("abstract") || firstKeyword.equals("channel") || firstKeyword.equals("object")) {
                    hasFirstKeyword = true;
                }
                boolean updatedFirstKeyword = false;
                boolean isColonAvailable = false;
                boolean varAvailable = false;
                boolean isEllipsisAvailable = false;
                for (int i = 0; i < ws.size(); ++i) {
                    JsonObject currentWS = ws.get(i).getAsJsonObject();
                    String text = currentWS.get("text").getAsString();
                    if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                        if (text.equals("final") || text.equals("public") || text.equals("private") || text.equals("const") || text.equals("var") || text.equals("client") || text.equals("listener") || text.equals("abstract") || text.equals("channel") || text.equals("object")) {
                            if (updatedFirstKeyword) {
                                currentWS.addProperty("ws", " ");
                            } else if (text.equals(firstKeywordWS.get("text").getAsString())) {
                                if (hasAnnotation) {
                                    currentWS.addProperty("ws", " ");
                                } else {
                                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                                }
                                updatedFirstKeyword = true;
                            } else {
                                currentWS.addProperty("ws", " ");
                            }
                            if (!text.equals("var") || !isEllipsisAvailable) continue;
                            currentWS.addProperty("ws", "");
                            varAvailable = true;
                            continue;
                        }
                        if (text.equals(";") || text.equals("?") || text.equals(",")) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (text.equals("{")) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (text.equals("}")) {
                            if (!lineSeparationAvailable) {
                                currentWS.addProperty("ws", "");
                                continue;
                            }
                            currentWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
                            continue;
                        }
                        if (text.equals("...")) {
                            isEllipsisAvailable = true;
                            if (!node.has("typeNode") && firstKeyword.equals("...")) {
                                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                                updatedFirstKeyword = true;
                                continue;
                            }
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (text.equals("=")) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (text.equals(":")) {
                            currentWS.addProperty("ws", "");
                            isColonAvailable = true;
                            continue;
                        }
                        if (text.equals(varName) && varAvailable) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (!node.has("typeNode") && firstKeyword.equals("...")) {
                            currentWS.addProperty("ws", "");
                            continue;
                        }
                        if (node.has("isAnonType") && node.get("isAnonType").getAsBoolean()) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (i == 0 && formatConfig.get("newLineCount").getAsInt() > 0 && !node.has("typeNode")) {
                            currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                            continue;
                        }
                        if (isColonAvailable) {
                            currentWS.addProperty("ws", " ");
                            continue;
                        }
                        if (!node.has("typeNode") && !hasFirstKeyword || node.has("arrowExprParam") && node.get("arrowExprParam").getAsBoolean()) {
                            currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                            continue;
                        }
                        currentWS.addProperty("ws", formatConfig.get("spacesCount").getAsInt() > 0 ? this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) : " ");
                        continue;
                    }
                    if (useParentIndentation && isObject) {
                        if (text.equals("final") || text.equals("public") || text.equals("private") || text.equals("const") || text.equals("var") || text.equals("client") || text.equals("listener") || text.equals("abstract") || text.equals("channel") || text.equals("object")) {
                            currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                            isLineBroken = true;
                            continue;
                        }
                        if (!isLineBroken || !text.equals("{") && !text.equals("}") && !text.equals("...")) continue;
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        continue;
                    }
                    if (!text.equals("start")) continue;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                }
                if (node.has("typeNode")) {
                    JsonObject typeFormatConfig;
                    JsonObject typeNode = node.getAsJsonObject("typeNode");
                    if (node.has("isAnonType") && node.get("isAnonType").getAsBoolean()) {
                        int spaceCount = formatConfig.get("spacesCount").getAsInt();
                        if (hasAnnotation && spaceCount == 0) {
                            spaceCount = 1;
                        }
                        typeFormatConfig = this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), spaceCount, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(useParentIndentation ? indentWithParentIndentation : indentation), useParentIndentation);
                        typeNode.add("formattingConfig", (JsonElement)typeFormatConfig);
                    } else if (node.has("final") && node.get("final").getAsBoolean() || node.has("public") && node.get("public").getAsBoolean() && firstKeywordWS.get("text").getAsString().equals("public") || firstKeywordWS.get("text").getAsString().equals("private") || firstKeywordWS.get("text").getAsString().equals("const") || firstKeywordWS.get("text").getAsString().equals("var") || firstKeywordWS.get("text").getAsString().equals("client") || firstKeywordWS.get("text").getAsString().equals("listener") || firstKeywordWS.get("text").getAsString().equals("abstract") || firstKeywordWS.get("text").getAsString().equals("channel")) {
                        typeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount((useParentIndentation ? indentWithParentIndentation : indentation) + (isParam ? additionalIndentation : "")), useParentIndentation);
                        typeNode.add("formattingConfig", (JsonElement)typeFormatConfig);
                    } else if (!hasAnnotation) {
                        typeNode.add("formattingConfig", (JsonElement)formatConfig);
                    } else {
                        typeFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentWithParentIndentation : indentation), useParentIndentation);
                        typeNode.add("formattingConfig", (JsonElement)typeFormatConfig);
                    }
                    node.getAsJsonObject("typeNode").addProperty("isLineBroken", Boolean.valueOf(isLineBroken));
                }
                if (node.has("initialExpression")) {
                    JsonObject initialExprFormattingConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentWithParentIndentation), true);
                    node.getAsJsonObject("initialExpression").add("formattingConfig", (JsonElement)initialExprFormattingConfig);
                }
                if (node.has("annotationAttachments")) {
                    JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
                    for (int i = 0; i < annotationAttachments.size(); ++i) {
                        JsonObject annotationAttachment = annotationAttachments.get(i).getAsJsonObject();
                        JsonObject annotationAttachmentFormattingConfig = isParam ? (i == 0 ? this.getFormattingConfig(0, 0, this.getWhiteSpaceCount(indentation + additionalIndentation), false, this.getWhiteSpaceCount(indentWithParentIndentation + additionalIndentation), true) : this.getFormattingConfig(0, 1, this.getWhiteSpaceCount(indentation + additionalIndentation), false, this.getWhiteSpaceCount(indentWithParentIndentation + additionalIndentation), true)) : this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), false, this.getWhiteSpaceCount(indentWithParentIndentation), false);
                        annotationAttachment.getAsJsonObject().add("formattingConfig", (JsonElement)annotationAttachmentFormattingConfig);
                    }
                }
            } else if (node.has("typeNode")) {
                node.getAsJsonObject("typeNode").add("formattingConfig", (JsonElement)formatConfig);
                node.getAsJsonObject("typeNode").addProperty("isLineBroken", Boolean.valueOf(isLineBroken));
            } else if (node.has("worker") && node.get("worker").getAsBoolean() && node.has("initialExpression") && node.getAsJsonObject("initialExpression").get("kind").getAsString().equals("Lambda")) {
                node.getAsJsonObject("initialExpression").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatWaitExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = this.getParentIndentation(formatConfig);
            boolean isWaitBroken = false;
            this.preserveHeight(ws, indentWithParentIndentation, false);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (this.noHeightAvailable(currentWS.get("ws").getAsString())) {
                    if (text.equals("wait") || text.equals("{")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals("}") && !text.equals(",")) continue;
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (text.equals("wait")) {
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                    isWaitBroken = true;
                }
                if (isWaitBroken) {
                    if (text.equals("{") || text.equals("}")) {
                        currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
                        continue;
                    }
                    if (!text.equals(",")) continue;
                    currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    " + "    ");
                    continue;
                }
                if (!text.equals(",")) continue;
                currentWS.addProperty("ws", currentWS.get("ws").getAsString() + "    ");
            }
            if (node.has("keyValuePairs")) {
                JsonArray keyValuePairs = node.getAsJsonArray("keyValuePairs");
                this.iterateAndFormatMembers(isWaitBroken ? indentWithParentIndentation + "    " : indentWithParentIndentation, keyValuePairs);
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(isWaitBroken ? indentWithParentIndentation + "    " : indentWithParentIndentation), true));
            }
        }
    }

    public void formatWaitLiteralKeyValueNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            String keyName = "";
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            if (node.has("key")) {
                Iterator key = node.getAsJsonObject("key");
                keyName = key.get("value").getAsString();
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals(":")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                if (!text.equals(keyName)) continue;
                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
            if (node.has("value")) {
                JsonObject value = node.getAsJsonObject("value");
                value.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatWhereNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !text.equals("where")) continue;
                if (formatConfig.get("spacesCount").getAsInt() > 0) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (formatConfig.get("newLineCount").getAsInt() > 0) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent + "    "), true));
            }
        }
    }

    public void formatWhileNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject openingBraceWS;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, true);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, indentation, useParentIndentation);
            JsonObject whileKeywordWS = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(whileKeywordWS.get("ws").getAsString())) {
                whileKeywordWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
            if (this.noHeightAvailable((openingBraceWS = ws.get(ws.size() - 2).getAsJsonObject()).get("ws").getAsString())) {
                openingBraceWS.addProperty("ws", " ");
            }
            JsonObject closingBraceWS = ws.get(ws.size() - 1).getAsJsonObject();
            this.modifyBlockClosingBrace(node, indentation, closingBraceWS, "body", true);
            if (node.has("condition")) {
                JsonObject whileCondition = node.getAsJsonObject("condition");
                JsonObject whileConditionFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                whileCondition.add("formattingConfig", (JsonElement)whileConditionFormatConfig);
            }
            if (node.has("body")) {
                this.modifyConstructBody(node.getAsJsonObject("body"), indentation, indentationOfParent, false);
            }
        }
    }

    public void formatWithinNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatWorkerNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject openingBrace;
            JsonObject workerIdentifier;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            node.getAsJsonObject("position").addProperty("startColumn", (Number)this.getWhiteSpaceCount(indentation));
            this.preserveHeight(ws, indentation, useParentIndentation);
            JsonObject workerKeywordWhitespace = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(workerKeywordWhitespace.get("ws").getAsString())) {
                workerKeywordWhitespace.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
            }
            if (this.noHeightAvailable((workerIdentifier = ws.get(ws.size() - 3).getAsJsonObject()).get("ws").getAsString())) {
                workerIdentifier.addProperty("ws", " ");
            }
            if (this.noHeightAvailable((openingBrace = ws.get(ws.size() - 2).getAsJsonObject()).get("ws").getAsString())) {
                openingBrace.addProperty("ws", " ");
            }
            JsonObject closingBrace = ws.get(ws.size() - 1).getAsJsonObject();
            if (node.has("body") && node.getAsJsonObject("body").getAsJsonArray("statements").size() <= 0 && node.getAsJsonArray("workers").size() <= 0 && node.getAsJsonArray("endpointNodes").size() <= 0) {
                if (this.noHeightAvailable(closingBrace.get("ws").getAsString())) {
                    closingBrace.addProperty("ws", "");
                }
            } else if (this.noHeightAvailable(ws.get(ws.size() - 1).getAsJsonObject().get("ws").getAsString())) {
                closingBrace.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
            }
        }
    }

    public void formatWorkerFlushNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("flush")) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
        }
    }

    public void formatWorkerReceiveNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentationFromParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentationFromParent, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("<-")) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                if (text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("keyExpression")) {
                node.getAsJsonObject("keyExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationFromParent), false));
            }
        }
    }

    public void formatWorkerSendNode(JsonObject node) {
        if (node.has("formattingConfig") && node.has("ws")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                String text = currentWS.get("text").getAsString();
                if (text.equals("->")) {
                    currentWS.addProperty("ws", " ");
                    continue;
                }
                if (text.equals(";") || text.equals(",")) {
                    currentWS.addProperty("ws", "");
                    continue;
                }
                currentWS.addProperty("ws", " ");
            }
            if (node.has("keyExpression")) {
                node.getAsJsonObject("keyExpression").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), false));
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatWorkerSyncSendNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", " ");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatXmlAttributeNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIdentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIdentation ? indentationOfParent : indentation, useParentIdentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("=")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("name")) {
                node.getAsJsonObject("name").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("value")) {
                node.getAsJsonObject("value").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatXmlAttributeAccessExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                String text;
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString()) || !(text = currentWS.get("text").getAsString()).equals("@") && !text.equals("[") && !text.equals("]")) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                node.getAsJsonObject("expression").add("formattingConfig", (JsonElement)formatConfig);
            }
            if (node.has("index")) {
                node.getAsJsonObject("index").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(useParentIndentation ? indentationOfParent : indentation), true));
            }
        }
    }

    public void formatXmlCommentLiteralNode(JsonObject node) {
        this.modifyXMLLiteralNode(node);
    }

    public void formatXmlElementAccessNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, formatConfig.get("spacesCount").getAsInt(), 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("filters")) {
                JsonArray filters = node.getAsJsonArray("filters");
                for (JsonElement filterItem : filters) {
                    JsonObject filter = filterItem.getAsJsonObject();
                    filter.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
        }
    }

    public void formatXmlElementLiteralNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            String startLiteral = "";
            if (node.has("startLiteral")) {
                startLiteral = node.get("startLiteral").getAsString();
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("text", "xml `");
                }
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("startTagName")) {
                node.getAsJsonObject("startTagName").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("attributes")) {
                JsonArray attributes = node.getAsJsonArray("attributes");
                for (JsonElement attributeItem : attributes) {
                    JsonObject attribute = attributeItem.getAsJsonObject();
                    attribute.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
            if (node.has("content")) {
                JsonArray contents = node.getAsJsonArray("content");
                for (JsonElement contentItem : contents) {
                    JsonObject content = contentItem.getAsJsonObject();
                    content.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
            if (node.has("endTagName")) {
                node.getAsJsonObject("endTagName").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
        }
    }

    public void formatXmlnsNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("ws")) {
                JsonArray ws = node.getAsJsonArray("ws");
                String indentation = this.getIndentation(formatConfig, false);
                String indentationOfParent = this.getParentIndentation(formatConfig);
                boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
                this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
                String prefix = "";
                if (node.has("prefix")) {
                    prefix = node.getAsJsonObject("prefix").get("value").getAsString();
                }
                for (JsonElement wsItem : ws) {
                    JsonObject currentWS = wsItem.getAsJsonObject();
                    if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                    String text = currentWS.get("text").getAsString();
                    if (text.equals("xmlns")) {
                        currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentation);
                        continue;
                    }
                    if (text.equals("as")) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (text.equals(prefix)) {
                        currentWS.addProperty("ws", " ");
                        continue;
                    }
                    if (!text.equals(";")) continue;
                    currentWS.addProperty("ws", "");
                }
                if (node.has("namespaceURI")) {
                    node.getAsJsonObject("namespaceURI").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true));
                }
            } else if (node.has("namespaceDeclaration")) {
                node.getAsJsonObject("namespaceDeclaration").add("formattingConfig", (JsonElement)formatConfig);
            }
        }
    }

    public void formatXmlNavigationNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", "");
            }
            if (node.has("expression")) {
                JsonObject expression = node.getAsJsonObject("expression");
                expression.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, formatConfig.get("spacesCount").getAsInt(), 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("childIndex")) {
                JsonObject childIndex = node.getAsJsonObject("childIndex");
                childIndex.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("filters")) {
                JsonArray filters = node.getAsJsonArray("filters");
                for (JsonElement filterItem : filters) {
                    JsonObject filter = filterItem.getAsJsonObject();
                    filter.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
        }
    }

    public void formatXmlElementFilterExprNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
            }
        }
    }

    public void formatXmlPiLiteralNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            String startLiteral = "";
            if (node.has("startLiteral")) {
                startLiteral = node.get("startLiteral").getAsString();
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("text", "xml `");
                }
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("target")) {
                node.getAsJsonObject("target").add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
            }
            if (node.has("dataTextFragments")) {
                JsonArray dataTextFragments = node.getAsJsonArray("dataTextFragments");
                for (JsonElement textFragmentItem : dataTextFragments) {
                    JsonObject textFragment = textFragmentItem.getAsJsonObject();
                    textFragment.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
        }
    }

    public void formatXmlQnameNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (i == 0) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
        }
    }

    public void formatXmlQuotedStringNode(JsonObject node) {
        if (node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            if (node.has("textFragments")) {
                JsonArray textFragments = node.getAsJsonArray("textFragments");
                for (JsonElement textFragmentItem : textFragments) {
                    JsonObject textFragment = textFragmentItem.getAsJsonObject();
                    textFragment.add("formattingConfig", (JsonElement)formatConfig);
                }
            }
        }
    }

    public void formatXmlSequenceLiteralNode(JsonObject node) {
        this.skipFormatting(node, true);
    }

    public void formatXmlTextLiteralNode(JsonObject node) {
        this.modifyXMLLiteralNode(node);
    }

    private void modifyConstructBody(JsonObject node, String indentation, String indentWithParentIndentation, boolean useParentIndentation) {
        node.add("formattingConfig", (JsonElement)this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(this.getWhiteSpaceCount(indentation) == 0 ? indentWithParentIndentation : indentation), true, this.getWhiteSpaceCount(indentWithParentIndentation), useParentIndentation));
    }

    private void modifyXMLLiteralNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            JsonArray ws = node.getAsJsonArray("ws");
            String indentation = this.getIndentation(formatConfig, false);
            String indentationOfParent = this.getParentIndentation(formatConfig);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? indentationOfParent : indentation, useParentIndentation);
            String startLiteral = "";
            if (node.has("startLiteral")) {
                startLiteral = node.get("startLiteral").getAsString();
            }
            for (JsonElement wsItem : ws) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                String text = currentWS.get("text").getAsString();
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("text", "xml `");
                }
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (text.equals(startLiteral)) {
                    currentWS.addProperty("ws", this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()));
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
            if (node.has("textFragments")) {
                JsonArray textFragments = node.getAsJsonArray("textFragments");
                for (JsonElement textFragmentItem : textFragments) {
                    JsonObject textFragment = textFragmentItem.getAsJsonObject();
                    textFragment.add("formattingConfig", (JsonElement)this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentationOfParent), true));
                }
            }
        }
    }

    private void modifyLiteralNode(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentation = this.getIndentation(formatConfig, false);
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, useParentIndentation ? this.getParentIndentation(formatConfig) : indentation, useParentIndentation);
            for (int i = 0; i < ws.size(); ++i) {
                JsonObject currentWS = ws.get(i).getAsJsonObject();
                if (!this.noHeightAvailable(currentWS.get("ws").getAsString())) continue;
                if (i == 0) {
                    currentWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation);
                    continue;
                }
                currentWS.addProperty("ws", "");
            }
        }
    }

    private void modifyReturnTypeAnnotations(JsonObject node, String indentation) {
        if (node.has("returnTypeAnnotationAttachments")) {
            JsonArray returnTypeAnnotations = node.getAsJsonArray("returnTypeAnnotationAttachments");
            for (JsonElement element : returnTypeAnnotations) {
                JsonObject returnTypeAnnotation = element.getAsJsonObject();
                JsonObject memberFormatConfig = this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
                returnTypeAnnotation.add("formattingConfig", (JsonElement)memberFormatConfig);
            }
        }
    }

    private void modifyExpressions(JsonObject node, String indentWithParentIndentation) {
        if (node.has("expressions")) {
            JsonArray expressions = node.getAsJsonArray("expressions");
            this.iterateAndFormatMembers(indentWithParentIndentation, expressions);
        }
    }

    private void modifyBlockClosingBrace(JsonObject node, String indentation, JsonObject closingBraceWS, String block, boolean isSingleLineBlock) {
        if (node.has(block) && node.getAsJsonObject(block).getAsJsonArray("statements").size() <= 0 && this.noHeightAvailable(closingBraceWS.get("ws").getAsString())) {
            if (!isSingleLineBlock) {
                closingBraceWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation + FormattingConstants.NEW_LINE + indentation);
            } else {
                closingBraceWS.addProperty("ws", "");
            }
        } else if (this.noHeightAvailable(closingBraceWS.get("ws").getAsString())) {
            closingBraceWS.addProperty("ws", FormattingConstants.NEW_LINE + indentation);
        }
    }

    private void modifyBranchingStatement(JsonObject node) {
        if (node.has("ws") && node.has("formattingConfig")) {
            JsonObject semicolonWS;
            JsonArray ws = node.getAsJsonArray("ws");
            JsonObject formatConfig = node.getAsJsonObject("formattingConfig");
            String indentWithParentIndentation = formatConfig.get("doIndent").getAsBoolean() ? this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt()) + "    " : this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt());
            boolean useParentIndentation = formatConfig.get("useParentIndentation").getAsBoolean();
            this.preserveHeight(ws, indentWithParentIndentation, useParentIndentation);
            JsonObject doneWS = ws.get(0).getAsJsonObject();
            if (this.noHeightAvailable(doneWS.get("ws").getAsString())) {
                doneWS.addProperty("ws", this.getNewLines(formatConfig.get("newLineCount").getAsInt()) + indentWithParentIndentation);
            }
            if (this.noHeightAvailable((semicolonWS = ws.get(ws.size() - 1).getAsJsonObject()).get("ws").getAsString())) {
                semicolonWS.addProperty("ws", "");
            }
        }
    }

    private void modifyAnnotationAttachments(JsonObject node, JsonObject formatConfig, String indentation) {
        if (node.has("annotationAttachments")) {
            JsonArray annotationAttachments = node.getAsJsonArray("annotationAttachments");
            for (int i = 0; i < annotationAttachments.size(); ++i) {
                JsonObject annotationAttachment = annotationAttachments.get(i).getAsJsonObject();
                JsonObject annotationFormattingConfig = i == 0 ? this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), 0, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), true) : this.getFormattingConfig(1, 0, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), true);
                annotationAttachment.add("formattingConfig", (JsonElement)annotationFormattingConfig);
            }
        }
    }

    private void modifyMarkdownDocumentation(JsonObject node, JsonObject formatConfig, String indentation) {
        if (node.has("markdownDocumentationAttachment")) {
            JsonObject markdownDocumentationAttachment = node.getAsJsonObject("markdownDocumentationAttachment");
            JsonObject markdownDocumentationAttachmentConfig = this.getFormattingConfig(formatConfig.get("newLineCount").getAsInt(), 0, formatConfig.get("startColumn").getAsInt(), false, this.getWhiteSpaceCount(indentation), false);
            markdownDocumentationAttachment.add("formattingConfig", (JsonElement)markdownDocumentationAttachmentConfig);
        }
    }

    private void modifyWorkers(JsonObject node, String indentation) {
        if (node.has("workers")) {
            JsonArray workers = node.getAsJsonArray("workers");
            this.iterateAndFormatBlockStatements(this.getWhiteSpaces(node.getAsJsonObject("position").get("startColumn").getAsInt()), indentation, workers);
        }
    }

    private void modifyEndpoints(JsonObject node, String indentation) {
        if (node.has("endpointNodes")) {
            JsonArray endpointNodes = node.getAsJsonArray("endpointNodes");
            this.iterateAndFormatBlockStatements(this.getWhiteSpaces(node.getAsJsonObject("position").get("startColumn").getAsInt()), indentation, endpointNodes);
        }
    }

    private void modifyPatternClauses(JsonObject node, String indentation) {
        if (node.has("patternClauses")) {
            JsonArray patternClauses = node.getAsJsonArray("patternClauses");
            for (JsonElement patternClause : patternClauses) {
                JsonObject patternFormatConfig = this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentation), false);
                patternClause.getAsJsonObject().add("formattingConfig", (JsonElement)patternFormatConfig);
            }
        }
    }

    private void modifyVariableReferences(JsonObject formatConfig, String indentation, JsonArray variableReferences) {
        for (int i = 0; i < variableReferences.size(); ++i) {
            JsonObject memberType = variableReferences.get(i).getAsJsonObject();
            JsonObject memberTypeFormatConfig = i == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true);
            memberType.add("formattingConfig", (JsonElement)memberTypeFormatConfig);
        }
    }

    private void iterateAndFormatBlockStatements(String indentation, String indentationOfParent, JsonArray blockStatementNodes) {
        for (int i = 0; i < blockStatementNodes.size(); ++i) {
            JsonObject endpointNode = blockStatementNodes.get(i).getAsJsonObject();
            JsonObject endpointFormatConfig = i == 0 ? this.getFormattingConfig(1, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentationOfParent), false) : this.getFormattingConfig(2, 0, this.getWhiteSpaceCount(indentation), true, this.getWhiteSpaceCount(indentationOfParent), false);
            endpointNode.add("formattingConfig", (JsonElement)endpointFormatConfig);
        }
    }

    private void iterateAndFormatMembers(String indentation, JsonArray members) {
        int count = 0;
        for (int i = 0; i < members.size(); ++i) {
            JsonObject member = members.get(i).getAsJsonObject();
            if (member.has("skipFormatting") && member.get("skipFormatting").getAsBoolean()) continue;
            JsonObject memberFormatConfig = count == 0 ? this.getFormattingConfig(0, 0, 0, false, this.getWhiteSpaceCount(indentation), true) : (member.get("kind").getAsString().equals("RecordLiteralExpr") ? this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation + "    "), true) : this.getFormattingConfig(0, 1, 0, false, this.getWhiteSpaceCount(indentation), true));
            member.add("formattingConfig", (JsonElement)memberFormatConfig);
            ++count;
        }
    }

    private String getWhiteSpaces(int column) {
        StringBuilder whiteSpaces = new StringBuilder();
        for (int i = 0; i <= column - 1; ++i) {
            whiteSpaces.append(" ");
        }
        return whiteSpaces.toString();
    }

    private String getNewLines(int column) {
        StringBuilder newLines = new StringBuilder();
        for (int i = 0; i < column; ++i) {
            newLines.append("\n");
        }
        return newLines.toString();
    }

    private int getWhiteSpaceCount(String ws) {
        return ws.length();
    }

    private List<String> tokenizer(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder comment = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String character = text.charAt(i) + "";
            if (!character.contains("\n")) {
                comment.append(text.charAt(i));
            } else {
                if (!comment.toString().trim().equals("")) {
                    tokens.add(comment.toString().trim());
                    comment = new StringBuilder();
                }
                tokens.add(character);
            }
            if (i != text.length() - 1 || comment.toString().trim().equals("")) continue;
            tokens.add(comment.toString().trim());
            comment = new StringBuilder();
        }
        return tokens;
    }

    private String getTextFromTokens(List<String> tokens, String indent) {
        StringBuilder text = new StringBuilder();
        for (String token : tokens) {
            if (!token.contains("\n")) {
                text.append(indent != null ? indent + token : token);
                continue;
            }
            text.append(token);
        }
        return indent != null ? text + indent : text.toString();
    }

    private void preserveHeight(JsonArray ws, String indent, boolean activateLineBreakIndent) {
        indent = activateLineBreakIndent ? indent + "    " : indent;
        for (int i = 0; i < ws.size(); ++i) {
            if (!ws.get(i).isJsonObject()) continue;
            this.preserveHeightForWS(ws.get(i).getAsJsonObject(), indent);
        }
    }

    private void preserveHeightForWS(JsonObject ws, String indent) {
        if (ws.has("ws") && (ws.get("ws").getAsString().trim().length() > 0 || ws.get("ws").getAsString().contains("\n"))) {
            List<String> tokens = this.tokenizer(ws.get("ws").getAsString());
            ws.addProperty("ws", this.getTextFromTokens(tokens, indent));
        }
    }

    private boolean noHeightAvailable(String ws) {
        return ws.trim().length() <= 0 && !ws.contains("\n");
    }

    private boolean noNewLine(String text) {
        return !text.contains("\n");
    }

    private void skipFormatting(JsonObject node, boolean doSkip) {
        node.addProperty("skipFormatting", Boolean.valueOf(doSkip));
        for (Map.Entry child : node.entrySet()) {
            if (((String)child.getKey()).equals("parent") || ((String)child.getKey()).equals("position") || ((String)child.getKey()).equals("ws")) continue;
            if (((JsonElement)child.getValue()).isJsonObject() && ((JsonElement)child.getValue()).getAsJsonObject().has("kind")) {
                this.skipFormatting(((JsonElement)child.getValue()).getAsJsonObject(), doSkip);
                continue;
            }
            if (!((JsonElement)child.getValue()).isJsonArray()) continue;
            for (int i = 0; i < ((JsonElement)child.getValue()).getAsJsonArray().size(); ++i) {
                JsonElement childItem = ((JsonElement)child.getValue()).getAsJsonArray().get(i);
                if (!childItem.isJsonObject() || !childItem.getAsJsonObject().has("kind")) continue;
                this.skipFormatting(childItem.getAsJsonObject(), doSkip);
            }
        }
    }

    private JsonObject getFormattingConfig(int newLineCount, int spacesCount, int startColumn, boolean doIndent, int indentedStartColumn, boolean userParentIndentation) {
        JsonObject formattingConfig = new JsonObject();
        formattingConfig.addProperty("newLineCount", (Number)newLineCount);
        formattingConfig.addProperty("spacesCount", (Number)spacesCount);
        formattingConfig.addProperty("startColumn", (Number)startColumn);
        formattingConfig.addProperty("doIndent", Boolean.valueOf(doIndent));
        formattingConfig.addProperty("indentedStartColumn", (Number)indentedStartColumn);
        formattingConfig.addProperty("useParentIndentation", Boolean.valueOf(userParentIndentation));
        return formattingConfig;
    }

    private String getIndentation(JsonObject formatConfig, boolean addSpaces) {
        String indentation = formatConfig.get("doIndent").getAsBoolean() ? this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt()) + "    " : this.getWhiteSpaces(formatConfig.get("startColumn").getAsInt());
        return addSpaces ? this.getWhiteSpaces(formatConfig.get("spacesCount").getAsInt()) + indentation : indentation;
    }

    private String getParentIndentation(JsonObject formatConfig) {
        return formatConfig.get("doIndent").getAsBoolean() ? this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt()) + "    " : this.getWhiteSpaces(formatConfig.get("indentedStartColumn").getAsInt());
    }

    private boolean isMemberOnNewLine(JsonArray members) {
        boolean lineSeparationAvailable = false;
        block0: for (JsonElement memberItem : members) {
            JsonObject member = memberItem.getAsJsonObject();
            if (!member.has("ws")) continue;
            List<JsonObject> sortedWSForMember = FormattingSourceGen.extractWS(member);
            for (JsonObject wsForMember : sortedWSForMember) {
                String currentWS = wsForMember.get("ws").getAsString();
                if (this.noNewLine(currentWS)) continue;
                lineSeparationAvailable = true;
                continue block0;
            }
        }
        return lineSeparationAvailable;
    }

    private boolean isOnNewLine(JsonObject member) {
        boolean lineSeparationAvailable = false;
        if (member.has("ws")) {
            List<JsonObject> sortedWSForMember = FormattingSourceGen.extractWS(member);
            for (JsonObject wsForMember : sortedWSForMember) {
                String currentWS = wsForMember.get("ws").getAsString();
                if (this.noNewLine(currentWS)) continue;
                lineSeparationAvailable = true;
                break;
            }
        }
        return lineSeparationAvailable;
    }

    private boolean isReasonAvailable(JsonObject reason) {
        boolean reasonAvailable = true;
        if (!reason.has("ws")) {
            JsonObject name;
            String value;
            if (reason.get("kind").getAsString().equals("SimpleVariableRef") && reason.has("variableName")) {
                JsonObject variableName = reason.getAsJsonObject("variableName");
                String value2 = variableName.get("value").getAsString();
                if (value2.equals("_")) {
                    reasonAvailable = false;
                }
            } else if (reason.get("kind").getAsString().equals("Variable") && reason.has("name") && ((value = (name = reason.getAsJsonObject("name")).get("value").getAsString()).equals("$reason$") || value.equals("_"))) {
                reasonAvailable = false;
            }
        }
        return reasonAvailable;
    }
}

