/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.format;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.ballerinalang.langserver.compiler.common.modal.SymbolMetaInfo;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.format.FormatterCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.format.JSONGenerationException;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;

public class TextDocumentFormatUtil {
    private static final Logger logger = LoggerFactory.getLogger(TextDocumentFormatUtil.class);
    private static final String SYMBOL_TYPE = "symbolType";
    private static final String INVOCATION_TYPE = "invocationType";
    private static final String UNESCAPED_VALUE = "unescapedValue";

    public static JsonObject getAST(Path file, WorkspaceDocumentManager documentManager, LSContext context) throws JSONGenerationException, CompilationFailedException {
        String path = file.toAbsolutePath().toString();
        LSDocumentIdentifierImpl lsDocument = new LSDocumentIdentifierImpl(file.toUri().toString());
        String packageName = lsDocument.getOwnerModule();
        String[] breakFromPackage = path.split(Pattern.quote(packageName + File.separator));
        String relativePath = breakFromPackage[breakFromPackage.length - 1];
        BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage(context, documentManager, FormatterCustomErrorStrategy.class, false, false);
        ArrayList diagnostics = new ArrayList();
        JsonArray errors = new JsonArray();
        JsonObject result = new JsonObject();
        result.add("errors", (JsonElement)errors);
        Gson gson = new Gson();
        JsonElement diagnosticsJson = gson.toJsonTree(diagnostics);
        result.add("diagnostics", diagnosticsJson);
        BLangCompilationUnit compilationUnit = TextDocumentFormatUtil.isTestablePackage(relativePath) ? (BLangCompilationUnit)bLangPackage.getTestablePkg().getCompilationUnits().stream().filter(compUnit -> relativePath.equals(compUnit.getName())).findFirst().orElse(null) : (BLangCompilationUnit)bLangPackage.getCompilationUnits().stream().filter(compUnit -> relativePath.equals(compUnit.getName())).findFirst().orElse(null);
        JsonElement modelElement = TextDocumentFormatUtil.generateJSON((Node)compilationUnit, new HashMap<String, Node>(), new HashMap<BLangNode, List<SymbolMetaInfo>>());
        result.add("model", modelElement);
        return result;
    }

    private static boolean isTestablePackage(String relativeFilePath) {
        return relativeFilePath.startsWith("tests" + File.separator);
    }

    public static JsonElement generateJSON(Node node, Map<String, Node> anonStructs, Map<BLangNode, List<SymbolMetaInfo>> visibleEPsByNode) throws JSONGenerationException {
        Diagnostic.DiagnosticPosition position;
        if (node == null) {
            return JsonNull.INSTANCE;
        }
        Set methods = ClassUtils.getAllInterfaces(node.getClass()).stream().flatMap(aClass -> Arrays.stream(aClass.getMethods())).collect(Collectors.toSet());
        JsonObject nodeJson = new JsonObject();
        JsonArray wsJsonArray = new JsonArray();
        Set ws = node.getWS();
        if (ws != null && !ws.isEmpty()) {
            for (Whitespace whitespace : ws) {
                JsonObject wsJson = new JsonObject();
                wsJson.addProperty("ws", whitespace.getWs());
                wsJson.addProperty("i", (Number)whitespace.getIndex());
                wsJson.addProperty("text", whitespace.getPrevious());
                wsJson.addProperty("static", Boolean.valueOf(whitespace.isStatic()));
                wsJsonArray.add((JsonElement)wsJson);
            }
            nodeJson.add("ws", (JsonElement)wsJsonArray);
        }
        if ((position = node.getPosition()) != null) {
            JsonObject positionJson = new JsonObject();
            positionJson.addProperty("startColumn", (Number)position.getStartColumn());
            positionJson.addProperty("startLine", (Number)position.getStartLine());
            positionJson.addProperty("endColumn", (Number)position.getEndColumn());
            positionJson.addProperty("endLine", (Number)position.getEndLine());
            nodeJson.add("position", (JsonElement)positionJson);
        }
        nodeJson.addProperty("id", (Number)System.identityHashCode(node));
        if (visibleEPsByNode.containsKey(node)) {
            List<SymbolMetaInfo> endpointMetaList = visibleEPsByNode.get(node);
            JsonArray endpoints = new JsonArray();
            endpointMetaList.forEach(symbolMetaInfo -> endpoints.add(symbolMetaInfo.getJson()));
            nodeJson.add("VisibleEndpoints", (JsonElement)endpoints);
        }
        if (node instanceof BLangSimpleVariableDef) {
            nodeJson.addProperty("isEndpoint", Boolean.valueOf(TextDocumentFormatUtil.isClientObject((BSymbol)((BLangSimpleVariableDef)node).var.symbol)));
        } else if (node instanceof BLangSimpleVariable) {
            nodeJson.addProperty("isEndpoint", Boolean.valueOf(TextDocumentFormatUtil.isClientObject((BSymbol)((BLangSimpleVariable)node).symbol)));
        } else if (node instanceof BLangSimpleVarRef) {
            BSymbol varSymbol = ((BLangSimpleVarRef)node).symbol;
            nodeJson.addProperty("isEndpoint", Boolean.valueOf(varSymbol != null && TextDocumentFormatUtil.isClientObject(varSymbol)));
        }
        JsonArray type = TextDocumentFormatUtil.getType(node);
        if (type != null) {
            nodeJson.add(SYMBOL_TYPE, (JsonElement)type);
        }
        if (node.getKind() == NodeKind.INVOCATION) {
            assert (node instanceof BLangInvocation) : node.getClass();
            BLangInvocation invocation = (BLangInvocation)node;
            if (invocation.symbol != null && invocation.symbol.kind != null) {
                nodeJson.addProperty(INVOCATION_TYPE, invocation.symbol.kind.toString());
                JsonArray defLink = new JsonArray();
                TextDocumentFormatUtil.getDefinitionLink(invocation.symbol, defLink);
                nodeJson.add("definition", (JsonElement)defLink);
            }
        }
        for (Method m : methods) {
            String jsonName;
            String name = m.getName();
            if (name.equals("getWS") || name.equals("getPosition")) continue;
            if (name.startsWith("get")) {
                jsonName = TextDocumentFormatUtil.toJsonName(name, 3);
            } else {
                if (!name.startsWith("is")) continue;
                jsonName = TextDocumentFormatUtil.toJsonName(name, 2);
            }
            Object prop = null;
            try {
                prop = m.invoke((Object)node, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONGenerationException("Error occurred while generating JSON", e);
            }
            if ((node.getKind() == NodeKind.LITERAL || node.getKind() == NodeKind.NUMERIC_LITERAL) && "value".equals(jsonName)) {
                if (prop instanceof String) {
                    nodeJson.addProperty(jsonName, '\"' + StringEscapeUtils.escapeJava((String)((String)prop)) + '\"');
                    nodeJson.addProperty(UNESCAPED_VALUE, String.valueOf(prop));
                    continue;
                }
                nodeJson.addProperty(jsonName, String.valueOf(prop));
                continue;
            }
            if (node.getKind() == NodeKind.ANNOTATION && node instanceof BLangAnnotation) {
                JsonArray attachmentPoints = new JsonArray();
                ((BLangAnnotation)node).getAttachPoints().stream().map(attachPoint -> attachPoint.point.getValue()).map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)attachmentPoints).add(arg_0));
                nodeJson.add("attachmentPoints", (JsonElement)attachmentPoints);
            }
            if (prop instanceof List && jsonName.equals("types")) continue;
            if (prop instanceof Node) {
                nodeJson.add(jsonName, TextDocumentFormatUtil.generateJSON((Node)prop, anonStructs, visibleEPsByNode));
                continue;
            }
            if (prop instanceof List) {
                List listProp = (List)prop;
                Flag[] listPropJson = new JsonArray();
                nodeJson.add(jsonName, (JsonElement)listPropJson);
                for (Object listPropItem : listProp) {
                    if (listPropItem instanceof Node) {
                        if (node.getKind() == NodeKind.COMPILATION_UNIT && listPropItem instanceof BLangFunction && ((BLangFunction)listPropItem).name.value.startsWith("$lambda$")) continue;
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)listPropItem, anonStructs, visibleEPsByNode));
                        continue;
                    }
                    if (listPropItem instanceof BLangRecordVarRef.BLangRecordVarRefKeyValue) {
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangRecordVarRef.BLangRecordVarRefKeyValue)listPropItem).getVariableName(), anonStructs, visibleEPsByNode));
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangRecordVarRef.BLangRecordVarRefKeyValue)listPropItem).getBindingPattern(), anonStructs, visibleEPsByNode));
                        continue;
                    }
                    if (listPropItem instanceof BLangRecordVariable.BLangRecordVariableKeyValue) {
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangRecordVariable.BLangRecordVariableKeyValue)listPropItem).getKey(), anonStructs, visibleEPsByNode));
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangRecordVariable.BLangRecordVariableKeyValue)listPropItem).getValue(), anonStructs, visibleEPsByNode));
                        continue;
                    }
                    if (listPropItem instanceof BLangErrorVariable.BLangErrorDetailEntry) {
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangErrorVariable.BLangErrorDetailEntry)listPropItem).getKey(), anonStructs, visibleEPsByNode));
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)((BLangErrorVariable.BLangErrorDetailEntry)listPropItem).getValue(), anonStructs, visibleEPsByNode));
                        continue;
                    }
                    if (listPropItem instanceof String) {
                        listPropJson.add((String)listPropItem);
                        continue;
                    }
                    if (listPropItem instanceof BLangLetVariable) {
                        BLangLetVariable variable = (BLangLetVariable)listPropItem;
                        listPropJson.add(TextDocumentFormatUtil.generateJSON((Node)variable.definitionNode, anonStructs, visibleEPsByNode));
                        continue;
                    }
                    logger.debug("Can't serialize " + jsonName + ", has a an array of " + listPropItem);
                }
                continue;
            }
            if (prop instanceof Set && jsonName.equals("flags")) {
                Set flags = (Set)prop;
                for (Flag flag : Flag.values()) {
                    nodeJson.addProperty(StringUtils.lowerCase((String)flag.toString()), Boolean.valueOf(flags.contains(flag)));
                }
                continue;
            }
            if (prop instanceof Set) {
                Set vars = (Set)prop;
                JsonArray listVarJson = new JsonArray();
                nodeJson.add(jsonName, (JsonElement)listVarJson);
                for (Object obj : vars) {
                    listVarJson.add(obj.toString());
                }
                continue;
            }
            if (prop instanceof NodeKind) {
                String kindName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, prop.toString());
                nodeJson.addProperty(jsonName, kindName);
                continue;
            }
            if (prop instanceof OperatorKind) {
                nodeJson.addProperty(jsonName, prop.toString());
                continue;
            }
            if (prop instanceof String) {
                nodeJson.addProperty(jsonName, (String)prop);
                continue;
            }
            if (prop instanceof Number) {
                nodeJson.addProperty(jsonName, (Number)prop);
                continue;
            }
            if (prop instanceof Boolean) {
                nodeJson.addProperty(jsonName, (Boolean)prop);
                continue;
            }
            if (prop instanceof Enum) {
                nodeJson.addProperty(jsonName, StringUtils.lowerCase((String)((Enum)prop).name()));
                continue;
            }
            if (prop instanceof int[]) {
                int[] intArray = (int[])prop;
                JsonArray intArrayPropJson = new JsonArray();
                nodeJson.add(jsonName, (JsonElement)intArrayPropJson);
                for (Object intProp : (Object)intArray) {
                    intArrayPropJson.add((Number)((int)intProp));
                }
                continue;
            }
            if (prop == null) continue;
            nodeJson.addProperty(jsonName, prop.toString());
        }
        return nodeJson;
    }

    public static void getDefinitionLink(BSymbol symbol, JsonArray owners) {
        if (symbol == null) {
            return;
        }
        JsonArray part = new JsonArray();
        if (symbol.name == null) {
            part.add((JsonElement)null);
        } else {
            part.add(symbol.name.value);
        }
        if (symbol.kind == null) {
            part.add((JsonElement)null);
        } else {
            part.add(symbol.kind.name());
        }
        owners.add((JsonElement)part);
        TextDocumentFormatUtil.getDefinitionLink(symbol.owner, owners);
    }

    public static String toJsonName(String name, int prefixLen) {
        return Character.toLowerCase(name.charAt(prefixLen)) + name.substring(prefixLen + 1);
    }

    public static JsonArray getType(Node node) {
        if (!(node instanceof BLangNode)) {
            return null;
        }
        BType type = ((BLangNode)node).type;
        if (node instanceof BLangInvocation) {
            return new JsonArray();
        }
        if (type != null) {
            JsonArray jsonElements = new JsonArray();
            jsonElements.add(type.getKind().typeName());
            return jsonElements;
        }
        return null;
    }

    public static boolean isClientObject(BSymbol bSymbol) {
        return bSymbol != null && bSymbol.type != null && bSymbol.type.tsymbol != null && SymbolKind.OBJECT.equals((Object)bSymbol.type.tsymbol.kind) && (bSymbol.type.tsymbol.flags & 0x20000) == 131072;
    }
}

