/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.sourcegen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormattingSourceGen {
    private static Map<String, JsonObject> anonTypes = new HashMap<String, JsonObject>();

    public static JsonObject build(JsonObject json, String parentKind) {
        String kind = json.get("kind").getAsString();
        for (Map.Entry child : json.entrySet()) {
            if (((String)child.getKey()).equals("position") || ((String)child.getKey()).equals("ws")) continue;
            if (((JsonElement)child.getValue()).isJsonObject() && ((JsonElement)child.getValue()).getAsJsonObject().get("kind") != null) {
                json.add((String)child.getKey(), (JsonElement)FormattingSourceGen.build(((JsonElement)child.getValue()).getAsJsonObject(), kind));
                continue;
            }
            if (!((JsonElement)child.getValue()).isJsonArray()) continue;
            JsonArray childArray = ((JsonElement)child.getValue()).getAsJsonArray();
            for (int j = 0; j < childArray.size(); ++j) {
                JsonElement childItem = childArray.get(j);
                if ("CompilationUnit".equals(kind) && childItem.getAsJsonObject().get("kind").getAsString().equals("Function") && childItem.getAsJsonObject().has("lambda") && childItem.getAsJsonObject().get("lambda").getAsBoolean()) {
                    childArray.remove(j);
                    --j;
                    continue;
                }
                if (!childItem.isJsonObject() || childItem.getAsJsonObject().get("kind") == null) continue;
                FormattingSourceGen.build(childItem.getAsJsonObject(), kind);
            }
        }
        FormattingSourceGen.modifyNode(json, parentKind);
        return json;
    }

    public static String getSourceOf(JsonObject node) {
        StringBuilder sourceBuilder = new StringBuilder();
        for (JsonObject wsItem : FormattingSourceGen.extractWS(node)) {
            sourceBuilder.append(wsItem.get("ws").getAsString()).append(wsItem.get("text").getAsString());
        }
        return sourceBuilder.toString();
    }

    public static List<JsonObject> extractWS(JsonObject node) {
        return FormattingSourceGen.unify(FormattingSourceGen.getSortedWSList(node));
    }

    public static void reconcileWS(JsonObject node, JsonArray attachPoint, JsonObject tree, int startIndex) {
        List<JsonObject> nodeWS = FormattingSourceGen.extractWS(node);
        List<JsonObject> astWS = FormattingSourceGen.getSortedWSList(tree);
        if (startIndex == -1) {
            if (attachPoint.size() > 0) {
                List<JsonObject> attachWS = FormattingSourceGen.extractWS(attachPoint.get(attachPoint.size() - 1).getAsJsonObject());
                startIndex = attachWS.get(attachWS.size() - 1).get("i").getAsInt() + 1;
            } else {
                startIndex = 0;
            }
        }
        int nodeFirstIndex = nodeWS.get(0).get("i").getAsInt();
        int diff = startIndex - nodeFirstIndex;
        nodeWS.forEach(ws -> ws.addProperty("i", (Number)(ws.get("i").getAsInt() + diff)));
        int lastIndex = nodeWS.get(nodeWS.size() - 1).get("i").getAsInt();
        int treeDiff = lastIndex - startIndex + 1;
        for (JsonObject ws2 : astWS) {
            if (ws2.get("i").getAsInt() < startIndex) continue;
            ws2.addProperty("i", (Number)(ws2.get("i").getAsInt() + treeDiff));
        }
    }

    public static void swapWSIndexes(JsonObject firstNode, JsonObject secondNode) {
        List<JsonObject> firstNodeWS = FormattingSourceGen.extractWS(firstNode);
        List<JsonObject> secondNodeWS = FormattingSourceGen.extractWS(secondNode);
        int firstNodeIndex = firstNodeWS.get(0).get("i").getAsInt();
        int secondNodeIndex = secondNodeWS.get(0).get("i").getAsInt();
        int diff = firstNodeIndex - secondNodeIndex;
        firstNodeWS.forEach(ws -> ws.addProperty("i", (Number)(ws.get("i").getAsInt() - diff)));
        String whitespace = firstNodeWS.get(0).get("ws").getAsString();
        int lastIndexOfFirstNode = firstNodeWS.get(firstNodeWS.size() - 1).get("i").getAsInt() + 1 + (whitespace.length() > 0 ? 1 : 0);
        int diffToAddToSecondNode = lastIndexOfFirstNode - secondNodeIndex;
        secondNodeWS.forEach(ws -> ws.addProperty("i", (Number)(ws.get("i").getAsInt() + diffToAddToSecondNode)));
    }

    public static void addNewWS(JsonObject targetNode, JsonObject tree, String ws, String text, boolean isStatic, int startIndex) {
        JsonObject newWS = new JsonObject();
        List<JsonObject> astWS = FormattingSourceGen.getSortedWSList(tree);
        List<JsonObject> nodeWS = FormattingSourceGen.extractWS(targetNode);
        if (startIndex == -1) {
            startIndex = nodeWS.get(nodeWS.size() - 1).getAsJsonObject().get("i").getAsInt();
        }
        newWS.addProperty("i", (Number)startIndex);
        newWS.addProperty("static", Boolean.valueOf(isStatic));
        newWS.addProperty("ws", ws);
        newWS.addProperty("text", text);
        targetNode.getAsJsonArray("ws").add((JsonElement)newWS);
        for (JsonObject wsItem : astWS) {
            if (wsItem.get("i").getAsInt() < startIndex) continue;
            wsItem.addProperty("i", (Number)(wsItem.get("i").getAsInt() + 1));
        }
    }

    public static int getStartPosition(JsonObject node, String attachPoint, int insertBefore) {
        String kind;
        int startPosition = 0;
        switch (kind = node.get("kind").getAsString()) {
            case "CompilationUnit": {
                if (!node.has("topLevelNodes") || !attachPoint.equals("imports")) break;
                JsonArray topLevelNodes = node.getAsJsonArray("topLevelNodes");
                ArrayList<JsonObject> importsWS = new ArrayList<JsonObject>();
                for (int i = 0; i < topLevelNodes.size(); ++i) {
                    if (!topLevelNodes.get(i).getAsJsonObject().get("kind").getAsString().equals("Import")) continue;
                    importsWS.add(topLevelNodes.get(i).getAsJsonObject());
                }
                int prevPosition = 0;
                for (JsonObject ws : importsWS) {
                    List<JsonObject> extractedWS = FormattingSourceGen.extractWS(ws);
                    int lastIndex = extractedWS.get(extractedWS.size() - 1).get("i").getAsInt();
                    if (prevPosition >= lastIndex) continue;
                    prevPosition = lastIndex;
                }
                startPosition = prevPosition + 1;
                break;
            }
            case "Service": 
            case "Function": {
                int prevPosition;
                JsonObject typeDefinition;
                JsonArray annotationAttachments;
                JsonArray nodeWS = node.getAsJsonArray("ws");
                if ((!node.has("resource") || !node.get("resource").getAsBoolean()) && !kind.equals("Service")) break;
                JsonArray jsonArray = annotationAttachments = node.has("annotationAttachments") ? node.getAsJsonArray("annotationAttachments") : node.getAsJsonArray("annAttachments");
                if ((node.has("annAttachments") || node.has("annotationAttachments")) && attachPoint.equals("annAttachments")) {
                    startPosition = FormattingSourceGen.getCollectionStartPosition(annotationAttachments, nodeWS.get(0).getAsJsonObject().get("i").getAsInt() - 1, insertBefore);
                }
                JsonObject jsonObject = typeDefinition = kind.equals("Service") && node.has("typeDefinition") && node.getAsJsonObject("typeDefinition").get("service").getAsBoolean() ? node.getAsJsonObject("typeDefinition") : null;
                if (typeDefinition != null && typeDefinition.has("typeNode") && typeDefinition.getAsJsonObject("typeNode").has("ws")) {
                    JsonArray typeDefinitionWS = typeDefinition.getAsJsonObject("typeNode").getAsJsonArray("ws");
                    prevPosition = FormattingSourceGen.findOpeningBrace(typeDefinitionWS);
                } else {
                    prevPosition = FormattingSourceGen.findOpeningBrace(nodeWS);
                }
                if (node.has("endpointNodes")) {
                    if (attachPoint.equals("endpointNodes")) {
                        startPosition = FormattingSourceGen.getCollectionStartPosition(node.getAsJsonArray("endpointNodes"), prevPosition, insertBefore);
                    } else if (node.getAsJsonArray("endpointNodes").size() > 0) {
                        List<JsonObject> endpointWS = FormattingSourceGen.extractWS(node.getAsJsonArray("endpointNodes").get(node.getAsJsonArray("endpointNodes").size() - 1).getAsJsonObject());
                        prevPosition = endpointWS.get(endpointWS.size() - 1).get("i").getAsInt();
                    }
                }
                if (kind.equals("Service")) {
                    if (node.has("vars")) {
                        JsonArray vars = node.getAsJsonArray("vars");
                        if (attachPoint.equals("vars")) {
                            startPosition = FormattingSourceGen.getCollectionStartPosition(vars, prevPosition, insertBefore);
                        } else if (vars.size() > 0) {
                            List<JsonObject> varWS = FormattingSourceGen.extractWS(vars.get(vars.size() - 1).getAsJsonObject());
                            prevPosition = varWS.get(varWS.size() - 1).get("i").getAsInt();
                        }
                    }
                    if (node.has("resources")) {
                        JsonArray resources = node.getAsJsonArray("resources");
                        if (attachPoint.equals("resources")) {
                            startPosition = FormattingSourceGen.getCollectionStartPosition(resources, prevPosition, insertBefore);
                        } else if (resources.size() > 0) {
                            List<JsonObject> resourceWS = FormattingSourceGen.extractWS(resources.get(resources.size() - 1).getAsJsonObject());
                            prevPosition = resourceWS.get(resourceWS.size() - 1).get("i").getAsInt();
                        }
                    }
                }
                if (!kind.equals("Function") || !node.has("resource") || !node.get("resource").getAsBoolean()) break;
                if (node.has("workers")) {
                    if (attachPoint.equals("workers")) {
                        startPosition = FormattingSourceGen.getCollectionStartPosition(node.getAsJsonArray("workers"), prevPosition, insertBefore);
                    } else if (node.getAsJsonArray("workers").size() > 0) {
                        List<JsonObject> workerWS = FormattingSourceGen.extractWS(node.getAsJsonArray("workers").get(node.getAsJsonArray("workers").size() - 1).getAsJsonObject());
                        prevPosition = workerWS.get(workerWS.size() - 1).get("i").getAsInt();
                    }
                }
                if (!node.has("body") || !attachPoint.equals("statements")) break;
                startPosition = FormattingSourceGen.getCollectionStartPosition(node.getAsJsonObject("body").getAsJsonArray(attachPoint), prevPosition, insertBefore);
                break;
            }
            default: {
                if (!node.has("ws")) break;
                startPosition = FormattingSourceGen.findOpeningBrace(node.getAsJsonArray("ws")) + 1;
            }
        }
        return startPosition;
    }

    private static List<JsonObject> getSortedWSList(JsonObject node) {
        ArrayList<JsonObject> wsCollection = new ArrayList<JsonObject>();
        FormattingSourceGen.collectWSFromNode(node, wsCollection);
        wsCollection.sort(Comparator.comparingInt(a -> a.get("i").getAsInt()));
        return wsCollection;
    }

    private static List<JsonObject> unify(List<JsonObject> toBeUnified) {
        ArrayList<JsonObject> unified = new ArrayList<JsonObject>();
        JsonObject prevWS = null;
        for (JsonObject wsItem : toBeUnified) {
            if (prevWS == null) {
                prevWS = wsItem;
                unified.add(prevWS);
                continue;
            }
            if (prevWS.get("i").getAsInt() == wsItem.get("i").getAsInt() || prevWS.equals((Object)wsItem)) continue;
            unified.add(wsItem);
            prevWS = wsItem;
        }
        return unified;
    }

    private static int getCollectionStartPosition(JsonArray collection, int entryPoint, int insertBefore) {
        int startPosition = collection.size() > 0 ? FormattingSourceGen.getPositionToInsertBefore(collection, insertBefore) : entryPoint + 1;
        return startPosition;
    }

    private static int getPositionToInsertBefore(JsonArray collection, int insertBefore) {
        int startPosition = -1;
        if (collection.size() > 0) {
            if (insertBefore == -1) {
                List<JsonObject> statementWS = FormattingSourceGen.extractWS(collection.get(collection.size() - 1).getAsJsonObject());
                startPosition = statementWS.get(statementWS.size() - 1).get("i").getAsInt() + 1;
            } else {
                List<JsonObject> statementWS = FormattingSourceGen.extractWS(collection.get(insertBefore).getAsJsonObject());
                startPosition = statementWS.get(statementWS.size() - 1).get("i").getAsInt();
            }
        }
        return startPosition;
    }

    private static int findOpeningBrace(JsonArray ws) {
        int index = -1;
        for (int i = 0; i < ws.size(); ++i) {
            if (!ws.get(i).getAsJsonObject().get("text").getAsString().equals("{")) continue;
            index = ws.get(i).getAsJsonObject().get("i").getAsInt();
            break;
        }
        return index;
    }

    private static void collectWSFromNode(JsonObject node, List<JsonObject> wsCollection) {
        if (!node.has("skip")) {
            for (Map.Entry child : node.entrySet()) {
                String childName = (String)child.getKey();
                if ("position".equals(childName) || "parent".equals(childName)) continue;
                if (((JsonElement)child.getValue()).isJsonObject() && ((JsonElement)child.getValue()).getAsJsonObject().has("kind")) {
                    FormattingSourceGen.collectWSFromNode(((JsonElement)child.getValue()).getAsJsonObject(), wsCollection);
                    continue;
                }
                if (!((JsonElement)child.getValue()).isJsonArray()) continue;
                if ("ws".equals(childName)) {
                    for (JsonElement wsElement : ((JsonElement)child.getValue()).getAsJsonArray()) {
                        wsCollection.add(wsElement.getAsJsonObject());
                    }
                    continue;
                }
                for (JsonElement wsElement : ((JsonElement)child.getValue()).getAsJsonArray()) {
                    if (!wsElement.isJsonObject() || !wsElement.getAsJsonObject().has("kind")) continue;
                    FormattingSourceGen.collectWSFromNode(wsElement.getAsJsonObject(), wsCollection);
                }
            }
        }
    }

    private static void modifyNode(JsonObject node, String parentKind) {
        String text;
        JsonArray compilationUnitWS;
        String kind = node.get("kind").getAsString();
        if ("CompilationUnit".equals(kind) && node.has("ws") && (compilationUnitWS = node.getAsJsonArray("ws")).size() > 0) {
            compilationUnitWS.get(compilationUnitWS.size() - 1).getAsJsonObject().addProperty("text", "");
        }
        if ("If".equals(kind)) {
            if (node.getAsJsonObject("elseStatement") != null) {
                node.addProperty("ladderParent", Boolean.valueOf(true));
            }
            if (node.has("ws") && node.getAsJsonArray("ws").size() > 1 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("else") && node.getAsJsonArray("ws").get(1).getAsJsonObject().get("text").getAsString().equals("if")) {
                node.addProperty("isElseIfBlock", Boolean.valueOf(true));
            }
        }
        if ("Transaction".equals(kind) && node.has("condition") && node.getAsJsonObject("condition").has("value")) {
            JsonObject retry = null;
            if (node.has("failedBody") && node.getAsJsonObject("failedBody").has("statements")) {
                for (JsonElement statement : node.getAsJsonObject("failedBody").get("statements").getAsJsonArray()) {
                    if (!statement.isJsonObject() || !statement.getAsJsonObject().has("kind") || !statement.getAsJsonObject().get("kind").getAsString().equals("retry")) continue;
                    retry = statement.getAsJsonObject();
                }
            }
            if (node.has("committedBody") && node.getAsJsonObject("committedBody").has("statements")) {
                for (JsonElement statement : node.getAsJsonObject("committedBody").get("statements").getAsJsonArray()) {
                    if (!statement.isJsonObject() || !statement.getAsJsonObject().has("kind") || !statement.getAsJsonObject().get("kind").getAsString().equals("retry")) continue;
                    retry = statement.getAsJsonObject();
                }
            }
            if (node.has("transactionBody") && node.getAsJsonObject("transactionBody").has("statements")) {
                for (JsonElement statement : node.getAsJsonObject("transactionBody").get("statements").getAsJsonArray()) {
                    if (!statement.isJsonObject() || !statement.getAsJsonObject().has("kind") || !statement.getAsJsonObject().get("kind").getAsString().equals("retry")) continue;
                    retry = statement.getAsJsonObject();
                }
            }
            if (retry != null) {
                retry.addProperty("count", node.getAsJsonObject("condition").get("value").getAsString());
            }
        }
        if (("XmlCommentLiteral".equals(kind) || "XmlElementLiteral".equals(kind) || "XmlTextLiteral".equals(kind) || "XmlPiLiteral".equals(kind)) && node.has("ws") && node.getAsJsonArray("ws").get(0) != null && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().contains("xml") && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().contains("`")) {
            node.addProperty("root", Boolean.valueOf(true));
            node.addProperty("startLiteral", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
        }
        if ("XmlElementLiteral".equals(parentKind) || "XmlTextLiteral".equals(parentKind) || "XmlPiLiteral".equals(parentKind)) {
            node.addProperty("inTemplateLiteral", Boolean.valueOf(true));
        }
        if ("Annotation".equals(kind) && node.has("attachmentPoints") && node.getAsJsonArray("attachmentPoints").size() <= 0) {
            node.addProperty("noAttachmentPoints", Boolean.valueOf(true));
        }
        if ("Identifier".equals(kind)) {
            if (node.has("literal") && node.get("literal").getAsBoolean()) {
                String[] words = node.get("value").getAsString().split(" ");
                StringBuilder valueWithBar = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    if (i == 0) {
                        valueWithBar.append("'").append(words[i]);
                        continue;
                    }
                    if (words[i].equals("")) {
                        valueWithBar.append("\\").append(" ");
                        continue;
                    }
                    valueWithBar.append("\\ ").append(words[i]);
                }
                node.addProperty("valueWithBar", valueWithBar.toString());
            } else {
                node.addProperty("valueWithBar", node.get("value").getAsString());
            }
        }
        if ("Import".equals(kind)) {
            if (node.getAsJsonObject("alias") != null && node.getAsJsonObject("alias").get("value") != null && node.getAsJsonArray("packageName") != null && node.getAsJsonArray("packageName").size() != 0 && !node.getAsJsonObject("alias").get("value").getAsString().equals(node.getAsJsonArray("packageName").get(node.getAsJsonArray("packageName").size() - 1).getAsJsonObject().get("value").getAsString())) {
                node.addProperty("userDefinedAlias", Boolean.valueOf(true));
            }
            if (node.getAsJsonArray("packageName") != null && node.getAsJsonArray("packageName").size() == 2 && node.getAsJsonArray("packageName").get(0).getAsJsonObject().get("value").getAsString().equals("transactions") && node.getAsJsonArray("packageName").get(1).getAsJsonObject().get("value").getAsString().equals("coordinator") || node.getAsJsonObject("alias") != null && node.getAsJsonObject("alias").get("value") != null && node.getAsJsonObject("alias").get("value").getAsString().startsWith(".")) {
                node.addProperty("isInternal", Boolean.valueOf(true));
            }
        }
        if ("CompilationUnit".equals(parentKind) && ("Variable".equals(kind) || "Xmlns".equals(kind))) {
            node.addProperty("global", Boolean.valueOf(true));
        }
        if ("VariableDef".equals(kind)) {
            if (node.has("variable") && node.has("ws") && node.getAsJsonObject("variable").has("ws") && !node.getAsJsonObject("variable").get("kind").getAsString().equals("TupleVariable") && (!node.getAsJsonObject("variable").has("symbolType") || node.getAsJsonObject("variable").getAsJsonArray("symbolType").size() <= 0 || !node.getAsJsonObject("variable").getAsJsonArray("symbolType").get(0).getAsString().equals("service"))) {
                node.getAsJsonObject("variable").getAsJsonArray("ws").addAll(node.getAsJsonArray("ws"));
                node.remove("ws");
            }
            if (node.getAsJsonObject("variable") != null && node.getAsJsonObject("variable").getAsJsonObject("typeNode") != null && node.getAsJsonObject("variable").getAsJsonObject("typeNode").get("kind").getAsString().equals("EndpointType")) {
                node.getAsJsonObject("variable").addProperty("endpoint", Boolean.valueOf(true));
                node.addProperty("endpoint", Boolean.valueOf(true));
            }
            if (node.has("isInFork") && node.get("isInFork").getAsBoolean() && !parentKind.equals("ForkJoin")) {
                node.addProperty("skip", Boolean.valueOf(true));
            }
            if (node.has("isWorker") && node.get("isWorker").getAsBoolean() && node.has("variable") && node.getAsJsonObject("variable").has("initialExpression") && node.getAsJsonObject("variable").getAsJsonObject("initialExpression").has("kind") && node.getAsJsonObject("variable").getAsJsonObject("initialExpression").get("kind").getAsString().equals("Invocation")) {
                node.addProperty("skip", Boolean.valueOf(true));
            }
        }
        if ("Variable".equals(kind)) {
            JsonArray ws;
            if ("ObjectType".equals(parentKind)) {
                node.addProperty("inObject", Boolean.valueOf(true));
            }
            if (node.has("typeNode") && node.getAsJsonObject("typeNode").has("isAnonType") && node.getAsJsonObject("typeNode").get("isAnonType").getAsBoolean()) {
                node.addProperty("isAnonType", Boolean.valueOf(true));
            }
            if (node.has("initialExpression")) {
                node.getAsJsonObject("initialExpression").addProperty("isExpression", Boolean.valueOf(true));
                if (node.getAsJsonObject("initialExpression").has("async") && node.getAsJsonObject("initialExpression").get("async").getAsBoolean() && node.has("ws")) {
                    ws = node.getAsJsonArray("ws");
                    for (int i = 0; i < ws.size(); ++i) {
                        if (!ws.get(i).getAsJsonObject().get("text").getAsString().equals("start") || !node.getAsJsonObject("initialExpression").has("ws")) continue;
                        node.getAsJsonObject("initialExpression").add("ws", (JsonElement)FormattingSourceGen.addDataToArray(0, node.getAsJsonArray("ws").get(i), node.getAsJsonObject("initialExpression").getAsJsonArray("ws")));
                        node.getAsJsonArray("ws").remove(i);
                    }
                }
            }
            if (node.has("typeNode") && node.getAsJsonObject("typeNode").has("nullable") && node.getAsJsonObject("typeNode").get("nullable").getAsBoolean() && node.getAsJsonObject("typeNode").has("ws")) {
                ws = node.getAsJsonObject("typeNode").get("ws").getAsJsonArray();
                for (int i = 0; i < ws.size(); ++i) {
                    if (!ws.get(i).getAsJsonObject().get("text").getAsString().equals("?")) continue;
                    node.getAsJsonObject("typeNode").addProperty("nullableOperatorAvailable", Boolean.valueOf(true));
                    break;
                }
            }
            if (node.has("typeNode") && node.getAsJsonObject("typeNode").has("ws") && !node.has("ws")) {
                node.addProperty("noVisibleName", Boolean.valueOf(true));
            }
            if (node.has("ws")) {
                ws = node.getAsJsonArray("ws");
                for (int i = 0; i < ws.size(); ++i) {
                    if (ws.get(i).getAsJsonObject().get("text").getAsString().equals(";")) {
                        node.addProperty("endWithSemicolon", Boolean.valueOf(true));
                    }
                    if (!ws.get(i).getAsJsonObject().get("text").getAsString().equals(",")) continue;
                    node.addProperty("endWithComma", Boolean.valueOf(true));
                }
            }
            if (node.has("service") && node.get("service").getAsBoolean() && node.has("noVisibleName") && node.get("noVisibleName").getAsBoolean()) {
                node.addProperty("skip", Boolean.valueOf(true));
            }
            if (node.has("name") && node.getAsJsonObject("name").get("value").getAsString().startsWith("0")) {
                node.addProperty("worker", Boolean.valueOf(true));
            }
        }
        if ("Service".equals(kind)) {
            JsonObject typeDefinition;
            JsonObject typeNode;
            if (!node.has("serviceTypeStruct")) {
                node.addProperty("isServiceTypeUnavailable", Boolean.valueOf(true));
            }
            if (node.has("resources") && node.has("typeDefinition") && (typeNode = (typeDefinition = node.getAsJsonObject("typeDefinition")).getAsJsonObject("typeNode")).has("symbolType") && typeNode.getAsJsonArray("symbolType").get(0).getAsString().equals("service")) {
                JsonArray functions = typeNode.getAsJsonArray("functions");
                for (JsonElement func : functions) {
                    JsonObject function = func.getAsJsonObject();
                    if (!function.has("resource") || !function.get("resource").getAsBoolean()) continue;
                    function.addProperty("skip", Boolean.valueOf(true));
                }
            }
            if (!node.has("anonymousEndpointBind") && node.has("boundEndpoints") && node.getAsJsonArray("boundEndpoints").size() <= 0) {
                boolean bindAvailable = false;
                for (JsonElement ws : node.getAsJsonArray("ws")) {
                    if (!ws.getAsJsonObject().get("text").getAsString().equals("bind")) continue;
                    bindAvailable = true;
                    break;
                }
                if (!bindAvailable) {
                    node.addProperty("bindNotAvailable", Boolean.valueOf(true));
                }
            }
            if (node.has("userDefinedTypeNode") && node.getAsJsonObject("userDefinedTypeNode").has("ws")) {
                node.getAsJsonObject("userDefinedTypeNode").remove("ws");
            }
            if (node.has("anonymousService") && node.get("anonymousService").getAsBoolean() && parentKind.equals("CompilationUnit")) {
                node.addProperty("skip", Boolean.valueOf(true));
            }
        }
        if ("Resource".equals(kind) && node.has("parameters") && node.getAsJsonArray("parameters").size() > 0 && node.getAsJsonArray("parameters").get(0).getAsJsonObject().has("ws")) {
            for (JsonElement ws : node.getAsJsonArray("parameters").get(0).getAsJsonObject().getAsJsonArray("ws")) {
                if (!ws.getAsJsonObject().get("text").getAsString().equals("endpoint")) continue;
                JsonObject endpointParam = node.getAsJsonArray("parameters").get(0).getAsJsonObject();
                String valueWithBar = endpointParam.get("name").getAsJsonObject().has("valueWithBar") ? endpointParam.get("name").getAsJsonObject().get("valueWithBar").getAsString() : endpointParam.get("name").getAsJsonObject().get("value").getAsString();
                endpointParam.addProperty("serviceEndpoint", Boolean.valueOf(true));
                endpointParam.get("name").getAsJsonObject().addProperty("value", endpointParam.get("name").getAsJsonObject().get("value").getAsString().replace("$", ""));
                endpointParam.get("name").getAsJsonObject().addProperty("valueWithBar", valueWithBar.replace("$", ""));
                break;
            }
        }
        if ("ForkJoin".equals(kind)) {
            if (node.getAsJsonObject("joinBody") != null) {
                node.getAsJsonObject("joinBody").add("position", (JsonElement)node.getAsJsonObject("joinResultVar").getAsJsonObject("position"));
            }
            if (node.getAsJsonObject("timeoutBody") != null) {
                node.getAsJsonObject("timeoutBody").add("position", (JsonElement)node.getAsJsonObject("timeOutExpression").getAsJsonObject("position"));
            }
        }
        if ("Match".equals(kind)) {
            if (node.has("structuredPatternClauses")) {
                JsonArray structuredPatternClauses = node.getAsJsonArray("structuredPatternClauses");
                for (JsonElement pattern : structuredPatternClauses) {
                    pattern.getAsJsonObject().addProperty("skip", Boolean.valueOf(true));
                }
            }
            if (node.has("staticPatternClauses")) {
                JsonArray staticPatternClauses = node.getAsJsonArray("staticPatternClauses");
                for (JsonElement pattern : staticPatternClauses) {
                    pattern.getAsJsonObject().addProperty("skip", Boolean.valueOf(true));
                }
            }
        }
        if (("MatchStructuredPatternClause".equals(kind) || "MatchStaticPatternClause".equals(kind) || "MatchTypedPatternClause".equals(kind)) && node.has("ws")) {
            for (JsonElement wsItem : node.getAsJsonArray("ws")) {
                JsonObject currentWS = wsItem.getAsJsonObject();
                text = currentWS.get("text").getAsString();
                if (!text.equals("{")) continue;
                node.addProperty("withCurlies", Boolean.valueOf(true));
                break;
            }
        }
        if ("ValueType".equals(kind)) {
            if (node.has("ws") && node.getAsJsonArray("ws").size() > 2) {
                node.addProperty("withParantheses", Boolean.valueOf(true));
            }
            if (node.has("typeKind") && node.get("typeKind").getAsString().equals("nil") && node.has("ws")) {
                node.addProperty("emptyParantheses", Boolean.valueOf(true));
            }
            if (node.has("nullable") && node.get("nullable").getAsBoolean() && node.has("ws")) {
                for (int i = 0; i < node.get("ws").getAsJsonArray().size(); ++i) {
                    if (!node.get("ws").getAsJsonArray().get(i).getAsJsonObject().get("text").getAsString().equals("?")) continue;
                    node.addProperty("nullableOperatorAvailable", Boolean.valueOf(true));
                    break;
                }
            }
        }
        if ("UnionTypeNode".equals(kind) && node.has("ws")) {
            if (node.getAsJsonArray("ws").size() > 2) {
                for (JsonElement ws : node.getAsJsonArray("ws")) {
                    if (!ws.getAsJsonObject().get("text").getAsString().equals("(")) continue;
                    node.addProperty("withParantheses", Boolean.valueOf(true));
                    break;
                }
            }
            JsonArray memberTypeNodes = node.get("memberTypeNodes").getAsJsonArray();
            block15: for (int i = 0; i < memberTypeNodes.size(); ++i) {
                if (!memberTypeNodes.get(i).getAsJsonObject().has("nullable") || !memberTypeNodes.get(i).getAsJsonObject().get("nullable").getAsBoolean()) continue;
                for (JsonElement ws : node.getAsJsonArray("ws")) {
                    if (!ws.getAsJsonObject().get("text").getAsString().equals("?")) continue;
                    memberTypeNodes.get(i).getAsJsonObject().addProperty("nullableOperatorAvailable", Boolean.valueOf(true));
                    continue block15;
                }
            }
        }
        if ("Function".equals(kind)) {
            if (node.has("returnTypeNode")) {
                node.addProperty("hasReturns", Boolean.valueOf(true));
            }
            if (node.has("defaultableParameters")) {
                JsonArray defaultableParameters = node.getAsJsonArray("defaultableParameters");
                for (int i = 0; i < defaultableParameters.size(); ++i) {
                    defaultableParameters.get(i).getAsJsonObject().addProperty("defaultable", Boolean.valueOf(true));
                    defaultableParameters.get(i).getAsJsonObject().addProperty("param", Boolean.valueOf(true));
                    defaultableParameters.get(i).getAsJsonObject().getAsJsonObject("variable").addProperty("defaultable", Boolean.valueOf(true));
                }
            }
            if (node.has("parameters")) {
                JsonArray parameters = node.getAsJsonArray("parameters");
                for (int i = 0; i < parameters.size(); ++i) {
                    parameters.get(i).getAsJsonObject().addProperty("param", Boolean.valueOf(true));
                }
            }
            if (node.has("parameters") && node.has("defaultableParameters")) {
                JsonArray allParamsTemp = node.getAsJsonArray("parameters");
                allParamsTemp.addAll(node.getAsJsonArray("defaultableParameters"));
                ArrayList allParamElements = new ArrayList();
                allParamsTemp.forEach(allParamElements::add);
                allParamElements.sort((a, b) -> {
                    int comparator = 0;
                    comparator = a.getAsJsonObject().getAsJsonObject("position").get("endColumn").getAsInt() > b.getAsJsonObject().getAsJsonObject("position").get("startColumn").getAsInt() && a.getAsJsonObject().getAsJsonObject("position").get("endLine").getAsInt() == b.getAsJsonObject().getAsJsonObject("position").get("endLine").getAsInt() || a.getAsJsonObject().getAsJsonObject("position").get("endLine").getAsInt() > b.getAsJsonObject().getAsJsonObject("position").get("endLine").getAsInt() ? 1 : -1;
                    return comparator;
                });
                JsonArray allParams = new JsonArray();
                allParamElements.forEach(arg_0 -> ((JsonArray)allParams).add(arg_0));
                node.add("allParams", (JsonElement)allParams);
            }
            if (node.has("receiver") && !node.getAsJsonObject("receiver").has("ws")) {
                if (node.getAsJsonObject("receiver").has("typeNode") && node.getAsJsonObject("receiver").getAsJsonObject("typeNode").has("ws") && node.getAsJsonObject("receiver").getAsJsonObject("typeNode").getAsJsonArray("ws").size() > 0) {
                    for (JsonElement ws : node.get("ws").getAsJsonArray()) {
                        if (!ws.getAsJsonObject().get("text").getAsString().equals("::")) continue;
                        node.addProperty("objectOuterFunction", Boolean.valueOf(true));
                        if (node.getAsJsonObject("receiver").getAsJsonObject("typeNode").getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("function")) {
                            node.getAsJsonObject("receiver").getAsJsonObject("typeNode").getAsJsonArray("ws").remove(0);
                        }
                        node.add("objectOuterFunctionTypeName", (JsonElement)node.getAsJsonObject("receiver").getAsJsonObject("typeNode").getAsJsonObject("typeName"));
                        break;
                    }
                } else {
                    node.addProperty("noVisibleReceiver", Boolean.valueOf(true));
                }
            }
            if (node.has("restParameters") && node.has("allParams") && node.getAsJsonArray("allParams").size() > 0) {
                node.addProperty("hasRestParams", Boolean.valueOf(true));
            }
            if (node.has("restParameters")) {
                node.getAsJsonObject("restParameters").addProperty("param", Boolean.valueOf(true));
                if (node.getAsJsonObject("restParameters").has("typeNode")) {
                    node.getAsJsonObject("restParameters").getAsJsonObject("typeNode").addProperty("isRestParam", Boolean.valueOf(true));
                }
            }
        }
        if ("TypeDefinition".equals(kind) && node.has("typeNode")) {
            if (!node.has("ws")) {
                node.addProperty("notVisible", Boolean.valueOf(true));
            }
            if (node.has("name") && node.getAsJsonObject("name").get("value").getAsString().startsWith("$anonType$")) {
                anonTypes.put(node.getAsJsonObject("name").get("value").getAsString(), node.getAsJsonObject("typeNode"));
            }
            if (node.getAsJsonObject("typeNode").get("kind").getAsString().equals("ObjectType")) {
                node.addProperty("isObjectType", Boolean.valueOf(true));
                if (node.has("ws")) {
                    JsonArray typeDefWS = node.getAsJsonArray("ws");
                    for (int i = 0; i < typeDefWS.size(); ++i) {
                        if (!typeDefWS.get(i).getAsJsonObject().get("text").getAsString().equals("abstract")) continue;
                        node.addProperty("isAbstractKeywordAvailable", Boolean.valueOf(true));
                    }
                }
            }
            if (node.getAsJsonObject("typeNode").get("kind").getAsString().equals("RecordType")) {
                node.addProperty("isRecordType", Boolean.valueOf(true));
                if (node.has("ws")) {
                    for (int i = 0; i < node.getAsJsonArray("ws").size(); ++i) {
                        if (!node.getAsJsonArray("ws").get(i).getAsJsonObject().get("text").getAsString().equals("record")) continue;
                        node.addProperty("isRecordKeywordAvailable", Boolean.valueOf(true));
                    }
                }
            }
            if (node.has("service") && node.get("service").getAsBoolean() && parentKind.equals("CompilationUnit")) {
                node.addProperty("skip", Boolean.valueOf(true));
            }
        }
        if ("ObjectType".equals(kind) && node.has("initFunction")) {
            if (!node.getAsJsonObject("initFunction").has("ws")) {
                node.getAsJsonObject("initFunction").addProperty("defaultConstructor", Boolean.valueOf(true));
            } else {
                node.getAsJsonObject("initFunction").addProperty("isConstructor", Boolean.valueOf(true));
            }
        }
        if ("RecordType".equals(kind) && node.has("restFieldType")) {
            node.addProperty("isRestFieldAvailable", Boolean.valueOf(true));
        }
        if ("TypeInitExpr".equals(kind)) {
            if (node.getAsJsonArray("expressions").size() <= 0) {
                node.addProperty("noExpressionAvailable", Boolean.valueOf(true));
            }
            if (node.has("ws")) {
                for (int i = 0; i < node.getAsJsonArray("ws").size(); ++i) {
                    if (!node.getAsJsonArray("ws").get(i).getAsJsonObject().get("text").getAsString().equals("(")) continue;
                    node.addProperty("hasParantheses", Boolean.valueOf(true));
                    break;
                }
            }
            if (!node.has("type")) {
                node.addProperty("noTypeAttached", Boolean.valueOf(true));
            } else {
                node.add("typeName", node.getAsJsonObject("type").get("typeName"));
            }
        }
        if ("Return".equals(kind) && node.has("expression")) {
            if (node.getAsJsonObject("expression").get("kind").getAsString().equals("Literal")) {
                if (node.getAsJsonObject("expression").get("value").getAsString().equals("()")) {
                    node.addProperty("noExpressionAvailable", Boolean.valueOf(true));
                }
                if (node.getAsJsonObject("expression").get("value").getAsString().equals("null")) {
                    node.getAsJsonObject("expression").addProperty("emptyParantheses", Boolean.valueOf(true));
                }
            }
            node.getAsJsonObject("expression").addProperty("isExpression", "true");
        }
        if ("Documentation".equals(kind)) {
            if (node.has("ws") && node.getAsJsonArray("ws").size() > 1) {
                node.addProperty("startDoc", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
            }
            for (int j = 0; j < node.getAsJsonArray("attributes").size(); ++j) {
                JsonObject attribute = node.getAsJsonArray("attributes").get(j).getAsJsonObject();
                if (!attribute.has("ws")) continue;
                for (int i = 0; i < attribute.getAsJsonArray("ws").size(); ++i) {
                    text = attribute.getAsJsonArray("ws").get(i).getAsJsonObject().get("text").getAsString();
                    if (!text.contains("{{") || attribute.has("paramType")) continue;
                    int lastIndex = text.lastIndexOf("{{");
                    String paramType = text.substring(0, lastIndex);
                    String startCurl = text.substring(lastIndex, text.length());
                    attribute.getAsJsonArray("ws").get(i).getAsJsonObject().addProperty("text", paramType);
                    attribute.addProperty("paramType", paramType);
                    JsonObject ws = new JsonObject();
                    ws.addProperty("text", startCurl);
                    ws.addProperty("ws", "");
                    ws.addProperty("static", Boolean.valueOf(false));
                    attribute.add("ws", (JsonElement)FormattingSourceGen.addDataToArray(++i, (JsonElement)ws, attribute.getAsJsonArray("ws")));
                }
            }
        }
        if (("Function".equals(kind) || "Resource".equals(kind)) && node.has("restParameters")) {
            node.getAsJsonObject("restParameters").addProperty("rest", Boolean.valueOf(true));
        }
        if ("PostIncrement".equals(kind)) {
            node.addProperty("operator", node.get("operatorKind").getAsString() + node.get("operatorKind").getAsString());
        }
        if ("SelectExpression".equals(kind) && node.has("identifier")) {
            node.addProperty("identifierAvailable", Boolean.valueOf(true));
        }
        if ("StreamAction".equals(kind) && node.has("invokableBody") && node.getAsJsonObject("invokableBody").has("functionNode")) {
            node.getAsJsonObject("invokableBody").getAsJsonObject("functionNode").addProperty("isStreamAction", Boolean.valueOf(true));
        }
        if ("StreamingInput".equals(kind) && node.has("alias")) {
            node.addProperty("aliasAvailable", Boolean.valueOf(true));
        }
        if ("IntRangeExpr".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0) {
            if (node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("[")) {
                node.addProperty("isWrappedWithBracket", Boolean.valueOf(true));
            } else if (node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("(")) {
                node.addProperty("isWrappedWithParenthesis", Boolean.valueOf(true));
            }
        }
        if ("FunctionType".equals(kind)) {
            if (node.has("returnTypeNode") && node.getAsJsonObject("returnTypeNode").has("ws")) {
                node.addProperty("hasReturn", Boolean.valueOf(true));
            }
            if (node.has("ws") && node.getAsJsonArray("ws").size() > 0 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("(")) {
                node.addProperty("withParantheses", Boolean.valueOf(true));
            }
        }
        if ("Literal".equals(kind) && !"StringTemplateLiteral".equals(parentKind)) {
            if (node.has("ws") && node.getAsJsonArray("ws").size() == 1 && node.getAsJsonArray("ws").get(0).getAsJsonObject().has("text")) {
                node.addProperty("value", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
            }
            if ((node.get("value").getAsString().equals("nil") || node.get("value").getAsString().equals("null")) && node.has("ws") && node.getAsJsonArray("ws").size() < 3 && node.getAsJsonArray("ws").get(0) != null && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("(")) {
                node.addProperty("emptyParantheses", Boolean.valueOf(true));
            }
        }
        if ("Foreach".equals(kind) && node.has("ws")) {
            for (JsonElement ws : node.getAsJsonArray("ws")) {
                if (!ws.getAsJsonObject().get("text").getAsString().equals("(")) continue;
                node.addProperty("withParantheses", Boolean.valueOf(true));
                break;
            }
        }
        if ("Endpoint".equals(kind) && node.has("ws")) {
            for (JsonElement ws : node.getAsJsonArray("ws")) {
                if (!ws.getAsJsonObject().get("text").getAsString().equals("=")) continue;
                node.addProperty("isConfigAssignment", Boolean.valueOf(true));
                break;
            }
        }
        if ("UserDefinedType".equals(kind)) {
            if (node.has("ws") && node.has("nullable") && node.get("nullable").getAsBoolean()) {
                for (JsonElement ws : node.getAsJsonArray("ws")) {
                    if (!ws.getAsJsonObject().get("text").getAsString().equals("?")) continue;
                    node.addProperty("nullableOperatorAvailable", Boolean.valueOf(true));
                    break;
                }
            }
            if (node.has("typeName") && node.getAsJsonObject("typeName").has("value") && anonTypes.containsKey(node.getAsJsonObject("typeName").get("value").getAsString())) {
                node.addProperty("isAnonType", Boolean.valueOf(true));
                JsonObject anonType = anonTypes.get(node.getAsJsonObject("typeName").get("value").getAsString());
                anonType.addProperty("isAnonType", Boolean.valueOf(true));
                node.add("anonType", (JsonElement)anonType);
            }
        }
        if ("ArrayType".equals(kind) && node.has("dimensions") && node.get("dimensions").getAsInt() > 0 && node.has("ws")) {
            StringBuilder dimensionAsString = new StringBuilder();
            JsonObject startingBracket = null;
            StringBuilder content = new StringBuilder();
            JsonArray ws = node.getAsJsonArray("ws");
            for (int j = 0; j < ws.size(); ++j) {
                if (ws.get(j).getAsJsonObject().get("text").getAsString().equals("[")) {
                    startingBracket = ws.get(j).getAsJsonObject();
                    continue;
                }
                if (ws.get(j).getAsJsonObject().get("text").getAsString().equals("]")) {
                    JsonObject endingBracket = ws.get(j).getAsJsonObject();
                    dimensionAsString.append(startingBracket.get("text").getAsString()).append(content.toString()).append(endingBracket.get("ws").getAsString()).append(endingBracket.get("text").getAsString());
                    startingBracket = null;
                    content = new StringBuilder();
                    continue;
                }
                if (startingBracket == null) continue;
                content.append(ws.get(j).getAsJsonObject().get("ws").getAsString()).append(ws.get(j).getAsJsonObject().get("text").getAsString());
            }
            node.addProperty("dimensionAsString", dimensionAsString.toString());
        }
        if ("Block".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("else")) {
            node.addProperty("isElseBlock", Boolean.valueOf(true));
        }
        if ("FieldBasedAccessExpr".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("!")) {
            node.addProperty("errorLifting", Boolean.valueOf(true));
        }
        if ("StringTemplateLiteral".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().contains("string") && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().contains("`")) {
            node.addProperty("startTemplate", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
            FormattingSourceGen.literalWSAssignForTemplates(1, 2, node.getAsJsonArray("expressions"), node.getAsJsonArray("ws"), 2);
        }
        if ("ArrowExpr".equals(kind)) {
            if (node.has("ws") && node.getAsJsonArray("ws").size() > 0 && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("(")) {
                node.addProperty("hasParantheses", Boolean.valueOf(true));
            }
            if (node.has("parameters")) {
                JsonArray parameters = node.getAsJsonArray("parameters");
                for (int i = 0; i < parameters.size(); ++i) {
                    JsonObject parameter = parameters.get(i).getAsJsonObject();
                    parameter.addProperty("arrowExprParam", Boolean.valueOf(true));
                }
            }
        }
        if ("PatternStreamingInput".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString().equals("(")) {
            node.addProperty("enclosedInParenthesis", Boolean.valueOf(true));
        }
        if ("SelectClause".equals(kind) && !node.has("ws")) {
            node.addProperty("notVisible", Boolean.valueOf(true));
        }
        if ("OrderByVariable".equals(kind)) {
            if (!node.has("ws")) {
                node.addProperty("noVisibleType", Boolean.valueOf(true));
            } else {
                node.addProperty("typeString", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
            }
        }
        if ("Deprecated".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0) {
            node.addProperty("deprecatedStart", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
        }
        if ("TypedescExpression".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0) {
            JsonArray typeDescWS = node.getAsJsonArray("ws");
            if (typeDescWS.get(0).getAsJsonObject().get("text").getAsString().equals("object")) {
                node.addProperty("isObject", Boolean.valueOf(true));
            } else if (typeDescWS.get(0).getAsJsonObject().get("text").getAsString().equals("record")) {
                node.addProperty("isRecord", Boolean.valueOf(true));
            }
        }
        if ("CompoundAssignment".equals(kind) && node.has("ws") && node.getAsJsonArray("ws").size() > 0) {
            node.addProperty("compoundOperator", node.getAsJsonArray("ws").get(0).getAsJsonObject().get("text").getAsString());
        }
        if ("Assignment".equals(kind) && node.has("expression")) {
            node.getAsJsonObject("expression").addProperty("isExpression", Boolean.valueOf(true));
        }
    }

    private static void literalWSAssignForTemplates(int currentWs, int nextWs, JsonArray literals, JsonArray ws, int wsStartLocation) {
        block5: {
            block4: {
                if (literals.size() != ws.size() - wsStartLocation) break block4;
                for (int i = 0; i < literals.size(); ++i) {
                    if (!literals.get(i).getAsJsonObject().get("kind").getAsString().equals("Literal")) continue;
                    if (!literals.get(i).getAsJsonObject().has("ws")) {
                        literals.get(i).getAsJsonObject().add("ws", (JsonElement)new JsonArray());
                    }
                    FormattingSourceGen.stringTemplateSourceFromWS(currentWs, nextWs, literals, ws, i);
                    if (i != literals.size() - 1) continue;
                    literals.get(i).getAsJsonObject().get("ws").getAsJsonArray().add(ws.get(currentWs));
                    literals.get(i).getAsJsonObject().addProperty("value", ws.get(currentWs).getAsJsonObject().get("text").getAsString());
                    literals.get(i).getAsJsonObject().addProperty("lastNodeValue", Boolean.valueOf(true));
                    ws.remove(currentWs);
                }
                break block5;
            }
            if (literals.size() - 1 != ws.size() - wsStartLocation) break block5;
            for (int i = 0; i < literals.size(); ++i) {
                if (!literals.get(i).getAsJsonObject().get("kind").getAsString().equals("Literal")) continue;
                if (!literals.get(i).getAsJsonObject().has("ws")) {
                    literals.get(i).getAsJsonObject().add("ws", (JsonElement)new JsonArray());
                }
                FormattingSourceGen.stringTemplateSourceFromWS(currentWs, nextWs, literals, ws, i);
            }
        }
    }

    private static void stringTemplateSourceFromWS(int currentWs, int nextWs, JsonArray literals, JsonArray ws, int i) {
        if (ws.get(currentWs).getAsJsonObject().get("text").getAsString().contains("${")) {
            literals.get(i).getAsJsonObject().get("ws").getAsJsonArray().add(ws.get(currentWs));
            literals.get(i).getAsJsonObject().addProperty("value", ws.get(currentWs).getAsJsonObject().get("text").getAsString());
            ws.remove(currentWs);
            literals.get(i).getAsJsonObject().addProperty("startTemplateLiteral", Boolean.valueOf(true));
        } else if (ws.get(currentWs).getAsJsonObject().get("text").getAsString().contains("}")) {
            literals.get(i).getAsJsonObject().get("ws").getAsJsonArray().add(ws.get(currentWs));
            if (ws.get(nextWs).getAsJsonObject().get("text").getAsString().contains("${")) {
                literals.get(i).getAsJsonObject().get("ws").getAsJsonArray().add(ws.get(nextWs));
                literals.get(i).getAsJsonObject().addProperty("value", ws.get(nextWs).getAsJsonObject().get("text").getAsString());
                literals.get(i).getAsJsonObject().addProperty("startTemplateLiteral", Boolean.valueOf(true));
                ws.remove(nextWs);
            }
            ws.remove(currentWs);
            literals.get(i).getAsJsonObject().addProperty("endTemplateLiteral", Boolean.valueOf(true));
        }
    }

    private static JsonArray addDataToArray(int index, JsonElement element, JsonArray ws) {
        int length = ws.size() + 1;
        JsonArray array = new JsonArray();
        boolean added = false;
        for (int i = 0; i < length; ++i) {
            if (i == index) {
                array.add(element);
                added = true;
                continue;
            }
            if (added) {
                array.add(ws.get(i - 1));
                continue;
            }
            array.add(ws.get(i));
        }
        return array;
    }
}

