/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace.repository;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.converters.FileSystemSourceInput;

class LSInMemorySourceEntry
extends FileSystemSourceInput {
    private WorkspaceDocumentManager documentManager;

    LSInMemorySourceEntry(Path path, Path root, PackageID pkgId, WorkspaceDocumentManager documentManager) {
        super(path, root.resolve(Paths.get(pkgId.name.value, new String[0])));
        this.documentManager = documentManager;
    }

    public byte[] getCode() {
        try {
            return this.documentManager.getFileContent(this.getPath()).getBytes(StandardCharsets.UTF_8);
        }
        catch (WorkspaceDocumentException e) {
            throw new RuntimeException("Error in loading package source entry '" + this.getPath() + "': " + e.getMessage(), e);
        }
    }
}

