/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.compiler.workspace.repository;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.workspace.repository.LSInMemorySourceEntry;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.converters.PathConverter;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class LSPathConverter
extends PathConverter {
    private WorkspaceDocumentManager documentManager;

    public LSPathConverter(Path root, WorkspaceDocumentManager documentManager) {
        super(root);
        this.documentManager = documentManager;
    }

    public Stream<CompilerInput> finalize(Path path, PackageID id) {
        if (id.version.value.isEmpty() && !id.orgName.equals((Object)Names.BUILTIN_ORG) && !id.orgName.equals((Object)Names.ANON_ORG)) {
            Manifest manifest = TomlParserUtils.getManifest((Path)Paths.get(this.toString(), new String[0]));
            id.version = new Name(manifest.getProject().getVersion());
        }
        Path moduleRoot = this.isBallerinaProject(this.start().toString()) ? this.start().resolve("src") : this.start();
        return Stream.of(new LSInMemorySourceEntry(path, moduleRoot, id, this.documentManager));
    }

    private boolean isBallerinaProject(String projectRoot) {
        return ProjectDirs.findProjectRoot((Path)Paths.get(projectRoot, new String[0])) != null;
    }
}

