/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorDispatcher;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;

public class ChannelRegisterCallback {
    private SocketService socketService;
    private NonBlockingCallback callback;
    private final int initialInterest;

    public ChannelRegisterCallback(SocketService socketService, NonBlockingCallback callback, int initialInterest) {
        this.socketService = socketService;
        this.callback = callback;
        this.initialInterest = initialInterest;
    }

    public SocketService getSocketService() {
        return this.socketService;
    }

    public int getInitialInterest() {
        return this.initialInterest;
    }

    public void notifyRegister(boolean serviceAttached) {
        this.callback.notifySuccess();
        if (serviceAttached) {
            SelectorDispatcher.invokeOnConnect(this.socketService);
        }
    }

    public void notifyFailure(String errorMsg) {
        ErrorValue error = SocketUtils.createSocketError(errorMsg);
        this.callback.notifyFailure((BError)error);
    }
}

