/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.stdlib.socket.SocketConstants;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingSocketMap;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;

public class ReadPendingCallback {
    private NonBlockingCallback callback;
    private final int expectedLength;
    private int currentLength;
    private ByteBuffer buffer;
    private int socketHash;
    private Timer timer;
    private long timeout;

    public ReadPendingCallback(NonBlockingCallback callback, int expectedLength, int socketHash, long timeout) {
        this.callback = callback;
        this.expectedLength = expectedLength;
        this.socketHash = socketHash;
        this.timeout = timeout;
        this.scheduleTimeout(timeout);
    }

    public NonBlockingCallback getCallback() {
        return this.callback;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void updateCurrentLength(int currentLength) {
        this.currentLength += currentLength;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private void scheduleTimeout(long timeout) {
        this.timer = this.getTimer();
        this.timer.schedule(this.getTimerTask(), timeout);
    }

    void resetTimeout() {
        this.timer.cancel();
        this.timer = this.getTimer();
        this.timer.schedule(this.getTimerTask(), this.timeout);
    }

    void cancelTimeout() {
        this.timer.cancel();
    }

    private Timer getTimer() {
        return new Timer("B7aSocketTimeoutTimer");
    }

    private TimerTask getTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                ReadPendingSocketMap.getInstance().remove(ReadPendingCallback.this.socketHash);
                ErrorValue timeoutError = SocketUtils.createSocketError(SocketConstants.ErrorCode.ReadTimedOutError, "read timed out");
                ReadPendingCallback.this.callback.setReturnValues((Object)timeoutError);
                ReadPendingCallback.this.callback.notifySuccess();
                this.cancel();
            }
        };
    }
}

