/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.datasource;

import java.util.Map;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;

public class PoolKey {
    private String jdbcUrl;
    private MapValue<String, ?> dbOptions;

    public PoolKey(String jdbcUrl, MapValue<String, ?> dbOptions) {
        this.jdbcUrl = jdbcUrl;
        this.dbOptions = dbOptions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PoolKey)) {
            return false;
        }
        boolean jdbcUrlEqual = ((PoolKey)obj).jdbcUrl.equals(this.jdbcUrl);
        return jdbcUrlEqual && this.dbOptionsEqual((PoolKey)obj);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 31 + this.jdbcUrl.hashCode();
        if (this.dbOptions != null) {
            hashCode = 31 * hashCode + this.calculateDbOptionsHashCode();
        }
        return hashCode;
    }

    private int calculateDbOptionsHashCode() {
        int hashCode = 17;
        for (Map.Entry entry : this.dbOptions.entrySet()) {
            int valueHashCode;
            int keyHashCode = ((String)entry.getKey()).hashCode();
            Object value = entry.getValue();
            BType type = TypeChecker.getType(value);
            int typeTag = type.getTag();
            switch (typeTag) {
                case 4: 
                case 5: {
                    valueHashCode = value.hashCode();
                    break;
                }
                case 1: 
                case 2: {
                    long longValue = (Long)value;
                    valueHashCode = (int)(longValue ^ longValue >>> 32);
                    break;
                }
                case 3: {
                    long longValueConvertedFromDouble = Double.doubleToLongBits((Double)value);
                    valueHashCode = (int)(longValueConvertedFromDouble ^ longValueConvertedFromDouble >>> 32);
                    break;
                }
                case 6: {
                    valueHashCode = (Boolean)value != false ? 1 : 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("type " + type.getName() + " shouldn't have occurred"));
                }
            }
            hashCode = hashCode + keyHashCode + valueHashCode;
        }
        return hashCode;
    }

    private boolean dbOptionsEqual(PoolKey anotherPoolKey) {
        MapValue<String, ?> anotherDbOptions = anotherPoolKey.dbOptions;
        if (this.dbOptions == null && anotherDbOptions == null) {
            return true;
        }
        if (this.dbOptions == null || anotherDbOptions == null) {
            return false;
        }
        if (this.dbOptions.size() != anotherDbOptions.size()) {
            return false;
        }
        for (Map.Entry entry : this.dbOptions.entrySet()) {
            if (entry.getValue().equals(anotherDbOptions.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

