/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.statement;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.datasource.SQLDatasourceUtils;
import org.ballerinax.jdbc.exceptions.ApplicationException;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.statement.AbstractSQLStatement;
import org.ballerinax.jdbc.statement.ProcessedStatement;
import org.ballerinax.jdbc.statement.StatementProcessUtils;

public class CallStatement
extends AbstractSQLStatement {
    private final ObjectValue client;
    private final SQLDatasource datasource;
    private final String query;
    private final ArrayValue parameters;
    private final ArrayValue structTypes;

    public CallStatement(ObjectValue client, SQLDatasource datasource, String query, ArrayValue structTypes, ArrayValue parameters, Strand strand) {
        super(strand);
        this.client = client;
        this.datasource = datasource;
        this.query = query;
        this.parameters = parameters;
        this.structTypes = structTypes;
    }

    @Override
    public Object execute() {
        this.checkAndObserveSQLAction(this.strand, this.datasource, this.query);
        Connection conn = null;
        CallableStatement stmt = null;
        List<ResultSet> resultSets = null;
        boolean isInTransaction = this.strand.isInTransaction();
        String errorMessagePrefix = "failed to execute stored procedure: ";
        try {
            boolean requiredToReturnTables;
            ArrayValue generatedParams = this.constructParameters(this.parameters);
            conn = this.getDatabaseConnection(this.strand, this.client, this.datasource);
            stmt = this.getPreparedCall(conn, this.datasource, this.query, generatedParams);
            ProcessedStatement processedStatement = new ProcessedStatement(conn, stmt, generatedParams, this.datasource.getDatabaseProductName());
            stmt = (CallableStatement)processedStatement.prepare();
            boolean refCursorOutParamsPresent = this.isRefCursorOutParamPresent(generatedParams);
            boolean resultSetsReturned = false;
            TableResourceManager rm = null;
            boolean bl = requiredToReturnTables = this.structTypes != null && this.structTypes.size() > 0;
            if (requiredToReturnTables) {
                resultSets = this.executeStoredProc(stmt, this.datasource.getDatabaseProductName());
                resultSetsReturned = !resultSets.isEmpty();
            } else {
                stmt.execute();
            }
            if (resultSetsReturned || refCursorOutParamsPresent) {
                rm = new TableResourceManager(conn, (Statement)stmt, !isInTransaction);
            }
            this.setOutParameters(stmt, this.parameters, rm);
            if (resultSetsReturned) {
                rm.addAllResultSets(resultSets);
                return this.constructTablesForResultSets(resultSets, rm, this.structTypes, this.datasource.getDatabaseProductName());
            }
            if (!refCursorOutParamsPresent) {
                this.cleanupResources(resultSets, (Statement)stmt, conn, !isInTransaction);
            }
        }
        catch (SQLException e) {
            this.cleanupResources(resultSets, stmt, conn, !isInTransaction);
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute stored procedure failed: " + e.getMessage());
            return ErrorGenerator.getSQLDatabaseError(e, errorMessagePrefix);
        }
        catch (ApplicationException e) {
            this.cleanupResources(resultSets, stmt, conn, !isInTransaction);
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute stored procedure failed: " + e.getMessage());
            return ErrorGenerator.getSQLApplicationError(e, errorMessagePrefix);
        }
        return null;
    }

    private ArrayValue constructTablesForResultSets(List<ResultSet> resultSets, TableResourceManager rm, ArrayValue structTypes, String databaseProductName) throws SQLException, ApplicationException {
        int typeFlags = TypeFlags.asMask((int[])new int[]{2, 4});
        BRecordType tableConstraint = new BRecordType("$table$anon$constraint$", null, 0, false, typeFlags);
        tableConstraint.restFieldType = BTypes.typeAnydata;
        ArrayValueImpl bTables = new ArrayValueImpl(new BArrayType((BType)new BTableType((BType)tableConstraint)));
        if (databaseProductName.contains("mysql") && structTypes != null && structTypes.size() > 1) {
            throw new ApplicationException("it is not supported to retrieve result sets from stored procedures since it is returning more than one result set");
        }
        if (structTypes == null || resultSets.size() != structTypes.size()) {
            throw new ApplicationException("mismatching record type count " + (structTypes == null ? 0 : structTypes.size()) + " and returned result set count " + resultSets.size() + " from the stored procedure");
        }
        for (int i = 0; i < resultSets.size(); ++i) {
            TypedescValue typedescValue = (TypedescValue)structTypes.get((long)i);
            BStructureType structureType = (BStructureType)typedescValue.getDescribingType();
            bTables.add((long)i, (Object)this.constructTable(rm, resultSets.get(i), structureType, databaseProductName));
        }
        return bTables;
    }

    private TableValue constructTable(TableResourceManager rm, ResultSet rs, BStructureType structType, String databaseProductName) throws SQLException {
        List<ColumnDefinition> columnDefinitions = this.getColumnDefinitions(rs);
        return this.constructTable(rm, rs, structType, columnDefinitions, databaseProductName);
    }

    private List<ResultSet> executeStoredProc(CallableStatement stmt, String databaseProductName) throws SQLException {
        boolean resultAndNoUpdateCount = stmt.execute();
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
        while (true) {
            if (!resultAndNoUpdateCount) {
                int updateCount = stmt.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
            } else {
                ResultSet result = stmt.getResultSet();
                resultSets.add(result);
                if (databaseProductName.contains("mysql") || databaseProductName.contains("microsoft sql server")) break;
            }
            try {
                if (databaseProductName.contains("microsoft sql server")) {
                    resultAndNoUpdateCount = stmt.getMoreResults();
                    continue;
                }
                resultAndNoUpdateCount = stmt.getMoreResults(2);
            }
            catch (SQLException e) {
                break;
            }
        }
        return resultSets;
    }

    private void setOutParameters(CallableStatement stmt, ArrayValue params, TableResourceManager rm) throws SQLException, ApplicationException {
        if (params == null) {
            return;
        }
        int paramCount = params.size();
        for (int index = 0; index < paramCount; ++index) {
            BType type = TypeChecker.getType((Object)params.get((long)index));
            if (type.getTag() != 12) continue;
            MapValue paramValue = (MapValue)params.get((long)index);
            if (paramValue != null) {
                String sqlType = StatementProcessUtils.getSQLType((MapValue<String, Object>)paramValue);
                int direction = StatementProcessUtils.getParameterDirection((MapValue<String, Object>)paramValue);
                if (direction != 2 && direction != 1) continue;
                this.setOutParameterValue(stmt, sqlType, index, (MapValue<String, Object>)paramValue, rm);
                continue;
            }
            throw new ApplicationException("OUT value cannot be set for a null parameter at index " + index);
        }
    }

    private void setOutParameterValue(CallableStatement stmt, String sqlType, int index, MapValue<String, Object> paramValue, TableResourceManager resourceManager) throws SQLException, ApplicationException {
        try {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "INTEGER": {
                    int value = stmt.getInt(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "NVARCHAR": 
                case "LONGNVARCHAR": 
                case "NCHAR": {
                    String value = stmt.getNString(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "CHAR": 
                case "LONGVARCHAR": 
                case "VARCHAR": {
                    String value = stmt.getString(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "NUMERIC": 
                case "DECIMAL": {
                    BigDecimal value = stmt.getBigDecimal(index + 1);
                    if (value == null) {
                        paramValue.put((Object)"value", (Object)0);
                        break;
                    }
                    paramValue.put((Object)"value", (Object)new DecimalValue(value));
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    boolean value = stmt.getBoolean(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "TINYINT": 
                case "SMALLINT": {
                    short value = stmt.getShort(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "BIGINT": {
                    long value = stmt.getLong(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "REAL": 
                case "FLOAT": {
                    float value = stmt.getFloat(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "DOUBLE": {
                    double value = stmt.getDouble(index + 1);
                    paramValue.put((Object)"value", (Object)value);
                    break;
                }
                case "CLOB": {
                    Clob value = stmt.getClob(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "BLOB": {
                    Blob value = stmt.getBlob(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "NCLOB": {
                    NClob value = stmt.getNClob(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "VARBINARY": 
                case "BINARY": {
                    byte[] value = stmt.getBytes(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "DATE": {
                    Date value = stmt.getDate(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    Timestamp value = stmt.getTimestamp(index + 1, this.utcCalendar);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "TIME": {
                    Time value = stmt.getTime(index + 1, this.utcCalendar);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "ARRAY": {
                    Array value = stmt.getArray(index + 1);
                    paramValue.put((Object)"value", (Object)SQLDatasourceUtils.getString(value));
                    break;
                }
                case "STRUCT": {
                    Object value = stmt.getObject(index + 1);
                    String stringValue = "";
                    if (value != null) {
                        stringValue = value instanceof Struct ? SQLDatasourceUtils.getString((Struct)value) : value.toString();
                    }
                    paramValue.put((Object)"value", (Object)stringValue);
                    break;
                }
                case "REFCURSOR": {
                    ResultSet rs = (ResultSet)stmt.getObject(index + 1);
                    BStructureType structType = this.getStructType(paramValue);
                    if (structType != null) {
                        resourceManager.addResultSet(rs);
                        SQLDatasource datasource = this.retrieveDatasource(this.client);
                        paramValue.put((Object)"value", (Object)this.constructTable(resourceManager, rs, this.getStructType(paramValue), datasource.getDatabaseProductName()));
                        break;
                    }
                    throw new ApplicationException("the struct type for the result set pointed by the ref cursor cannot be null");
                }
                default: {
                    throw new ApplicationException("unsupported data type " + sqlType + " specified as OUT/INOUT parameter at index " + index);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLException("error while getting OUT parameter value. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
        catch (IOException e) {
            throw new ApplicationException("error while getting OUT parameter value", e.getMessage());
        }
    }

    private SQLDatasource retrieveDatasource(ObjectValue client) {
        return (SQLDatasource)client.getNativeData("Client");
    }

    private BStructureType getStructType(MapValue<String, Object> parameter) {
        TypedescValue typedescValue = (TypedescValue)parameter.get((Object)"recordType");
        BStructureType structType = null;
        if (typedescValue != null) {
            structType = (BStructureType)typedescValue.getDescribingType();
        }
        return structType;
    }

    private CallableStatement getPreparedCall(Connection conn, SQLDatasource datasource, String query, ArrayValue parameters) throws SQLException {
        CallableStatement stmt;
        boolean mysql = datasource.getDatabaseProductName().contains("mysql");
        if (mysql) {
            stmt = conn.prepareCall(query, 1003, 1007);
            if (parameters != null && !this.hasOutParams(parameters)) {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
        } else {
            stmt = conn.prepareCall(query);
        }
        return stmt;
    }

    private boolean hasOutParams(ArrayValue params) {
        int paramCount = params.size();
        for (int index = 0; index < paramCount; ++index) {
            MapValue paramValue = (MapValue)params.getRefValue((long)index);
            int direction = StatementProcessUtils.getParameterDirection((MapValue<String, Object>)paramValue);
            if (direction != 1 && direction != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isRefCursorOutParamPresent(ArrayValue params) {
        boolean refCursorOutParamPresent = false;
        int paramCount = params.size();
        for (int index = 0; index < paramCount; ++index) {
            MapValue paramValue = (MapValue)params.getRefValue((long)index);
            if (paramValue == null) continue;
            String sqlType = StatementProcessUtils.getSQLType((MapValue<String, Object>)paramValue);
            int direction = StatementProcessUtils.getParameterDirection((MapValue<String, Object>)paramValue);
            if (direction != 1 || !"REFCURSOR".equals(sqlType)) continue;
            refCursorOutParamPresent = true;
            break;
        }
        return refCursorOutParamPresent;
    }

    private void cleanupResources(List<ResultSet> resultSets, Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (resultSets != null) {
                for (ResultSet rs : resultSets) {
                    if (rs == null || rs.isClosed()) continue;
                    rs.close();
                }
            }
            this.cleanupResources(stmt, conn, connectionClosable);
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while cleaning sql resources: ");
        }
    }
}

