/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApi;
import org.ballerinalang.openapi.model.GenSrcFile;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiType;
import org.ballerinalang.openapi.utils.CodegenUtils;
import org.ballerinalang.openapi.utils.GeneratorConstants;
import org.ballerinalang.openapi.utils.TypeExtractorUtil;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public class CodeGenerator {
    private String srcPackage;
    private String modelPackage;
    private static final PrintStream outStream = System.err;

    private void generate(GeneratorConstants.GenType type, String executionPath, String definitionPath, String reldefinitionPath, String serviceName, String outPath) throws IOException, BallerinaOpenApiException {
        if (!CodegenUtils.isBallerinaProject(Paths.get(outPath, new String[0]))) {
            throw new BallerinaOpenApiException("Output path is not a valid ballerina project directory.\nUse 'ballerina new' to generate a new project");
        }
        Path projectRoot = ProjectDirs.findProjectRoot((Path)Paths.get(executionPath, new String[0]));
        if (type.equals((Object)GeneratorConstants.GenType.GEN_SERVICE) && projectRoot == null) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"Ballerina service generation should be done from the project root. \nIf you like to start with a new project use `ballerina new` command to create a new project.");
        }
        Path srcPath = CodegenUtils.getSourcePath(this.srcPackage, outPath);
        Path implPath = CodegenUtils.getImplPath(this.srcPackage, srcPath);
        if (type.equals((Object)GeneratorConstants.GenType.GEN_CLIENT)) {
            if (this.srcPackage.equals("")) {
                srcPath = srcPath.resolve("client");
                implPath = implPath.resolve("client");
            }
            if (Files.notExists(srcPath, new LinkOption[0])) {
                Files.createDirectory(srcPath, new FileAttribute[0]);
            }
            if (Files.notExists(implPath, new LinkOption[0])) {
                Files.createDirectory(implPath, new FileAttribute[0]);
            }
        }
        List<GenSrcFile> genFiles = this.generateBalSource(type, definitionPath, reldefinitionPath, serviceName);
        this.writeGeneratedSources(genFiles, srcPath, implPath, type);
    }

    public void generateClient(String executionPath, String definitionPath, String serviceName, String outPath) throws IOException, BallerinaOpenApiException {
        this.generate(GeneratorConstants.GenType.GEN_CLIENT, executionPath, definitionPath, null, serviceName, outPath);
    }

    public void generateService(String executionPath, String definitionPath, String reldefinitionPath, String serviceName, String outPath) throws IOException, BallerinaOpenApiException {
        this.generate(GeneratorConstants.GenType.GEN_SERVICE, executionPath, definitionPath, reldefinitionPath, serviceName, outPath);
    }

    public List<GenSrcFile> generateBalSource(GeneratorConstants.GenType type, String definitionPath, String reldefinitionPath, String serviceName) throws IOException, BallerinaOpenApiException {
        List<GenSrcFile> sourceFiles;
        OpenAPI api = new OpenAPIV3Parser().read(definitionPath);
        if (api == null) {
            throw new BallerinaOpenApiException("Couldn't read the definition from file: " + definitionPath);
        }
        if (serviceName != null) {
            api.getInfo().setTitle(serviceName);
        } else if (api.getInfo() == null || StringUtils.isEmpty((CharSequence)api.getInfo().getTitle())) {
            api.getInfo().setTitle("UntitledAPI");
        }
        switch (type) {
            case GEN_CLIENT: {
                BallerinaOpenApi definitionContext = new BallerinaOpenApi().buildContext(api).srcPackage(this.srcPackage).modelPackage(this.srcPackage);
                definitionContext.setDefinitionPath(reldefinitionPath);
                sourceFiles = this.generateClient(definitionContext);
                break;
            }
            case GEN_SERVICE: {
                BallerinaOpenApiType openApi = TypeExtractorUtil.extractOpenApiObject(api);
                openApi.setBalServiceName(serviceName);
                openApi.setBalModule(this.srcPackage);
                openApi.setServers(api);
                openApi.setTags(api.getTags());
                if (reldefinitionPath == null) {
                    openApi.setDefPath(definitionPath.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")));
                } else {
                    openApi.setDefPath(reldefinitionPath.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")));
                }
                sourceFiles = this.generateBallerinaService(openApi);
                break;
            }
            default: {
                return null;
            }
        }
        return sourceFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeBallerina(Object object, String templateDir, String templateName, String outPath) throws IOException {
        try (PrintWriter writer = null;){
            Template template = this.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, new CustomFieldValueResolver()}).build();
            writer = new PrintWriter(outPath, "UTF-8");
            writer.println(template.apply(context));
        }
    }

    private Template compileTemplate(String defaultTemplateDir, String templateName) throws IOException {
        defaultTemplateDir = defaultTemplateDir.replaceAll("\\\\", "/");
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.setInfiniteLoops(true);
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            CharSequence result = object != null ? (object.toString().equals(param0.toString()) ? options.fn(options.context) : options.inverse()) : null;
            return result;
        });
        return handlebars.compile(templateName);
    }

    private void writeGeneratedSources(List<GenSrcFile> sources, Path srcPath, Path implPath, GeneratorConstants.GenType type) throws IOException {
        File[] listFiles;
        if (this.srcPackage != null && !this.srcPackage.isEmpty() && Files.exists(srcPath, new LinkOption[0]) && (listFiles = new File(String.valueOf(srcPath)).listFiles()) != null) {
            Arrays.stream(listFiles).forEach(file -> {
                boolean deleteStatus = true;
                if (!file.isDirectory() && !file.getName().equals("Module.md")) {
                    deleteStatus = file.delete();
                }
                if (!deleteStatus) {
                    outStream.println("Unable to clean module directory.");
                }
            });
        }
        for (GenSrcFile file2 : sources) {
            Path filePath;
            if (!file2.getType().isOverwritable()) {
                filePath = implPath.resolve(file2.getFileName());
                if (!Files.notExists(filePath, new LinkOption[0])) continue;
                CodegenUtils.writeFile(filePath, file2.getContent());
                continue;
            }
            filePath = srcPath.resolve(file2.getFileName());
            CodegenUtils.writeFile(filePath, file2.getContent());
        }
        if (type.equals((Object)GeneratorConstants.GenType.GEN_SERVICE)) {
            outStream.println("Service generated successfully and the OpenApi contract is copied to " + this.srcPackage + "/resources. this location will be referenced throughout the ballerina project.");
        } else if (type.equals((Object)GeneratorConstants.GenType.GEN_CLIENT)) {
            outStream.println("Client generated successfully.");
        }
        outStream.println("Following files were created. \nsrc/ \n- " + this.srcPackage);
        Iterator<GenSrcFile> iterator = sources.iterator();
        while (iterator.hasNext()) {
            outStream.println("-- " + iterator.next().getFileName());
        }
    }

    private List<GenSrcFile> generateClient(BallerinaOpenApi context) throws IOException {
        if (this.srcPackage == null || this.srcPackage.isEmpty()) {
            this.srcPackage = "client";
        }
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        String srcFile = context.getInfo().getTitle().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_") + ".bal";
        String mainContent = this.getContent(context, "/templates/client", "client-ep");
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, srcFile, mainContent));
        String schemaContent = this.getContent(context, "/templates/model", "schemas");
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, this.srcPackage, "schema.bal", schemaContent));
        return sourceFiles;
    }

    private List<GenSrcFile> generateBallerinaService(BallerinaOpenApiType api) throws IOException {
        if (this.srcPackage == null || this.srcPackage.isEmpty()) {
            this.srcPackage = "mock";
        }
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        String concatTitle = api.getBalServiceName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(api, "/templates/service", "balService");
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, srcFile, mainContent));
        String schemaContent = this.getContent(api, "/templates/service", "schemaList");
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "schema.bal", schemaContent));
        return sourceFiles;
    }

    private String getContent(BallerinaOpenApiType object, String templateDir, String templateName) throws IOException {
        Template template = this.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, new CustomFieldValueResolver()}).build();
        return template.apply(context);
    }

    private String getContent(BallerinaOpenApi object, String templateDir, String templateName) throws IOException {
        Template template = this.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, new CustomFieldValueResolver()}).build();
        return template.apply(context);
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public void setSrcPackage(String srcPackage) {
        this.srcPackage = srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    static class CustomFieldValueResolver
    extends FieldValueResolver {
        CustomFieldValueResolver() {
        }

        protected Set<FieldValueResolver.FieldWrapper> members(Class<?> clazz) {
            Set members = super.members(clazz);
            return members.stream().filter(fw -> this.isValidField((FieldValueResolver.FieldWrapper)fw)).collect(Collectors.toSet());
        }

        boolean isValidField(FieldValueResolver.FieldWrapper fw) {
            if (fw instanceof AccessibleObject) {
                return this.isUseSetAccessible((Member)fw);
            }
            return true;
        }
    }
}

