/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.openapi.CodeGenerator;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import picocli.CommandLine;

@CommandLine.Command(name="gen-client")
public class OpenApiGenClientCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "openapi-gen-client";
    private PrintStream outStream = System.err;
    private String executionPath = System.getProperty("user.dir");
    @CommandLine.Parameters(index="0", split=":")
    private List<String> moduleArgs;
    @CommandLine.Parameters(index="1..*")
    private List<String> argList;
    @CommandLine.Option(names={"-o", "--output"}, description={"where to write the generated files (current dir by default)"})
    private String output = "";
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public OpenApiGenClientCmd() {
        this.outStream = System.err;
    }

    public OpenApiGenClientCmd(PrintStream outStream, String executionPath) {
        this.outStream = outStream;
        this.executionPath = executionPath;
    }

    public void execute() {
        this.outStream.println("Note: This is an experimental tool, which only supports a limited set of functionality.");
        CodeGenerator generator = new CodeGenerator();
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.moduleArgs == null) {
            throw LauncherUtils.createLauncherException((String)"Client name is mandatory to generate the ballerina client. \nE.g. ballerina openapi gen-client [<module>]:<servicename> <openapicontract>");
        }
        if (this.argList == null) {
            throw LauncherUtils.createLauncherException((String)"An OpenApi definition file is required to generate the client. \nE.g: ballerina openapi gen-client [<module>]:<servicename> <OpenApiContract>");
        }
        if (this.moduleArgs.size() >= 2) {
            generator.setSrcPackage(this.moduleArgs.get(0));
        }
        try {
            generator.generateClient(this.executionPath, this.argList.get(0), this.moduleArgs.get(1), this.output);
        }
        catch (IOException | BallerinaOpenApiException e) {
            if (e.getLocalizedMessage() != null) {
                throw LauncherUtils.createLauncherException((String)e.getLocalizedMessage());
            }
            throw LauncherUtils.createLauncherException((String)"Error occurred when generating client for openapi contract");
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

