/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.cmd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.ballerinalang.openapi.CodeGenerator;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="gen-service")
public class OpenApiGenServiceCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "openapi-gen-service";
    private PrintStream outStream;
    private String executionPath;
    @CommandLine.Parameters(index="0", split=":")
    private List<String> moduleArgs;
    @CommandLine.Parameters(index="1..*")
    private List<String> argList;
    @CommandLine.Option(names={"-s", "--skip-bind"}, description={"Skip copying of the used contract to project"})
    boolean skipBind = false;
    @CommandLine.Option(names={"-o", "--output"}, description={"where to write the generated files (current dir by default)"})
    private String output = "";
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public OpenApiGenServiceCmd() {
        this.outStream = System.err;
        this.executionPath = System.getProperty("user.dir");
    }

    public OpenApiGenServiceCmd(PrintStream outStream, String executionPath) {
        this.outStream = outStream;
        this.executionPath = executionPath;
    }

    public void execute() {
        File moduleMd;
        this.outStream.println("Note: This is an experimental tool, which only supports a limited set of functionality.");
        CodeGenerator generator = new CodeGenerator();
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.moduleArgs == null || this.moduleArgs.size() < 2) {
            throw LauncherUtils.createLauncherException((String)"A module name and a service name is required in order to generate the ballerina service for the provided OpenApi contract. \nE.g. ballerina openapi gen-service <module_name>:<service_name> <openapi_contract>");
        }
        if (this.moduleArgs.get(0).trim().isEmpty()) {
            throw LauncherUtils.createLauncherException((String)"A module name is required in order to generate the ballerina service for the provided OpenApi contract. \nE.g. ballerina openapi gen-service <module_name>:<service_name> <openapi_contract>");
        }
        if (this.moduleArgs.get(1).trim().isEmpty()) {
            throw LauncherUtils.createLauncherException((String)"A service name is required in order to generate the ballerina service for the provided OpenApi contract. \nE.g. ballerina openapi gen-service <module_name>:<service_name> <openapi_contract>");
        }
        if (this.argList == null) {
            throw LauncherUtils.createLauncherException((String)("An OpenApi definition file is required to generate the service. \nE.g: ballerina openapi gen-service " + this.moduleArgs.get(0) + ":" + this.moduleArgs.get(1) + " <OpenApiContract>"));
        }
        Path projectRoot = ProjectDirs.findProjectRoot((Path)Paths.get(this.executionPath, new String[0]));
        if (projectRoot == null) {
            throw LauncherUtils.createLauncherException((String)"Ballerina service generation should be done from the project root. \nIf you like to start with a new project use `ballerina new` command to create a new project.");
        }
        Path sourceDirectory = projectRoot.resolve("src");
        Path moduleDirectory = sourceDirectory.resolve(this.moduleArgs.get(0));
        Path resourcesDirectory = Paths.get(moduleDirectory + "/resources", new String[0]);
        Path testsDirectory = Paths.get(moduleDirectory + "/tests", new String[0]);
        File openApiFile = new File(this.argList.get(0));
        String openApiFilePath = openApiFile.getPath();
        Path resourcePath = Paths.get(resourcesDirectory + "/" + openApiFile.getName(), new String[0]);
        Path relativeResourcePath = Paths.get("resources", openApiFile.getName());
        if (Files.notExists(Paths.get(openApiFilePath, new String[0]), new LinkOption[0])) {
            throw LauncherUtils.createLauncherException((String)("Could not resolve a valid OpenApi contract in " + openApiFilePath));
        }
        if (Files.notExists(moduleDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(moduleDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Unable to create module directory. File system error occured.\n" + e.getLocalizedMessage()));
            }
        }
        if (!(moduleMd = new File(moduleDirectory + "/Module.md")).exists()) {
            try {
                boolean createMd = true;
                createMd = moduleMd.createNewFile();
                if (!createMd) {
                    throw LauncherUtils.createLauncherException((String)"Unable to create moudle.md file. File system error occured.");
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Unable to create moudle.md file. File system error occured.\n" + e.getLocalizedMessage()));
            }
        }
        if (Files.notExists(testsDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(testsDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Unable to create tests directory. File system error occured\n" + e.getLocalizedMessage()));
            }
        }
        if (this.skipBind) {
            try {
                resourcePath = Paths.get(openApiFile.getCanonicalPath(), new String[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)e.getLocalizedMessage());
            }
        }
        if (Files.notExists(resourcesDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(resourcesDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Unable to create resource directory. File system error occured.\n" + e.getLocalizedMessage()));
            }
        }
        if (Files.notExists(resourcePath, new LinkOption[0])) {
            try {
                Files.copy(Paths.get(openApiFilePath, new String[0]), resourcePath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)e.getLocalizedMessage());
            }
        } else {
            throw LauncherUtils.createLauncherException((String)("There is already an OpenApi contract in the location. " + resourcesDirectory));
        }
        if (this.output.isEmpty()) {
            this.output = this.executionPath;
        }
        generator.setSrcPackage(this.moduleArgs.get(0));
        try {
            generator.generateService(this.executionPath, resourcePath.toString(), relativeResourcePath.toString(), this.moduleArgs.get(1), this.output);
        }
        catch (IOException | BallerinaOpenApiException e) {
            throw LauncherUtils.createLauncherException((String)("Error occurred when generating service for openapi contract at " + this.argList.get(0) + ". " + e.getMessage() + "."));
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

