/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.Map;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.model.BallerinaSchema;

public class BallerinaMediaType
implements BallerinaOpenApiObject<BallerinaMediaType, MediaType> {
    private BallerinaSchema schema;
    private Map<String, Example> examples;
    private Object example;
    private Map<String, Encoding> encoding;
    private Map<String, Object> extensions;
    private String mediaType;

    @Override
    public BallerinaMediaType buildContext(MediaType mediaType) throws BallerinaOpenApiException {
        return this.buildContext(mediaType, (OpenAPI)null);
    }

    @Override
    public BallerinaMediaType buildContext(MediaType mediaType, OpenAPI openAPI) throws BallerinaOpenApiException {
        this.example = mediaType.getExample();
        this.extensions = mediaType.getExtensions();
        this.encoding = mediaType.getEncoding();
        this.examples = mediaType.getExamples();
        this.schema = new BallerinaSchema().buildContext(mediaType.getSchema(), openAPI);
        return this;
    }

    @Override
    public BallerinaMediaType getDefaultValue() {
        return new BallerinaMediaType();
    }

    public BallerinaSchema getSchema() {
        return this.schema;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Object getExample() {
        return this.example;
    }

    public Map<String, Encoding> getEncoding() {
        return this.encoding;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }
}

