/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Map;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.model.BallerinaSchema;

public class BallerinaParameter
implements BallerinaOpenApiObject<BallerinaParameter, Parameter> {
    private String name;
    private String in;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private String ref;
    private Parameter.StyleEnum style;
    private Boolean explode;
    private Boolean allowReserved;
    private BallerinaSchema schema;
    private Map<String, Example> examples;
    private Object example;
    private Content content;
    private Map<String, Object> extensions;

    @Override
    public BallerinaParameter buildContext(Parameter parameter) throws BallerinaOpenApiException {
        return this.buildContext(parameter, (OpenAPI)null);
    }

    @Override
    public BallerinaParameter buildContext(Parameter parameter, OpenAPI openAPI) throws BallerinaOpenApiException {
        this.name = parameter.getName();
        this.in = parameter.getIn();
        this.description = parameter.getDescription();
        this.required = parameter.getRequired();
        this.deprecated = parameter.getDeprecated();
        this.allowEmptyValue = parameter.getAllowEmptyValue();
        this.ref = parameter.get$ref();
        this.style = parameter.getStyle();
        this.explode = parameter.getExplode();
        this.allowReserved = parameter.getAllowReserved();
        this.examples = parameter.getExamples();
        this.example = parameter.getExample();
        this.content = parameter.getContent();
        this.extensions = parameter.getExtensions();
        this.schema = new BallerinaSchema().buildContext(parameter.getSchema(), openAPI);
        return this;
    }

    @Override
    public BallerinaParameter getDefaultValue() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return this.in;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public String getRef() {
        return this.ref;
    }

    public Parameter.StyleEnum getStyle() {
        return this.style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public BallerinaSchema getSchema() {
        return this.schema;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Object getExample() {
        return this.example;
    }

    public Content getContent() {
        return this.content;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }
}

