/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.openapi.OpenApiMesseges;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiComponent;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiOperation;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiParameter;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiPath;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiRequestBody;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiSchema;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiType;

public class TypeExtractorUtil {
    private static final PrintStream outStream = System.err;

    public static BallerinaOpenApiType extractOpenApiObject(OpenAPI apiDef) throws BallerinaOpenApiException {
        BallerinaOpenApiType typeDef = new BallerinaOpenApiType();
        if (apiDef.getPaths() != null) {
            typeDef.setPathList(TypeExtractorUtil.extractOpenApiPaths(apiDef.getPaths()));
        }
        if (apiDef.getComponents() != null) {
            BallerinaOpenApiComponent component = new BallerinaOpenApiComponent();
            if (apiDef.getComponents().getSchemas() != null) {
                component.setSchemaList(TypeExtractorUtil.extractComponentSchema(apiDef.getComponents().getSchemas()));
            }
            typeDef.setComponent(component);
        }
        return typeDef;
    }

    private static List<BallerinaOpenApiPath> extractOpenApiPaths(Paths defPaths) throws BallerinaOpenApiException {
        ArrayList<BallerinaOpenApiPath> paths = new ArrayList<BallerinaOpenApiPath>();
        for (Map.Entry nextPath : defPaths.entrySet()) {
            String pathName = (String)nextPath.getKey();
            PathItem pathObject = (PathItem)nextPath.getValue();
            BallerinaOpenApiPath typePath = new BallerinaOpenApiPath();
            typePath.setPath(pathName);
            typePath.setOperationsList(TypeExtractorUtil.extractOpenApiOperations(pathObject.readOperationsMap(), pathName));
            paths.add(typePath);
        }
        return paths;
    }

    public static List<BallerinaOpenApiOperation> extractOpenApiOperations(Map<PathItem.HttpMethod, Operation> operationMap, String pathName) throws BallerinaOpenApiException {
        Iterator<Map.Entry<PathItem.HttpMethod, Operation>> opIterator = operationMap.entrySet().iterator();
        ArrayList<BallerinaOpenApiOperation> typeOpList = new ArrayList<BallerinaOpenApiOperation>();
        while (opIterator.hasNext()) {
            Map.Entry<PathItem.HttpMethod, Operation> nextOp = opIterator.next();
            PathItem.HttpMethod opMethod = nextOp.getKey();
            Operation opObject = nextOp.getValue();
            BallerinaOpenApiOperation operation = new BallerinaOpenApiOperation();
            operation.setOpMethod(opMethod.toString());
            if (opObject.getOperationId() == null) {
                String resName = "resource_" + nextOp.getKey().toString().toLowerCase(Locale.ENGLISH) + pathName.replaceAll("/", "_").replaceAll("[{}]", "");
                operation.setOpName(resName);
                outStream.println("warning : `" + resName + "` is used as the resource name since the operation id is missing for " + pathName + " " + nextOp.getKey());
            } else {
                operation.setOpName(TypeExtractorUtil.escapeIdentifierInFunctionName(opObject.getOperationId().replace(" ", "_")));
            }
            if (opObject.getParameters() != null) {
                operation.setParameterList(TypeExtractorUtil.extractOpenApiParameters(opObject.getParameters()));
            }
            if (opObject.getRequestBody() != null) {
                operation.setRequestBody(TypeExtractorUtil.extractOpenApiRequestBody(opObject.getRequestBody()));
            }
            typeOpList.add(operation);
        }
        return typeOpList;
    }

    private static List<BallerinaOpenApiParameter> extractOpenApiParameters(List<Parameter> parameters) throws BallerinaOpenApiException {
        Iterator<Parameter> paramIterator = parameters.iterator();
        ArrayList<BallerinaOpenApiParameter> paramList = new ArrayList<BallerinaOpenApiParameter>();
        while (paramIterator.hasNext()) {
            Parameter nextParam = paramIterator.next();
            BallerinaOpenApiParameter parameter = new BallerinaOpenApiParameter();
            if (nextParam.getName() != null) {
                parameter.setParamName(TypeExtractorUtil.escapeIdentifier(nextParam.getName()));
            }
            if (nextParam.getIn() != null) {
                parameter.setPathParam(nextParam.getIn().equals("path"));
            }
            if (nextParam.get$ref() != null) {
                parameter.setRefType(TypeExtractorUtil.extractReferenceType(nextParam.get$ref()));
            }
            if (nextParam.getSchema() != null) {
                BallerinaOpenApiSchema typeSchema = new BallerinaOpenApiSchema();
                TypeExtractorUtil.extractOpenApiSchema(nextParam.getSchema(), typeSchema, true, null);
                parameter.setParamType(typeSchema);
            }
            paramList.add(parameter);
        }
        return paramList;
    }

    private static BallerinaOpenApiRequestBody extractOpenApiRequestBody(RequestBody requestBody) throws BallerinaOpenApiException {
        BallerinaOpenApiRequestBody requestType = new BallerinaOpenApiRequestBody();
        if (requestBody.get$ref() != null) {
            requestType.setRefType(TypeExtractorUtil.extractReferenceType(requestBody.get$ref()));
        } else if (requestBody.getContent() != null) {
            BallerinaOpenApiSchema requestSchema = new BallerinaOpenApiSchema();
            MediaType request = (MediaType)((Map.Entry)requestBody.getContent().entrySet().iterator().next()).getValue();
            if (request.getSchema() != null) {
                TypeExtractorUtil.extractOpenApiSchema(request.getSchema(), requestSchema, true, null);
            }
            requestType.setContentType(requestSchema);
        }
        return requestType;
    }

    private static List<BallerinaOpenApiSchema> extractComponentSchema(Map<String, Schema> schemas) throws BallerinaOpenApiException {
        ArrayList<BallerinaOpenApiSchema> schemaList = new ArrayList<BallerinaOpenApiSchema>();
        for (Map.Entry<String, Schema> schemaEntry : schemas.entrySet()) {
            String schemaName = schemaEntry.getKey();
            Schema schemaObject = schemaEntry.getValue();
            BallerinaOpenApiSchema typeSchema = new BallerinaOpenApiSchema();
            typeSchema.setSchemaName(TypeExtractorUtil.escapeIdentifier(schemaName));
            TypeExtractorUtil.extractOpenApiSchema(schemaObject, typeSchema, false, null);
            schemaList.add(typeSchema);
        }
        return schemaList;
    }

    private static void extractOpenApiSchema(Schema schema, BallerinaOpenApiSchema typeSchema, Boolean isInline, String composedSchemaType) throws BallerinaOpenApiException {
        typeSchema.setInline(isInline);
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            typeSchema.setComposedSchema(true);
            if (composedSchema.getOneOf() != null) {
                Iterator oneOfList = composedSchema.getOneOf().iterator();
                typeSchema.setOneOf(true);
                while (oneOfList.hasNext()) {
                    Schema nextOneOf = (Schema)oneOfList.next();
                    TypeExtractorUtil.extractOpenApiSchema(nextOneOf, typeSchema, isInline, "ONE_OF");
                }
            }
            if (composedSchema.getAllOf() != null) {
                Iterator allOfIterator = composedSchema.getAllOf().iterator();
                typeSchema.setAllOf(true);
                while (allOfIterator.hasNext()) {
                    Schema allOfNext = (Schema)allOfIterator.next();
                    TypeExtractorUtil.extractOpenApiSchema(allOfNext, typeSchema, isInline, "ALL_OF");
                }
            }
        }
        if (schema.getType() != null || schema.getProperties() != null) {
            if (schema.getType() != null && (schema.getType().equals("integer") || schema.getType().equals("number"))) {
                TypeExtractorUtil.setSchemaType(typeSchema, "int");
            } else if (schema.getType() != null && schema.getType().equals("string")) {
                TypeExtractorUtil.setSchemaType(typeSchema, "string");
            } else if (schema.getType() != null && schema.getType().equals("boolean")) {
                TypeExtractorUtil.setSchemaType(typeSchema, "boolean");
            } else if (schema.getType() != null && schema.getType().equals("array")) {
                if (schema instanceof ArraySchema) {
                    ArraySchema arraySchema = (ArraySchema)schema;
                    typeSchema.setArray(true);
                    if (arraySchema.getItems() != null) {
                        BallerinaOpenApiSchema arrayItems = new BallerinaOpenApiSchema();
                        TypeExtractorUtil.extractOpenApiSchema(arraySchema.getItems(), arrayItems, isInline, composedSchemaType);
                        typeSchema.setItemsSchema(arrayItems);
                    }
                }
            } else if (schema.getType() != null && schema.getType().equals("object") || schema.getProperties() != null) {
                if (schema.getProperties() != null) {
                    List requiredBlock = schema.getRequired();
                    Iterator propertyIterator = schema.getProperties().entrySet().iterator();
                    ArrayList<BallerinaOpenApiSchema> propertyList = new ArrayList<BallerinaOpenApiSchema>();
                    while (propertyIterator.hasNext()) {
                        Map.Entry nextProp = propertyIterator.next();
                        String propName = (String)nextProp.getKey();
                        if (requiredBlock == null || !requiredBlock.isEmpty() && !requiredBlock.contains(propName)) {
                            propName = propName + "?";
                        }
                        Schema propValue = (Schema)nextProp.getValue();
                        BallerinaOpenApiSchema propertySchema = new BallerinaOpenApiSchema();
                        propertySchema.setSchemaName(TypeExtractorUtil.escapeIdentifier(propName));
                        TypeExtractorUtil.extractOpenApiSchema(propValue, propertySchema, isInline, composedSchemaType);
                        propertyList.add(propertySchema);
                    }
                    typeSchema.setHasChildElements(true);
                    typeSchema.setSchemaProperties(propertyList);
                }
            } else {
                outStream.println("Encountered an unsupported type. Type `any` would be used for the field.");
                TypeExtractorUtil.setSchemaType(typeSchema, "any");
            }
        } else if (schema.get$ref() != null) {
            if (composedSchemaType != null && composedSchemaType.equals("ALL_OF")) {
                TypeExtractorUtil.setComposedSchemaType(typeSchema, TypeExtractorUtil.extractReferenceType(schema.get$ref()));
            } else {
                TypeExtractorUtil.setSchemaType(typeSchema, TypeExtractorUtil.extractReferenceType(schema.get$ref()));
            }
        } else {
            outStream.println("Encountered an unsupported type. Type `any` would be used for the field.");
            TypeExtractorUtil.setSchemaType(typeSchema, "any");
        }
    }

    private static void setComposedSchemaType(BallerinaOpenApiSchema schema, String schemaType) {
        if (schema.getComposedSchemaTypes() == null) {
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add(schemaType);
            schema.setComposedSchemaTypes(typeList);
        } else {
            schema.getComposedSchemaTypes().add(schemaType);
        }
    }

    private static void setSchemaType(BallerinaOpenApiSchema schema, String schemaType) {
        if (schema.getSchemaType() == null) {
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add(schemaType);
            schema.setSchemaType(typeList);
        } else {
            schema.getSchemaType().add(schemaType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String escapeIdentifier(String identifier) {
        if (identifier.matches("[a-zA-Z0-9]+")) {
            if (!OpenApiMesseges.BAL_KEYWORDS.stream().anyMatch(identifier::equals)) return identifier;
        }
        if (!(identifier = identifier.replaceAll("([\\\\?!<>*\\-=^+()_{}|.$])", "$1")).endsWith("?")) return "'" + identifier;
        if (!OpenApiMesseges.BAL_KEYWORDS.stream().anyMatch(Optional.ofNullable(identifier).filter(sStr -> sStr.length() != 0).map(sStr -> sStr.substring(0, sStr.length() - 1)).orElse(identifier)::equals)) return identifier;
        return "'" + identifier;
    }

    public static String escapeIdentifierInFunctionName(String identifier) {
        block3: {
            block2: {
                if (!identifier.matches("[a-zA-Z]+")) break block2;
                if (!OpenApiMesseges.BAL_KEYWORDS.stream().anyMatch(identifier::equals)) break block3;
            }
            identifier = identifier.replaceAll("([\\\\?!<>*\\-=^+()_{}|.$])", "_");
        }
        return identifier;
    }

    public static String extractReferenceType(String referenceVariable) throws BallerinaOpenApiException {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return TypeExtractorUtil.escapeIdentifier(refArray[refArray.length - 1]);
        }
        throw new BallerinaOpenApiException("Invalid reference value : " + referenceVariable + "\nBallerina only supports local reference values.");
    }
}

