/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.math.LongMath;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class JsonUtil {
    private static final long DURATION_SECONDS_MIN = -315576000000L;
    private static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);

    @Nullable
    public static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (!(value2 instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not List", value2, key, obj));
        }
        return (List)value2;
    }

    @Nullable
    public static List<Map<String, ?>> getListOfObjects(Map<String, ?> obj, String key) {
        List<?> list = JsonUtil.getList(obj, key);
        if (list == null) {
            return null;
        }
        return JsonUtil.checkObjectList(list);
    }

    @Nullable
    public static List<String> getListOfStrings(Map<String, ?> obj, String key) {
        List<?> list = JsonUtil.getList(obj, key);
        if (list == null) {
            return null;
        }
        return JsonUtil.checkStringList(list);
    }

    @Nullable
    public static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (!(value2 instanceof Map)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not object", value2, key, obj));
        }
        return (Map)value2;
    }

    @Nullable
    public static Double getNumberAsDouble(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof String) {
            try {
                return Double.parseDouble((String)value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a double", value2, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' in '%s' is not a number", value2, key, obj));
    }

    @Nullable
    public static Integer getNumberAsInteger(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (value2 instanceof Double) {
            Double d = (Double)value2;
            int i = d.intValue();
            if ((double)i != d) {
                throw new ClassCastException("Number expected to be integer: " + d);
            }
            return i;
        }
        if (value2 instanceof String) {
            try {
                return Integer.parseInt((String)value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not an integer", value2, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not an integer", value2, key));
    }

    public static Long getNumberAsLong(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (value2 instanceof Double) {
            Double d = (Double)value2;
            long l = d.longValue();
            if ((double)l != d) {
                throw new ClassCastException("Number expected to be long: " + d);
            }
            return l;
        }
        if (value2 instanceof String) {
            try {
                return Long.parseLong((String)value2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a long integer", value2, key));
            }
        }
        throw new IllegalArgumentException(String.format("value '%s' for key '%s' is not a long integer", value2, key));
    }

    @Nullable
    public static String getString(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (!(value2 instanceof String)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not String", value2, key, obj));
        }
        return (String)value2;
    }

    public static Long getStringAsDuration(Map<String, ?> obj, String key) {
        String value2 = JsonUtil.getString(obj, key);
        if (value2 == null) {
            return null;
        }
        try {
            return JsonUtil.parseDuration(value2);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Boolean getBoolean(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value2 = obj.get(key);
        if (!(value2 instanceof Boolean)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Boolean", value2, key, obj));
        }
        return (Boolean)value2;
    }

    public static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format(Locale.US, "value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    public static List<String> checkStringList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof String) continue;
            throw new ClassCastException(String.format(Locale.US, "value '%s' for idx %d in '%s' is not string", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    private static long parseDuration(String value2) throws ParseException {
        int nanos;
        if (value2.isEmpty() || value2.charAt(value2.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + value2, 0);
        }
        boolean negative = false;
        if (value2.charAt(0) == '-') {
            negative = true;
            value2 = value2.substring(1);
        }
        String secondValue = value2.substring(0, value2.length() - 1);
        String nanoValue = "";
        int pointPosition = secondValue.indexOf(46);
        if (pointPosition != -1) {
            nanoValue = secondValue.substring(pointPosition + 1);
            secondValue = secondValue.substring(0, pointPosition);
        }
        long seconds = Long.parseLong(secondValue);
        int n = nanos = nanoValue.isEmpty() ? 0 : JsonUtil.parseNanos(nanoValue);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value2, 0);
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        try {
            return JsonUtil.normalizedDuration(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    private static int parseNanos(String value2) throws ParseException {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value2.length()) continue;
            if (value2.charAt(i) < '0' || value2.charAt(i) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            result += value2.charAt(i) - 48;
        }
        return result;
    }

    private static long normalizedDuration(long seconds, int nanos) {
        if ((long)nanos <= -NANOS_PER_SECOND || (long)nanos >= NANOS_PER_SECOND) {
            seconds = LongMath.checkedAdd(seconds, (long)nanos / NANOS_PER_SECOND);
            nanos = (int)((long)nanos % NANOS_PER_SECOND);
        }
        if (seconds > 0L && nanos < 0) {
            nanos = (int)((long)nanos + NANOS_PER_SECOND);
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos = (int)((long)nanos - NANOS_PER_SECOND);
            ++seconds;
        }
        if (!JsonUtil.durationIsValid(seconds, nanos)) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", seconds, nanos));
        }
        return JsonUtil.saturatedAdd(TimeUnit.SECONDS.toNanos(seconds), nanos);
    }

    private static boolean durationIsValid(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return false;
        }
        if ((long)nanos < -999999999L || (long)nanos >= NANOS_PER_SECOND) {
            return false;
        }
        return seconds >= 0L && nanos >= 0 || seconds <= 0L && nanos <= 0;
    }

    private static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }
}

