/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.internal.TemporaryBuffers;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JaegerPropagator
implements TextMapPropagator {
    private static final Logger logger = Logger.getLogger(JaegerPropagator.class.getName());
    static final String PROPAGATION_HEADER = "uber-trace-id";
    static final String BAGGAGE_HEADER = "jaeger-baggage";
    static final String BAGGAGE_PREFIX = "uberctx-";
    static final char DEPRECATED_PARENT_SPAN = '0';
    static final char PROPAGATION_HEADER_DELIMITER = ':';
    private static final int MAX_TRACE_ID_LENGTH = TraceId.getLength();
    private static final int MAX_SPAN_ID_LENGTH = SpanId.getLength();
    private static final int MAX_FLAGS_LENGTH = 2;
    private static final char IS_SAMPLED_CHAR = '1';
    private static final char NOT_SAMPLED_CHAR = '0';
    private static final int PROPAGATION_HEADER_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int PARENT_SPAN_ID_SIZE = 1;
    private static final int SAMPLED_FLAG_SIZE = 1;
    private static final int SPAN_ID_OFFSET = TRACE_ID_HEX_SIZE + 1;
    private static final int PARENT_SPAN_ID_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int SAMPLED_FLAG_OFFSET = PARENT_SPAN_ID_OFFSET + 1 + 1;
    private static final int PROPAGATION_HEADER_SIZE = SAMPLED_FLAG_OFFSET + 1;
    private static final Collection<String> FIELDS = Collections.singletonList("uber-trace-id");
    private static final JaegerPropagator INSTANCE = new JaegerPropagator();

    private JaegerPropagator() {
    }

    public static JaegerPropagator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null) {
            return;
        }
        if (setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (spanContext.isValid()) {
            JaegerPropagator.injectSpan(spanContext, carrier, setter);
        }
        JaegerPropagator.injectBaggage(Baggage.fromContext(context), carrier, setter);
    }

    private static <C> void injectSpan(SpanContext spanContext, @Nullable C carrier, TextMapSetter<C> setter) {
        char[] chars = TemporaryBuffers.chars(PROPAGATION_HEADER_SIZE);
        String traceId = spanContext.getTraceId();
        traceId.getChars(0, traceId.length(), chars, 0);
        chars[JaegerPropagator.SPAN_ID_OFFSET - 1] = 58;
        String spanId = spanContext.getSpanId();
        spanId.getChars(0, spanId.length(), chars, SPAN_ID_OFFSET);
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET - 1] = 58;
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET] = 48;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET - 1] = 58;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET] = spanContext.isSampled() ? 49 : 48;
        setter.set(carrier, PROPAGATION_HEADER, new String(chars, 0, PROPAGATION_HEADER_SIZE));
    }

    private static <C> void injectBaggage(Baggage baggage, @Nullable C carrier, TextMapSetter<C> setter) {
        baggage.forEach((key, baggageEntry) -> setter.set(carrier, BAGGAGE_PREFIX + key, baggageEntry.getValue()));
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        Baggage baggage;
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        SpanContext spanContext = JaegerPropagator.getSpanContextFromHeader(carrier, getter);
        if (spanContext.isValid()) {
            context = context.with(Span.wrap(spanContext));
        }
        if ((baggage = JaegerPropagator.getBaggageFromHeader(carrier, getter)) != null) {
            context = context.with(baggage);
        }
        return context;
    }

    public String toString() {
        return "JaegerPropagator";
    }

    private static <C> SpanContext getSpanContextFromHeader(@Nullable C carrier, TextMapGetter<C> getter) {
        String[] parts;
        String value2 = getter.get(carrier, PROPAGATION_HEADER);
        if (StringUtils.isNullOrEmpty(value2)) {
            return SpanContext.getInvalid();
        }
        if (value2.lastIndexOf(58) == -1) {
            try {
                value2 = URLDecoder.decode(value2, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.fine("Error decoding 'uber-trace-id' with value " + value2 + ". Returning INVALID span context.");
                return SpanContext.getInvalid();
            }
        }
        if ((parts = value2.split(String.valueOf(':'))).length != 4) {
            logger.fine("Invalid header 'uber-trace-id' with value " + value2 + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!JaegerPropagator.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in Jaeger header: 'uber-trace-id' with traceId " + traceId + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!JaegerPropagator.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String flags = parts[3];
        if (!JaegerPropagator.isFlagsValid(flags)) {
            logger.fine("Invalid Flags in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        return JaegerPropagator.buildSpanContext(traceId, spanId, flags);
    }

    @Nullable
    private static <C> Baggage getBaggageFromHeader(@Nullable C carrier, TextMapGetter<C> getter) {
        BaggageBuilder builder = null;
        List<String> keys2 = carrier != null ? getter.keys(carrier) : Collections.emptyList();
        for (String key : keys2) {
            String value2;
            if (key.startsWith(BAGGAGE_PREFIX)) {
                String value3;
                if (key.length() == BAGGAGE_PREFIX.length()) continue;
                if (builder == null) {
                    builder = Baggage.builder();
                }
                if ((value3 = getter.get(carrier, key)) == null) continue;
                builder.put(key.substring(BAGGAGE_PREFIX.length()), value3);
                continue;
            }
            if (!key.equals(BAGGAGE_HEADER) || (value2 = getter.get(carrier, key)) == null) continue;
            if (builder == null) {
                builder = Baggage.builder();
            }
            builder = JaegerPropagator.parseBaggageHeader(value2, builder);
        }
        return builder == null ? null : builder.build();
    }

    private static BaggageBuilder parseBaggageHeader(String header, BaggageBuilder builder) {
        for (String part : header.split("\\s*,\\s*")) {
            String[] kv = part.split("\\s*=\\s*");
            if (kv.length == 2) {
                builder.put(kv[0], kv[1]);
                continue;
            }
            logger.fine("malformed token in jaeger-baggage header: " + part);
        }
        return builder;
    }

    private static SpanContext buildSpanContext(String traceId, String spanId, String flags) {
        try {
            String otelTraceId = StringUtils.padLeft(traceId, MAX_TRACE_ID_LENGTH);
            String otelSpanId = StringUtils.padLeft(spanId, MAX_SPAN_ID_LENGTH);
            int flagsInt = Integer.parseInt(flags);
            return SpanContext.createFromRemoteParent(otelTraceId, otelSpanId, (flagsInt & 1) == 1 ? TraceFlags.getSampled() : TraceFlags.getDefault(), TraceState.getDefault());
        }
        catch (RuntimeException e) {
            logger.log(Level.FINE, "Error parsing 'uber-trace-id' header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    private static boolean isTraceIdValid(String value2) {
        return !StringUtils.isNullOrEmpty(value2) && value2.length() <= MAX_TRACE_ID_LENGTH;
    }

    private static boolean isSpanIdValid(String value2) {
        return !StringUtils.isNullOrEmpty(value2) && value2.length() <= MAX_SPAN_ID_LENGTH;
    }

    private static boolean isFlagsValid(String value2) {
        return !StringUtils.isNullOrEmpty(value2) && value2.length() <= 2;
    }
}

