/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.proto.trace.v1;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.common.v1.KeyValueOrBuilder;
import io.opentelemetry.proto.trace.v1.SpanOrBuilder;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.proto.trace.v1.StatusOrBuilder;
import io.opentelemetry.proto.trace.v1.TraceProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Span
extends GeneratedMessageV3
implements SpanOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TRACE_ID_FIELD_NUMBER = 1;
    private ByteString traceId_;
    public static final int SPAN_ID_FIELD_NUMBER = 2;
    private ByteString spanId_;
    public static final int TRACE_STATE_FIELD_NUMBER = 3;
    private volatile Object traceState_;
    public static final int PARENT_SPAN_ID_FIELD_NUMBER = 4;
    private ByteString parentSpanId_;
    public static final int NAME_FIELD_NUMBER = 5;
    private volatile Object name_;
    public static final int KIND_FIELD_NUMBER = 6;
    private int kind_;
    public static final int START_TIME_UNIX_NANO_FIELD_NUMBER = 7;
    private long startTimeUnixNano_;
    public static final int END_TIME_UNIX_NANO_FIELD_NUMBER = 8;
    private long endTimeUnixNano_;
    public static final int ATTRIBUTES_FIELD_NUMBER = 9;
    private List<KeyValue> attributes_;
    public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 10;
    private int droppedAttributesCount_;
    public static final int EVENTS_FIELD_NUMBER = 11;
    private List<Event> events_;
    public static final int DROPPED_EVENTS_COUNT_FIELD_NUMBER = 12;
    private int droppedEventsCount_;
    public static final int LINKS_FIELD_NUMBER = 13;
    private List<Link> links_;
    public static final int DROPPED_LINKS_COUNT_FIELD_NUMBER = 14;
    private int droppedLinksCount_;
    public static final int STATUS_FIELD_NUMBER = 15;
    private Status status_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Span DEFAULT_INSTANCE = new Span();
    private static final Parser<Span> PARSER = new AbstractParser<Span>(){

        @Override
        public Span parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Span(input, extensionRegistry);
        }
    };

    private Span(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Span() {
        this.traceId_ = ByteString.EMPTY;
        this.spanId_ = ByteString.EMPTY;
        this.traceState_ = "";
        this.parentSpanId_ = ByteString.EMPTY;
        this.name_ = "";
        this.kind_ = 0;
        this.attributes_ = Collections.emptyList();
        this.events_ = Collections.emptyList();
        this.links_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Span();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Span(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block24: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block24;
                    }
                    case 10: {
                        this.traceId_ = input.readBytes();
                        continue block24;
                    }
                    case 18: {
                        this.spanId_ = input.readBytes();
                        continue block24;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.traceState_ = s;
                        continue block24;
                    }
                    case 34: {
                        this.parentSpanId_ = input.readBytes();
                        continue block24;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block24;
                    }
                    case 48: {
                        int rawValue;
                        this.kind_ = rawValue = input.readEnum();
                        continue block24;
                    }
                    case 57: {
                        this.startTimeUnixNano_ = input.readFixed64();
                        continue block24;
                    }
                    case 65: {
                        this.endTimeUnixNano_ = input.readFixed64();
                        continue block24;
                    }
                    case 74: {
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.attributes_ = new ArrayList<KeyValue>();
                            mutable_bitField0_ |= 1;
                        }
                        this.attributes_.add(input.readMessage(KeyValue.parser(), extensionRegistry));
                        continue block24;
                    }
                    case 80: {
                        this.droppedAttributesCount_ = input.readUInt32();
                        continue block24;
                    }
                    case 90: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.events_ = new ArrayList<Event>();
                            mutable_bitField0_ |= 2;
                        }
                        this.events_.add(input.readMessage(Event.parser(), extensionRegistry));
                        continue block24;
                    }
                    case 96: {
                        this.droppedEventsCount_ = input.readUInt32();
                        continue block24;
                    }
                    case 106: {
                        if ((mutable_bitField0_ & 4) == 0) {
                            this.links_ = new ArrayList<Link>();
                            mutable_bitField0_ |= 4;
                        }
                        this.links_.add(input.readMessage(Link.parser(), extensionRegistry));
                        continue block24;
                    }
                    case 112: {
                        this.droppedLinksCount_ = input.readUInt32();
                        continue block24;
                    }
                    case 122: {
                        Status.Builder subBuilder = null;
                        if (this.status_ != null) {
                            subBuilder = this.status_.toBuilder();
                        }
                        this.status_ = input.readMessage(Status.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.status_);
                        this.status_ = subBuilder.buildPartial();
                        continue block24;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.attributes_ = Collections.unmodifiableList(this.attributes_);
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.events_ = Collections.unmodifiableList(this.events_);
            }
            if ((mutable_bitField0_ & 4) != 0) {
                this.links_ = Collections.unmodifiableList(this.links_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_fieldAccessorTable.ensureFieldAccessorsInitialized(Span.class, Builder.class);
    }

    @Override
    public ByteString getTraceId() {
        return this.traceId_;
    }

    @Override
    public ByteString getSpanId() {
        return this.spanId_;
    }

    @Override
    public String getTraceState() {
        Object ref = this.traceState_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.traceState_ = s;
        return s;
    }

    @Override
    public ByteString getTraceStateBytes() {
        Object ref = this.traceState_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.traceState_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public ByteString getParentSpanId() {
        return this.parentSpanId_;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getKindValue() {
        return this.kind_;
    }

    @Override
    public SpanKind getKind() {
        SpanKind result = SpanKind.valueOf(this.kind_);
        return result == null ? SpanKind.UNRECOGNIZED : result;
    }

    @Override
    public long getStartTimeUnixNano() {
        return this.startTimeUnixNano_;
    }

    @Override
    public long getEndTimeUnixNano() {
        return this.endTimeUnixNano_;
    }

    @Override
    public List<KeyValue> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public KeyValue getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public KeyValueOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public int getDroppedAttributesCount() {
        return this.droppedAttributesCount_;
    }

    @Override
    public List<Event> getEventsList() {
        return this.events_;
    }

    @Override
    public List<? extends EventOrBuilder> getEventsOrBuilderList() {
        return this.events_;
    }

    @Override
    public int getEventsCount() {
        return this.events_.size();
    }

    @Override
    public Event getEvents(int index) {
        return this.events_.get(index);
    }

    @Override
    public EventOrBuilder getEventsOrBuilder(int index) {
        return this.events_.get(index);
    }

    @Override
    public int getDroppedEventsCount() {
        return this.droppedEventsCount_;
    }

    @Override
    public List<Link> getLinksList() {
        return this.links_;
    }

    @Override
    public List<? extends LinkOrBuilder> getLinksOrBuilderList() {
        return this.links_;
    }

    @Override
    public int getLinksCount() {
        return this.links_.size();
    }

    @Override
    public Link getLinks(int index) {
        return this.links_.get(index);
    }

    @Override
    public LinkOrBuilder getLinksOrBuilder(int index) {
        return this.links_.get(index);
    }

    @Override
    public int getDroppedLinksCount() {
        return this.droppedLinksCount_;
    }

    @Override
    public boolean hasStatus() {
        return this.status_ != null;
    }

    @Override
    public Status getStatus() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public StatusOrBuilder getStatusOrBuilder() {
        return this.getStatus();
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!this.traceId_.isEmpty()) {
            output.writeBytes(1, this.traceId_);
        }
        if (!this.spanId_.isEmpty()) {
            output.writeBytes(2, this.spanId_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.traceState_)) {
            GeneratedMessageV3.writeString(output, 3, this.traceState_);
        }
        if (!this.parentSpanId_.isEmpty()) {
            output.writeBytes(4, this.parentSpanId_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            GeneratedMessageV3.writeString(output, 5, this.name_);
        }
        if (this.kind_ != SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.kind_);
        }
        if (this.startTimeUnixNano_ != 0L) {
            output.writeFixed64(7, this.startTimeUnixNano_);
        }
        if (this.endTimeUnixNano_ != 0L) {
            output.writeFixed64(8, this.endTimeUnixNano_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(9, this.attributes_.get(i));
        }
        if (this.droppedAttributesCount_ != 0) {
            output.writeUInt32(10, this.droppedAttributesCount_);
        }
        for (i = 0; i < this.events_.size(); ++i) {
            output.writeMessage(11, this.events_.get(i));
        }
        if (this.droppedEventsCount_ != 0) {
            output.writeUInt32(12, this.droppedEventsCount_);
        }
        for (i = 0; i < this.links_.size(); ++i) {
            output.writeMessage(13, this.links_.get(i));
        }
        if (this.droppedLinksCount_ != 0) {
            output.writeUInt32(14, this.droppedLinksCount_);
        }
        if (this.status_ != null) {
            output.writeMessage(15, this.getStatus());
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.traceId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(1, this.traceId_);
        }
        if (!this.spanId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(2, this.spanId_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.traceState_)) {
            size += GeneratedMessageV3.computeStringSize(3, this.traceState_);
        }
        if (!this.parentSpanId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(4, this.parentSpanId_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            size += GeneratedMessageV3.computeStringSize(5, this.name_);
        }
        if (this.kind_ != SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(6, this.kind_);
        }
        if (this.startTimeUnixNano_ != 0L) {
            size += CodedOutputStream.computeFixed64Size(7, this.startTimeUnixNano_);
        }
        if (this.endTimeUnixNano_ != 0L) {
            size += CodedOutputStream.computeFixed64Size(8, this.endTimeUnixNano_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(9, this.attributes_.get(i));
        }
        if (this.droppedAttributesCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size(10, this.droppedAttributesCount_);
        }
        for (i = 0; i < this.events_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(11, this.events_.get(i));
        }
        if (this.droppedEventsCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size(12, this.droppedEventsCount_);
        }
        for (i = 0; i < this.links_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(13, this.links_.get(i));
        }
        if (this.droppedLinksCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size(14, this.droppedLinksCount_);
        }
        if (this.status_ != null) {
            size += CodedOutputStream.computeMessageSize(15, this.getStatus());
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Span)) {
            return super.equals(obj);
        }
        Span other = (Span)obj;
        if (!this.getTraceId().equals(other.getTraceId())) {
            return false;
        }
        if (!this.getSpanId().equals(other.getSpanId())) {
            return false;
        }
        if (!this.getTraceState().equals(other.getTraceState())) {
            return false;
        }
        if (!this.getParentSpanId().equals(other.getParentSpanId())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.kind_ != other.kind_) {
            return false;
        }
        if (this.getStartTimeUnixNano() != other.getStartTimeUnixNano()) {
            return false;
        }
        if (this.getEndTimeUnixNano() != other.getEndTimeUnixNano()) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
            return false;
        }
        if (!this.getEventsList().equals(other.getEventsList())) {
            return false;
        }
        if (this.getDroppedEventsCount() != other.getDroppedEventsCount()) {
            return false;
        }
        if (!this.getLinksList().equals(other.getLinksList())) {
            return false;
        }
        if (this.getDroppedLinksCount() != other.getDroppedLinksCount()) {
            return false;
        }
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && !this.getStatus().equals(other.getStatus())) {
            return false;
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Span.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTraceId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getSpanId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getTraceState().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getParentSpanId().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.kind_;
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong(this.getStartTimeUnixNano());
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashLong(this.getEndTimeUnixNano());
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getDroppedAttributesCount();
        if (this.getEventsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getEventsList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getDroppedEventsCount();
        if (this.getLinksCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getLinksList().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + this.getDroppedLinksCount();
        if (this.hasStatus()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getStatus().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static Span parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Span parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Span parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Span parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static Span parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static Span parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static Span parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static Span parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static Span parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return Span.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Span prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Span getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Span> parser() {
        return PARSER;
    }

    public Parser<Span> getParserForType() {
        return PARSER;
    }

    @Override
    public Span getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Event
    extends GeneratedMessageV3
    implements EventOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TIME_UNIX_NANO_FIELD_NUMBER = 1;
        private long timeUnixNano_;
        public static final int NAME_FIELD_NUMBER = 2;
        private volatile Object name_;
        public static final int ATTRIBUTES_FIELD_NUMBER = 3;
        private List<KeyValue> attributes_;
        public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 4;
        private int droppedAttributesCount_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Event DEFAULT_INSTANCE = new Event();
        private static final Parser<Event> PARSER = new AbstractParser<Event>(){

            @Override
            public Event parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new Event(input, extensionRegistry);
            }
        };

        private Event(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Event() {
            this.name_ = "";
            this.attributes_ = Collections.emptyList();
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Event();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private Event(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            boolean mutable_bitField0_ = false;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 9: {
                            this.timeUnixNano_ = input.readFixed64();
                            continue block13;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.name_ = s;
                            continue block13;
                        }
                        case 26: {
                            if (!(mutable_bitField0_ & true)) {
                                this.attributes_ = new ArrayList<KeyValue>();
                                mutable_bitField0_ |= true;
                            }
                            this.attributes_.add(input.readMessage(KeyValue.parser(), extensionRegistry));
                            continue block13;
                        }
                        case 32: {
                            this.droppedAttributesCount_ = input.readUInt32();
                            continue block13;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
            }
            finally {
                if (mutable_bitField0_ & true) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                }
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
        }

        @Override
        public long getTimeUnixNano() {
            return this.timeUnixNano_;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.name_ = s;
            return s;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<KeyValue> getAttributesList() {
            return this.attributes_;
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            return this.attributes_;
        }

        @Override
        public int getAttributesCount() {
            return this.attributes_.size();
        }

        @Override
        public KeyValue getAttributes(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.timeUnixNano_ != 0L) {
                output.writeFixed64(1, this.timeUnixNano_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
                GeneratedMessageV3.writeString(output, 2, this.name_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                output.writeMessage(3, this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                output.writeUInt32(4, this.droppedAttributesCount_);
            }
            this.unknownFields.writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.timeUnixNano_ != 0L) {
                size += CodedOutputStream.computeFixed64Size(1, this.timeUnixNano_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
                size += GeneratedMessageV3.computeStringSize(2, this.name_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize(3, this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                size += CodedOutputStream.computeUInt32Size(4, this.droppedAttributesCount_);
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Event)) {
                return super.equals(obj);
            }
            Event other = (Event)obj;
            if (this.getTimeUnixNano() != other.getTimeUnixNano()) {
                return false;
            }
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (!this.getAttributesList().equals(other.getAttributesList())) {
                return false;
            }
            if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
                return false;
            }
            return this.unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Event.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashLong(this.getTimeUnixNano());
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getName().hashCode();
            if (this.getAttributesCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getAttributesList().hashCode();
            }
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getDroppedAttributesCount();
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static Event parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Event parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Event parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Event parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static Event parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static Event parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static Event parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static Event parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static Event parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return Event.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Event prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Event getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Event> parser() {
            return PARSER;
        }

        public Parser<Event> getParserForType() {
            return PARSER;
        }

        @Override
        public Event getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements EventOrBuilder {
            private int bitField0_;
            private long timeUnixNano_;
            private Object name_ = "";
            private List<KeyValue> attributes_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
            private int droppedAttributesCount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getAttributesFieldBuilder();
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.timeUnixNano_ = 0L;
                this.name_ = "";
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.attributesBuilder_.clear();
                }
                this.droppedAttributesCount_ = 0;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
            }

            @Override
            public Event getDefaultInstanceForType() {
                return Event.getDefaultInstance();
            }

            @Override
            public Event build() {
                Event result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public Event buildPartial() {
                Event result = new Event(this);
                int from_bitField0_ = this.bitField0_;
                result.timeUnixNano_ = this.timeUnixNano_;
                result.name_ = this.name_;
                if (this.attributesBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0) {
                        this.attributes_ = Collections.unmodifiableList(this.attributes_);
                        this.bitField0_ &= 0xFFFFFFFE;
                    }
                    result.attributes_ = this.attributes_;
                } else {
                    result.attributes_ = this.attributesBuilder_.build();
                }
                result.droppedAttributesCount_ = this.droppedAttributesCount_;
                this.onBuilt();
                return result;
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value2) {
                return (Builder)super.setField(field, value2);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value2) {
                return (Builder)super.setRepeatedField(field, index, value2);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
                return (Builder)super.addRepeatedField(field, value2);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof Event) {
                    return this.mergeFrom((Event)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Event other) {
                if (other == Event.getDefaultInstance()) {
                    return this;
                }
                if (other.getTimeUnixNano() != 0L) {
                    this.setTimeUnixNano(other.getTimeUnixNano());
                }
                if (!other.getName().isEmpty()) {
                    this.name_ = other.name_;
                    this.onChanged();
                }
                if (this.attributesBuilder_ == null) {
                    if (!other.attributes_.isEmpty()) {
                        if (this.attributes_.isEmpty()) {
                            this.attributes_ = other.attributes_;
                            this.bitField0_ &= 0xFFFFFFFE;
                        } else {
                            this.ensureAttributesIsMutable();
                            this.attributes_.addAll(other.attributes_);
                        }
                        this.onChanged();
                    }
                } else if (!other.attributes_.isEmpty()) {
                    if (this.attributesBuilder_.isEmpty()) {
                        this.attributesBuilder_.dispose();
                        this.attributesBuilder_ = null;
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                    } else {
                        this.attributesBuilder_.addAllMessages(other.attributes_);
                    }
                }
                if (other.getDroppedAttributesCount() != 0) {
                    this.setDroppedAttributesCount(other.getDroppedAttributesCount());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                Event parsedMessage = null;
                try {
                    parsedMessage = (Event)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (Event)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public long getTimeUnixNano() {
                return this.timeUnixNano_;
            }

            public Builder setTimeUnixNano(long value2) {
                this.timeUnixNano_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearTimeUnixNano() {
                this.timeUnixNano_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public String getName() {
                Object ref = this.name_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.name_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNameBytes() {
                Object ref = this.name_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.name_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setName(String value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.name_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearName() {
                this.name_ = Event.getDefaultInstance().getName();
                this.onChanged();
                return this;
            }

            public Builder setNameBytes(ByteString value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                Event.checkByteStringIsUtf8(value2);
                this.name_ = value2;
                this.onChanged();
                return this;
            }

            private void ensureAttributesIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<KeyValue> getAttributesList() {
                if (this.attributesBuilder_ == null) {
                    return Collections.unmodifiableList(this.attributes_);
                }
                return this.attributesBuilder_.getMessageList();
            }

            @Override
            public int getAttributesCount() {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.size();
                }
                return this.attributesBuilder_.getCount();
            }

            @Override
            public KeyValue getAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return this.attributesBuilder_.getMessage(index);
            }

            public Builder setAttributes(int index, KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, value2);
                }
                return this;
            }

            public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(value2);
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, value2);
                }
                return this;
            }

            public Builder addAttributes(KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAllAttributes(Iterable<? extends KeyValue> values2) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    AbstractMessageLite.Builder.addAll(values2, this.attributes_);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addAllMessages(values2);
                }
                return this;
            }

            public Builder clearAttributes() {
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                } else {
                    this.attributesBuilder_.clear();
                }
                return this;
            }

            public Builder removeAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.remove(index);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.remove(index);
                }
                return this;
            }

            public KeyValue.Builder getAttributesBuilder(int index) {
                return this.getAttributesFieldBuilder().getBuilder(index);
            }

            @Override
            public KeyValueOrBuilder getAttributesOrBuilder(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return this.attributesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
                if (this.attributesBuilder_ != null) {
                    return this.attributesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.attributes_);
            }

            public KeyValue.Builder addAttributesBuilder() {
                return this.getAttributesFieldBuilder().addBuilder(KeyValue.getDefaultInstance());
            }

            public KeyValue.Builder addAttributesBuilder(int index) {
                return this.getAttributesFieldBuilder().addBuilder(index, KeyValue.getDefaultInstance());
            }

            public List<KeyValue.Builder> getAttributesBuilderList() {
                return this.getAttributesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> getAttributesFieldBuilder() {
                if (this.attributesBuilder_ == null) {
                    this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                    this.attributes_ = null;
                }
                return this.attributesBuilder_;
            }

            @Override
            public int getDroppedAttributesCount() {
                return this.droppedAttributesCount_;
            }

            public Builder setDroppedAttributesCount(int value2) {
                this.droppedAttributesCount_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearDroppedAttributesCount() {
                this.droppedAttributesCount_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class Link
    extends GeneratedMessageV3
    implements LinkOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TRACE_ID_FIELD_NUMBER = 1;
        private ByteString traceId_;
        public static final int SPAN_ID_FIELD_NUMBER = 2;
        private ByteString spanId_;
        public static final int TRACE_STATE_FIELD_NUMBER = 3;
        private volatile Object traceState_;
        public static final int ATTRIBUTES_FIELD_NUMBER = 4;
        private List<KeyValue> attributes_;
        public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 5;
        private int droppedAttributesCount_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Link DEFAULT_INSTANCE = new Link();
        private static final Parser<Link> PARSER = new AbstractParser<Link>(){

            @Override
            public Link parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new Link(input, extensionRegistry);
            }
        };

        private Link(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Link() {
            this.traceId_ = ByteString.EMPTY;
            this.spanId_ = ByteString.EMPTY;
            this.traceState_ = "";
            this.attributes_ = Collections.emptyList();
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Link();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private Link(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            boolean mutable_bitField0_ = false;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 10: {
                            this.traceId_ = input.readBytes();
                            continue block14;
                        }
                        case 18: {
                            this.spanId_ = input.readBytes();
                            continue block14;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.traceState_ = s;
                            continue block14;
                        }
                        case 34: {
                            if (!(mutable_bitField0_ & true)) {
                                this.attributes_ = new ArrayList<KeyValue>();
                                mutable_bitField0_ |= true;
                            }
                            this.attributes_.add(input.readMessage(KeyValue.parser(), extensionRegistry));
                            continue block14;
                        }
                        case 40: {
                            this.droppedAttributesCount_ = input.readUInt32();
                            continue block14;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
            }
            finally {
                if (mutable_bitField0_ & true) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                }
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_fieldAccessorTable.ensureFieldAccessorsInitialized(Link.class, Builder.class);
        }

        @Override
        public ByteString getTraceId() {
            return this.traceId_;
        }

        @Override
        public ByteString getSpanId() {
            return this.spanId_;
        }

        @Override
        public String getTraceState() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.traceState_ = s;
            return s;
        }

        @Override
        public ByteString getTraceStateBytes() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.traceState_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<KeyValue> getAttributesList() {
            return this.attributes_;
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            return this.attributes_;
        }

        @Override
        public int getAttributesCount() {
            return this.attributes_.size();
        }

        @Override
        public KeyValue getAttributes(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (!this.traceId_.isEmpty()) {
                output.writeBytes(1, this.traceId_);
            }
            if (!this.spanId_.isEmpty()) {
                output.writeBytes(2, this.spanId_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.traceState_)) {
                GeneratedMessageV3.writeString(output, 3, this.traceState_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                output.writeMessage(4, this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                output.writeUInt32(5, this.droppedAttributesCount_);
            }
            this.unknownFields.writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!this.traceId_.isEmpty()) {
                size += CodedOutputStream.computeBytesSize(1, this.traceId_);
            }
            if (!this.spanId_.isEmpty()) {
                size += CodedOutputStream.computeBytesSize(2, this.spanId_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.traceState_)) {
                size += GeneratedMessageV3.computeStringSize(3, this.traceState_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize(4, this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                size += CodedOutputStream.computeUInt32Size(5, this.droppedAttributesCount_);
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Link)) {
                return super.equals(obj);
            }
            Link other = (Link)obj;
            if (!this.getTraceId().equals(other.getTraceId())) {
                return false;
            }
            if (!this.getSpanId().equals(other.getSpanId())) {
                return false;
            }
            if (!this.getTraceState().equals(other.getTraceState())) {
                return false;
            }
            if (!this.getAttributesList().equals(other.getAttributesList())) {
                return false;
            }
            if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
                return false;
            }
            return this.unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Link.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTraceId().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getSpanId().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getTraceState().hashCode();
            if (this.getAttributesCount() > 0) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getAttributesList().hashCode();
            }
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDroppedAttributesCount();
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static Link parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Link parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Link parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static Link parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static Link parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static Link parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static Link parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static Link parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static Link parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return Link.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Link prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Link getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Link> parser() {
            return PARSER;
        }

        public Parser<Link> getParserForType() {
            return PARSER;
        }

        @Override
        public Link getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LinkOrBuilder {
            private int bitField0_;
            private ByteString traceId_ = ByteString.EMPTY;
            private ByteString spanId_ = ByteString.EMPTY;
            private Object traceState_ = "";
            private List<KeyValue> attributes_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
            private int droppedAttributesCount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_fieldAccessorTable.ensureFieldAccessorsInitialized(Link.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getAttributesFieldBuilder();
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.traceId_ = ByteString.EMPTY;
                this.spanId_ = ByteString.EMPTY;
                this.traceState_ = "";
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.attributesBuilder_.clear();
                }
                this.droppedAttributesCount_ = 0;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
            }

            @Override
            public Link getDefaultInstanceForType() {
                return Link.getDefaultInstance();
            }

            @Override
            public Link build() {
                Link result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public Link buildPartial() {
                Link result = new Link(this);
                int from_bitField0_ = this.bitField0_;
                result.traceId_ = this.traceId_;
                result.spanId_ = this.spanId_;
                result.traceState_ = this.traceState_;
                if (this.attributesBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0) {
                        this.attributes_ = Collections.unmodifiableList(this.attributes_);
                        this.bitField0_ &= 0xFFFFFFFE;
                    }
                    result.attributes_ = this.attributes_;
                } else {
                    result.attributes_ = this.attributesBuilder_.build();
                }
                result.droppedAttributesCount_ = this.droppedAttributesCount_;
                this.onBuilt();
                return result;
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value2) {
                return (Builder)super.setField(field, value2);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value2) {
                return (Builder)super.setRepeatedField(field, index, value2);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
                return (Builder)super.addRepeatedField(field, value2);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof Link) {
                    return this.mergeFrom((Link)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Link other) {
                if (other == Link.getDefaultInstance()) {
                    return this;
                }
                if (other.getTraceId() != ByteString.EMPTY) {
                    this.setTraceId(other.getTraceId());
                }
                if (other.getSpanId() != ByteString.EMPTY) {
                    this.setSpanId(other.getSpanId());
                }
                if (!other.getTraceState().isEmpty()) {
                    this.traceState_ = other.traceState_;
                    this.onChanged();
                }
                if (this.attributesBuilder_ == null) {
                    if (!other.attributes_.isEmpty()) {
                        if (this.attributes_.isEmpty()) {
                            this.attributes_ = other.attributes_;
                            this.bitField0_ &= 0xFFFFFFFE;
                        } else {
                            this.ensureAttributesIsMutable();
                            this.attributes_.addAll(other.attributes_);
                        }
                        this.onChanged();
                    }
                } else if (!other.attributes_.isEmpty()) {
                    if (this.attributesBuilder_.isEmpty()) {
                        this.attributesBuilder_.dispose();
                        this.attributesBuilder_ = null;
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                    } else {
                        this.attributesBuilder_.addAllMessages(other.attributes_);
                    }
                }
                if (other.getDroppedAttributesCount() != 0) {
                    this.setDroppedAttributesCount(other.getDroppedAttributesCount());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                Link parsedMessage = null;
                try {
                    parsedMessage = (Link)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (Link)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public ByteString getTraceId() {
                return this.traceId_;
            }

            public Builder setTraceId(ByteString value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.traceId_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearTraceId() {
                this.traceId_ = Link.getDefaultInstance().getTraceId();
                this.onChanged();
                return this;
            }

            @Override
            public ByteString getSpanId() {
                return this.spanId_;
            }

            public Builder setSpanId(ByteString value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.spanId_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearSpanId() {
                this.spanId_ = Link.getDefaultInstance().getSpanId();
                this.onChanged();
                return this;
            }

            @Override
            public String getTraceState() {
                Object ref = this.traceState_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.traceState_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getTraceStateBytes() {
                Object ref = this.traceState_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.traceState_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setTraceState(String value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.traceState_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearTraceState() {
                this.traceState_ = Link.getDefaultInstance().getTraceState();
                this.onChanged();
                return this;
            }

            public Builder setTraceStateBytes(ByteString value2) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                Link.checkByteStringIsUtf8(value2);
                this.traceState_ = value2;
                this.onChanged();
                return this;
            }

            private void ensureAttributesIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<KeyValue> getAttributesList() {
                if (this.attributesBuilder_ == null) {
                    return Collections.unmodifiableList(this.attributes_);
                }
                return this.attributesBuilder_.getMessageList();
            }

            @Override
            public int getAttributesCount() {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.size();
                }
                return this.attributesBuilder_.getCount();
            }

            @Override
            public KeyValue getAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return this.attributesBuilder_.getMessage(index);
            }

            public Builder setAttributes(int index, KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, value2);
                }
                return this;
            }

            public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(value2);
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue value2) {
                if (this.attributesBuilder_ == null) {
                    if (value2 == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, value2);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, value2);
                }
                return this;
            }

            public Builder addAttributes(KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAllAttributes(Iterable<? extends KeyValue> values2) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    AbstractMessageLite.Builder.addAll(values2, this.attributes_);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addAllMessages(values2);
                }
                return this;
            }

            public Builder clearAttributes() {
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                } else {
                    this.attributesBuilder_.clear();
                }
                return this;
            }

            public Builder removeAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.remove(index);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.remove(index);
                }
                return this;
            }

            public KeyValue.Builder getAttributesBuilder(int index) {
                return this.getAttributesFieldBuilder().getBuilder(index);
            }

            @Override
            public KeyValueOrBuilder getAttributesOrBuilder(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return this.attributesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
                if (this.attributesBuilder_ != null) {
                    return this.attributesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.attributes_);
            }

            public KeyValue.Builder addAttributesBuilder() {
                return this.getAttributesFieldBuilder().addBuilder(KeyValue.getDefaultInstance());
            }

            public KeyValue.Builder addAttributesBuilder(int index) {
                return this.getAttributesFieldBuilder().addBuilder(index, KeyValue.getDefaultInstance());
            }

            public List<KeyValue.Builder> getAttributesBuilderList() {
                return this.getAttributesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> getAttributesFieldBuilder() {
                if (this.attributesBuilder_ == null) {
                    this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                    this.attributes_ = null;
                }
                return this.attributesBuilder_;
            }

            @Override
            public int getDroppedAttributesCount() {
                return this.droppedAttributesCount_;
            }

            public Builder setDroppedAttributesCount(int value2) {
                this.droppedAttributesCount_ = value2;
                this.onChanged();
                return this;
            }

            public Builder clearDroppedAttributesCount() {
                this.droppedAttributesCount_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SpanOrBuilder {
        private int bitField0_;
        private ByteString traceId_ = ByteString.EMPTY;
        private ByteString spanId_ = ByteString.EMPTY;
        private Object traceState_ = "";
        private ByteString parentSpanId_ = ByteString.EMPTY;
        private Object name_ = "";
        private int kind_ = 0;
        private long startTimeUnixNano_;
        private long endTimeUnixNano_;
        private List<KeyValue> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
        private int droppedAttributesCount_;
        private List<Event> events_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Event, Event.Builder, EventOrBuilder> eventsBuilder_;
        private int droppedEventsCount_;
        private List<Link> links_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Link, Link.Builder, LinkOrBuilder> linksBuilder_;
        private int droppedLinksCount_;
        private Status status_;
        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> statusBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_fieldAccessorTable.ensureFieldAccessorsInitialized(Span.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAttributesFieldBuilder();
                this.getEventsFieldBuilder();
                this.getLinksFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.traceId_ = ByteString.EMPTY;
            this.spanId_ = ByteString.EMPTY;
            this.traceState_ = "";
            this.parentSpanId_ = ByteString.EMPTY;
            this.name_ = "";
            this.kind_ = 0;
            this.startTimeUnixNano_ = 0L;
            this.endTimeUnixNano_ = 0L;
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.attributesBuilder_.clear();
            }
            this.droppedAttributesCount_ = 0;
            if (this.eventsBuilder_ == null) {
                this.events_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.eventsBuilder_.clear();
            }
            this.droppedEventsCount_ = 0;
            if (this.linksBuilder_ == null) {
                this.links_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
            } else {
                this.linksBuilder_.clear();
            }
            this.droppedLinksCount_ = 0;
            if (this.statusBuilder_ == null) {
                this.status_ = null;
            } else {
                this.status_ = null;
                this.statusBuilder_ = null;
            }
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
        }

        @Override
        public Span getDefaultInstanceForType() {
            return Span.getDefaultInstance();
        }

        @Override
        public Span build() {
            Span result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public Span buildPartial() {
            Span result = new Span(this);
            int from_bitField0_ = this.bitField0_;
            result.traceId_ = this.traceId_;
            result.spanId_ = this.spanId_;
            result.traceState_ = this.traceState_;
            result.parentSpanId_ = this.parentSpanId_;
            result.name_ = this.name_;
            result.kind_ = this.kind_;
            result.startTimeUnixNano_ = this.startTimeUnixNano_;
            result.endTimeUnixNano_ = this.endTimeUnixNano_;
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
            result.droppedAttributesCount_ = this.droppedAttributesCount_;
            if (this.eventsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.events_ = Collections.unmodifiableList(this.events_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.events_ = this.events_;
            } else {
                result.events_ = this.eventsBuilder_.build();
            }
            result.droppedEventsCount_ = this.droppedEventsCount_;
            if (this.linksBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.links_ = Collections.unmodifiableList(this.links_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.links_ = this.links_;
            } else {
                result.links_ = this.linksBuilder_.build();
            }
            result.droppedLinksCount_ = this.droppedLinksCount_;
            if (this.statusBuilder_ == null) {
                result.status_ = this.status_;
            } else {
                result.status_ = this.statusBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value2) {
            return (Builder)super.setField(field, value2);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value2) {
            return (Builder)super.setRepeatedField(field, index, value2);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
            return (Builder)super.addRepeatedField(field, value2);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof Span) {
                return this.mergeFrom((Span)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Span other) {
            if (other == Span.getDefaultInstance()) {
                return this;
            }
            if (other.getTraceId() != ByteString.EMPTY) {
                this.setTraceId(other.getTraceId());
            }
            if (other.getSpanId() != ByteString.EMPTY) {
                this.setSpanId(other.getSpanId());
            }
            if (!other.getTraceState().isEmpty()) {
                this.traceState_ = other.traceState_;
                this.onChanged();
            }
            if (other.getParentSpanId() != ByteString.EMPTY) {
                this.setParentSpanId(other.getParentSpanId());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (other.kind_ != 0) {
                this.setKindValue(other.getKindValue());
            }
            if (other.getStartTimeUnixNano() != 0L) {
                this.setStartTimeUnixNano(other.getStartTimeUnixNano());
            }
            if (other.getEndTimeUnixNano() != 0L) {
                this.setEndTimeUnixNano(other.getEndTimeUnixNano());
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages(other.attributes_);
                }
            }
            if (other.getDroppedAttributesCount() != 0) {
                this.setDroppedAttributesCount(other.getDroppedAttributesCount());
            }
            if (this.eventsBuilder_ == null) {
                if (!other.events_.isEmpty()) {
                    if (this.events_.isEmpty()) {
                        this.events_ = other.events_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureEventsIsMutable();
                        this.events_.addAll(other.events_);
                    }
                    this.onChanged();
                }
            } else if (!other.events_.isEmpty()) {
                if (this.eventsBuilder_.isEmpty()) {
                    this.eventsBuilder_.dispose();
                    this.eventsBuilder_ = null;
                    this.events_ = other.events_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.eventsBuilder_ = alwaysUseFieldBuilders ? this.getEventsFieldBuilder() : null;
                } else {
                    this.eventsBuilder_.addAllMessages(other.events_);
                }
            }
            if (other.getDroppedEventsCount() != 0) {
                this.setDroppedEventsCount(other.getDroppedEventsCount());
            }
            if (this.linksBuilder_ == null) {
                if (!other.links_.isEmpty()) {
                    if (this.links_.isEmpty()) {
                        this.links_ = other.links_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureLinksIsMutable();
                        this.links_.addAll(other.links_);
                    }
                    this.onChanged();
                }
            } else if (!other.links_.isEmpty()) {
                if (this.linksBuilder_.isEmpty()) {
                    this.linksBuilder_.dispose();
                    this.linksBuilder_ = null;
                    this.links_ = other.links_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.linksBuilder_ = alwaysUseFieldBuilders ? this.getLinksFieldBuilder() : null;
                } else {
                    this.linksBuilder_.addAllMessages(other.links_);
                }
            }
            if (other.getDroppedLinksCount() != 0) {
                this.setDroppedLinksCount(other.getDroppedLinksCount());
            }
            if (other.hasStatus()) {
                this.mergeStatus(other.getStatus());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Span parsedMessage = null;
            try {
                parsedMessage = (Span)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Span)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public ByteString getTraceId() {
            return this.traceId_;
        }

        public Builder setTraceId(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.traceId_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearTraceId() {
            this.traceId_ = Span.getDefaultInstance().getTraceId();
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getSpanId() {
            return this.spanId_;
        }

        public Builder setSpanId(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.spanId_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearSpanId() {
            this.spanId_ = Span.getDefaultInstance().getSpanId();
            this.onChanged();
            return this;
        }

        @Override
        public String getTraceState() {
            Object ref = this.traceState_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.traceState_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTraceStateBytes() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.traceState_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTraceState(String value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.traceState_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearTraceState() {
            this.traceState_ = Span.getDefaultInstance().getTraceState();
            this.onChanged();
            return this;
        }

        public Builder setTraceStateBytes(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            Span.checkByteStringIsUtf8(value2);
            this.traceState_ = value2;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getParentSpanId() {
            return this.parentSpanId_;
        }

        public Builder setParentSpanId(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.parentSpanId_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearParentSpanId() {
            this.parentSpanId_ = Span.getDefaultInstance().getParentSpanId();
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.name_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Span.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            Span.checkByteStringIsUtf8(value2);
            this.name_ = value2;
            this.onChanged();
            return this;
        }

        @Override
        public int getKindValue() {
            return this.kind_;
        }

        public Builder setKindValue(int value2) {
            this.kind_ = value2;
            this.onChanged();
            return this;
        }

        @Override
        public SpanKind getKind() {
            SpanKind result = SpanKind.valueOf(this.kind_);
            return result == null ? SpanKind.UNRECOGNIZED : result;
        }

        public Builder setKind(SpanKind value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.kind_ = value2.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKind() {
            this.kind_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getStartTimeUnixNano() {
            return this.startTimeUnixNano_;
        }

        public Builder setStartTimeUnixNano(long value2) {
            this.startTimeUnixNano_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearStartTimeUnixNano() {
            this.startTimeUnixNano_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getEndTimeUnixNano() {
            return this.endTimeUnixNano_;
        }

        public Builder setEndTimeUnixNano(long value2) {
            this.endTimeUnixNano_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearEndTimeUnixNano() {
            this.endTimeUnixNano_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<KeyValue> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public KeyValue getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, KeyValue value2) {
            if (this.attributesBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value2);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, value2);
            }
            return this;
        }

        public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(KeyValue value2) {
            if (this.attributesBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value2);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(value2);
            }
            return this;
        }

        public Builder addAttributes(int index, KeyValue value2) {
            if (this.attributesBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value2);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, value2);
            }
            return this;
        }

        public Builder addAttributes(KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends KeyValue> values2) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public KeyValue.Builder getAttributesBuilder(int index) {
            return this.getAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public KeyValue.Builder addAttributesBuilder() {
            return this.getAttributesFieldBuilder().addBuilder(KeyValue.getDefaultInstance());
        }

        public KeyValue.Builder addAttributesBuilder(int index) {
            return this.getAttributesFieldBuilder().addBuilder(index, KeyValue.getDefaultInstance());
        }

        public List<KeyValue.Builder> getAttributesBuilderList() {
            return this.getAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValue, KeyValue.Builder, KeyValueOrBuilder> getAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        public Builder setDroppedAttributesCount(int value2) {
            this.droppedAttributesCount_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedAttributesCount() {
            this.droppedAttributesCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureEventsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.events_ = new ArrayList<Event>(this.events_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Event> getEventsList() {
            if (this.eventsBuilder_ == null) {
                return Collections.unmodifiableList(this.events_);
            }
            return this.eventsBuilder_.getMessageList();
        }

        @Override
        public int getEventsCount() {
            if (this.eventsBuilder_ == null) {
                return this.events_.size();
            }
            return this.eventsBuilder_.getCount();
        }

        @Override
        public Event getEvents(int index) {
            if (this.eventsBuilder_ == null) {
                return this.events_.get(index);
            }
            return this.eventsBuilder_.getMessage(index);
        }

        public Builder setEvents(int index, Event value2) {
            if (this.eventsBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.set(index, value2);
                this.onChanged();
            } else {
                this.eventsBuilder_.setMessage(index, value2);
            }
            return this;
        }

        public Builder setEvents(int index, Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addEvents(Event value2) {
            if (this.eventsBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.add(value2);
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(value2);
            }
            return this;
        }

        public Builder addEvents(int index, Event value2) {
            if (this.eventsBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.add(index, value2);
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(index, value2);
            }
            return this;
        }

        public Builder addEvents(Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addEvents(int index, Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllEvents(Iterable<? extends Event> values2) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.events_);
                this.onChanged();
            } else {
                this.eventsBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearEvents() {
            if (this.eventsBuilder_ == null) {
                this.events_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.eventsBuilder_.clear();
            }
            return this;
        }

        public Builder removeEvents(int index) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.remove(index);
                this.onChanged();
            } else {
                this.eventsBuilder_.remove(index);
            }
            return this;
        }

        public Event.Builder getEventsBuilder(int index) {
            return this.getEventsFieldBuilder().getBuilder(index);
        }

        @Override
        public EventOrBuilder getEventsOrBuilder(int index) {
            if (this.eventsBuilder_ == null) {
                return this.events_.get(index);
            }
            return this.eventsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EventOrBuilder> getEventsOrBuilderList() {
            if (this.eventsBuilder_ != null) {
                return this.eventsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.events_);
        }

        public Event.Builder addEventsBuilder() {
            return this.getEventsFieldBuilder().addBuilder(Event.getDefaultInstance());
        }

        public Event.Builder addEventsBuilder(int index) {
            return this.getEventsFieldBuilder().addBuilder(index, Event.getDefaultInstance());
        }

        public List<Event.Builder> getEventsBuilderList() {
            return this.getEventsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Event, Event.Builder, EventOrBuilder> getEventsFieldBuilder() {
            if (this.eventsBuilder_ == null) {
                this.eventsBuilder_ = new RepeatedFieldBuilderV3(this.events_, (this.bitField0_ & 2) != 0, this.getParentForChildren(), this.isClean());
                this.events_ = null;
            }
            return this.eventsBuilder_;
        }

        @Override
        public int getDroppedEventsCount() {
            return this.droppedEventsCount_;
        }

        public Builder setDroppedEventsCount(int value2) {
            this.droppedEventsCount_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedEventsCount() {
            this.droppedEventsCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureLinksIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.links_ = new ArrayList<Link>(this.links_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Link> getLinksList() {
            if (this.linksBuilder_ == null) {
                return Collections.unmodifiableList(this.links_);
            }
            return this.linksBuilder_.getMessageList();
        }

        @Override
        public int getLinksCount() {
            if (this.linksBuilder_ == null) {
                return this.links_.size();
            }
            return this.linksBuilder_.getCount();
        }

        @Override
        public Link getLinks(int index) {
            if (this.linksBuilder_ == null) {
                return this.links_.get(index);
            }
            return this.linksBuilder_.getMessage(index);
        }

        public Builder setLinks(int index, Link value2) {
            if (this.linksBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.set(index, value2);
                this.onChanged();
            } else {
                this.linksBuilder_.setMessage(index, value2);
            }
            return this;
        }

        public Builder setLinks(int index, Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addLinks(Link value2) {
            if (this.linksBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.add(value2);
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(value2);
            }
            return this;
        }

        public Builder addLinks(int index, Link value2) {
            if (this.linksBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.add(index, value2);
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(index, value2);
            }
            return this;
        }

        public Builder addLinks(Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addLinks(int index, Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllLinks(Iterable<? extends Link> values2) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.links_);
                this.onChanged();
            } else {
                this.linksBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearLinks() {
            if (this.linksBuilder_ == null) {
                this.links_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.linksBuilder_.clear();
            }
            return this;
        }

        public Builder removeLinks(int index) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.remove(index);
                this.onChanged();
            } else {
                this.linksBuilder_.remove(index);
            }
            return this;
        }

        public Link.Builder getLinksBuilder(int index) {
            return this.getLinksFieldBuilder().getBuilder(index);
        }

        @Override
        public LinkOrBuilder getLinksOrBuilder(int index) {
            if (this.linksBuilder_ == null) {
                return this.links_.get(index);
            }
            return this.linksBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LinkOrBuilder> getLinksOrBuilderList() {
            if (this.linksBuilder_ != null) {
                return this.linksBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.links_);
        }

        public Link.Builder addLinksBuilder() {
            return this.getLinksFieldBuilder().addBuilder(Link.getDefaultInstance());
        }

        public Link.Builder addLinksBuilder(int index) {
            return this.getLinksFieldBuilder().addBuilder(index, Link.getDefaultInstance());
        }

        public List<Link.Builder> getLinksBuilderList() {
            return this.getLinksFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Link, Link.Builder, LinkOrBuilder> getLinksFieldBuilder() {
            if (this.linksBuilder_ == null) {
                this.linksBuilder_ = new RepeatedFieldBuilderV3(this.links_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                this.links_ = null;
            }
            return this.linksBuilder_;
        }

        @Override
        public int getDroppedLinksCount() {
            return this.droppedLinksCount_;
        }

        public Builder setDroppedLinksCount(int value2) {
            this.droppedLinksCount_ = value2;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedLinksCount() {
            this.droppedLinksCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStatus() {
            return this.statusBuilder_ != null || this.status_ != null;
        }

        @Override
        public Status getStatus() {
            if (this.statusBuilder_ == null) {
                return this.status_ == null ? Status.getDefaultInstance() : this.status_;
            }
            return this.statusBuilder_.getMessage();
        }

        public Builder setStatus(Status value2) {
            if (this.statusBuilder_ == null) {
                if (value2 == null) {
                    throw new NullPointerException();
                }
                this.status_ = value2;
                this.onChanged();
            } else {
                this.statusBuilder_.setMessage(value2);
            }
            return this;
        }

        public Builder setStatus(Status.Builder builderForValue) {
            if (this.statusBuilder_ == null) {
                this.status_ = builderForValue.build();
                this.onChanged();
            } else {
                this.statusBuilder_.setMessage(builderForValue.build());
            }
            return this;
        }

        public Builder mergeStatus(Status value2) {
            if (this.statusBuilder_ == null) {
                this.status_ = this.status_ != null ? Status.newBuilder(this.status_).mergeFrom(value2).buildPartial() : value2;
                this.onChanged();
            } else {
                this.statusBuilder_.mergeFrom(value2);
            }
            return this;
        }

        public Builder clearStatus() {
            if (this.statusBuilder_ == null) {
                this.status_ = null;
                this.onChanged();
            } else {
                this.status_ = null;
                this.statusBuilder_ = null;
            }
            return this;
        }

        public Status.Builder getStatusBuilder() {
            this.onChanged();
            return this.getStatusFieldBuilder().getBuilder();
        }

        @Override
        public StatusOrBuilder getStatusOrBuilder() {
            if (this.statusBuilder_ != null) {
                return this.statusBuilder_.getMessageOrBuilder();
            }
            return this.status_ == null ? Status.getDefaultInstance() : this.status_;
        }

        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getStatusFieldBuilder() {
            if (this.statusBuilder_ == null) {
                this.statusBuilder_ = new SingleFieldBuilderV3(this.getStatus(), this.getParentForChildren(), this.isClean());
                this.status_ = null;
            }
            return this.statusBuilder_;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SpanKind implements ProtocolMessageEnum
    {
        SPAN_KIND_UNSPECIFIED(0),
        SPAN_KIND_INTERNAL(1),
        SPAN_KIND_SERVER(2),
        SPAN_KIND_CLIENT(3),
        SPAN_KIND_PRODUCER(4),
        SPAN_KIND_CONSUMER(5),
        UNRECOGNIZED(-1);

        public static final int SPAN_KIND_UNSPECIFIED_VALUE = 0;
        public static final int SPAN_KIND_INTERNAL_VALUE = 1;
        public static final int SPAN_KIND_SERVER_VALUE = 2;
        public static final int SPAN_KIND_CLIENT_VALUE = 3;
        public static final int SPAN_KIND_PRODUCER_VALUE = 4;
        public static final int SPAN_KIND_CONSUMER_VALUE = 5;
        private static final Internal.EnumLiteMap<SpanKind> internalValueMap;
        private static final SpanKind[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SpanKind valueOf(int value2) {
            return SpanKind.forNumber(value2);
        }

        public static SpanKind forNumber(int value2) {
            switch (value2) {
                case 0: {
                    return SPAN_KIND_UNSPECIFIED;
                }
                case 1: {
                    return SPAN_KIND_INTERNAL;
                }
                case 2: {
                    return SPAN_KIND_SERVER;
                }
                case 3: {
                    return SPAN_KIND_CLIENT;
                }
                case 4: {
                    return SPAN_KIND_PRODUCER;
                }
                case 5: {
                    return SPAN_KIND_CONSUMER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SpanKind> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return SpanKind.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SpanKind.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return Span.getDescriptor().getEnumTypes().get(0);
        }

        public static SpanKind valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SpanKind.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SpanKind(int value2) {
            this.value = value2;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SpanKind>(){

                @Override
                public SpanKind findValueByNumber(int number) {
                    return SpanKind.forNumber(number);
                }
            };
            VALUES = SpanKind.values();
        }
    }

    public static interface EventOrBuilder
    extends MessageOrBuilder {
        public long getTimeUnixNano();

        public String getName();

        public ByteString getNameBytes();

        public List<KeyValue> getAttributesList();

        public KeyValue getAttributes(int var1);

        public int getAttributesCount();

        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList();

        public KeyValueOrBuilder getAttributesOrBuilder(int var1);

        public int getDroppedAttributesCount();
    }

    public static interface LinkOrBuilder
    extends MessageOrBuilder {
        public ByteString getTraceId();

        public ByteString getSpanId();

        public String getTraceState();

        public ByteString getTraceStateBytes();

        public List<KeyValue> getAttributesList();

        public KeyValue getAttributes(int var1);

        public int getAttributesCount();

        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList();

        public KeyValueOrBuilder getAttributesOrBuilder(int var1);

        public int getDroppedAttributesCount();
    }
}

