/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.axiom.locator.DefaultLoader;
import org.apache.axiom.locator.Implementation;
import org.apache.axiom.locator.ImplementationFactory;
import org.apache.axiom.locator.PriorityBasedOMMetaFactoryLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DefaultOMMetaFactoryLocator
extends PriorityBasedOMMetaFactoryLocator {
    private static final Log log = LogFactory.getLog(DefaultOMMetaFactoryLocator.class);

    public DefaultOMMetaFactoryLocator() {
        Enumeration<URL> e;
        ClassLoader classLoader = DefaultOMMetaFactoryLocator.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        DefaultLoader loader = new DefaultLoader(classLoader);
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        String metaFactoryClassName = null;
        try {
            metaFactoryClassName = System.getProperty("org.apache.axiom.om.OMMetaFactory");
            if ("".equals(metaFactoryClassName)) {
                metaFactoryClassName = null;
            }
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        if (metaFactoryClassName != null) {
            Implementation implementation;
            if (log.isDebugEnabled()) {
                log.debug("org.apache.axiom.om.OMMetaFactory system property is set; value=" + metaFactoryClassName);
            }
            if ((implementation = ImplementationFactory.createDefaultImplementation(loader, metaFactoryClassName)) != null) {
                implementations.add(implementation);
            }
        }
        log.debug("Starting class path based discovery");
        try {
            e = classLoader.getResources("META-INF/axiom.xml");
        }
        catch (IOException ex) {
            log.error("Failed to look up META-INF/axiom.xml from class loader", ex);
            e = null;
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                implementations.addAll(ImplementationFactory.parseDescriptor(loader, e.nextElement()));
            }
        }
        this.loadImplementations(implementations);
    }
}

