/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.util.stax.dialect.AbstractStAXDialect;
import org.apache.axiom.util.stax.dialect.DisallowDoctypeDeclInputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.NormalizingXMLInputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.SJSXPOutputFactoryWrapper;
import org.apache.axiom.util.stax.dialect.SJSXPStreamReaderWrapper;
import org.apache.axiom.util.stax.dialect.SJSXPStreamWriterWrapper;
import org.apache.axiom.util.stax.dialect.SynchronizedOutputFactoryWrapper;

class SJSXPDialect
extends AbstractStAXDialect {
    private final boolean isUnsafeStreamResult;

    public SJSXPDialect(boolean isUnsafeStreamResult) {
        this.isUnsafeStreamResult = isUnsafeStreamResult;
    }

    public String getName() {
        return this.isUnsafeStreamResult ? "SJSXP (with thread safety issue)" : "SJSXP";
    }

    public XMLInputFactory enableCDataReporting(XMLInputFactory factory2) {
        factory2.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        factory2.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        return factory2;
    }

    public XMLInputFactory disallowDoctypeDecl(XMLInputFactory factory2) {
        factory2.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        factory2.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        factory2.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory2.setXMLResolver(new XMLResolver(){

            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("DOCTYPE is not allowed");
            }
        });
        return new DisallowDoctypeDeclInputFactoryWrapper(factory2);
    }

    public XMLInputFactory makeThreadSafe(XMLInputFactory factory2) {
        factory2.setProperty("reuse-instance", Boolean.FALSE);
        return factory2;
    }

    public XMLOutputFactory makeThreadSafe(XMLOutputFactory factory2) {
        factory2.setProperty("reuse-instance", Boolean.FALSE);
        if (this.isUnsafeStreamResult) {
            factory2 = new SynchronizedOutputFactoryWrapper(factory2);
        }
        return factory2;
    }

    public XMLStreamReader normalize(XMLStreamReader reader) {
        return new SJSXPStreamReaderWrapper(reader);
    }

    public XMLStreamWriter normalize(XMLStreamWriter writer) {
        return new SJSXPStreamWriterWrapper(writer);
    }

    public XMLInputFactory normalize(XMLInputFactory factory2) {
        return new NormalizingXMLInputFactoryWrapper(factory2, this);
    }

    public XMLOutputFactory normalize(XMLOutputFactory factory2) {
        return new SJSXPOutputFactoryWrapper(factory2, this);
    }
}

