/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.awaitility.core.BiFunction;
import org.awaitility.core.Function;
import org.awaitility.core.SameThreadExecutorService;

public class InternalExecutorServiceFactory {
    public static ExecutorService sameThreadExecutorService() {
        return new SameThreadExecutorService();
    }

    public static ExecutorService create(final Function<Runnable, Thread> threadSupplier) {
        if (threadSupplier == null) {
            throw new IllegalArgumentException("Condition evaluation thread supplier cannot be null");
        }
        return InternalExecutorServiceFactory.create(new BiFunction<Runnable, String, Thread>(){

            @Override
            public Thread apply(Runnable runnable2, String __) {
                return (Thread)threadSupplier.apply(runnable2);
            }
        }, null);
    }

    public static ExecutorService create(final BiFunction<Runnable, String, Thread> threadSupplier, final String alias) {
        if (threadSupplier == null) {
            throw new IllegalArgumentException("Condition evaluation thread supplier cannot be null");
        }
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String threadName = InternalExecutorServiceFactory.generateDefaultThreadName(alias);
                return (Thread)threadSupplier.apply(r, threadName);
            }
        });
    }

    private static String generateDefaultThreadName(String alias) {
        return alias == null ? "awaitility-thread" : "awaitility[" + alias + "]";
    }
}

