/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;

public class BRuntime {
    private Scheduler scheduler;

    private BRuntime(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public static CompletableFuture<Object> markAsync() {
        Strand strand = Scheduler.getStrand();
        strand.blockedOnExtern = true;
        strand.setState(State.BLOCK_AND_YIELD);
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        future2.whenComplete((BiConsumer)new Unblocker(strand));
        return future2;
    }

    public static BRuntime getCurrentRuntime() {
        Strand strand = Scheduler.getStrand();
        return new BRuntime(strand.scheduler);
    }

    public void invokeMethodAsync(ObjectValue object, String methodName, Object ... args2) {
        Function<Object, Object> func = o -> object.call((Strand)((Object[])o)[0], methodName, args2);
        this.scheduler.schedule(new Object[1], (Function)func, (Strand)null, (CallableUnitCallback)null);
    }

    public void invokeMethodAsync(ObjectValue object, String methodName, CallableUnitCallback callback, Object ... args2) {
        Function<Object, Object> func = o -> object.call((Strand)((Object[])o)[0], methodName, args2);
        this.scheduler.schedule(new Object[1], func, null, callback);
    }

    public void invokeMethodAsync(ObjectValue object, String methodName, CallableUnitCallback callback, Map<String, Object> properties, Object ... args2) {
        Function<Object[], Object> func = objects -> {
            Strand strand = (Strand)objects[0];
            if (ObserveUtils.isObservabilityEnabled() && properties != null && properties.containsKey("__observer_context__")) {
                strand.observerContext = (ObserverContext)properties.remove("__observer_context__");
            }
            return object.call(strand, methodName, args2);
        };
        this.scheduler.schedule(new Object[1], func, null, callback, properties, BTypes.typeNull);
    }

    public void invokeMethodSync(ObjectValue object, String methodName, Object ... args2) {
        Function<Object, Object> func = o -> object.call((Strand)((Object[])o)[0], methodName, args2);
        final Semaphore semaphore = new Semaphore(0);
        final ErrorValue[] errorValue = new ErrorValue[1];
        this.scheduler.schedule(new Object[1], func, null, new CallableUnitCallback(){

            @Override
            public void notifySuccess() {
                semaphore.release();
            }

            @Override
            public void notifyFailure(ErrorValue error2) {
                errorValue[0] = error2;
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (errorValue[0] != null) {
            throw errorValue[0];
        }
    }

    public Object getSyncMethodInvokeResult(ObjectValue object, String methodName, int timeout2, Object ... args2) {
        Function<Object, Object> func = o -> object.call((Strand)((Object[])o)[0], methodName, args2);
        final Semaphore semaphore = new Semaphore(0);
        final ErrorValue[] errorValue = new ErrorValue[1];
        Object[] params = new Object[]{null, args2};
        FutureValue futureValue = this.scheduler.schedule(params, func, null, new CallableUnitCallback(){

            @Override
            public void notifySuccess() {
                semaphore.release();
            }

            @Override
            public void notifyFailure(ErrorValue error2) {
                errorValue[0] = error2;
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(timeout2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (errorValue[0] != null) {
            throw errorValue[0];
        }
        return futureValue.result;
    }

    private static class Unblocker
    implements BiConsumer<Object, Throwable> {
        private Strand strand;

        public Unblocker(Strand strand) {
            this.strand = strand;
        }

        @Override
        public void accept(Object returnValue, Throwable throwable) {
            if (throwable == null) {
                this.strand.setReturnValues(returnValue);
                this.strand.scheduler.unblockStrand(this.strand);
            }
        }
    }
}

