/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.tracer.BSpan;
import org.ballerinalang.jvm.values.ErrorValue;

public class TracingUtils {
    private static final String SEPARATOR = ":";

    private TracingUtils() {
    }

    public static void startObservation(ObserverContext observerContext, boolean isClient) {
        BSpan span = new BSpan(observerContext, isClient);
        span.setConnectorName(observerContext.getServiceName() != null ? observerContext.getServiceName() : "Unknown Service");
        if (isClient) {
            span.setActionName(observerContext.getConnectorName() != null ? observerContext.getConnectorName() + SEPARATOR + observerContext.getActionName() : observerContext.getActionName());
            observerContext.addProperty("trace_properties", span.getProperties());
        } else {
            span.setActionName(observerContext.getResourceName());
            Map httpHeaders = (Map)observerContext.getProperty("trace_properties");
            if (httpHeaders != null) {
                httpHeaders.entrySet().forEach(e -> span.addProperty((String)e.getKey(), (String)e.getValue()));
            }
        }
        observerContext.addProperty("_span_", span);
        span.startSpan();
    }

    public static void stopObservation(ObserverContext observerContext) {
        BSpan span = (BSpan)observerContext.getProperty("_span_");
        if (span != null) {
            Boolean error2 = (Boolean)observerContext.getProperty("error");
            if (error2 != null && error2.booleanValue()) {
                ErrorValue bError;
                StringBuilder errorMessageBuilder = new StringBuilder();
                String errorMessage = (String)observerContext.getProperty("error_message");
                if (errorMessage != null) {
                    errorMessageBuilder.append(errorMessage);
                }
                if ((bError = (ErrorValue)observerContext.getProperty("bstruct_error")) != null) {
                    if (errorMessage != null) {
                        errorMessageBuilder.append('\n');
                    }
                    errorMessageBuilder.append(bError.getPrintableStackTrace());
                }
                HashMap<String, Object> logProps = new HashMap<String, Object>();
                logProps.put("error.kind", "Exception");
                logProps.put("event", "error");
                logProps.put("message", errorMessageBuilder.toString());
                span.logError(logProps);
            }
            span.addTags(observerContext.getTags());
            span.addTags(observerContext.getTracingTags());
            span.finishSpan();
        }
    }
}

