/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.tracer;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.observability.tracer.OtelTracersStore;
import org.ballerinalang.jvm.observability.tracer.TraceConstants;

public class BOtelSpan {
    private final Tracer tracer;
    private final Span span;
    private Map<String, String> bOtelSpanContext;
    private static final PropagatingParentContextGetter GETTER = new PropagatingParentContextGetter();
    private static final PropagatingParentContextSetter SETTER = new PropagatingParentContextSetter();

    private BOtelSpan(Tracer tracer, Span span) {
        this.tracer = tracer;
        this.span = span;
    }

    public Span getSpan() {
        return this.span;
    }

    private static BOtelSpan start(Tracer tracer, Context parentContext, String operationName, boolean isClient) {
        SpanBuilder builder = tracer.spanBuilder(operationName);
        if (parentContext != null) {
            builder.setParent(parentContext);
        }
        builder.setAttribute("span.kind", isClient ? "client" : "server");
        builder.setSpanKind(isClient ? SpanKind.CLIENT : SpanKind.SERVER);
        Span span = builder.startSpan();
        return new BOtelSpan(tracer, span);
    }

    public static BOtelSpan start(String serviceName, String operationName, boolean isClient) {
        Tracer tracer = OtelTracersStore.getInstance().getTracer(serviceName);
        return BOtelSpan.start(tracer, null, operationName, isClient);
    }

    public static BOtelSpan start(BOtelSpan parentSpan, String serviceName, String operationName, boolean isClient) {
        Tracer tracer = OtelTracersStore.getInstance().getTracer(serviceName);
        Context parentContext = Context.current().with(parentSpan.span);
        return BOtelSpan.start(tracer, parentContext, operationName, isClient);
    }

    public static BOtelSpan start(Map<String, String> parentTraceContext, String serviceName, String operationName, boolean isClient) {
        Tracer tracer = OtelTracersStore.getInstance().getTracer(serviceName);
        Context parentContext = OtelTracersStore.getInstance().getPropagators().getTextMapPropagator().extract(Context.current(), parentTraceContext, GETTER);
        return BOtelSpan.start(tracer, parentContext, operationName, isClient);
    }

    public void finishSpan() {
        this.span.end();
    }

    public void addEvent(String eventName, Attributes attributes) {
        this.span.addEvent(eventName, attributes);
    }

    public void setStatus(StatusCode statusCode) {
        this.span.setStatus(statusCode);
    }

    public void addTags(Map<String, String> tags) {
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.span.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void addTag(String tagKey, String tagValue) {
        this.span.setAttribute(tagKey, tagValue);
    }

    public Map<String, String> extractContextAsHttpHeaders() {
        Map<String, String> carrierMap;
        if (this.span != null) {
            carrierMap = new HashMap();
            TextMapPropagator propagator = OtelTracersStore.getInstance().getPropagators().getTextMapPropagator();
            propagator.inject(Context.current().with(this.span), carrierMap, SETTER);
        } else {
            carrierMap = Collections.emptyMap();
        }
        return carrierMap;
    }

    public Map<String, String> getBOtelSpanContext() {
        if (this.bOtelSpanContext == null) {
            this.bOtelSpanContext = new HashMap<String, String>();
            SpanContext spanContext = this.span.getSpanContext();
            this.bOtelSpanContext.put(TraceConstants.SPAN_CONTEXT_MAP_KEY_TRACE_ID.getValue(), spanContext.getTraceId());
            this.bOtelSpanContext.put(TraceConstants.SPAN_CONTEXT_MAP_KEY_SPAN_ID.getValue(), spanContext.getSpanId());
        }
        return this.bOtelSpanContext;
    }

    static class PropagatingParentContextSetter
    implements TextMapSetter<Map<String, String>> {
        PropagatingParentContextSetter() {
        }

        @Override
        public void set(Map<String, String> carrier, String key, String value2) {
            carrier.put(key, value2);
        }
    }

    static class PropagatingParentContextGetter
    implements TextMapGetter<Map<String, String>> {
        PropagatingParentContextGetter() {
        }

        @Override
        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }

        @Override
        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }
    }
}

