/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.tracer;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.observability.InvalidConfigurationException;
import org.ballerinalang.jvm.observability.tracer.spi.TracerProvider;

public class OtelTracersStore {
    private TracerProvider tracerProvider;
    private Map<String, Tracer> store;
    private static final PrintStream consoleError = System.err;
    private static final OtelTracersStore instance = new OtelTracersStore();
    private ContextPropagators propagators;

    public static OtelTracersStore getInstance() {
        return instance;
    }

    private OtelTracersStore() {
    }

    public void setTracerGenerator(TracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        if (tracerProvider != null) {
            this.propagators = tracerProvider.getPropagators();
        }
        this.store = new HashMap<String, Tracer>();
    }

    public void loadTracers() {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (configRegistry.getAsBoolean("b7a.observability.tracing.enabled")) {
            this.store = new HashMap<String, Tracer>();
            String tracerName = configRegistry.getConfigOrDefault("b7a.observability.tracing.name", "jaeger");
            for (TracerProvider providerFactory : ServiceLoader.load(TracerProvider.class)) {
                if (!tracerName.equalsIgnoreCase(providerFactory.getName())) continue;
                this.tracerProvider = providerFactory;
                try {
                    this.tracerProvider.init();
                }
                catch (InvalidConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.store = new HashMap<String, Tracer>();
        }
    }

    public Tracer getTracer(String serviceName) {
        Tracer tracer;
        if (!this.isInitialized()) {
            throw BallerinaErrors.createError(StringUtils.fromString("error: the tracer store is not initialized because observability has not been enabled."));
        }
        if (this.store.containsKey(serviceName)) {
            tracer = this.store.get(serviceName);
        } else if (this.tracerProvider != null) {
            try {
                tracer = this.tracerProvider.getTracer(serviceName);
            }
            catch (Throwable e) {
                tracer = io.opentelemetry.api.trace.TracerProvider.noop().get("");
                consoleError.println("error: tracing disabled as getting tracer for " + serviceName + " service. " + e.getMessage());
            }
            this.store.put(serviceName, tracer);
        } else {
            tracer = io.opentelemetry.api.trace.TracerProvider.noop().get("");
            consoleError.println("error: tracing disabled as the tracer provider had not been initialized.");
        }
        return tracer;
    }

    public ContextPropagators getPropagators() {
        if (this.propagators != null) {
            return this.propagators;
        }
        return ContextPropagators.noop();
    }

    public boolean isInitialized() {
        return this.store != null;
    }
}

