/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.services.spi.EmbeddedExecutor;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.ArgumentParser;
import org.ballerinalang.jvm.util.RuntimeUtils;
import org.ballerinalang.jvm.util.exceptions.BLangRuntimeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;

public class JVMEmbeddedExecutor
implements EmbeddedExecutor {
    @Override
    public Optional<RuntimeException> executeMainFunction(String moduleName, String[] args2) {
        try {
            Scheduler scheduler = new Scheduler(false);
            JVMEmbeddedExecutor.runInitOnSchedule(moduleName, scheduler);
            JVMEmbeddedExecutor.runMainOnSchedule(moduleName, scheduler, args2);
            scheduler.immortal = true;
            new Thread(scheduler::start).start();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e);
        }
    }

    @Override
    public Optional<RuntimeException> executeService(String moduleName) {
        try {
            Scheduler scheduler = new Scheduler(false);
            JVMEmbeddedExecutor.runInitOnSchedule(moduleName, scheduler);
            this.runStartOnSchedule(moduleName, scheduler);
            scheduler.immortal = true;
            new Thread(scheduler::start).start();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e);
        }
    }

    private void runStartOnSchedule(String moduleName, Scheduler scheduler) throws RuntimeException {
        try {
            Class<?> initClazz = Class.forName("ballerina." + moduleName + ".___init");
            Method initMethod = initClazz.getDeclaredMethod("$moduleStart", Strand.class);
            Function<Object[], Object> func = objects -> {
                try {
                    return initMethod.invoke(null, objects[0]);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(new Object[1], func, null, null, null, BTypes.typeNull);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof BallerinaConnectorException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }

    private static void runMainOnSchedule(String moduleName, Scheduler scheduler, String[] stringArgs) throws RuntimeException {
        try {
            Class<?> mainClass = Class.forName("ballerina." + moduleName + "." + moduleName);
            Method mainMethod = mainClass.getDeclaredMethod("main", Strand.class, ArrayValue.class, Boolean.TYPE);
            Object[] entryFuncArgs = ArgumentParser.extractEntryFuncArgs(new RuntimeUtils.ParamInfo[]{new RuntimeUtils.ParamInfo(false, "%1", new BArrayType(BTypes.typeString, stringArgs.length))}, stringArgs, true);
            Function<Object[], Object> func = objects -> {
                try {
                    return mainMethod.invoke(null, entryFuncArgs);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(entryFuncArgs, func, null, null, null, BTypes.typeNull);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof BallerinaConnectorException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }

    private static void runInitOnSchedule(String moduleName, Scheduler scheduler) throws RuntimeException {
        try {
            Class<?> initClazz = Class.forName("ballerina." + moduleName + ".___init");
            Method initMethod = initClazz.getDeclaredMethod("$moduleInit", Strand.class);
            Function<Object[], Object> func = objects -> {
                try {
                    return initMethod.invoke(null, objects[0]);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Method has private access", e);
                }
            };
            FutureValue out = scheduler.schedule(new Object[1], func, null, null, null, BTypes.typeNull);
            scheduler.start();
            Throwable t = out.panic;
            if (t != null) {
                if (t instanceof BLangRuntimeException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof BallerinaConnectorException) {
                    throw new BLangRuntimeException(t.getMessage());
                }
                if (t instanceof ErrorValue) {
                    throw new BLangRuntimeException("error: " + ((ErrorValue)t).getPrintableStackTrace().replaceAll("\\{}", ""));
                }
                throw (RuntimeException)t;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Error while invoking main function: " + moduleName, e);
        }
    }
}

