/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.transactions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;

public class TransactionUtils {
    public static void notifyTransactionAbort(Strand strand, String globalTransactionId, String transactionBlockId) {
        TransactionUtils.executeFunction(strand.scheduler, TransactionUtils.class.getClassLoader(), "ballerina.transactions", "transaction_block", "abortTransaction", globalTransactionId, transactionBlockId);
    }

    public static Object executeFunction(Scheduler scheduler, ClassLoader classLoader, String packageName, String className, String methodName, Object ... paramValues) {
        try {
            Class<?> clazz = classLoader.loadClass(packageName + "." + className);
            int paramCount = paramValues.length * 2 + 1;
            Class[] jvmParamTypes = new Class[paramCount];
            Object[] jvmArgs = new Object[paramCount];
            jvmParamTypes[0] = Strand.class;
            jvmArgs[0] = scheduler;
            int j = 1;
            for (int i = 0; i < paramValues.length; ++i) {
                jvmArgs[j] = paramValues[i];
                jvmParamTypes[j++] = TransactionUtils.getJvmType(paramValues[i]);
                jvmArgs[j] = true;
                jvmParamTypes[j++] = Boolean.TYPE;
            }
            Method method = clazz.getDeclaredMethod(methodName, jvmParamTypes);
            Function<Object[], Object> func = args2 -> {
                try {
                    return method.invoke(null, args2);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new BallerinaException(methodName + " function invocation failed: " + e.getMessage());
                }
            };
            final CountDownLatch completeFunction = new CountDownLatch(1);
            FutureValue futureValue = scheduler.schedule(jvmArgs, func, null, new CallableUnitCallback(){

                @Override
                public void notifySuccess() {
                    completeFunction.countDown();
                }

                @Override
                public void notifyFailure(ErrorValue error2) {
                    completeFunction.countDown();
                }
            }, new HashMap<String, Object>(), BTypes.typeAny);
            completeFunction.await();
            return futureValue.result;
        }
        catch (ClassNotFoundException | InterruptedException | NoSuchMethodException e) {
            throw new BallerinaException("invocation failed: " + e.getMessage());
        }
    }

    private static Class<?> getJvmType(Object paramValue) {
        if (paramValue instanceof MapValue) {
            return MapValue.class;
        }
        if (paramValue instanceof ObjectValue) {
            return ObjectValue.class;
        }
        if (paramValue instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (paramValue instanceof String) {
            return String.class;
        }
        throw new RuntimeException("unknown param type: " + paramValue.getClass());
    }
}

