/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.util.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ErrorValue;

public class BLangExceptionHelper {
    private static ResourceBundle messageBundle = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());

    public static ErrorValue getRuntimeException(RuntimeErrors runtimeErrors, Object ... params) {
        String errorMsg = MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
        return BallerinaErrors.createError(errorMsg);
    }

    public static ErrorValue getRuntimeException(String reason, RuntimeErrors runtimeErrors, Object ... params) {
        String errorDetail = MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
        return BallerinaErrors.createError(reason, errorDetail);
    }

    public static String getErrorMessage(RuntimeErrors runtimeErrors, Object ... params) {
        return MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
    }

    public static ErrorValue getJsonError(String reason, String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            return BallerinaErrors.createError(reason, "Failed to " + operation + ": " + ((BallerinaException)e).getDetail());
        }
        if (e instanceof BLangFreezeException) {
            return BallerinaErrors.createError(reason, "Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail());
        }
        if (e.getCause() != null) {
            return BallerinaErrors.createError(reason, "Failed to " + operation + ": " + e.getCause().getMessage());
        }
        return BallerinaErrors.createError(reason, "Failed to " + operation + ": " + e.getMessage());
    }

    public static void handleInvalidXPath(String operation, Exception e) {
        throw BallerinaErrors.createError("Failed to " + operation + ". Invalid xpath: " + e.getMessage());
    }

    public static void handleXMLException(String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, "Failed to " + operation + ": " + ((BallerinaException)e).getDetail());
        }
        if (e instanceof BLangFreezeException) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, "Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail());
        }
        if (e.getCause() != null) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, "Failed to " + operation + ": " + e.getCause().getMessage());
        }
        throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, "Failed to " + operation + ": " + e.getMessage());
    }
}

