/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.IteratorUtils;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinalang.jvm.values.utils.StringUtils;

public class MapValueImpl<K, V>
extends LinkedHashMap<K, V>
implements RefValue,
CollectionValue,
MapValue<K, V>,
BMap<K, V> {
    private static final long serialVersionUID = 1L;
    private BType type;
    private volatile Status freezeStatus = new Status(State.UNFROZEN);
    private final Map<String, Object> nativeData = new HashMap<String, Object>();
    private BType iteratorNextReturnType;

    public MapValueImpl(BType type) {
        this.type = type;
    }

    public MapValueImpl() {
        this.type = BTypes.typeMap;
    }

    @Override
    public V get(Object key) {
        return super.get(key);
    }

    @Override
    public Long getIntValue(String key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getFloatValue(String key) {
        return (Double)this.get(key);
    }

    @Override
    public String getStringValue(String key) {
        return (String)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return (Boolean)this.get(key);
    }

    @Override
    public MapValueImpl<?, ?> getMapValue(String key) {
        return (MapValueImpl)this.get(key);
    }

    @Override
    public ObjectValue getObjectValue(String key) {
        return (ObjectValue)this.get(key);
    }

    @Override
    public ArrayValue getArrayValue(String key) {
        return (ArrayValue)this.get(key);
    }

    @Override
    public long getDefaultableIntValue(String key) {
        if (this.get(key) != null) {
            return this.getIntValue(key);
        }
        return 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        if (!this.containsKey(key)) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
        }
        return this.get(key);
    }

    @Override
    public V fillAndGet(Object key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        BType expectedType = null;
        if (this.type.getTag() == 12) {
            BRecordType recordType = (BRecordType)this.type;
            Map<String, BField> fields = recordType.getFields();
            if (fields.containsKey(key)) {
                expectedType = fields.get((Object)key).type;
            } else {
                if (recordType.sealed) {
                    throw BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
                }
                expectedType = recordType.restFieldType;
            }
        } else {
            expectedType = ((BMapType)this.type).getConstrainedType();
        }
        if (!TypeChecker.hasFillerValue(expectedType)) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, "cannot find key '" + key + "'");
        }
        Object value2 = expectedType.getZeroValue();
        this.put(key, value2);
        return value2;
    }

    @Override
    public Object merge(MapValue v2, boolean checkMergeability) {
        return this.merge((MapValueImpl)v2, checkMergeability);
    }

    @Override
    public V put(K key, V value2) {
        this.checkFreezeStatus();
        return this.putValue(key, value2);
    }

    protected void checkFreezeStatus() {
        try {
            if (this.freezeStatus.getState() == State.UNFROZEN) {
                return;
            }
            FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.map");
        }
        catch (BLangFreezeException e) {
            String errMessage = "";
            switch (this.getType().getTag()) {
                case 12: {
                    errMessage = "Invalid update of record field: ";
                    break;
                }
                case 15: {
                    errMessage = "Invalid map insertion: ";
                }
            }
            throw BallerinaErrors.createError(e.getMessage(), errMessage + e.getDetail());
        }
    }

    @Override
    public void clear() {
        this.validateFreezeStatus();
        super.clear();
    }

    protected void validateFreezeStatus() {
        if (this.freezeStatus.getState() != State.UNFROZEN) {
            FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.map");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public V remove(Object key) {
        this.validateFreezeStatus();
        return super.remove(key);
    }

    @Override
    public K[] getKeys() {
        Set keys2 = super.keySet();
        return keys2.toArray(new String[keys2.size()]);
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        MapValueImpl newMap = new MapValueImpl(this.type);
        refs.put(this, newMap);
        for (Map.Entry entry : this.entrySet()) {
            Object value2 = entry.getValue();
            value2 = value2 instanceof RefValue ? ((RefValue)value2).copy(refs) : value2;
            newMap.put(entry.getKey(), value2);
        }
        return newMap;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        MapValueImpl copy = (MapValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(" ");
        for (Map.Entry kvEntry : this.entrySet()) {
            Object key = kvEntry.getKey();
            Object value2 = kvEntry.getValue();
            sj.add(key + "=" + StringUtils.getStringValue(value2));
        }
        return sj.toString();
    }

    @Override
    public StringValue bStringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (this.type.getTag() == 34) {
            throw new BLangFreezeException("'freeze()' not allowed on '" + this.getType() + "'");
        }
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
            this.values().forEach((? super T val) -> {
                if (val instanceof RefValue) {
                    ((RefValue)val).attemptFreeze(freezeStatus);
                }
            });
        }
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.freezeStatus.setFrozen();
        this.values().forEach((? super T val) -> {
            if (val instanceof RefValue) {
                ((RefValue)val).freezeDirect();
            }
        });
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    /*
     * Exception decompiling
     */
    public String getJSONString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IteratorValue getIterator() {
        return new MapIterator(new LinkedHashSet(this.entrySet()).iterator());
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    public Map<String, Object> getNativeDataMap() {
        return this.nativeData;
    }

    private void initializeIteratorNextReturnType() {
        BType type;
        if (this.type.getTag() == BTypes.typeMap.getTag()) {
            BMapType mapType = (BMapType)this.type;
            type = mapType.getConstrainedType();
        } else {
            BRecordType recordType = (BRecordType)this.type;
            LinkedHashSet types = recordType.getFields().values().stream().map(bField -> bField.type).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType != null) {
                types.add(recordType.restFieldType);
            }
            type = types.size() == 1 ? (BType)types.iterator().next() : new BUnionType(new ArrayList<BType>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    public BType getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected V putValue(K key, V value2) {
        return super.put(key, value2);
    }

    private Object merge(MapValueImpl v2, boolean checkMergeability) {
        ErrorValue errorIfUnmergeable;
        if (checkMergeability && (errorIfUnmergeable = JSONUtils.getErrorIfUnmergeable(this, v2, new ArrayList<JSONUtils.ObjectPair>())) != null) {
            return errorIfUnmergeable;
        }
        MapValueImpl m1 = this;
        MapValueImpl m2 = v2;
        for (Map.Entry entry : m2.entrySet()) {
            String key = (String)entry.getKey();
            if (!m1.containsKey(key)) {
                m1.put(key, entry.getValue());
                continue;
            }
            m1.put(key, JSONUtils.mergeJson(m1.get(key), entry.getValue(), false));
        }
        return this;
    }

    static class MapIterator<K, V>
    implements IteratorValue {
        Iterator<Map.Entry<K, V>> iterator;

        MapIterator(Iterator<Map.Entry<K, V>> iterator2) {
            this.iterator = iterator2;
        }

        public Object next() {
            Map.Entry<K, V> next = this.iterator.next();
            V value2 = next.getValue();
            LinkedList<BType> types = new LinkedList<BType>();
            types.add(BTypes.typeString);
            types.add(TypeChecker.getType(value2));
            BTupleType tupleType = new BTupleType(types);
            TupleValueImpl tuple = new TupleValueImpl(tupleType);
            tuple.add(0L, next.getKey());
            tuple.add(1L, value2);
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public BString bStringValue() {
            return null;
        }
    }
}

