/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.DecimalValueKind;
import org.ballerinalang.jvm.JSONDataSource;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.StreamValue;
import org.ballerinalang.jvm.values.StreamingJsonValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BDecimal;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.api.BFunctionPointer;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BObject;
import org.ballerinalang.jvm.values.api.BStream;
import org.ballerinalang.jvm.values.api.BStreamingJson;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BTable;
import org.ballerinalang.jvm.values.api.BTypedesc;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.jvm.values.api.BXMLQName;

public class BValueCreator {
    public static BArray createArrayValue(BArrayType type) {
        return new ArrayValueImpl(type);
    }

    public static BArray createTupleValue(BTupleType type) {
        return new TupleValueImpl(type);
    }

    public static BArray createArrayValue(long[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(boolean[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(byte[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(double[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(String[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(BString[] values2) {
        return new ArrayValueImpl(values2);
    }

    public static BArray createArrayValue(Object[] values2, BArrayType type) {
        return new ArrayValueImpl(values2, type);
    }

    public static BArray createArrayValue(BArrayType type, int length) {
        return new ArrayValueImpl(type, length);
    }

    public static BDecimal createDecimalValue(BigDecimal value2) {
        return new DecimalValue(value2);
    }

    public static BDecimal createDecimalValue(String value2) {
        return new DecimalValue(value2);
    }

    public static BDecimal createDecimalValue(String value2, DecimalValueKind valueKind) {
        return new DecimalValue(value2, valueKind);
    }

    public static BError createErrorValue(BErrorType type, BString reason, Object details) {
        return new ErrorValue((BType)type, (StringValue)reason, details);
    }

    public static BError createErrorValue(BString reason, Object details) {
        return new ErrorValue((StringValue)reason, details);
    }

    public static BFunctionPointer createFPValue(Function function, BFunctionType type) {
        return new FPValue(function, type, false);
    }

    public static BStreamingJson createStreamingJsonValue(JSONDataSource datasource) {
        return new StreamingJsonValue(datasource);
    }

    public static BStream createStreamValue(BStreamType type) {
        return new StreamValue(type);
    }

    public static BTable createTableValue() {
        return new TableValue();
    }

    public static BTable createTableValue(String tableName, BStructureType constraintType) {
        return new TableValue(tableName, constraintType);
    }

    public static BTable createTableValue(BStructureType constraintType) {
        return new TableValue(constraintType);
    }

    public static BTable createTableValue(String query, TableValue fromTable, TableValue joinTable, BStructureType constraintType, ArrayValue params) {
        return new TableValue(query, fromTable, joinTable, constraintType, params);
    }

    public static BTable createTableValue(BType constraintType, ArrayValue keyColumns, ArrayValue dataRows) {
        return new TableValue(constraintType, keyColumns, dataRows);
    }

    public static BTypedesc createTypedescValue(BType describingType) {
        return new TypedescValue(describingType);
    }

    public static BXML createXMLItem() {
        return new XMLItem(new QName(null), new XMLSequence());
    }

    public static BXML createXMLItem(String xmlValue) {
        return XMLFactory.parse(xmlValue);
    }

    public static BXML createXMLItem(InputStream inputStream2) {
        return XMLFactory.parse(inputStream2);
    }

    public static BXMLQName createXMLQName(String localName, String uri, String prefix) {
        return new XMLQName(localName, uri, prefix);
    }

    public static BXMLQName createXMLQName(String qNameStr) {
        return new XMLQName(qNameStr);
    }

    public static BXML createXMLSequence() {
        return new XMLSequence();
    }

    public static BXML createXMLSequence(ArrayValue sequence2) {
        ArrayList<BXML> children = new ArrayList<BXML>();
        for (Object value2 : sequence2.getValues()) {
            children.add((BXML)value2);
        }
        return new XMLSequence(children);
    }

    public static BMap<String, Object> createRecordValue(BPackage packageId, String recordTypeName) {
        return BallerinaValues.createRecordValue(packageId, recordTypeName);
    }

    public static BMap<String, Object> createRecordValue(BPackage packageId, String recordTypeName, Map<String, Object> valueMap) {
        return BallerinaValues.createRecordValue(packageId, recordTypeName, valueMap);
    }

    public static BObject createObjectValue(BPackage packageId, String objectTypeName, Object ... fieldValues) {
        return BallerinaValues.createObjectValue(packageId, objectTypeName, fieldValues);
    }

    public static BMap<String, Object> createRecord(BMap<String, Object> record, Object ... values2) {
        return BallerinaValues.createRecord((MapValue)record, values2);
    }
}

