/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import java.util.ArrayList;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.langlib.internal.IsElement;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.__internal", functionName="getElements", args={@Argument(name="xmlValue", type=TypeKind.XML), @Argument(name="elemNames", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.XML)}, isPublic=true)
public class GetElements {
    public static final String EMPTY = "";
    public static final String STAR = "*";

    public static XMLValue getElements(Strand strand, XMLValue xmlVal, ArrayValue elemNames) {
        ArrayList<String> nsList = new ArrayList<String>();
        ArrayList<String> localNameList = new ArrayList<String>();
        GetElements.destructureFilters(elemNames, nsList, localNameList);
        if (IsElement.isElement(xmlVal)) {
            if (GetElements.matchFilters(elemNames, nsList, localNameList, xmlVal.getElementName())) {
                return xmlVal;
            }
            return new XMLSequence();
        }
        ArrayList<BXML> selectedElements = new ArrayList<BXML>();
        if (xmlVal.getNodeType() == XMLNodeType.SEQUENCE) {
            XMLSequence sequence2 = (XMLSequence)xmlVal;
            for (BXML child : sequence2.getChildrenList()) {
                if (child.getNodeType() != XMLNodeType.ELEMENT || !GetElements.matchFilters(elemNames, nsList, localNameList, child.getElementName())) continue;
                selectedElements.add(child);
            }
        }
        return new XMLSequence(selectedElements);
    }

    public static void destructureFilters(ArrayValue elemNames, ArrayList<String> nsList, ArrayList<String> localNameList) {
        int filterCount = elemNames.size();
        for (int i = 0; i < filterCount; ++i) {
            String fullName = elemNames.getString(i);
            int lastIndexOf = fullName.lastIndexOf(125);
            if (lastIndexOf < 0) {
                nsList.add(EMPTY);
                localNameList.add(fullName);
                continue;
            }
            nsList.add(fullName.substring(1, lastIndexOf));
            localNameList.add(fullName.substring(lastIndexOf + 1));
        }
    }

    public static boolean matchFilters(ArrayValue elemNames, ArrayList<String> nsList, ArrayList<String> elemList, String elementName) {
        int filterCount = elemNames.size();
        for (int i = 0; i < filterCount; ++i) {
            int index;
            String ns = nsList.get(i);
            String eName = elemList.get(i);
            if (ns.equals(EMPTY) && eName.equals(STAR)) {
                return true;
            }
            if (eName.equals(STAR) && (index = elementName.lastIndexOf(125)) > 0 && elementName.substring(1, index).equals(ns)) {
                return true;
            }
            if (!elementName.equals(elemNames.getString(i))) continue;
            return true;
        }
        return false;
    }
}

