/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.langlib.internal.GetElements;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.__internal", functionName="getFilteredChildrenFlat", args={@Argument(name="xmlValue", type=TypeKind.XML), @Argument(name="index", type=TypeKind.INT), @Argument(name="elemNames", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.XML)}, isPublic=true)
public class GetFilteredChildrenFlat {
    public static XMLValue getFilteredChildrenFlat(Strand strand, XMLValue xmlVal, long index, ArrayValue elemNames) {
        if (xmlVal.getNodeType() == XMLNodeType.ELEMENT) {
            XMLItem element = (XMLItem)xmlVal;
            return new XMLSequence(GetFilteredChildrenFlat.filterElementChildren(strand, index, elemNames, element));
        }
        if (xmlVal.getNodeType() == XMLNodeType.SEQUENCE) {
            XMLSequence sequence2 = (XMLSequence)xmlVal;
            ArrayList<BXML> liftedFilteredChildren = new ArrayList<BXML>();
            for (BXML child : sequence2.getChildrenList()) {
                if (child.getNodeType() != XMLNodeType.ELEMENT) continue;
                liftedFilteredChildren.addAll(GetFilteredChildrenFlat.filterElementChildren(strand, index, elemNames, (XMLItem)child));
            }
            return new XMLSequence(liftedFilteredChildren);
        }
        return new XMLSequence();
    }

    private static List<BXML> filterElementChildren(Strand strand, long index, ArrayValue elemNames, XMLItem element) {
        XMLSequence elements = (XMLSequence)GetElements.getElements(strand, element.getChildrenSeq(), elemNames);
        if (index < 0L) {
            return elements.getChildrenList();
        }
        if ((long)elements.getChildrenList().size() > index) {
            return Collections.singletonList(elements.getChildrenList().get((int)index));
        }
        return new ArrayList<BXML>();
    }
}

