/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import java.util.Collection;
import org.ballerinalang.jvm.MapUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.langlib.map.util.MapLibUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.map", functionName="toArray", args={@Argument(name="m", type=TypeKind.MAP)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.ANY)}, isPublic=true)
public class ToArray {
    public static ArrayValue toArray(Strand strand, MapValue<?, ?> m) {
        BType arrElemType;
        BType mapType = m.getType();
        switch (mapType.getTag()) {
            case 15: {
                arrElemType = ((BMapType)mapType).getConstrainedType();
                break;
            }
            case 12: {
                arrElemType = MapLibUtils.getCommonTypeForRecordField((BRecordType)mapType);
                break;
            }
            default: {
                throw MapUtils.createOpNotSupportedError(mapType, "toArray()");
            }
        }
        Collection values2 = m.values();
        int size = values2.size();
        int i = 0;
        switch (arrElemType.getTag()) {
            case 1: {
                long[] intArr = new long[size];
                for (Object val : values2) {
                    intArr[i++] = (Long)val;
                }
                return new ArrayValueImpl(intArr);
            }
            case 3: {
                double[] floatArr = new double[size];
                for (Object val : values2) {
                    floatArr[i++] = (Double)val;
                }
                return new ArrayValueImpl(floatArr);
            }
            case 2: {
                byte[] byteArr = new byte[size];
                for (Object val : values2) {
                    byteArr[i++] = ((Integer)val).byteValue();
                }
                return new ArrayValueImpl(byteArr);
            }
            case 6: {
                boolean[] booleanArr = new boolean[size];
                for (Object val : values2) {
                    booleanArr[i++] = (Boolean)val;
                }
                return new ArrayValueImpl(booleanArr);
            }
            case 5: {
                String[] stringArr = new String[size];
                for (Object val : values2) {
                    stringArr[i++] = (String)val;
                }
                return new ArrayValueImpl(stringArr);
            }
        }
        return new ArrayValueImpl(values2.toArray(), new BArrayType(arrElemType));
    }
}

