/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.typedesc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.typedesc", functionName="constructFrom", args={@Argument(name="t", type=TypeKind.TYPEDESC), @Argument(name="v", type=TypeKind.ANYDATA)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class ConstructFrom {
    private static final String AMBIGUOUS_TARGET = "ambiguous target type";

    public static Object constructFrom(Strand strand, TypedescValue t, Object v) {
        BType describingType = t.getDescribingType();
        if (describingType.getTag() == 13) {
            return ConstructFrom.convert(((BTypedescType)t.getDescribingType()).getConstraint(), v);
        }
        return ConstructFrom.convert(describingType, v);
    }

    public static Object convert(BType convertType, Object inputValue) {
        try {
            return ConstructFrom.convert(inputValue, convertType, new ArrayList<TypeValuePair>());
        }
        catch (ErrorValue e) {
            return e;
        }
        catch (BallerinaException e) {
            return BallerinaErrors.createError(BallerinaErrorReasons.CONSTRUCT_FROM_CONVERSION_ERROR, e.getDetail());
        }
    }

    private static Object convert(Object value2, BType targetType, List<TypeValuePair> unresolvedValues) {
        return ConstructFrom.convert(value2, targetType, unresolvedValues, false);
    }

    private static Object convert(Object value2, BType targetType, List<TypeValuePair> unresolvedValues, boolean allowAmbiguity) {
        if (value2 == null) {
            if (targetType.isNilable()) {
                return null;
            }
            return BallerinaErrors.createError(BallerinaErrorReasons.CONSTRUCT_FROM_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CANNOT_CONVERT_NIL, targetType));
        }
        List<BType> convertibleTypes = TypeConverter.getConvertibleTypes(value2, targetType);
        if (convertibleTypes.size() == 0) {
            throw ConstructFrom.createConversionError(value2, targetType);
        }
        if (!allowAmbiguity && convertibleTypes.size() > 1) {
            throw ConstructFrom.createConversionError(value2, targetType, AMBIGUOUS_TARGET);
        }
        BType sourceType = TypeChecker.getType(value2);
        BType matchingType = convertibleTypes.get(0);
        if (sourceType.getTag() <= 6) {
            if (TypeChecker.checkIsType(value2, matchingType)) {
                return value2;
            }
            return TypeConverter.convertValues(matchingType, value2);
        }
        return ConstructFrom.convert((RefValue)value2, matchingType, unresolvedValues);
    }

    private static Object convert(RefValue value2, BType targetType, List<TypeValuePair> unresolvedValues) {
        Object newValue;
        TypeValuePair typeValuePair = new TypeValuePair(value2, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            throw new BallerinaException(BallerinaErrorReasons.CONSTRUCT_FROM_CYCLIC_VALUE_REFERENCE_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CYCLIC_VALUE_REFERENCE, value2.getType()));
        }
        unresolvedValues.add(typeValuePair);
        switch (value2.getType().getTag()) {
            case 12: 
            case 15: {
                newValue = ConstructFrom.convertMap((MapValue)value2, targetType, unresolvedValues);
                break;
            }
            case 20: 
            case 31: {
                newValue = ConstructFrom.convertArray((ArrayValue)value2, targetType, unresolvedValues);
                break;
            }
            case 8: 
            case 29: {
                newValue = value2.copy(new HashMap<Object, Object>());
                break;
            }
            default: {
                throw BallerinaErrors.createConversionError(value2, targetType);
            }
        }
        unresolvedValues.remove(typeValuePair);
        return newValue;
    }

    private static Object convertMap(MapValue<?, ?> map2, BType targetType, List<TypeValuePair> unresolvedValues) {
        switch (targetType.getTag()) {
            case 15: {
                MapValueImpl<String, Object> newMap = new MapValueImpl<String, Object>(targetType);
                for (Map.Entry entry : map2.entrySet()) {
                    BType constraintType = ((BMapType)targetType).getConstrainedType();
                    ConstructFrom.putToMap(newMap, entry, constraintType, unresolvedValues);
                }
                return newMap;
            }
            case 12: {
                BRecordType recordType = (BRecordType)targetType;
                MapValueImpl newRecord = (MapValueImpl)BallerinaValues.createRecordValue(recordType.getPackage(), recordType.getName());
                BType restFieldType = recordType.restFieldType;
                HashMap<String, BType> targetTypeField = new HashMap<String, BType>();
                for (BField bField : recordType.getFields().values()) {
                    targetTypeField.put(bField.getFieldName(), bField.getFieldType());
                }
                for (Map.Entry entry : map2.entrySet()) {
                    BType fieldType = targetTypeField.getOrDefault(entry.getKey(), restFieldType);
                    ConstructFrom.putToMap(newRecord, entry, fieldType, unresolvedValues);
                }
                return newRecord;
            }
            case 7: {
                BType matchingType = TypeConverter.resolveMatchingTypeForUnion(map2, targetType);
                return ConstructFrom.convert(map2, matchingType, unresolvedValues);
            }
        }
        throw BallerinaErrors.createConversionError(map2, targetType);
    }

    private static Object convertArray(ArrayValue array2, BType targetType, List<TypeValuePair> unresolvedValues) {
        switch (targetType.getTag()) {
            case 20: {
                BArrayType arrayType = (BArrayType)targetType;
                ArrayValueImpl newArray = new ArrayValueImpl(arrayType);
                for (int i = 0; i < array2.size(); ++i) {
                    Object newValue = ConstructFrom.convert(array2.get(i), arrayType.getElementType(), unresolvedValues);
                    newArray.add((long)i, newValue);
                }
                return newArray;
            }
            case 31: {
                BTupleType tupleType = (BTupleType)targetType;
                TupleValueImpl newTuple = new TupleValueImpl(tupleType);
                int minLen = tupleType.getTupleTypes().size();
                for (int i = 0; i < array2.size(); ++i) {
                    BType elementType = i < minLen ? tupleType.getTupleTypes().get(i) : tupleType.getRestType();
                    Object newValue = ConstructFrom.convert(array2.get(i), elementType, unresolvedValues);
                    newTuple.add((long)i, newValue);
                }
                return newTuple;
            }
            case 7: {
                ArrayValueImpl newArray = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
                for (int i = 0; i < array2.size(); ++i) {
                    Object newValue = ConstructFrom.convert(array2.get(i), BTypes.typeJSON, unresolvedValues);
                    newArray.add((long)i, newValue);
                }
                return newArray;
            }
        }
        throw BallerinaErrors.createConversionError(array2, targetType);
    }

    private static void putToMap(MapValue<String, Object> map2, Map.Entry entry, BType fieldType, List<TypeValuePair> unresolvedValues) {
        Object newValue = ConstructFrom.convert(entry.getValue(), fieldType, unresolvedValues, true);
        map2.put(entry.getKey().toString(), newValue);
    }

    private static ErrorValue createConversionError(Object inputValue, BType targetType) {
        return BallerinaErrors.createError(BallerinaErrorReasons.CONSTRUCT_FROM_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType));
    }

    private static ErrorValue createConversionError(Object inputValue, BType targetType, String detailMessage) {
        return BallerinaErrors.createError(BallerinaErrorReasons.CONSTRUCT_FROM_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType).concat(": ".concat(detailMessage)));
    }
}

