/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.jvm.XMLValueUtil;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.xml.IsComment;
import org.ballerinalang.langlib.xml.IsProcessingInstruction;
import org.ballerinalang.langlib.xml.IsText;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="getContent", args={@Argument(name="xmlValue", type=TypeKind.XML)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetContent {
    public static String getContent(Strand strand, Object xmlVal) {
        XMLValue value2 = (XMLValue)xmlVal;
        if (IsText.isText(strand, value2)) {
            return value2.getTextValue();
        }
        if (IsProcessingInstruction.isProcessingInstruction(strand, value2)) {
            return XMLValueUtil.getPIContent(value2);
        }
        if (IsComment.isComment(strand, value2)) {
            return XMLValueUtil.getCommentContent(value2);
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.XML_FUNC_TYPE_ERROR, "getContent", "text|processing instruction|comment");
    }
}

