/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.logging.util;

public enum BLogLevel {
    OFF(Integer.MAX_VALUE),
    ERROR(1000),
    WARN(900),
    INFO(800),
    DEBUG(700),
    TRACE(600),
    ALL(Integer.MIN_VALUE);

    private int levelValue;

    private BLogLevel(int levelValue) {
        this.levelValue = levelValue;
    }

    public int value() {
        return this.levelValue;
    }

    public static BLogLevel toBLogLevel(String logLevel) {
        BLogLevel level;
        try {
            level = BLogLevel.valueOf(logLevel);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("invalid log level: " + logLevel);
        }
        return level;
    }
}

