/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import java.math.BigDecimal;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValueArray;

public class ListUtils {
    public static BRefType<?> execListGetOperation(BNewArray array2, long index) {
        if (array2.getType().getTag() != 19) {
            BValueArray bRefValueArray = (BValueArray)array2;
            return bRefValueArray.getRefValue(index);
        }
        switch (((BArrayType)array2.getType()).getElementType().getTag()) {
            case 6: {
                BValueArray bBooleanArray = (BValueArray)array2;
                int i = bBooleanArray.getBoolean(index);
                return i == 0 ? new BBoolean(false) : new BBoolean(true);
            }
            case 2: {
                BValueArray bByteArray = (BValueArray)array2;
                return new BByte(bByteArray.getByte(index));
            }
            case 3: {
                BValueArray bFloatArray = (BValueArray)array2;
                return new BFloat(bFloatArray.getFloat(index));
            }
            case 4: {
                BValueArray bDecimalArray = (BValueArray)array2;
                return new BDecimal(new BigDecimal(bDecimalArray.getRefValue(index).stringValue()));
            }
            case 1: {
                BValueArray bIntArray = (BValueArray)array2;
                return new BInteger(bIntArray.getInt(index));
            }
            case 5: {
                BValueArray bStringArray = (BValueArray)array2;
                return new BString(bStringArray.getString(index));
            }
        }
        BValueArray bRefValueArray = (BValueArray)array2;
        return bRefValueArray.getRefValue(index);
    }

    public static void execListAddOperation(BNewArray array2, long index, BRefType refType) {
        if (array2.getType().getTag() != 19) {
            BValueArray bRefValueArray = (BValueArray)array2;
            bRefValueArray.add(index, refType);
            return;
        }
        BValueArray bValueArray = (BValueArray)array2;
        switch (((BArrayType)array2.getType()).getElementType().getTag()) {
            case 6: {
                bValueArray.add(index, ((BBoolean)refType).value() != false ? 1 : 0);
                return;
            }
            case 2: {
                bValueArray.add(index, (Byte)refType.value());
                return;
            }
            case 3: {
                bValueArray.add(index, (Double)refType.value());
                return;
            }
            case 1: {
                bValueArray.add(index, (Long)refType.value());
                return;
            }
            case 5: {
                bValueArray.add(index, (String)refType.value());
                return;
            }
        }
        bValueArray.add(index, refType);
    }
}

