/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;

public class BValueArrayBValueProvider
implements SerializationBValueProvider<BValueArray> {
    public static final String TYPE = "TYPE";

    @Override
    public String typeName() {
        return this.getType().getSimpleName();
    }

    @Override
    public Class<?> getType() {
        return BValueArray.class;
    }

    @Override
    public BPacket toBValue(BValueArray array2, BValueSerializer serializer) {
        long size = array2.size();
        BValueArray target = new BValueArray(new BArrayType(BTypes.typeAny));
        BValue elemType = serializer.toBValue(array2.getType(), null);
        if (array2.getType().getTag() == 19) {
            BType elementType = ((BArrayType)array2.getType()).getElementType();
            if (elementType == BTypes.typeInt) {
                int i = 0;
                while ((long)i < size) {
                    BValue value2 = serializer.toBValue(array2.getInt(i), Integer.class);
                    target.add((long)i, (BRefType)value2);
                    ++i;
                }
            } else if (elementType == BTypes.typeBoolean) {
                int i = 0;
                while ((long)i < size) {
                    BValue value3 = serializer.toBValue(array2.getBoolean(i), Boolean.class);
                    target.add((long)i, (BRefType)value3);
                    ++i;
                }
            } else if (elementType == BTypes.typeByte) {
                int i = 0;
                while ((long)i < size) {
                    BValue value4 = serializer.toBValue(array2.getByte(i), Byte.class);
                    target.add((long)i, (BRefType)value4);
                    ++i;
                }
            } else if (elementType == BTypes.typeFloat) {
                int i = 0;
                while ((long)i < size) {
                    BValue value5 = serializer.toBValue(array2.getFloat(i), Double.class);
                    target.add((long)i, (BRefType)value5);
                    ++i;
                }
            } else if (elementType == BTypes.typeString) {
                int i = 0;
                while ((long)i < size) {
                    BValue value6 = serializer.toBValue(array2.getString(i), String.class);
                    target.add((long)i, (BRefType)value6);
                    ++i;
                }
            } else {
                this.serializeRefObjArray(array2, serializer, size, target);
            }
        } else if (array2.getType().getTag() == 29) {
            this.serializeRefObjArray(array2, serializer, size, target);
        }
        return BPacket.from(this.typeName(), target).put(TYPE, elemType);
    }

    private void serializeRefObjArray(BValueArray array2, BValueSerializer serializer, long size, BValueArray target) {
        int i = 0;
        while ((long)i < size) {
            BValue value2 = serializer.toBValue(array2.getRefValue(i), null);
            target.add((long)i, (BRefType)value2);
            ++i;
        }
    }

    @Override
    public BValueArray toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BValueArray array2 = (BValueArray)packet.getValue();
        BType type = (BType)bValueDeserializer.deserialize(packet.get(TYPE), BType.class);
        int size = (int)array2.size();
        BValueArray target = null;
        if (type.getTag() == 19) {
            int i;
            Object[] arr;
            if ((type = ((BArrayType)type).getElementType()).getTag() == 1) {
                arr = new long[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (Long)bValueDeserializer.deserialize(array2.getBValue(i), Long.class);
                }
                target = new BValueArray((long[])arr);
            } else if (type.getTag() == 6) {
                arr = new int[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = ((Integer)bValueDeserializer.deserialize(array2.getBValue(i), Integer.class)).intValue();
                }
                target = new BValueArray((int[])arr);
            } else if (type.getTag() == 2) {
                arr = new byte[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = ((Byte)bValueDeserializer.deserialize(array2.getBValue(i), BType.class)).byteValue();
                }
                target = new BValueArray((byte[])arr);
            } else if (type.getTag() == 3) {
                arr = new double[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (long)((Double)bValueDeserializer.deserialize(array2.getBValue(i), Double.class)).doubleValue();
                }
                target = new BValueArray((double[])arr);
            } else if (type.getTag() == 5) {
                arr = new String[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (long)((String)bValueDeserializer.deserialize(array2.getBValue(i), String.class));
                }
                target = new BValueArray((String[])arr);
            }
        }
        if (target == null) {
            target = type.getTag() == 29 ? new BValueArray(type) : new BValueArray(new BArrayType(type));
            int i = 0;
            while ((long)i < array2.size()) {
                target.add((long)i, (BRefType)bValueDeserializer.deserialize(array2.getRefValue(i), null));
                ++i;
            }
        }
        return target;
    }
}

