/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.TableIterator;
import org.ballerinalang.util.TableProvider;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BTable
implements BRefType<Object>,
BCollection {
    protected DataIterator iterator;
    private boolean hasNextVal;
    private boolean nextPrefetched;
    private TableProvider tableProvider;
    private String tableName;
    private BStructureType constraintType;
    private BValueArray primaryKeys;
    private BValueArray indices;
    private boolean tableClosed;
    private BType type;

    public BTable() {
        this.iterator = null;
        this.tableProvider = null;
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableName = null;
        this.type = BTypes.typeTable;
    }

    public BTable(String tableName, BStructureType constraintType) {
        this(constraintType);
        this.tableName = tableName;
    }

    public BTable(BStructureType constraintType) {
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    public BTable(String query, BTable fromTable, BTable joinTable, BStructureType constraintType, BValueArray params) {
        this.tableProvider = TableProvider.getInstance();
        if (!fromTable.isInMemoryTable()) {
            throw new BallerinaException(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
        }
        if (joinTable != null) {
            if (!joinTable.isInMemoryTable()) {
                throw new BallerinaException(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
            }
            this.tableName = this.tableProvider.createTable(fromTable.tableName, joinTable.tableName, query, constraintType, params);
        } else {
            this.tableName = this.tableProvider.createTable(fromTable.tableName, query, constraintType, params);
        }
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    public BTable(BType type, BValueArray indexColumns, BValueArray keyColumns, BValueArray dataRows) {
        BType constrainedType = ((BTableType)type).getConstrainedType();
        this.tableProvider = TableProvider.getInstance();
        this.tableName = this.tableProvider.createTable(constrainedType, keyColumns, indexColumns);
        this.constraintType = (BStructureType)constrainedType;
        this.type = new BTableType(this.constraintType);
        this.primaryKeys = keyColumns;
        this.indices = indexColumns;
        if (dataRows != null) {
            this.insertInitialData(dataRows);
        }
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public String stringValue() {
        String constraint = this.constraintType != null ? "<" + this.constraintType.toString() + ">" : "";
        StringBuilder tableWrapper = new StringBuilder("table" + constraint + " ");
        StringJoiner tableContent = new StringJoiner(", ", "{", "}");
        tableContent.add(this.createStringValueEntry("index", this.indices));
        tableContent.add(this.createStringValueEntry("primaryKey", this.primaryKeys));
        tableContent.add(this.createStringValueDataEntry());
        tableWrapper.append(tableContent.toString());
        return tableWrapper.toString();
    }

    private String createStringValueEntry(String key, BValueArray contents) {
        String stringValue = "[]";
        if (contents != null) {
            stringValue = contents.stringValue();
        }
        return key + ": " + stringValue;
    }

    private String createStringValueDataEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append("data: ");
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        while (this.hasNext()) {
            BMap<String, BValue> struct = this.getNext();
            sj.add(struct.stringValue());
        }
        sb.append(sj.toString());
        return sb.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    public boolean hasNext() {
        if (this.tableClosed) {
            throw new BallerinaException("Trying to perform hasNext operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.hasNextVal = this.iterator.next();
            this.nextPrefetched = true;
        }
        if (!this.hasNextVal) {
            this.reset();
        }
        return this.hasNextVal;
    }

    public void moveToNext() {
        if (this.tableClosed) {
            throw new BallerinaException(BallerinaErrorReasons.TABLE_CLOSED_ERROR, "Trying to perform an operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.iterator.next();
        } else {
            this.nextPrefetched = false;
        }
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableClosed = true;
    }

    public void reset() {
        if (this.iterator != null) {
            this.iterator.reset();
            this.iterator = null;
        }
        this.resetIterationHelperAttributes();
    }

    public BMap<String, BValue> getNext() {
        this.moveToNext();
        return this.iterator.generateNext();
    }

    public void addData(BMap<String, BValue> data) {
        if (data.getType() != this.constraintType) {
            throw new BallerinaException("incompatible types: record of type:" + data.getType().getName() + " cannot be added to a table with type:" + this.constraintType.getName());
        }
        this.tableProvider.insertData(this.tableName, data);
        this.reset();
    }

    public String getString(int columnIndex) {
        return this.iterator.getString(columnIndex);
    }

    public Long getInt(int columnIndex) {
        return this.iterator.getInt(columnIndex);
    }

    public Double getFloat(int columnIndex) {
        return this.iterator.getFloat(columnIndex);
    }

    public BigDecimal getDecimal(int columnIndex) {
        return this.iterator.getDecimal(columnIndex);
    }

    public Boolean getBoolean(int columnIndex) {
        return this.iterator.getBoolean(columnIndex);
    }

    public String getBlob(int columnIndex) {
        return this.iterator.getBlob(columnIndex);
    }

    public Object[] getStruct(int columnIndex) {
        return this.iterator.getStruct(columnIndex);
    }

    public Object[] getArray(int columnIndex) {
        return this.iterator.getArray(columnIndex);
    }

    public List<ColumnDefinition> getColumnDefs() {
        return this.iterator.getColumnDefinitions();
    }

    public BStructureType getStructType() {
        return this.iterator.getStructType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        if (this.tableClosed) {
            throw new BallerinaException("Trying to invoke clone built-in method over a closed table");
        }
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        TableIterator cloneIterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        BValueArray data = new BValueArray();
        int cursor = 0;
        try {
            while (cloneIterator.next()) {
                data.add((long)cursor++, cloneIterator.generateNext());
            }
            BTable table2 = new BTable(new BTableType(this.constraintType), this.indices, this.primaryKeys, data);
            refs.put(this, table2);
            BTable bTable = table2;
            return bTable;
        }
        finally {
            cloneIterator.close();
        }
    }

    @Override
    public BIterator newIterator() {
        return new BTableIterator(this);
    }

    private void generateIterator() {
        this.iterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        this.resetIterationHelperAttributes();
    }

    protected boolean isIteratorGenerationConditionMet() {
        return this.iterator == null;
    }

    protected void resetIterationHelperAttributes() {
        this.nextPrefetched = false;
        this.hasNextVal = false;
    }

    protected void finalize() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableProvider.dropTable(this.tableName);
    }

    private void insertInitialData(BValueArray data) {
        int count = (int)data.size();
        for (int i = 0; i < count; ++i) {
            this.addData((BMap)data.getRefValue(i));
        }
    }

    public boolean isInMemoryTable() {
        return true;
    }

    @Override
    public long size() {
        if (this.tableName == null) {
            return 0L;
        }
        return this.tableProvider.getRowCount(this.tableName);
    }

    @Override
    public synchronized boolean isFrozen() {
        return true;
    }

    private static class BTableIterator<K, V extends BValue>
    implements BIterator {
        private BTable table;

        BTableIterator(BTable value2) {
            this.table = value2;
        }

        @Override
        public BValue getNext() {
            if (this.hasNext()) {
                return this.table.getNext();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.table.hasNext();
        }
    }
}

