/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.metrics.extension.defaultimpl;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.DoubleRecorder;
import org.ballerinalang.jvm.observability.metrics.PercentileValue;
import org.ballerinalang.jvm.observability.metrics.Snapshot;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.observe.metrics.extension.defaultimpl.Clock;

public class RollingHistogram {
    private final Clock clock;
    private final StatisticConfig statisticConfig;
    private final DoubleRecorder[] ringBuffer;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;
    private final DoubleHistogram intervalHistogram;
    private DoubleHistogram accumulatedHistogram;
    private static final AtomicIntegerFieldUpdater<RollingHistogram> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(RollingHistogram.class, "rotating");
    private volatile int rotating;
    private volatile boolean accumulatedHistogramStale;

    public RollingHistogram(Clock clock, StatisticConfig statisticConfig) {
        this.clock = clock;
        this.statisticConfig = statisticConfig;
        int ageBuckets = (int)statisticConfig.getBuckets();
        this.ringBuffer = new DoubleRecorder[ageBuckets];
        for (int i = 0; i < ageBuckets; ++i) {
            this.ringBuffer[i] = new DoubleRecorder(statisticConfig.getPercentilePrecision());
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = clock.getCurrentTime();
        this.durationBetweenRotatesMillis = statisticConfig.getTimeWindow().toMillis() / (long)ageBuckets;
        this.intervalHistogram = new DoubleHistogram(statisticConfig.getPercentilePrecision());
        this.accumulatedHistogram = new DoubleHistogram(statisticConfig.getPercentilePrecision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value2) {
        this.rotate();
        try {
            for (DoubleRecorder recorder : this.ringBuffer) {
                recorder.recordValue(value2);
            }
        }
        finally {
            this.accumulatedHistogramStale = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.getCurrentTime() - this.lastRotateTimestampMillis;
        if (timeSinceLastRotateMillis < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            int iterations = 0;
            RollingHistogram rollingHistogram = this;
            synchronized (rollingHistogram) {
                do {
                    this.currentHistogram().reset();
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis && ++iterations < this.ringBuffer.length);
                if (iterations >= this.ringBuffer.length) {
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis * (timeSinceLastRotateMillis / this.durationBetweenRotatesMillis);
                }
                this.accumulatedHistogram = new DoubleHistogram(this.statisticConfig.getPercentilePrecision());
                this.accumulatedHistogramStale = true;
            }
        }
        finally {
            this.rotating = 0;
        }
    }

    public StatisticConfig getStatisticConfig() {
        return this.statisticConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSnapshot() {
        this.rotate();
        RollingHistogram rollingHistogram = this;
        synchronized (rollingHistogram) {
            this.accumulateIfStale();
            PercentileValue[] percentileValues = null;
            double[] monitoredPercentiles = this.statisticConfig.getPercentiles();
            if (monitoredPercentiles != null) {
                percentileValues = new PercentileValue[monitoredPercentiles.length];
                for (int i = 0; i < monitoredPercentiles.length; ++i) {
                    double p = monitoredPercentiles[i];
                    percentileValues[i] = new PercentileValue(p, this.accumulatedHistogram.getValueAtPercentile(p * 100.0));
                }
            }
            return new Snapshot(this.statisticConfig.getTimeWindow(), this.accumulatedHistogram.getMinValue(), this.accumulatedHistogram.getMean(), this.accumulatedHistogram.getStdDeviation(), this.accumulatedHistogram.getMaxValue(), percentileValues);
        }
    }

    private void accumulateIfStale() {
        if (this.accumulatedHistogramStale) {
            this.accumulate();
            this.accumulatedHistogramStale = false;
        }
    }

    private void accumulate() {
        this.currentHistogram().getIntervalHistogramInto(this.intervalHistogram);
        this.accumulatedHistogram.add(this.intervalHistogram);
    }

    private DoubleRecorder currentHistogram() {
        return this.ringBuffer[this.currentBucket];
    }
}

